Before reading this document, you should already have FDrepo installed and working. If
you need help getting it working, check out the **QuickStart.md** document. This document
mostly consists of of command line examples.

There is a special _not an option_ command line option not listed in the program help.
It is **null**. It is not a do nothing at all. It is simply this option does nothing.
It can be used to test the overall minumum configuration and required directories. If
it is the only option used, FDRepo will startup, print its banner text, process the
configuration, print the word _null_ and exit. If fundamental problems are detected error
messages will appear. This is not a full configuration test.

`fdrepo null`

When using FDRepo from command line, it will assume you want to operate on the default
repository specified in the _fdrepo.conf_ file. If you have more than one repository,
you can specify it from the command line using the **repo** option.

To get a list of all the local repositories simply use:

`fdrepo repos`

Now, lets assume you two repositories. The first as being the default and called
**latest**. The second one called **shareware**. You could get a list of the package groups
in the **latest** _(default)_ repository by using:

`fdrepo groups`

If you want a list of groups in the **shareware** repository, you need to
specify it firsts. You can do that by using:

`fdrepo repo shareware groups`

The same goes for retrieving a list of packages in a group. You would need to specify
the name of the group first. For example, list all packages in a **games** group in
the _default_ repository:

`fdrepo group games list`

Or, all the **games** in the **shareware** repository:

`fdrepo repo shareware group games list`

So lets take a look at a standard package you may have in your default repository called
_The FreeDOS Kernel_. Since no two packages can share the same package name, you do not
need to specify the group where it resides. To list all versions of the **kernel** you can
use:

`fdrepo versions kernel`

To view the metadata for the newest version of the **kernel**, use:

`fdrepo info kernel`

To view the German specific text for the newest version, use:

`fdrepo lang de info kernel`

Not too complicated. You are probably getting the hang of things already. So, I will
show you some thing a little weird. You can specify a specific version or versions by
its modified-date as a 'suffix' to the package name. For example, the package for kernel
version 2042 was last modified on 2020-12-23.2. You can view the specific metadata for that
version with:

`fdrepo info kernel:20201223.2`

Even better, you can use wildcards to view the ones modified in 2016. However, you need
to put quotes around the package to prevent the shell from trying to expand the wildcard
as filenames. Like this:

`fdrepo info "kernel:2016*"`

You can even get really fancy using a comma for multiple wildcards. For example,
show info for all versions modified in 2020 and 2021:

`fdrepo info "kernel:2020*,2021*"`

Want the see the latest metadata for both the **kernel** and **freecom**, you can just
specify them both, like this:

`fdrepo info kernel freecom`

The multiple package IDs and versioning suffix work with the various command line options.
For version, info, edit, export and delete. For the move option, the version suffix is
ignored and all versions of a package will be moved. This is because it cannot exist in
two separate groups.

If you are deleting specific versions of a package, I strongly suggest you test your
wildcard using **version** command before actually deleting those versions. While the
**version** will show all versions, it will highlight the ones matching the suffix with
an asterisk _(*)_.

All those options for viewing information on a repository and packages is wonderful. But,
you probably want to know how to add updated and new packages.

To add new versions of existing packages. You just need to tell it to add the zip files.
Like this:

`fdrepo add kernel.zip freecom.zip lots1234.zip 00000.zip ot*.zip`

FDRepo will examine the zip file and determine the package ID based on its metadata (not
the zip filename) and if a previous version exists in the repository, it will add it and
delete the zip file. If there are serious problems with the zip file, it will not add it
to the repository. Zip files that are not added will generate an error message and then
skipped.

If the packages are completely new, you must first specify a desired group. Like this:

`fdrepo group devel test*.zip`

Even when a group is specified, if a version of the package already is present in the
repository, the "preferred group" will be ignored and it will be placed in the same
group as the existing package. Although you could specify a group and mix updates and
new packages with the add option, I recommend against that. It could be confusing. It
would be better to simply run 'add' and let it complain. Then, run it again specifying
the desired group for the packages that were skipped.

If you accidentally put a package in the wrong group, it is easy to move. Just specify
the group ID where you want the package then tell it to move it. You do not need to
specify the group where the package is currently located. It would look something like
this:

`fdrepo group base move kernel`

Of course, there are more command line options. Like those for _upstream_ and _collab_
operations. But, if you made it this far and grasped the above jargon, I think you'll
be alright.

So, what is next? Be sure and read the **NoteThis.md** and **FAQ.md** for some additional
and possibly useful information. :-)
