# Notes on configuring and using FDRepo v3.x

### Where should I put the configuration file for FDRepo?

FDRepo will look for and use the first configuration file it finds in this order:

	${HOME}/.fdrepo
	${HOME}/.fdrepo/fdrepo.conf
	fdrepo.conf (in the installed location of the FDRepo executable)
	/etc/fdrepo.conf

### Why is there an empty Temporary setting in the configuration file?

For some actions, FDRepo needs a temporary directory. Normally, Temporary is left unset
and those will be performed in the system defined temporary directory for the user.
However, there could be some situations where a different location is desired for that
work. Setting the Temporary will override the location for temporary work files.
Regardless of the location used for those files, FDRepo will remove temporary files before
it terminates. This will occur with normal termination, Ctrl+C aborts and program
exceptions.  However, some signals (like KILL) that are sent to FDRepo, could result in
files which are still in use not being removed. However, even this is unlikely. Nearly all
processing is performed in memory with the exception of modifying zip file contents when
healing a repository or adding a package that needs adjusted.

### What about that blank Time_Zone, do I need to set that?

Probably not. FDRepo should detect the time zone settings of the system. Also, the
time zone is only used for informational purposes, like "page last modified". Otherwise,
It does not have a direct effect on managing a repository. However, if you feel a
desperate and urgent need to override the detected value, you can set it. It will not
affect the time itself, only the name of the time zone.

### What is the difference between "heal" and "heal-all"?

Heal-all is simply a convenience option that will go through and "heal" each repository.

### How often will I need to "heal" a repository?

In theory, never. In the real world, unless you have been modifying the contents of a
repository by hand, probably never. The healing process can fix most normal issues. For
example, it will convert the old structure of a repository managed by earlier versions of
FDRepo without any problem. It will also fix modified-date fields in packages, adjust
file time stamps, remove dead filesystem links and a number of other potential issues.
Often, it will display a "WARNING" and simply apply a fix. Some WARNINGS may not be or
should not be automatically repaired. If it is not a serious immediate problem, it will
be left to you fix someday.

But, there are some obscure circumstances that it must not or cannot fix automatically.
If it encounters such issues, it will display various messages based on severity. From,
an ERROR that may or may not continue processing, up to throwing an EXCEPTION with a
message to immediately stop processing. While in theory most of those situations could
possibly be corrected automatically, they are exceedingly rare and are not worth the
time and effort that would be involved to handle them at this time.

### What is NLS4FDRepo and why is there no executable?

Don't worry about it. You won't need it. :-) Because I am incredibly lazy and get bored
easily, it is a utility that will take information from the FDRepo translations in a
local copy of the FD-NLS project and splice them into the repo.ini and other files. It
will be a rare occurrence to update such translations and it can be easily done manually.
I just find such tasks unbearably tedious. Depending on the last time the translations
were updated and how much FDRepo has changed, it may not even work.

### Wait, what is the repo.ini file?

Well, it is a good thing you asked. Each repository that is managed by FDRepo will have
a "repo.ini" file in it's root directory. There is no system specific or sensitive
information in this file. It simply contains some general information about the
repository like the package groups, their descriptive text and a few other pieces of
public information about the repository. This information is used to create the web
browsable repository pages and can be seen there. The file is located in the repository
itself intentionally to permit future versions of programs like FDIMPLES to retrieve this
information when displaying online repositories.

So the information about the package groups for a repository are in that file? Yes.
Furthermore, if there is a directory in the root of the repository that is not listed in
that file as a group or special, it will not be acknowledged as existing and totally
ignored by FDRepo. It will not even remove dead links or prune empty directories in a
directory not declared in the repo.ini file.

### Why is my new group directory not showing up?

You need to define it as a group in the repo.ini file for the repository. Otherwise,
it will be ignored.

### I specified a group ID. But, why is update not adding them to the repo?

By design, update will not add completely new packages to a repository. You need to
specify the group ID and use the add command line option.
