# Notes, Issues and Farraginous Items

- ISO creation is performed by external utilities. On Linux, **mkisofs** is required.
macOS provides **hdiutil** for the task.

- The HTML index of all different repositories provided by a server is only updated when
the 'heal' option is specified. So if you add a new repository or delete one, you will
need to run **fdrepo heal**. It does not matter which repository is active at the time.

- Normally, you would add screen shot images using the **pic** command line option. But
if you dropped a bunch of images into the repository by hand, you have two options to
get the HTML pages updated. You can either **heal** or **update** the repository.
Performing a _heal_ can take a little while. It will "fix" the repository and therefore
to include the images on the pages. On the other hand, performing an _update_ is much
faster, it will update thumbnails images and update any pages that would be affected
by the new or changed images. However, the **update** command will automatically add
any packages which are waiting in the update directory for the repository.

- The BASE directory for the available repositories will exclude directory links which
resolve to the BASE directory. In other words, if there is a directory for a repository
called 'unstable' and you create a filesystem link called 'latest' that points to the
unstable directory, FDRepo will ignore the 'latest' link. However, if a link points
to a different directory (like on another drive) it will not ignore it.

- Using the 'edit' option to modify a packages LSM metadata will not change the package
modified-date. The timestamp for that file is preserved regardless of your changes.
This insures that multiple versions of a package maintain the correct order. If you change
the modified date field to a different day, FDRepo will notice it is wrong and change
it back to the original day. It will most likely assign a different .N based on the
fraction (1/10 of a day) of the timestamp.

- Like ISO creation, editing the of a LSM metadata file is done using an external text
editor. By default, it is probably set to use **vi** or **nano**. But, you can change
that in the fdrepo.conf file to whatever you prefer and have installed.

- FDRepo forces compliance of the _modified-date_ field in LSM files. It also prohibits
a package from having multiple LSM files. However, it places no restrictions on the
directory structure and other files. For example, a package that contains files in its
root directory has a very high probability of creating a conflict with other packages
during its installation. That is your responsibility. FDRepo will not prevent packages
that are non-compliant packages from being added. This is because there may be rare
cases when such things may be needed.

- Unlike earlier versions of FDRepo, the **update** option is not actually needed. The
new version is exponentially faster and better at determining what needs updated. It
just adjusts what is needed automatically after making changes. The update option was
added for backward compatibility to easily import package updates from a specified path
through a cron job. But, even that could be performed using other command line options.

- Normally, the command-line options regarding packages (edit, delete, info, versions)
operate on the newest version of a package. You can specify older or multiple versions
by appending _:something_ to the package name. That something can be the modified-date
or a wildcard for multiple items. The exception is the move command-line option. A
package can only exist in one group. Therefore, it always will move all versions
regardless of any modifier you suggest.

- The file names of imported packages are not relevant. FDRepo will examine the package
LSM metadata files and base the package name accordingly. For example, lets say you have
a new package of 'fdimples' in a file named 'my_new_version_9.102.7.zip'. It will be
added as 'fdimples.zip'.

- more to come.