# The FDRepo Quick Start Guide, version 0
_(preliminary doc, warts and all edition)_
_(for lazy people, like me)_

FDRepo is a server side program which maintains software repositories that can be used by
DOS programs like FDNPKG to download new or update existing DOS programs. It can be run
directly on compatible servers. Or, it can be run locally and the repository can be
uploaded (or synchronized) with a server. For various reasons, FDRepo generates a static
site. It does not engage in client/server activities. While this has a few drawbacks,
it also makes the output portable and requires no special permissions or software to be
run on the server hosting a repository.

Running FDRepo requires a Mac or Linux computer (or server). Windows is not supported by
FDRepo at this time and is unlikely to be supported in the future.

## Step -1, Getting started

If you are lucky enough to be able to use a pre-compiled binary release package, you
will not need to build FDRepo from sources and you can move along to Step 1.

## Step 0, You need a binary

If a binary does not exist for your OS or Hardware, you will need FreePascal and Lazarus
in order to compile the sources. Currently, FDRepo is being built with FPC v3.2.2 and
Lazarus v3.4. However, newer versions are likely to work for compiling the sources.

To compile the sources, go to the sources directory and execute the **build.sh** script.
And if all goes well, a platform specific executable will be created for you.

:-)

## Step 1, You can just stick it

You will want to put FDRepo somewhere. FDRepo will not care where. So, it just depends
on your needs. You will want to copy the contents of the **bin** directory from your
download to that location. Maybe under **/opt/fdrepo**. Or, assuming your name is _Linda_,
maybe at **/home/linda/fdrepo** would be a desirable location.

## Step 2, You need a place for repositories

FDRepo comes configured to use a **repos** sub-directory based on where the binary
is installed. It includes an empty _"latest and unstable"_ repository under that
directory. But, that location will not make the repositories visible to your web server
or the internet.

While you may be able to point a filesystem symlink to that directory from somewhere
inside your web server's document tree, it is usually better for you to locate the
repositories in the document tree for your site and point FDRepo at that location.

Once you move the **repos** directory, it is convenient to just create a symlink called
**repos** which points to the new location. Or, you can modify the
**[paths]/Repositories** setting in the **fdrepo.conf** file.

## Step 4, Configure it

Open up the **fdrepo.conf** in the editor of your choice and give it a once over. You will
need to change a couple things. Going from top to bottom in that file.

- **[paths]/repositories** If you did not create a symlink for step 2, will need set to
  the location of the repositories. Possibly something like **/srv/www/html/repos**.

- **[html]/website** set this to the name your website. Like _Linda's Tattoo Parlor_

- **[html]/url** set this as well. It will be your main home page for that
  _Linda's Tattoo Parlor_ website. It is not the URL to the base of the repositories.

You will likely want to configure the stuff regarding FDNPKG in the optional section.
Otherwise, you will not provide a config file for FDNPKG that users can easily download
to access your repository from DOS.

Your all done. Sort-of.

## Step 5, But there ain't nothing there

Well of course not. We did not put any packages in the repository yet.

The easiest way to get some packages into your repository is to head over to the server
that provides the official downloads for FreeDOS and fetch the monthly [Interim
Test Build](https://www.ibiblio.org/pub/micro/pc-stuff/freedos/files/distributions/test/)
of the FullUSB image.

Once you have finish downloading that large zip archive, extract it and mount the IMG
file. On a Mac, you can just double click to mount it. On Linux, you will likely need to
mount the image using a loop back device.

After you managed to get it mounted, you will see a _packages_ directory on the image.
That directory contains a bunch of sub-directories of package groups. Simply copy all of
those sub-directories to your repository in the **/srv/www/html/repos/latest** directory.
Make sure the copied files and directories have appropriate permissions and change them
if needed.

The USB image also contains a _pkg-info_ directory. Since this is not a package _group_
that is defined in the **repo.ini** file for the repository, FDrepo will ignore it. But,
it is just wasting space. So, delete that directory from your repository.

Dismount that disk image. :-)

That was not too bad, was it?

## Step 6, But there still is no HTML

Thats because we only copied the packages to the repository. There were no HTML files
for viewing the packages in a web browser on that disk image. We need FDRepo for that.

If you manually drop a packages into a repository or make any other changes to it by hand,
the first thing you should do is have FDRepo repair it. Simply run **fdrepo heal** and it
will go through everything, make adjustments, fix metadata, generate the HTML pages and
do a bunch of other things to the repository. Be prepared to see a number of warning
messages or other text as things get adjusted for the first time.

While it is not necessary to perform a second **heal** at this time, if you ran it again,
there should be few or no warnings or text messages regarding adjustments.

## Step 7, Now What?

Go visit your repository with the a browser. Download that FDNPKG.CFG file in DOS and
try to use FDNPKG with your repository. Maybe subscribe to your package update RSS feed.
In general, have a good look around to make sure all is working as expected. You may
need to adjust a few FDRepo settings or make changes to you webserver configuration.

Then, you can get on with actual management of the repository. When you are ready,
check out the **WhatNext.md** for some basic instructions on management.
