## V8Power Tools Turbo Booster

BSD 3-Clause License
Copyright (c) 2022-2023, Jerome Shidel
All rights reserved.

## Version

project development reboot pre-release
(there is more to do, than is already done)

## Editions

There are three different builds of V8Turbo from the same source code.

* V8Turbo - The primary feature rich edition.
* V8Micro - The economy edition.
* V8TurboX - A feature rich accessibility focused edition.

Of the three editions, *V8Micro* is the most like other traditional DOS command
line interpreters. It has most (but not all) of the V8Turbo specific commands.
It has no mouse or direct video support. Only supports a single theme and
provides no means to change video modes. Nor, does it provide any internal
command help.

V8TurboX is similar to *V8Turbo*. However, it contains some additional
functionality specifically and default settings for accessibility users.
This edition will most likely change drastically based on feedback from the
users of this edition.

## Requirements

[FreeDOS](http://freedos.org/), [DOSBox](https://www.dosbox.com/) or
other DOS based operating system.

## Minimum Build Requirements

[NASM](https://nasm.us/) 2.15.05 or later required
[UPX](https://upx.github.io/) 3.96 or later recommended

[DosKit LIBS](https://gitlab.com/DOSx86/DosKit/-/tree/master/DEVEL/DOSKIT/LIBS)
(At some point, these will be directly included for easy building from source.)

## How is V8Turbo Different from other Command Line Shells?

* It is not (normally) a single flat color. It uses color in different
intensities to help draw attention and focus to the most relevant information.
* Integrated mouse support which can be used to select options, navigate the
filesystem and other drives(1), etc. Sometimes even for past commands that are
no longer actively running. (V8Turbo only)
* Additional features and commands.
* Ability to change languages without a requiring a restart, reboot or changing
shell binaries.

(1) Using the mouse to click on the drive shown by the prompt will perform the
same task as typing 'CD *'. The 'CD *' command will list the current path of
all drives and can be used to change paths or drives using the mouse. This now
makes navigation of the different drives and the paths possible without ever
needing to touch the keyboard.

## New commands

* COMMANDS - list available commands with a short description.
* ERRORLEVEL - to report the current ERRORLEVEL code and message. Or, to change
the current ERRORLEVEL.
* GOSUB - TBA
* LANG - quickly and easily switch shell languages and font. (more TBA)
* MIME - TBA
* POWERNAP - TBA
* RETURN - TBA
* TEXTMODE - to report, probe or change the current text mode. (V8Turbo/X only)
* THEME - to select or change the current color theme. (V8Turbo/X only)

There are more to come. But, this list is the initial "known to be coming" (or
has already been implemented) additional commands provided by V8Turbo.

## Old commands with new features.

* BEEP - can vary play multiple tones with different frequencies and durations.
* CD - provides an option to display the current path of all drives.
* CDD - option to list directory after changing drive and/or directories.
* DATE - option to display date without the "date is" text
* DOSKEY - ability to change some keyboard input settings.
* ERASE - not identical to DELETE. It renames, overwrites then deletes files.
* EXIT - Can be used to terminate a batch or the shell and set ERRORLEVEL.
* HISTORY - can load, save and autosave to files
* MKDIR - TBA
* PATH - Prints the path as a list when viewing.
* PAUSE - TBA
* PUSHD - Like CDD, supports the /D switch, - (last dir) and * list drive paths
* POPD - TBA
* SET - TBA
* TIME - option to display time without the "time is" text
* TYPE - Wildcard support. Text, binary and autodetect output modes.
* VOL - Can display volume names for multiple drives.

Like the new command list. This is just what has additional functionality (or
will have in the near future).

## New internal Environment Variables (for batch and shell usage)

* _BOOTDRV - Drive the system used for booting as reported by the kernel.
* _CDD - Current Default Drive
* _ERRLVL - Current ERRORLEVEL in hexadecimal format.
* _SWITCHAR - Current command line switch character (most likely, '/' or '-')
* _SYSDATE - Current system date provided using 8 raw digits, YYYYMMDD.
* _SYSTIME - Current system time provided using 8 raw digits, HHMMSScc.
* _V8SHELL - V8Turbo command shell edition (V8Turbo, V8Micro or V8TurboX).

More internals are planned and will eventually be implemented.

## Retired commands

Retired commands are those I personally do not see much point in implementing
under a modern DOS shell. However if I receive enough requests for them, or
find a good reason, I will implement them at that time.

* CTTY
* PROMPT

## Major TO-DOs

A short list of the major items that still need done in order to make V8Turbo a
viable alternative shell.

* Execute externals
* XMS support, maybe EMS as well.
* Memory swapping/reduction during file execution
* Batch file processing (and related commands)
* I/O redirection
* Setting path and other environment variables
* Enable file deletion
* A handful of other commands

## Some behavior I'm thinking about

These may change during the preview releases or anytime prior to the initial
public release. Once initial released occurs, any items in this section will
most probably become permanent. After which time, it is highly unlikely that
these items may change.

* When PUSHD cannot change to a directory, it will still push the current
directory onto the DIRSTACK. Thinking if this the best behaviour. It may be
better to have it only PUSH the current directory when a successful dir change
has occurred.

* DIRS command, at present when clicked, it changes to that directory and
displays it. I may change that default behaviour to change do that dir without
performing a dir list and also roll the DIRSTACK back as well. Maybe.

* Possibly add Up/Down, PgUp/PgDn, Home and End keys support to TYPE command.

