# UMB-TEST

UMB TEST is for testing compatibility between MS-DOS and FreeDOS when allocating
memory blocks in the high memory area (640K+).

All 4 binaries are compiled from the same base source using compiler directives.
When compiled, a pair of COM and SYS files are created in two flavors. One that
terminates if read-back verification fails (V versions). And, one that will
ignore the results of the read-back and proceed with the attempt to allocate
memory (N versions).

Read-back verification is simply setting the value for one of the options that
control DOS memory allocation. If that function reports that it was successful,
the program will read the setting back and compare it to the setting that was
requested. If those values do not match, a verification error is generated in
the program. The V versions will stop testing if that error is detected. The N
versions will ignore the error and continue anyway.

Behaviour of the functions to allocate memory appear to perform the same between
the two operating systems once they have finished booting. This can be seen by
using either of the executable COM files.

However during the boot process, they yield very different results. This can be
observed with the SYS device drivers. Some of these differences are:

* MS-DOS fails to allocate any memory when the driver is loaded high. FreeDOS
will allocate memory. This is not a compatibility issue and is an improvement
over MS-DOS.

* MS-DOS (when driver is loaded low) appears to only allocate memory in the
high memory area. The lower 3-bits of the allocation strategy are respected
but the strategy used is always 0x40, 0x41 or 0x42. FreeDOS permits using all
nine strategies. However at present, 0x4? series appear to be using the 0x8? and
if a allocation will not fit in the high memory area a low memory block is
returned. When the request is made with a 0x40, 0x41 or 0x42 allocation strategy
and there is insufficient upper memory, it should fail but does not.

* FreeDOS (when the driver is loaded low) and allocation returns a block of
lower memory that will be in the first or best fit location, it will return
"success" and the segment of the device driver. This is a problem if a driver
did not check the memory segment against it's code segment.

* The test driver makes repeated attempts using different strategies. When the
N version of the driver is used, both operating systems will continue to boot.
However once CONFIG.SYS and AUTOEXEC.BAT have been processed, FreeDOS will
crash with a memory error while attempting to load the command shell. MS-DOS
will continue to operate normally.

None of the 4 binaries support command line options. However, you can easily
modify those in the SETTINGS.INC file and recompile them with build.sh script.
