/* This is part of the NEWTRACK eyetracking software, (c) 2004 by  */
/* Eric Auer. NEWTRACK is free software; you can redistribute it   */
/* and modify it under the terms of the GNU General Public License */
/* as published by the Free Software Foundation; either version 2  */
/* of the License, or (at your option) any later version.          */
/*     NEWTRACK is distributed in the hope that it will be useful, */
/*     but WITHOUT ANY WARRANTY; without even the implied warranty */
/*     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.     */
/*     See the GNU General Public License for more details.        */
/* You should have received a copy of the GNU General Public       */
/* License (license.txt) along with this program; if not, check    */
/* www.gnu.org or write to the Free Software Foundation, Inc., 59  */
/* Temple Place, Suite 330, Boston, MA  02111-1307 USA.            */

/* Helper function: Read a file into a buffer, possibly interactively */
/* UPDATE 2/2005: More flexible implementation, useful for PCX2TPL */


#include "tracker.h"    /* includes arch.h etc. */
/* used: stdio string unistd stdlib (for malloc) fcntl sys/stat arch */

#ifndef __DJGPP__
#ifndef stricmp		/* stricmp is available only on DJGPP */
#define stricmp(a,b) strcasecmp(a,b)
#endif
#ifndef getxkey		/* getxkey is available only on DJGPP */
#define getxkey getchar
#endif
#endif

/* Read file filename - or if filename is NULL, prompt the user  */
/* to specify the name of some 'describe' file. Returns the file */
/* size and a pointer to the loaded file contents in RAM.        */
/* The buffer will be allocated and returned by the function.    */
uint32 fileread(char * describe, char * filename, unsigned char ** buffer)
{
  char loadname[200];		/* file name */
  size_t filesize;              /* size of stimulus file */

  filesize = 0;
  do {
    struct stat fileinfo;

    if (!filesize) {
      if (filename) {
        strncpy(loadname, filename, 160);
        loadname[160] = 0;
        /* sprintf(loadname, "%160s", filename); <-- puts garbage at start */
      } else {
        printf("Please enter a %s file name ('none' = abort):\n", describe);
        scanf ("%160s", loadname);
        if (!stricmp(loadname,"none"))
          return 0;
      }
    }

    if (stat (loadname, &fileinfo)) {
      perror ("Error opening file");
    } else {
      if ( (S_IRUSR & fileinfo.st_mode) &&
        S_ISREG(fileinfo.st_mode) ) {
        filesize = fileinfo.st_size;
      } else {
        printf ("'%s' is %s. Try again.\n", loadname,
          ( S_ISREG(fileinfo.st_mode)
            ? "not readable" : "not a regular file" ) );
      } /* no readable regular file */
    } /* file exits at all */
  } while ((!filesize) && (!filename)); /* repeat until file okay */
  			/* do not repeat if non-interactive mode */
  if (!filesize) {
    printf("Failed to open file '%s'.\n", loadname);
    getxkey();
    return 0;
  }

  /* do ... while the following? */
  { /* read file to buffer */
    int i;	/* file handle */

    *buffer = (char *)malloc(filesize);
    if (*buffer == NULL) {
      perror ("Could not allocate buffer to load file\n");
      getxkey();
      return 0;
    }

#ifdef __DJGPP__ /* DOS uses binary vs. text open modes */
    if ( (i = open (loadname, O_RDONLY | O_BINARY)) < 0) {
#else
    if ( (i = open (loadname, O_RDONLY)) < 0) {
#endif
      perror ("Could not open file");
      getxkey();
      return 0;
    }
    if (read (i, *buffer, filesize) != filesize) {
      close (i);
      perror ("Could not read whole file");
      getxkey();
      return 0;
    }
    close (i);
  } /* file is in buffer now */

  return filesize;
} /* fileread */

