        org 0x100
start:  mov ax,0x13
        int 0x10        ; 320x200 graphics mode
        mov word [cs:scopex],0
repeat:
        mov dx,0x378    ; base, see 40[8]
        inc dx
        inc dx          ; control
        in al,dx
        or al,0x21      ; in, stb
        and al,0xfd     ; disable (set ~cs / ~afeed to HI, inverted!)
        out dx,al	; (~cs being HI means "chip not selected")
        call wait2
        or al,2         ; enable (~cs now LO, communication enabled)
        call wait2

        push dx
        push ax
        dec dx
        in al,dx
        mov [cs:tlb],al
        pop ax
        pop dx
                        ; now read: 2 tristates, 1 zero,
                        ; 12 data bits, 12 mirrored data bits
                        ; CX 27, BX 0x1000*8 ???
        mov cx,32
        mov ebx,0x1000*4	; *4 or *8 ???
        xor si,si
        xor di,di
bitget:
        push dx
        push ax
        dec dx
        dec dx          ; data
        in al,dx
        test al,0x20
        jz noX
        or si,bx
noX:    test al,0x10
        jz noY
        or di,bx
noY:    pop ax
        pop dx
        and al,0xfe     ; stb
        out dx,al
        call wait2
        or al,1         ; stb
        out dx,al
        call wait2
        shr ebx,1
        loop bitget

        and si,4095
        and di,4095
        mov [cs:x],si
        mov [cs:y],di
        call wait2
        call scope

        mov ah,1        ; if key pressed, return it
        int 0x16        ; BIOS KEY API
        jz repeat       ; else repeat
        mov ax,3
        int 0x10        ; text mode again
        mov ax,0x4c00   ; leave to DOS
        int 0x21        ; DOS API

wait2:  push ax         ; wait 2 ysec. Better 1, as each "in"
        push dx         ; or "out" between wait2 calls already takes
        mov dx,0x378    ; 1 ysec itself anyway...!
        in al,dx        ; dummy read, takes 1 ysec
; --         jmp short waitx ; dummy
; -- waitx:  in al,dx        ; second ysec
; --         jmp short waity ; dummy
; -- waity:  in al,dx        ; third ysec
        pop dx
        pop ax
        ret

x       dw 0
y       dw 0
tlb     db 0

scopex  dw 0

scope:  pusha   ; show 0..4095 as 0..199
        push es
        mov ax,0xa000
        mov es,ax
        mov cx,320
        mov bp,21
        mov ax,[cs:scopex]
        inc ax
        cmp ax,cx
        jb nowrap
        xor ax,ax
nowrap: mov [cs:scopex],ax
        mov bx,ax       ; BX has screen X part

clx:    mov al,[cs:remember+bx]
        mov ah,0
        xor dx,dx
        mul cx  ; convert to lines
        mov di,ax
        mov byte [es:bx+di], 0

cly:    mov al,[cs:remember+bx+320]
        mov ah,0
        xor dx,dx
        mul cx  ; convert to lines
        mov di,ax
        mov byte [es:bx+di], 0

xscop:  mov ax,[cs:x]
        xor dx,dx
        div bp  ; range now 0..199
        mov [cs:remember+bx],al
        xor dx,dx
        mul cx  ; convert to lines
        mov di,ax
        or byte [es:bx+di], 10

yscop:  mov ax,[cs:y]
        xor dx,dx
        div bp  ; range now 0..199
        mov [cs:remember+bx+320],al
        xor dx,dx
        mul cx  ; convert to lines
        mov di,ax
        or byte [es:bx+di], 12

        pop es
        popa
        ret

remember        db 0    ; 2 buffers of 320 bytes each
        ; (not too evil not to init them at start)

