/* This is part of the NEWTRACK eyetracking software, (c) 2004 by  */
/* Eric Auer. NEWTRACK is free software; you can redistribute it   */
/* and modify it under the terms of the GNU General Public License */
/* as published by the Free Software Foundation; either version 2  */
/* of the License, or (at your option) any later version.          */
/*     NEWTRACK is distributed in the hope that it will be useful, */
/*     but WITHOUT ANY WARRANTY; without even the implied warranty */
/*     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.     */
/*     See the GNU General Public License for more details.        */
/* You should have received a copy of the GNU General Public       */
/* License (license.txt) along with this program; if not, check    */
/* www.gnu.org or write to the Free Software Foundation, Inc., 59  */
/* Temple Place, Suite 330, Boston, MA  02111-1307 USA.            */

/* parsing the whole (SMI Eyelink Saarbruecken "reading") experiment script */
/* Note that the chunker of reading does not support \-protected linebreaks */
/* and that THIS software does not support any stimulus type which needs    */
/* external files (external text, bitmap images, sound) - yet.              */
/* UPDATE 4/2005: Allow font zooming for VESA mode, with FONT_ZOOM */
/* UPDATE 4/2005: Added reading argument to do_script*() functions */

#include "tracker.h"		/* include all needed headers */

#include "script.h"		/* script processing specific things */

#if GRAPHICS
#include "vesa.h"		/* for lfbSel for FONT_ZOOM */
#endif


void do_script(char * script, char * logbuf, int reading) {	/* whole script */
  char oneline[500];		/* buffers one line, for screen and log */
  uint32 firsttime;

  logleft = LOGDATASIZE - 1000;	/* we allow max 1 message to overflow this! */
  logptr = logbuf;

  firsttime = timestamp = 0;    /* log lines use "timestamp - firsttime" */
  				/* (timestamps are dummy in here) */
  oneline[0] = '\0';

  { /* variable scope: resolution log */
      int rows, cols, fake;

      rows = get_resolution_y (&cols, &fake);
      if (cols < 160) {				/* Use VIRTUAL 8x16 font */
          rows *= 16;				/* ***  MUST  MATCH  *** */
          cols *= 8;				/* *** get_pixel_xy! *** */
      } else {
          LOG_STRING ("EXPERIMENT ABORTED nottextmode");
          return;
      }
#if GRAPHICS					/* new 4/2005: VESA FONT_ZOOM */
      if (lfbSel > 0) {
          cols *= FONT_ZOOM;
          rows *= FONT_ZOOM;
      }
#endif
      sprintf (oneline, "DISPLAY_COORDS %d %d %d %d", 0, 0, cols, rows);
      LOG_STRING (oneline);			/* screen size in pixels */
  } /* variable scope: resolution log */

  do_script_defines (script, reading);	/* read all "define" lines */

  do_script_trials (script, reading);	/* do all trials */

  return;
} /* do_script */

