/* This is part of the NEWTRACK eyetracking software, (c) 2004 by  */
/* Eric Auer. NEWTRACK is free software; you can redistribute it   */
/* and modify it under the terms of the GNU General Public License */
/* as published by the Free Software Foundation; either version 2  */
/* of the License, or (at your option) any later version.          */
/*     NEWTRACK is distributed in the hope that it will be useful, */
/*     but WITHOUT ANY WARRANTY; without even the implied warranty */
/*     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.     */
/*     See the GNU General Public License for more details.        */
/* You should have received a copy of the GNU General Public       */
/* License (license.txt) along with this program; if not, check    */
/* www.gnu.org or write to the Free Software Foundation, Inc., 59  */
/* Temple Place, Suite 330, Boston, MA  02111-1307 USA.            */

/* parsing the whole (SMI Eyelink Saarbruecken "reading") experiment script */
/* Note that the chunker of reading does not support \-protected linebreaks */
/* and that THIS software does not support any stimulus type which needs    */
/* external files (external text, bitmap images, sound) - yet.              */
/* UPDATE  4/2005: Added MANUAL_ACTIVATE and DRIFT_PSEUDO trial types as    */
/*   new names for old-style variants of AUTO_ACTIVATE and DRIFT_CORRECT.   */
/* UPDATE  4/2005: Made .streaming a bit field of STREAMFIX and STREAMWORD. */
/* UPDATE  4/2005: Added alignment argment to layout - CENTERED or TOPLEFT. */

#ifndef SCRIPT_H
#define SCRIPT_H 1

#include "ctype.h"		/* toupper etc. */

#define LEAVE_THRESHOLD 8000	/* ysecs after which an area is really left */
#define ENTER_THRESHOLD 8000	/* ysecs after which an area is really entered */
#define GAZE_ACT_THRESHOLD 400000	/* ysecs of dwelltime for gaze act. */

#define GAZE_PAUSE 2500000	/* ysecs during which d.c./g.a. are blocked */
				/* stops people from entering next too fast */

/* bit flags: */
#define STREAMFIX 1		/* log fixation stream */
#define STREAMWORD 2		/* log stream of enter / leave word events */

/* enumeration: */
#define CENTERED 42		/* classic NEWTRACK stimuli: X / Y centered */
#define TOPLEFT 43		/* READING style layout: left / top aligned */

/* enumeration: */
#define GAZE_ACTIVATE 1		/* looking at rectangle starts trial */
				/* (rectangle is masked 1st area)    */
#define AUTO_ACTIVATE 2		/* trial starts at once */
#define DRIFT_CORRECT 3		/* drift correction before trial */
#define MANUAL_ACTIVATE 4	/* show test grid, wait for operator key, */
				/* added 4/2005, to make AUTO really auto */
#define DRIFT_PSEUDO 5		/* added 4/2005: looks like DRIFT_CORRECT */
				/* but does not touch calibration. Use to */
				/* simulate NEWTRACK 2004 behaviour...    */


/* the following is used for analyze.c and in trials.c */

#define MAX_AREAS 2020		/* max. number of words on screen */

typedef struct wordArea {
  char theWord[80];		/* should we use something more efficient? */
  int pminx, pminy, pmaxx, pmaxy;	/* pixel coordinates */
  int minx, miny, maxx, maxy;		/* char coordinates  */
  uint32 dwelltime;			/* accumulate time here */
  float avgxsum, avgysum;		/* accumulate position here */
} WORD_AREA;

WORD_AREA areas[MAX_AREAS];		/* stores word area descriptions */


/* the following {MIN,PREF}_{XMARGIN,XSPACING} defines are for layout.c */

#define MIN_XSPACING 1		/* min. number of spaces between words */
#define TOPLEFT_MIN_XMARGIN 3	/* 4/2005, for TOPLEFT (not CENTERED) layout */
#define TOPLEFT_PREF_XMARGIN 5	/* 4/2005, for TOPLEFT (not CENTERED) layout */

#if GRAPHICS	/* e.g. 1024x768 is only 64x24 when using a 16x32 font... */
#define MIN_XMARGIN 1		/* if it gives less rows, use this one (4? 1?) */
#define PREF_XMARGIN 5		/* if not, better use this one (8? 4?) */
#define PREF_XSPACING 1		/* preferred number of spaces between words */
#else
#define MIN_XMARGIN 4		/* if it gives less rows, use this one (4? 1?) */
#define PREF_XMARGIN 8		/* if not, better use this one (8? 4?) */
#define PREF_XSPACING 2		/* preferred number of spaces between words */
#endif


#define SINGLE_LINE 0x100	/* special bit flag for layout() lines */
	/* if set, not N lines reserved, but only line N allowed (10/2004) */

typedef struct defLine {
  char typename[80];		/* Name of this trial type */
  int start_type;		/* GAZE_ACTIVATE, AUTO_ACTIVATE or DRIFT_CORRECT */
  				/* or MANUAL_ACTIVATE (added 4/2005) */
  int streaming;		/* WAS: 1 to log eye movement analysis */
  				/* new 4/2005: bits STREAMFIX, STREAMWORD */
  int buttons;			/* can contain YESBUTTON, NOBUTTON, ... */
  char keybuttons[10];		/* list of possible keyboard replies (if any) */
} DEF_LINE;


#define LOG_STRING(s) { 			\
  sprintf (logptr, "%7.7u %s\r\n", (timestamp-firsttime)/1000, s); \
  if (logleft > strlen (logptr)) {		\
      logleft -= strlen (logptr);		\
      logptr += strlen (logptr);		\
  } else {	/* to avoid this: flush log */	\
  		/* BEFORE trial if >50% full */	\
      strcpy (logptr, "* LOG BUFFER FULL *\n");	\
      return;	/* abort experiment here */	\
  }						\
} /* timestamps are in milliseconds, so 7 digits are enough for hours */

/* (we even reset the timestamps for each new trial - 999 secs: 6 digits)  */
/* You can use either \r\n or \n or \r for DOS, Linux or Mac linebreaks in */
/* the log files, simply by changing only the above sprintf line.          */


char * logptr;			/* pointer into logbuf */
uint32 logleft;			/* how much space is left in logbuf */
DEF_LINE trial_types[42];	/* different types of trials -> define ... */
uint32 timestamp;		/* ysec time, also used for */
 				/* msec time timestamp in LOG_STRING */


#if 0	/* already in tracker.h */
! /* initial entry point to script processing area, initializing variables */
! void do_script(char * script, char * logbuf, int reading);	/* script.c */
#endif


/* find all "define" lines in script */
/* if reading is nonzero, assume READING script semantics */
void do_script_defines(char * script, int reading);	/* script_d.c */


/* run all trials in script */
/* if reading is nonzero, assume READING script semantics */
void do_script_trials(char * script, int reading);	/* trials.c */


/* layout.c: line-wrap and layout one trial */

char * get_line(int line);	/* pick a line of text from layout result */

int get_line_ypos(int line, int lines, int * xpos);	/* get suitable Y  */
    /* coordinate for line number "line" which is one out of "lines"       */
    /* stimulus lines ... and write an useful X coordinate to xpos as well */

int layout(char * text, int lines, int alignment);	/* ... text for one screen */
    /* 10/2004: reserves lines lines at top (positive) or bottom (negative) */
    /* returns number of lines found. The alignment is CENTERED or TOPLEFT. */
    /* see above for special SINGLE_LINE flag which can be set in lines. */


/* analyze.c: describe word positions and find word for coordinates */

/* browse through stimulus and create the INFO WORD log lines:   */
/* INFO WORD areanumber leftpix toppix rightpix bottompix string */
/* This assumes a virtual 8x16 font, as does get_pixel_xy etc.!  */ 
void describe_stimulus (int usedlines);	/* Also initializes area list! */

/* this step only gives an "for this moment" decision        */
/* input is in VIRTUAL pixels, as returned by get_pixel_xy() */
/* return value is an area number or -1                      */
int analyze_focus(int usedlines, int xeye, int yeye);	/* PIXEL coords now! */

char * word_for_area(int area);				/* guess what :-) */


/* fixation.c: check for fixations and saccades and log them */

/* the output is written as a string to the log buffer */
/* to configure the detection thresholds, edit the #defines in fixation.c */
void check_fixations(uint32 firsttime);  /* firsttime is a timestamp */

#endif

