/* This is part of the NEWTRACK eyetracking software, (c) 2004 by  */
/* Eric Auer. NEWTRACK is free software; you can redistribute it   */
/* and modify it under the terms of the GNU General Public License */
/* as published by the Free Software Foundation; either version 2  */
/* of the License, or (at your option) any later version.          */
/*     NEWTRACK is distributed in the hope that it will be useful, */
/*     but WITHOUT ANY WARRANTY; without even the implied warranty */
/*     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.     */
/*     See the GNU General Public License for more details.        */
/* You should have received a copy of the GNU General Public       */
/* License (license.txt) along with this program; if not, check    */
/* www.gnu.org or write to the Free Software Foundation, Inc., 59  */
/* Temple Place, Suite 330, Boston, MA  02111-1307 USA.            */

/* read all "define" lines from the experiment script and store */
/* the collected trial type class data in a global array.       */
/* UPDATE 4/2005: Added F E T P types for READING compatibility */
/* UPDATE 4/2005: Made .streaming a bit field of STREAMFIX and STREAMWORD  */

#include "tracker.h"		/* include all needed headers */

#include "script.h"		/* script processing specific things */


/* if reading is nonzero, assume READING script semantics */
void do_script_defines(char * script, int reading) {	/* define lines */
  char oneword[80];		/* buffers one word */
  char oneline[500];		/* buffers one line, for screen and log */
  char * trial;			/* start of the description of one trial */
  int wordlen;
  int tt;			/* number of last type definition */
  uint32 firsttime;

  trial = script;
  firsttime = timestamp = 0;    /* log lines use "timestamp - firsttime" */
  				/* (timestamps are dummy in here) */
  oneword[0] = oneline[0] = '\0';


  for (tt = 0; tt < 42; tt++) {
      trial_types[tt].keybuttons[0] = '\0';
      trial_types[tt].typename[0] = '\0';
  }
  tt = 0;
                  
  timestamp = 0;

  while (*trial) {

      wordlen = get_word (trial, oneword, &trial, 1 /* skip comments */);
      if (!wordlen)				/* linebreak? */
          continue;

      if (!strcmp (oneword, "define")) {	/* define ... line */
          int buttons;

          wordlen = get_word (trial, oneword, &trial, 1);	/* type name */
          if (!wordlen) {
              LOG_STRING ("DEFINE ERROR noname");
              continue;				/* ignore incomplete define */
          }
          strcpy (trial_types[tt].typename, oneword);

          wordlen = get_word (trial, oneword, &trial, 1);	/* gaze/... */
          if (!wordlen) {
              LOG_STRING ("DEFINE ERROR notype");
              continue;				/* ignore incomplete define */
          }
          switch (toupper(oneword[0])) {	/* F E T P all added 4/2005 */
              case 'F': /* READING compatibilty: "faster N" */
              case 'N': trial_types[tt].start_type = AUTO_ACTIVATE;   break;
              case 'G': trial_types[tt].start_type = GAZE_ACTIVATE;   break;
              case 'E': /* READING compatibilty: "faster D" */
              case 'D': trial_types[tt].start_type = DRIFT_CORRECT;   break;
              /* NEWTRACK-specific - show test grid, wait for operator: */
              case 'T': trial_types[tt].start_type = MANUAL_ACTIVATE; break;
              /* NEWTRACK-specific - PSEUDO drift-correct, show mark but */
              /* do not use sampled data for calibration modification:   */
              case 'P': trial_types[tt].start_type = DRIFT_PSEUDO;    break;
              default: LOG_STRING ("DEFINE WARNING unknowntype");
                  trial_types[tt].start_type = AUTO_ACTIVATE;
          } /* switch */

          wordlen = get_word (trial, oneword, &trial, 1);	/* stream */
          if (!wordlen) {
              LOG_STRING ("DEFINE ERROR nostreamsel");
              continue;				/* ignore incomplete define */
          }

          switch (toupper(oneword[0])) {	/* pre-4/2005: n was 0, other 1 */
              case 'W':	/* new name 'words' for NEWTRACKs 'nostream' semantics */
              case 'N': trial_types[tt].streaming = STREAMWORD;
                  break; /* 'words' - log only enter / leave word events */
              case 'F': trial_types[tt].streaming = STREAMFIX;
                  break; /* 'fixations' - log only fixations */
              case 'M': trial_types[tt].streaming = 0;
                  break; /* 'mute' - only log low-freq events like buttons */
              case 'S': trial_types[tt].streaming = STREAMWORD | STREAMFIX;
                  break; /* 'stream' - log both fixations and word events */
              default:  trial_types[tt].streaming = STREAMWORD | STREAMFIX;
          }

          if (reading) {				/* new 4/2005 */
              if ( (trial_types[tt].streaming == STREAMWORD) &&
                   (toupper(oneword[0]) == 'N') ) {
                  trial_types[tt].streaming = STREAMFIX; 
              }
              trial_types[tt].streaming |= STREAMFIX;
              /* READING always logs fixations, only WORD events are config'able */
              /* Semantics of 'nostream' in READING is 'fixations', not 'words'. */
          }

          wordlen = get_word (trial, oneword, &trial, 1);	/* 1st button */
          if (!wordlen) {
              LOG_STRING ("DEFINE ERROR nobuttons");
              continue;		/* ignore incomplete define */
          }
          for (buttons = 0; buttons < 10; buttons++)
              trial_types[tt].keybuttons[buttons] = '\0';
          buttons = 0;

          do {

              if (!strcmp (oneword, "left") || !strcmp (oneword, "down")) {
                  buttons |= YESBUTTON;
              } else if
                 (!strcmp (oneword, "right") || !strcmp(oneword, "up")) {
                  buttons |= NOBUTTON;
              } else if
                 (wordlen > 1) {
                  sprintf (oneline, "DEFINE ERROR invalidbutton %s", oneword);
                  LOG_STRING (oneline);
                  /* IGNORE invalid button name */
              } else if
                 (strlen (trial_types[tt].keybuttons) < 8) {	/* space left? */
                     trial_types[tt].keybuttons[
                         strlen (trial_types[tt].keybuttons)] = oneword[0];
                         /* then append it to the list of valid keybuttons */
              } else {
                  sprintf (oneline, "DEFINE ERROR toomanykeys %s", oneword);
                  LOG_STRING (oneline);
                  /* IGNORE overflowing keybutton definition */
              }

              wordlen = get_word (trial, oneword, &trial, 1);	/* next button */

          } while (wordlen);			/* collect all valid buttons */

          trial_types[tt].buttons = buttons;	/* store the button bitmask! */

          if (tt < (42-1)) {
              tt++;				/* define line complete now */
          } else {
              LOG_STRING ("DEFINE ERROR toomanydefines");
          }
          /* if too many trial types are defined, they overwrite each other */

          continue;				/* back to trial loop */

      } /* define line */ else {		/* stimulus line */

          /* current word: Type selection */
          wordlen = get_word (trial, oneword, &trial, 1);	/* label */
          if (!wordlen) continue;
          wordlen = get_word (trial, oneword, &trial, 1);	/* timeout */
          if (!wordlen) continue;
          wordlen = get_word (trial, oneword, &trial, 1);	/* inline */
          if (!wordlen) continue;
#if GRAPHICS	/* stimulus types which can have multiline text (11/2004) */
          if ( (!strcmp (oneword, "inline")) ||
               (!strcmp (oneword, "inlineleft")) ||		/* 4/2005 */
               (!strcmp (oneword, "image")) ||
               (!strcmp (oneword, "image2")) ) {
#else
          if ( (!strcmp (oneword, "inline")) ||
               (!strcmp (oneword, "inlineleft")) ) {		/* 4/2005 */
#endif
              do {
                  wordlen = get_word (trial, oneword, &trial, 0);
                  /* no checking for comments here. */
                  /* multiline trials are possible. */
              } while (wordlen);			/* skip to end of line */
          } /* inline trial */

      } /* stimulus line (an actual trial) */

  } /* while *trial */

  return;
} /* do_script_defines */

