; A tool to save the VGA BIOS into a file and to
; load a VGA BIOS image from a file and run it.
; Written by Eric Auer 2004. Public domain.

; WARNING: Some BIOSes can only be run from the
; normal 0xc000:0 location. Those will CRASH when
; you try to run them with this tool. This tool
; will only work on 386 or newer CPUs.

	org 0x100

start:
	push ax			; reduce (useful if it has been 0)
	cmp sp,vbiosseg+2048	; require enough RAM free (.com style)
	pop ax
	ja ram_ok
	mov dx,lowrammsg	; simple: give up if < 63k RAM free:
	call showmsg		; could be changed to allow less if
	mov ax,0x4c02		; the BIOS in question is smaller...
	int 0x21		; exit with errorlevel 2


ram_ok:				; enough RAM free? Then parse the
				; command line arguments...
	cld
	mov si,0x81		; command line starts here
	call skip_space
	cmp al,'S'
	jz do_save		; save BIOS to file
	cmp al,'s'
	jz do_save		; save BIOS to file
	cmp al,'L'
	jz do_load		; load BIOS from file and initialize it
	cmp al,'l'
	jz do_load		; load BIOS from file and initialize it
				; everything else -> syntax error
no_args:
	mov dx,helpmsg		; show help screen
	call showmsg
	mov ax,0x4cff		; exit with errorlevel 255
	int 0x21


do_save:
	call skip_space
	dec si
	mov dx,savemsg
	call showmsg
	push si			; filename starts here
	call make_asciiz
	pop dx			; filename starts here

	mov ax,0x3c00		; create (or truncate!) and open file
	mov cx,0		; no special attributes
	int 0x21
	jnc creat_ok		; if failed, abort - else continue
	mov dx,nocreatmsg
	jmp file_err


creat_ok:			; AX contains file handle now
	mov bx,ax
	mov ax,0xc000		; VGA BIOS segment
	mov ds,ax
	xor dx,dx		; VGA BIOS offset
	cmp word [ds:0],0xaa55	; BIOSes start with bytes 55, aa
	jnz near not_a_bios
	mov ch,0
	mov cl,[ds:2]		; size indicator byte
	cmp cl,60*2		; more than 60k? Then refuse.
	ja near too_big_bios
	shl cx,9		; convert to bytes
	mov ah,0x40		; write to file handle BX
	int 0x21
	mov dx,nowritemsg	; prepare for file read error message
	jc file_err		; if failed, abort...
				; ...else AX contains the actual number
				; of bytes written now.
	push cs
	pop ds
	mov ah,0x3e		; close file handle BX
	int 0x21

	mov ax,0x4c00		; exit with errorlevel 0
	int 0x21


do_load:
	call skip_space
	dec si
	mov dx,loadmsg
	call showmsg
	push si			; filename starts here
	call make_asciiz
	pop dx			; filename starts here
	jmp load_bios


; ------------------------------


skip_space:			; read from DS:SI until real char found
parse:	lodsb
	cmp al,9
	jz parse		; ignore tab
	cmp al,' '
	jz parse		; ignore space
	cmp al,13
	jbe near no_args	; end of command line (jump out of call!)
	ret			; return with first real char in AL


; ------------------------------


make_asciiz:			; replace end_of_value by 0 char
	push si
scan:	lodsb
	cmp al,9
	jz parsed		; ignore tab
	cmp al,' '
	jz parsed		; ignore space
	cmp al,13
	jbe parsed		; end of command line
	jmp short scan
parsed:	mov byte [si-1],0	; replace first char after value by 0
	pop si
	ret


; ------------------------------


load_bios:			; load file [name at DS:DX] to buffer
	mov ax,0x3d00		; open for reading
	int 0x21
	jnc open_ok		; if failed, abort - else continue
	mov dx,nofilemsg
file_err:
	push ax
	call showmsg
	pop ax
	mov ah,0x4c		; exit with errorlevel from error code
	int 0x21


open_ok:			; AX contains file handle now
	mov bx,ax
	mov ah,0x3f		; read from file handle BX
	mov cx,60*1024		; at most 60k
	mov dx,vbiosseg		; read into buffer (DS equal to CS)
	int 0x21
	mov dx,noreadmsg	; prepare for file read error message
	jc file_err		; if failed, abort...
				; ...else AX contains the actual number
				; of bytes read now (usually < 60k).
	mov ah,0x3e		; close file handle BX
	int 0x21
	jmp runbios		; all ready to run that BIOS now


; ------------------------------


not_a_bios:
	mov dx,badbiosmsg
	call showmsg
	push cs
	pop ds
	mov ax,0x4c01		; exit with errorlevel 1
	int 0x21


too_big_bios:			; for BIOS > 60k, we would have to
				; move the stack out of the way.
	mov dx,bigbiosmsg
	call showmsg
	push cs
	pop ds
	mov ax,0x4c01		; exit with errorlevel 1
	int 0x21


too_little_ram:			; BIOS buffer is in the way of
				; our stack
	mov dx,nomemmsg
	call showmsg
	push cs
	pop ds
	mov ax,0x4c01		; exit with errorlevel 1
	int 0x21


; ------------------------------


runbios:			; run the BIOS in our buffer
	mov ax,cs
	push bx
	mov bx,vbiosseg+15	; offset of BIOS load buffer
	shr bx,4		; turn into seg offset
	add ax,bx		; calculate buffer segment
	pop bx
	mov ds,ax
	cmp word [ds:0],0xaa55	; BIOSes start with bytes 55, aa
	jnz not_a_bios		; abort if no real BIOS image
	mov al,[ds:2]
	cmp al,60*2		; more than 60k size?
	ja too_big_bios		; too big for this version
	mov ah,0		; convert to word
	shl ax,9		; convert size to bytes
	add ax,vbiosseg		; convert to offset in CS
	add ax,2048		; reserve 2k for stack
	push ax			; reduce SP (if it has been 0)
	cmp ax,sp		; BIOS too big for us?
	pop ax
	ja too_little_ram	; as SS is equal to CS in .com,
				; SP must be > end_of_BIOS+2k
	
	mov dx,domsg
	call showmsg

	cli
	call save_bios_data
	push cs
	push word ret_from_bios
	push ds			; BIOS loaded to DS:0
	push word 3
	retf			; entry point is at DS:3


ret_from_bios:

	; *** could do something with the temporarily loaded   ***
	; *** VGA BIOS now, but for our purposes, it is enough ***
	; *** to know that we are in text mode after init now! ***

	call restore_bios_data
	sti
	mov dx,donemsg
	call showmsg
	mov ax,0x4c00		; exit, errorlevel 0
	int 0x21


; ------------------------------


showmsg:			; show message at CS:DX
	push ax
	push ds
	push cs
	pop ds
	mov ah,9		; show message
	int 0x21		; DOS API
	pop ds
	pop ax
	ret


; ------------------------------


save_bios_data:
	push ds
	push eax
	xor ax,ax
	mov ds,ax		; segment 0
	mov eax,[4*0x10]	; int 0x10 vector (current video API)
	mov [cs:i10],eax
	mov eax,[4*0x1f]	; int 0x1f vector (8x8 charset)
	mov [cs:i1f],eax
	mov eax,[4*0x42]	; int 0x42 vector (old video API)
	mov [cs:i42],eax
	mov eax,[4*0x43]	; int 0x43 vector (EGA charset)
	mov [cs:i43],eax
	mov eax,[4*0x6d]	; int 0x6d vector (VGA video API)
	mov [cs:i6d],eax
	mov eax,[0x4a8]		; video save pointer table pointer
	mov [cs:vspt],eax
	; *** other 40:xx video state information not saved: ***
	; *** should not be necessary to do this in our case ***
	pop eax
	pop ds
	ret


; ------------------------------


restore_bios_data:
	push ds
	push eax
	xor ax,ax
	mov ds,ax		; segment 0
	mov eax,[cs:i10]
	mov [4*0x10],eax	; int 0x10 vector (current video API)
	mov eax,[cs:i1f]
	mov [4*0x1f],eax	; int 0x1f vector (8x8 charset)
	mov eax,[cs:i42]
	mov [4*0x42],eax	; int 0x42 vector (old video API)
	mov eax,[cs:i43]
	mov [4*0x43],eax	; int 0x43 vector (EGA charset)
	mov eax,[cs:i6d]
	mov [4*0x6d],eax	; int 0x6d vector (VGA video API)
	mov eax,[cs:vspt]
	mov [0x4a8],eax		; video save pointer table pointer
	pop eax
	pop ds
	ret


; ------------------------------


i10	dd 0		; int 0x10 vector
i1f	dd 0		; int 0x1f vector
i42	dd 0		; int 0x42 vector
i43	dd 0		; int 0x43 vector
i6d	dd 0		; int 0x6d vector
vspt	dd 0		; video save pointer table (lists 5 pointers)


; ------------------------------


domsg	db "Running temporary VGA BIOS image from DOS RAM now."
	db 13,10,"$"
donemsg	db "VGA BIOS initialization done, unloading BIOS again."
	db 13,10,"$"

; *** idxbiosmsg	db "VGA BIOS contains IDX data - improved chances",13,10
; ***			db "to work with USEVBIOS.",13,10
; *** <-- add idx scan to save mode in a later version...

badbiosmsg	db "No proper VGA BIOS.",13,10,"$"
bigbiosmsg	db "VGA BIOS is bigger than 60k, not supported yet."
		db 13,10,"$"
nomemmsg	db "Not enough memory free to load VGA BIOS."
		db 13,10,"$"

nofilemsg	db "Could not open file.",13,10,"$"
noreadmsg	db "Error reading from file.",13,10,"$"
nocreatmsg	db "Could not create (or overwrite) file.",13,10,"$"
nowritemsg	db "Could not write VGA BIOS image to file.",13,10,"$"
lowrammsg	db "63k of free RAM needed for this tool.",13,10,"$"

loadmsg		db "Loading and initializing VGA BIOS from file.",13,10,"$"
savemsg		db "Saving VGA BIOS to file.",13,10,"$"
helpmsg		db "Usage:",13,10
		db "Save VGA BIOS image to file:",13,10
		db "USEVBIOS S filename",13,10
		db "Load, initialize and unload VGA BIOS image:",13,10
		db "USEVBIOS L filename",13,10
		db "Be warned that 'L' mode can crash for some BIOSes"
		db 13,10,"$"

; ------------------------------


	align 16
vbiosseg	dw 0	; BIOS will be loaded here
