/* This is part of the NEWTRACK eyetracking software, (c) 2004 by  */
/* Eric Auer. NEWTRACK is free software; you can redistribute it   */
/* and modify it under the terms of the GNU General Public License */
/* as published by the Free Software Foundation; either version 2  */
/* of the License, or (at your option) any later version.          */
/*     NEWTRACK is distributed in the hope that it will be useful, */
/*     but WITHOUT ANY WARRANTY; without even the implied warranty */
/*     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.     */
/*     See the GNU General Public License for more details.        */
/* You should have received a copy of the GNU General Public       */
/* License (license.txt) along with this program; if not, check    */
/* www.gnu.org or write to the Free Software Foundation, Inc., 59  */
/* Temple Place, Suite 330, Boston, MA  02111-1307 USA.            */

/* Functions, data and defines to use VESA LFB graphics modes */
/* UPDATE 2/2005: Added vesaunix support for PCX2TPL Linux binary */

#ifndef __DJGPP__
#include "vesaunix.h"	/* use non-DJGPP version, not this vesa.h! */
#define VESA_H 2	/* suppress normal version */
#endif

#ifndef VESA_H
#define VESA_H 1

#include "tracker.h"	/* includes arch.h etc. */
#include "vesadata.h"	/* data structures */


			/* If we would INIT "... lfbSel = 0", then we would  */
			/* get a SEPARATE lfbSel variable for EACH .o! Yikes */
VESA_MODE vesamode;	/* globally used current VESA video mode description */
int lfbSel;	  	/* globally used selector for LFB memory access      */
uint16 palette[256];	/* palette for 8 bit color data interpretation       */
uint8 * pixelspace;	/* pointer for general purpose 8 bit "second page"   */
#define spacePIX(a,b) pixelspace[(a) + ((b) * vesamode.width)]


#define RGB2c(r,g,b) ( (((r)>>(8-vesamode.redBits)) << vesamode.redShift) | \
 (((g)>>(8-vesamode.greenBits)) << vesamode.greenShift) | \
  (((b)>>(8-vesamode.blueBits)) << vesamode.blueShift) )
  
  /* no "putpixel" for text and EGA (4 plane) memory modes provided here... */
#define putpixel8(x,y,c) _farpokeb(lfbSel, \
  ((x) + (vesamode.bytes_line*(y))), (c))
#define putpixel16(x,y,c) _farpokew(lfbSel, \
  (((x)*2) + (vesamode.bytes_line*(y))), (c))
#define putpixel24(x,y,c) _farpokel(lfbSel, \
  (((x)*3) + (vesamode.bytes_line*(y))), (c))
#define putpixel32(x,y,c) _farpokel(lfbSel, \
  (((x)*4) + (vesamode.bytes_line*(y))), (c))

/* Enter VESA mode with requested width and height and depth - use   */
/* height <0 for: min -h. Use -bits value to enable status messages. */
/* Returns nonzero on failure. Use width 0 to enter 80x25 text mode. */
/* ADDED 11/2004 --> */
/* if khz is set, tries to configure to khz kHz hrefresh rate, if    */
/* VBE 3.0 present (newer nVidia / 3dfx). Limits vrefresh to 140 Hz. */
int vesainit(int width, int height, int bits, int khz);

/* Modify current mode - as described in vesamode structure - to use */
/* new hrefresh rate of khz kilohertz. Needs VESA mode number, too.  */
/* returns nonzero values if something went wrong. */
int vbe3refresh(int khz, uint16 modenumber);

#endif
