{
    BSD 3-Clause License
    Copyright (c) 2021, Jerome Shidel
    All rights reserved.
}

{$I INFERNO.DEF}
program Inferno_Test_Application;

uses Inferno;

var
    Smiley : PSprite;

procedure Run;
var
    Event : TEvent;
begin
    Video^.SpriteShow(Smiley);

    Video^.Update;
    Wait(1000, False);
end;

procedure Prepare;
var
    P : PAsset;
begin
    Smiley := nil;
    if AssetLoad('SMILEY.IGS', asDefault, P) then
        Smiley := P^.Data;
end;

procedure Initialize;
begin
    { If assets are attached to the executable, or compiled with D+, or
      drivers and fonts are (by default) available in the EXE's directory,
      then there is no need to add these system paths to the Asset Index }
    AssetIndexSys('DRIVERS\', '');
    AssetIndexSys('FONTS\', '');
end;

begin
    Initialize; { settings/changes needed before Inferno Game Engine is started }
    Ignite;     { start game engine }
    Prepare;    { Prepare for app/game run }
    Run;        { run game/program }
    Extinguish; { normal shutdown of Inferno }
end.