{
    BSD 3-Clause License
    Copyright (c) 2021, Jerome Shidel
    All rights reserved.
}

{$I INFERNO.DEF}
program Inferno_Driver_Information_Application;

uses Inferno;

procedure WriteAsciiZ(S :String; P : PAsciiZ);
var
    I : integer;
begin
    Write(S);
    I := 0;
    while Assigned(P) and (P^[I] <> #0) do begin
        if P^[I] = #13 then begin
            WriteLn;
            Write(RPad('', Length(S)));
        end else
            Write(P^[I]);
        Inc(I);
    end;
    WriteLn;
end;

procedure DriverInfo(FileName : String);
const
    Cols = 18;
var
    Driver : PDriver;
    I : integer;
    VideoModes : PVideoModes;
begin
    WriteLn(RPad('Driver:', Cols), FileName);
    if not LoadDriver(FileName, Driver) then begin
        WriteLn(RPad('Error: ', Cols), '#', GetError);
    end else begin
        with Driver^ do begin
            Write(RPad('Driver System:', Cols), Platform + ' ');
            if VersionCompat = 0 then
                WriteLN('pre-release')
            else
                WriteLn(' v' + IntStr(VersionCompat));
            WriteLn(RPad('Driver Class:', Cols), Class);
            WriteLn(RPad('Driver Name:', Cols), Name);
            WriteLn(RPad('Driver Version:', Cols), IntStr(Hi(Version)), '.', ZPad(Lo(Version), 2));
            Write(RPad('Required CPU:', Cols));
            case CPU of
                0    : WriteLn('none (8086)');
                1..2 : WriteLn(CPU, '86');
                3..6 : WriteLn('i', CPU, '86');
                7    : WriteLn('other (', CPU, ')');
            end;
            WriteLn(RPad('Memory Required:', Cols), MinimumMemory, ' bytes');
        end;
        if Driver^.Class = dcVideo then begin
            VideoModes := PVideoDriver(Driver)^.GetModes;
            I := 0;
            while VideoModes^[I].Mode <> 0 do with VideoModes^[I] do begin
                WriteLn(RPad('Video Mode ' + WordHEX(Mode) + 'h:', Cols),
                    Width, 'x', Height, ' ',
                    1 shl ColorDepth, ' colors');
                Inc(I);
            end;
        end;
        with Driver^ do begin
            WriteAsciiZ(RPad('Copyright:', Cols), GetCopyright);
            WriteAsciiZ(RPad('License:', Cols), GetLicense);
        end;
    end;
end;

var
    I : integer;
begin
    for I := 1 to ParamCount do
        DriverInfo(ParamStr(I));
end.