unit vga2;

interface

  uses Crt, dos;

 TYPE paltype = ARRAY[0..255,0..2] OF BYTE;
      fontype = ARRAY[0..40] OF pointer;
      a_palette = array[0..255,0..2] of byte; {a logical palette}
      BMP_Pal   = ARRAY[0..255,1..4] OF Byte;

CONST vvga = $A000;

      no = 8;

VAR regs : registers;
    palt : paltype;
    mousex, mousey, mouseb : WORD;
    Rx, Rx1, Ry, Ry1 : integer;

VAR x,y,sx,sy,ox,oy : ARRAY[0..no] OF INTEGER;
    back,back2,wt,n,xx,yy,c : INTEGER;

    rpx,rpy,rpx2,rpy2 : WORD;

    bck,bck2 : pointer;
    spr : ARRAY[0..no] OF pointer;

    kp : CHAR;

Procedure SetMCGA;
Procedure SetTEXT;
procedure WaitRetrace;
Procedure Pal(Col,R,G,B : Byte);
Procedure GetPal(Col : Byte; Var R,G,B : Byte);
PROCEDURE bPal(VAR palt : paltype; n,r,g,b : BYTE);
PROCEDURE SwapPal(palt : paltype);
PROCEDURE FadeOut;
PROCEDURE FadeTo(slow : WORD; palt2 : paltype);
PROCEDURE FadeOutOne;
PROCEDURE Cycle(s,e, skp : INTEGER);
PROCEDURE SavePalette(VAR palt : paltype; filename : STRING);
PROCEDURE LoadPalette(VAR palt : paltype; filename : STRING);
Procedure Cls(c : BYTE; where : WORD);
Procedure PutPixel(x, y, c, where : WORD);
Function  GetPixel(x, y, where : WORD) : BYTE;
PROCEDURE Bar(x,y,x2,y2 : WORD; c : BYTE; where : WORD);
PROCEDURE hline(x,y,x2 : WORD; c : BYTE; where : WORD);
PROCEDURE vline(x,y,y2 : WORD; c : BYTE; where : WORD);
PROCEDURE box(x1,y1,x2,y2,c : INTEGER; where : WORD);
PROCEDURE Line(x,y,x2,y2,c : INTEGER; where : WORD);
PROCEDURE makeSprite(VAR p : pointer; sx,sy : WORD);
PROCEDURE delSprite(VAR p : pointer; sx,sy : WORD);
PROCEDURE GetSprite(VAR p : pointer; x,y,sx,sy,where : WORD);
PROCEDURE putSprite(VAR p : pointer; x,y,sx,sy,where : WORD);
PROCEDURE maskSprite(VAR p : pointer; x,y,sx,sy : WORD; c : BYTE; where : WORD);
PROCEDURE ColourSprite(VAR p : pointer; x,y,sx,sy : WORD; c,c2 : BYTE; where : WORD);
PROCEDURE SaveSprite(VAR p : pointer; sx,sy : WORD; filename : STRING);
PROCEDURE LoadSprite(VAR p : pointer; sx,sy : WORD; filename : STRING);
PROCEDURE moveblock(source,x,y,sx,sy,dest : WORD);
PROCEDURE ScreenCopy(source,dest : WORD);
PROCEDURE MouseOn;
PROCEDURE ShowMouse;
PROCEDURE HideMouse;
PROCEDURE MouseXY;
PROCEDURE Squidge;
PROCEDURE DotIn(source,spd,d : WORD);
PROCEDURE LoadScreen(name : STRING; VAR palt : paltype; where : WORD);
PROCEDURE LoadFont(VAR font : fontype; VAR palt : paltype; strng : STRING; sx,sy : WORD);
PROCEDURE DelFont(VAR font : fontype; sx,sy : WORD);
PROCEDURE ConvertFont(VAR font : fontype; VAR palt : paltype; strng,save : STRING; sx,sy,y,where : WORD);
PROCEDURE Message(VAR font : fontype; x,y,sx,sy : INTEGER; strng : string; where : WORD);
PROCEDURE ColourMessage(VAR font : fontype; x,y,sx,sy,col : INTEGER; strng : string; where : WORD);
PROCEDURE Scroll_line_left(y,sy,speed,where : WORD);
PROCEDURE Scroll_line_right(y,sy,speed,where : WORD);
PROCEDURE Scroll_line_both(yy,sy,speed,where : WORD);
procedure scrollmessage(VAR font : fontype; y,sx,szy,speed : WORD; strng : STRING);
PROCEDURE KeyDelay(n : WORD);  {100ths of a second}
Procedure InitPalette(var P : Paltype; r,g,b : Byte);
Procedure SetPalette(P : Paltype; min, max : Byte);
Procedure InitxPalette(var P : Paltype; r,g,b : Byte);
PROCEDURE SetAllPal(palt : paltype);
PROCEDURE GetAllPal(var palt : paltype);
procedure MakeDefaultPal(var palt : a_palette);
PROCEDURE LoadPalette2(VAR palt : a_palette; filename : STRING);
PROCEDURE SavePalette2(VAR palt : a_palette; filename : STRING);
Procedure Set_BMP_Pal(RGB : BMP_Pal);
Procedure FadeOutFast;

implementation
{----------------------------------------------------------------------------}

Procedure SetMCGA;
  { This procedure gets you into 320x200x256 mode. }
BEGIN
     regs.ax:=$13;

     intr($10,regs);
END;

{----------------------------------------------------------------------------}

Procedure SetTEXT;
  { This procedure gets you into 320x200x256 mode. }
BEGIN
     regs.ax:=$3;

     intr($10,regs);
END;

{----------------------------------------------------------------------------}

procedure WaitRetrace;
  {  This waits for a vertical retrace to reduce snow on the screen }
VAR b : byte;
label l1, l2;
BEGIN
l1:
     IF port[$3da] and 8>0 THEN goto l1;
l2:
     IF port[$3da] and 8=0 THEN goto l2;
END;

{----------------------------------------------------------------------------}

Procedure Pal(Col,R,G,B : Byte);
  { This sets the Red, Green and Blue values of a certain color }
BEGIN
     port[$3c8]:=Col;

     port[$3c9]:=r;
     port[$3c9]:=g;
     port[$3c9]:=b;
END;

{----------------------------------------------------------------------------}

Procedure GetPal(Col : Byte; Var R,G,B : Byte);
  { This gets the Red, Green and Blue values of a certain color }
BEGIN
     port[$3c7]:=Col;

     r:=port[$3c9];
     g:=port[$3c9];
     b:=port[$3c9];
END;

{----------------------------------------------------------------------------}

PROCEDURE bPal(VAR palt : paltype; n,r,g,b : BYTE);
  {store palette entry in the palette buffer}
BEGIN
     palt[n,0]:=r;
     palt[n,1]:=g;
     palt[n,2]:=b;
END;

{----------------------------------------------------------------------------}

PROCEDURE SwapPal(palt : paltype);
  {quickly swaps to a new palette}
VAR n : BYTE;
BEGIN
     FOR n:=0 TO 255 DO
         pal(n,palt[n,0],palt[n,1],palt[n,2]);
END;

{----------------------------------------------------------------------------}

PROCEDURE FadeOut;
  { fades colours to black, (this is the text book way of doing it, it does
    have limitations as the fade is not actually quite correctly done. For a
    really good fade, use the FadeTo routine selecting a totally black palette,
    though only if you can be bothered!!!) }
VAR n, i : BYTE;
    palt : ARRAY[0..255,0..2] OF BYTE;
BEGIN
     FOR n:=0 TO 255 DO
          getpal(n,palt[n,0],palt[n,1],palt[n,2]);

     FOR i:=0 TO 63 DO
     BEGIN
          waitretrace;

          FOR n:=0 TO 255 DO
          BEGIN
               IF palt[n,0]>0 THEN dec(palt[n,0]);
               IF palt[n,1]>0 THEN dec(palt[n,1]);
               IF palt[n,2]>0 THEN dec(palt[n,2]);
               pal(n,palt[n,0],palt[n,1],palt[n,2]);
          END;
     END;
END;

{----------------------------------------------------------------------------}

PROCEDURE FadeTo(slow : WORD; palt2 : paltype);
  { does a proper fade between the current palette and the new palette}
VAR n, i, ii : BYTE;
    palt : paltype;
BEGIN
     FOR n:=0 TO 255 DO
          getpal(n,palt[n,0],palt[n,1],palt[n,2]);

     FOR i:=0 TO 63 DO
     BEGIN
          delay(slow);
          waitretrace;

          ii:=63-i;

          FOR n:=0 TO 255 DO
              pal(n,(palt2[n,0]*i+palt[n,0]*ii) div 63,
                    (palt2[n,1]*i+palt[n,1]*ii) div 63,
                    (palt2[n,2]*i+palt[n,2]*ii) div 63); {Super Fade!!!}
     END;
END;

{----------------------------------------------------------------------------}

PROCEDURE FadeOutOne;
  { fades out by one, call this 64 times to fade fully, this is good for fading
    out a screen while things are still moving!! }
VAR n, i : BYTE;
    r,g,b : BYTE;
BEGIN
     FOR n:=0 TO 255 DO
     BEGIN
          getpal(n,r,g,b);
          IF r>0 THEN dec(r);
          IF g>0 THEN dec(g);
          IF b>0 THEN dec(b);
          pal(n,r,g,b);
     END;
END;

{----------------------------------------------------------------------------}

PROCEDURE Cycle(s,e, skp : INTEGER);
VAR n,c : INTEGER;
    palt2 : paltype;
BEGIN
     FOR n:=s TO e DO
         getpal(n,palt2[n,0],palt2[n,1],palt2[n,2]);

     IF skp>0 THEN n:=skp+s else n:=e+1+skp;

     FOR c:=s TO e DO
     BEGIN
          pal(c,palt2[n,0],palt2[n,1],palt2[n,2]);
          inc(n);
          IF n>e THEN n:=s;
     END;
END;

{----------------------------------------------------------------------------}

PROCEDURE SavePalette(VAR palt : paltype; filename : STRING);
VAR fle : FILE OF paltype;
BEGIN
     {$I-}
     ASSIGN(fle,filename);
     rewrite(fle);
     {$I+}
     IF ioresult=0 THEN
     BEGIN
          write(fle,palt);
          close(fle);
     END;
END;

{----------------------------------------------------------------------------}

PROCEDURE LoadPalette(VAR palt : paltype; filename : STRING);
VAR fle : FILE OF paltype;
BEGIN
     {$I-}
     ASSIGN(fle,filename);
     reset(fle);
     {$I+}
     IF ioresult=0 THEN
     BEGIN
          read(fle,palt);
          close(fle);
     END;
END;

{----------------------------------------------------------------------------}

Procedure Cls(c : BYTE; where : WORD);
  {  Clears the screen to colour c }
BEGIN
     fillchar(mem[where:0],64000,c);
END;

{----------------------------------------------------------------------------}

Procedure PutPixel(x, y, c, where : WORD);
  { Places a pixel of colour c at x and y on screen bass address where}
BEGIN
     if x < rx then x := rx;
     if x > rx1 then x := rx1;
     if y < ry then y := ry;
     if y > ry1 then y := ry1;
     mem[where:y shl 8+y shl 6+x]:=c;
END;

{----------------------------------------------------------------------------}

Function GetPixel(x, y, where : WORD) : BYTE;
BEGIN
     getpixel:=mem[where:y shl 8+y shl 6+x];
END;

{----------------------------------------------------------------------------}

PROCEDURE Bar(x,y,x2,y2 : WORD; c : BYTE; where : WORD);
  { Draws a filled bar to where segment}
VAR pmo,py : WORD;
BEGIN
     pmo:=y shl 8+y shl 6+x;

     x2:=x2-x+1;
     y2:=y2-y;

     FOR py:=0 TO y2 DO
     BEGIN
          fillchar(mem[where:pmo],x2,c);
          inc(pmo,320);
     END;
END;

{----------------------------------------------------------------------------}

PROCEDURE hline(x,y,x2 : WORD; c : BYTE; where : WORD);
  { draws a horizontal line}
VAR pmo,py : WORD;
BEGIN
     pmo:=y shl 8+y shl 6+x;

     x2:=x2-x+1;

     fillchar(mem[where:pmo],x2,c);
END;

{----------------------------------------------------------------------------}

PROCEDURE vline(x,y,y2 : WORD; c : BYTE; where : WORD);
  {draws a vertical line}
VAR pmo,py : WORD;
BEGIN
     pmo:=y shl 8+y shl 6+x;

     y2:=y2-y;

     FOR py:=0 TO y2 DO
     BEGIN
          mem[where:pmo]:=c;
          inc(pmo,320);
     END;
END;

{----------------------------------------------------------------------------}

PROCEDURE box(x1,y1,x2,y2,c : INTEGER; where : WORD);
  { draws a retangle / box}
VAR s : WORD;
BEGIN
     IF x1>x2 THEN BEGIN s:=x1; x1:=x2; x2:=s; END;
     IF y1>y2 THEN BEGIN s:=y1; y1:=y2; y2:=s; END;
     hline(x1,y1,x2,c,where);
     hline(x1,y2,x2,c,where);
     vline(x1,y1,y2,c,where);
     vline(x2,y1,y2,c,where);
END;

{----------------------------------------------------------------------------}

PROCEDURE Line(x,y,x2,y2,c : INTEGER; where : WORD);
  { draws a line }
VAR adx,ady : INTEGER;
    px,py : INTEGER;
    sign : SHORTINT;
    n : WORD;
BEGIN
     adx:=x2-x;
     ady:=y2-y;
     IF (adx<>0) or (ady<>0) THEN
     BEGIN
          sign:=1;
          IF abs(adx)>abs(ady) THEN
          BEGIN
               IF adx<0 THEN sign:=-1;
               adx:=abs(adx);
               FOR n:=0 TO adx DO
               BEGIN
                    py:=y+(ady*n+adx shr 1) div adx;
                    px:=x+n*sign;
                    putpixel(px,py,c,where);
               END;
          END else
          BEGIN
               IF ady<0 THEN sign:=-1;
               ady:=abs(ady);
               FOR n:=0 TO ady DO
               BEGIN
                    px:=x+(adx*n+ady shr 1) div ady;
                    py:=y+n*sign;
                    putpixel(px,py,c,where);
               END;
          END;
     END else putpixel(x,y,c,where);
END;

{----------------------------------------------------------------------------}

PROCEDURE makeSprite(VAR p : pointer; sx,sy : WORD);
  { sets up the memory for a sprite}
BEGIN
     getmem(p,sx*sy);
END;

{----------------------------------------------------------------------------}

PROCEDURE delSprite(VAR p : pointer; sx,sy : WORD);
  { frees the memory used by a sprite, n.b. this is very important if you want
    your computer to keep working (If not done then after a while you will
    find strange things happen....  CRASH!!!!) }
BEGIN
     freemem(p,sx*sy);
END;

{----------------------------------------------------------------------------}

PROCEDURE GetSprite(VAR p : pointer; x,y,sx,sy,where : WORD);
  {  This grabs a sprite from the screen or memory

     p     - a pointer pointing to a memory area for the sprite
     x,y   - top left hand corner of the sprite to grab in pixels
     sx,sy - size of sprite in pixels (not position on screen)
     where - segment address of where to grab the image off}

VAR px,py,gmo,pms,pmo : WORD;
BEGIN
     gmo:=y shl 8+y shl 6+x;

     pms:=seg(p^);
     pmo:=ofs(p^);

     FOR py:=1 TO sy DO
     BEGIN
          move(mem[where:gmo],mem[pms:pmo],sx);
          inc(gmo,320);
          inc(pmo,sx);
     END;
END;

{----------------------------------------------------------------------------}

PROCEDURE putSprite(VAR p : pointer; x,y,sx,sy,where : WORD);
  {  Pastes a sprite onto the screen or into memory}

VAR px,py,gmo,pms,pmo : WORD;
BEGIN
     gmo:=y shl 8+y shl 6+x;

     pms:=seg(p^);
     pmo:=ofs(p^);

     FOR py:=1 TO sy DO
     BEGIN
          move(mem[pms:pmo],mem[where:gmo],sx);
          inc(gmo,320);
          inc(pmo,sx);
     END;
END;

{----------------------------------------------------------------------------}

PROCEDURE maskSprite(VAR p : pointer; x,y,sx,sy : WORD; c : BYTE; where : WORD);
  { Also pastes a sprite into memory, but changes colour c of that sprite
    into a transparent mask }

VAR px,py,gmo,pms,pmo : WORD;
    cc : BYTE;
BEGIN
     gmo:=y shl 8+y shl 6+x;

     pms:=seg(p^);
     pmo:=ofs(p^);

     FOR py:=1 TO sy DO
     BEGIN
          FOR px:=1 TO sx DO
          BEGIN
               cc:=mem[pms:pmo];
               IF cc<>c THEN mem[where:gmo]:=cc;
               inc(gmo);
               inc(pmo);
          END;

          inc(gmo,320);
          dec(gmo,sx);
     END;
END;

{----------------------------------------------------------------------------}

PROCEDURE ColourSprite(VAR p : pointer; x,y,sx,sy : WORD; c,c2 : BYTE; where : WORD);
  { Pastes a sprite into memory , all the colours are changed to c2 except
    c which is a transparent mask }

VAR px,py,gmo,pms,pmo : WORD;
    cc : BYTE;
BEGIN
     gmo:=y shl 8+y shl 6+x;

     pms:=seg(p^);
     pmo:=ofs(p^);

     FOR py:=1 TO sy DO
     BEGIN
          FOR px:=1 TO sx DO
          BEGIN
               IF mem[pms:pmo]<>c THEN mem[where:gmo]:=c2;
               inc(gmo);
               inc(pmo);
          END;

          inc(gmo,320);
          dec(gmo,sx);
     END;
END;

{----------------------------------------------------------------------------}

PROCEDURE SaveSprite(VAR p : pointer; sx,sy : WORD; filename : STRING);
VAR fle : FILE;
BEGIN
     {$I-}
     ASSIGN(fle,filename);
     rewrite(fle,1);
     {$I+}
     IF ioresult=0 THEN
     BEGIN
          blockwrite(fle,p^,sx*sy);
          close(fle);
     END;
END;

{----------------------------------------------------------------------------}

PROCEDURE LoadSprite(VAR p : pointer; sx,sy : WORD; filename : STRING);
VAR fle : FILE;
BEGIN
     {$I-}
     ASSIGN(fle,filename);
     reset(fle,1);
     {$I+}
     IF ioresult=0 THEN
     BEGIN
          blockread(fle,p^,sx*sy);
          close(fle);
     END;
END;

{----------------------------------------------------------------------------}

PROCEDURE moveblock(source,x,y,sx,sy,dest : WORD);
  { Copys a block off one page onto another, like grabing a sprite and
    pasting it down on a different page in one quick go.

    p     - grabing segment address
    where - pasting segment address}

VAR py,c : WORD;
BEGIN
     c:=y shl 8+y shl 6+x;

     FOR py:=1 TO sy DO
     BEGIN
          move(mem[source:c],mem[dest:c],sx);
          inc(c,320);
     END;
END;

{----------------------------------------------------------------------------}

PROCEDURE ScreenCopy(source,dest : WORD);
  { copys the an entire screen from source to destination}
BEGIN
     move(mem[source:0],mem[dest:0],64000);
END;

{----------------------------------------------------------------------------}

PROCEDURE MouseOn;
BEGIN
     regs.ax:=0;
     intr($33,regs);
END;

{----------------------------------------------------------------------------}

PROCEDURE ShowMouse;
BEGIN
     regs.ax:=1;
     intr($33,regs);
END;

{----------------------------------------------------------------------------}

PROCEDURE HideMouse;
BEGIN
     regs.ax:=2;
     intr($33,regs);
END;

{----------------------------------------------------------------------------}

PROCEDURE MouseXY;
BEGIN
     regs.ax:=3;
     intr($33,regs);
     mouseb:=regs.bx;
     mousex:=regs.cx;
     mousey:=regs.dx;
END;

{----------------------------------------------------------------------------}

PROCEDURE Squidge;
{pull contents of the screen into a black hole sort of thing!!!!}

CONST sz = 14;
VAR p : pointer;
    x,y,n,c : INTEGER;
BEGIN
     makesprite(p,sz,sz);
     n:=0;
     c:=0;

     REPEAT
           x:=random(319-sz);
           y:=random(199-sz);

           getsprite(p,x,y,sz,sz,vvga);

           x:=(x*10+160) div 11;
           y:=(y*10+100) div 11;

           putsprite(p,x,y,sz,sz,vvga);

           inc(c);
           IF c>150 THEN
           BEGIN
                c:=0;
                box(n,n,319-n,199-n,0,vvga);
                inc(n);
           END;
     UNTIL n=99;

     delsprite(p,sz,sz);
     cls(0,vvga);
END;

{----------------------------------------------------------------------------}

PROCEDURE DotIn(source,spd,d : WORD);
  { Makes a screen stored in source appear on the vga screen slowly by
    drawing it pixel by pixel using the pattern selected by changing spd.

    spd - no of pixels between redraws
    d=delay (1=slowest, try 400-800) }

VAR n,p : WORD;
BEGIN
     p:=0;
     FOR n:=0 TO 63999 DO
     BEGIN
          mem[vvga:p]:=mem[source:p];
          p:=p+spd;
          IF p>63999 THEN dec(p,64000);
          IF n mod d=0 THEN waitretrace;
     END;
END;

{----------------------------------------------------------------------------}

PROCEDURE LoadScreen(name : STRING; VAR palt : paltype; where : WORD);
VAR fle : FILE;
    fle2 : FILE OF BYTE;
    y : WORD;
BEGIN
     {$I-}
     assign(fle,name+'.SPR');
     reset(fle,1);
     {$I+}
     IF ioresult=0 THEN
     BEGIN
          blockread(fle,mem[where:0],64000);
          close(fle);
     END;

     LoadPalette(palt,name+'.PAL');
END;

{----------------------------------------------------------------------------}

PROCEDURE LoadFont(VAR font : fontype; VAR palt : paltype; strng : STRING; sx,sy : WORD);
VAR xx,yy,n : WORD;
    fle : FILE;
BEGIN
     {$I-}
     ASSIGN(fle,strng+'.FNT');
     RESET(fle,1);
     {$I+}
     IF (ioresult=0) and (filesize(fle)=41*sx*sy) THEN
     BEGIN
          FOR n:=0 TO 40 DO
          BEGIN
               makesprite(font[n],sx,sy);
               blockread(fle,font[n]^,sx*sy);
          END;
          close(fle);
     END;

     loadpalette(palt,strng+'.FPL');
END;

{----------------------------------------------------------------------------}

PROCEDURE DelFont(VAR font : fontype; sx,sy : WORD);
VAR n : WORD;
BEGIN
     FOR n:=0 TO 40 DO
         delsprite(font[n],sx,sy);
END;

{----------------------------------------------------------------------------}

PROCEDURE ConvertFont(VAR font : fontype; VAR palt : paltype; strng,save : STRING; sx,sy,y,where : WORD);
VAR xx,yy,n : WORD;
    fle : FILE;
BEGIN
     LoadScreen(strng ,palt, where);

     xx:=0;
     yy:=y;

     FOR n:=0 TO 39 DO
     BEGIN
          makesprite(font[n],sx,sy);
          getsprite(font[n],xx,yy,sx,sy,where);
          inc(xx,sx);
          IF xx>=320 THEN
          BEGIN
               xx:=0;
               inc(yy,sy);
          END;
     END;

     cls(0,where);
     makesprite(font[40],sx,sy);
     getsprite(font[40],0,0,sx,sy,where);

     {$I-}
     ASSIGN(fle,save+'.FNT');
     REWRITE(fle,1);
     {$I+}
     IF ioresult=0 THEN
     BEGIN
          FOR n:=0 TO 40 DO
              blockwrite(fle,font[n]^,sx*sy);
          close(fle);
     END;

     savepalette(palt,save+'.FPL');

     DelFont(font, sx,sy);
END;

{----------------------------------------------------------------------------}

PROCEDURE Message(VAR font : fontype; x,y,sx,sy : INTEGER; strng : string; where : WORD);
VAR p,c : BYTE;
BEGIN
     IF x=-1 THEN x:=160-(length(strng)*sx) div 2;
     IF x<0 THEN x:=0;
     p:=0;
     WHILE (x+sx<=320) and (p<length(strng)) DO
     BEGIN
          inc(p);
          c:=ord(strng[p]);
          CASE c OF

               65..90 : dec(c,65);
               48..57 : dec(c,22);
               33 : c:=36;
               44 : c:=37;
               46 : c:=38;
               63 : c:=39;

          else
              c:=40;
          END;

          masksprite(font[c],x,y,sx,sy,0,where);
          inc(x,sx);
     END;
END;

{----------------------------------------------------------------------------}

PROCEDURE ColourMessage(VAR font : fontype; x,y,sx,sy,col : INTEGER; strng : string; where : WORD);
VAR p,c : BYTE;
BEGIN
     IF x=-1 THEN x:=160-(length(strng)*sx) div 2;
     IF x<0 THEN x:=0;
     p:=0;
     WHILE (x+sx<=320) and (p<length(strng)) DO
     BEGIN
          inc(p);
          c:=ord(strng[p]);
          CASE c OF

               65..90 : dec(c,65);
               48..57 : dec(c,22);
               33 : c:=36;
               44 : c:=37;
               46 : c:=38;
               63 : c:=39;

          else
              c:=40;
          END;

          coloursprite(font[c],x,y,sx,sy,0,col,where);
          inc(x,sx);
     END;
END;

{----------------------------------------------------------------------------}

PROCEDURE Scroll_line_left(y,sy,speed,where : WORD);
BEGIN
     y:=y shl 8+y shl 6;
     sy:=sy shl 8+sy shl 6;
     dec(sy,speed);

     move(mem[where:y+speed],mem[where:y],sy);
END;

{----------------------------------------------------------------------------}

PROCEDURE Scroll_line_right(y,sy,speed,where : WORD);
BEGIN
     y:=y shl 8+y shl 6;
     sy:=sy shl 8+sy shl 6;
     dec(sy,speed);

     move(mem[where:y],mem[where:y+speed],sy);
END;

{----------------------------------------------------------------------------}

PROCEDURE Scroll_line_both(yy,sy,speed,where : WORD);
VAR cy,d,x,y : WORD;
BEGIN
     d:=0;
     x:=320-speed;

     FOR cy:=0 TO sy-1 DO
     BEGIN
          y:=cy+yy;
          y:=y shl 8+y shl 6;
          IF d=0 THEN move(mem[where:y],mem[where:y+speed],x) else
                      move(mem[where:y+speed],mem[where:y],x);
          d:=1-d;
     END;
END;

{----------------------------------------------------------------------------}

procedure scrollmessage(VAR font : fontype; y,sx,szy,speed : WORD; strng : STRING);
VAR p,x : WORD;
    kp : char;
    c,n,sy : BYTE;
    les, leo : WORD;
    plonk : WORD;
BEGIN
     p:=0;
     x:=sx;

     plonk:=y shl 8+y shl 6+319-speed;

     REPEAT
           waitretrace;

           scroll_line_left(y,szy,speed,vvga);
           {vline(319,y,y+szy-1,0,vga);}

           FOR n:=1 TO speed DO
           BEGIN
                IF x>=sx THEN
                BEGIN
                     inc(p);
                     IF p>length(strng) THEN p:=1;

                     c:=ord(strng[p]);
                     CASE c OF

                          65..90 : dec(c,65);
                          48..57 : dec(c,22);
                          33 : c:=36;
                          44 : c:=37;
                          46 : c:=38;
                          63 : c:=39;

                     else
                         c:=40;
                     END;

                     x:=0;

                     les:=seg(font[c]^);
                     leo:=ofs(font[c]^);
                END;

                FOR sy:=0 TO szy-1 DO
                    mem[vvga:plonk+sy shl 8+sy shl 6+n]:=mem[les:leo+sx*sy];

                inc(leo);
                inc(x);
           END;

     UNTIL keypressed;
END;

{----------------------------------------------------------------------------}

PROCEDURE KeyDelay(n : WORD);  {100ths of a second}
BEGIN
     n:=(n*7) div 100;
     WHILE not keypressed AND (n>0) DO
     BEGIN
          Waitretrace;
          dec(n);
     END;
     IF keypressed THEN kp:=readkey;
END;

Procedure InitPalette(var P : Paltype; r,g,b : Byte);
var
 I : Integer;
Begin
   for I := 0 to 255 do
   Begin
     p[i,0] := I+r;
     p[i,1] := I+g;
     p[i,2] := I+b;
   End;
End;

Procedure InitxPalette(var P : Paltype; r,g,b : Byte);
var
 I : Integer;
Begin
   for I := 0 to 255 do
   Begin
     p[i,0] := I*r;
     p[i,1] := I*g;
     p[i,2] := I*b;
   End;
End;

Procedure SetPalette(P : Paltype; min, max : Byte);
var
  I : Integer;
Begin
   for I := min to max do
   Begin
      Pal(I, p[i,0], p[i,1], p[i,2]);
   End;
End;

PROCEDURE LoadPalette2(VAR palt : a_palette; filename : STRING);
{load a palette into 'palt' from a file named 'filename'}
VAR fle : FILE OF a_palette;
BEGIN
     {$I-}
     ASSIGN(fle,filename+'.pal');
     reset(fle);
     {$I+}
     IF ioresult=0 THEN
     BEGIN
          read(fle,palt);
          close(fle);
     END;
END;


PROCEDURE SavePalette2(VAR palt : a_palette; filename : STRING);
{save a palette from 'palt' into a file named 'filename'}
VAR fle : FILE OF a_palette;
BEGIN
     {$I-}
     ASSIGN(fle,filename+'.pal');
     rewrite(fle);
     {$I+}
     IF ioresult=0 THEN
     BEGIN
          write(fle,palt);
          close(fle);
     END;
END;


procedure SetPal(var palt : a_palette; col, r,g,b : byte);
{set a logical palette value}
begin
     palt[col,0]:=r;
     palt[col,1]:=g;
     palt[col,2]:=b;
end;


PROCEDURE SetAllPal(palt : paltype);
{sets the whole physical palette to a logical palettes values very quickly}
VAR p : pointer;
BEGIN
     p:=addr(palt);
     asm
        mov  dx, $3c8
        xor  al, al
        out  dx, al
        mov  ax, word ptr [p+2]
        mov  es, ax
        mov  di, word ptr [p]
        mov  cx, 256*3
        inc  dx
     @loop1:
        mov  al, [es:di]
        out  dx, al
        inc  di
        loop @loop1
     end;
END;


PROCEDURE GetAllPal(var palt : paltype);
{sets a logical palette to the values of the whole physical palette}
VAR n : BYTE;
BEGIN
     FOR n:=0 TO 255 DO
         getpal(n,palt[n,0],palt[n,1],palt[n,2]);
END;


procedure MakeDefaultPal(var palt : a_palette);
{create a nice defualt colour palette}
var r,g,b : byte;
begin
     for r:=0 to 5 do
         for g:=0 to 5 do
             for b:=0 to 5 do
                 SetPal(palt, r+g*6+b*36, r*12, g*12, b*12);
end;
Procedure Set_BMP_Pal(RGB : BMP_Pal);
var
 I : Integer;
Begin
   for i := 0 to 255 do
     Pal(I,RGB[I,3] div 4,RGB[I,2] div 4,RGB[I,1] div 4);

End;

Procedure FadeOutFast;
var
 i : integer;
begin
   for i := 0 to 255 do
     fadeoutone;
end;

begin
   rx  := 1;
   rx1 := 320;
   ry  := 1;
   ry1 := 200;
end.