#!/usr/bin/sh
# shell script for building an Agena Mac OS X PKG package on Mac OS X 10.5 Intel
# execute this script in the /installers/mac folder

# environment variables, change the following paths according to your needs

#export AGENAHOME="/Users/alexanderwalz/agena"
export AGENAHOME="../.."
export MAINTARGETDIR="$AGENAHOME/installers/mac/macinstalldir"
export AGENATARGET_USR="$MAINTARGETDIR/agena/usr"
export AGENATARGET_DOCS="$MAINTARGETDIR/agena/Library/Documentation/Agena"

#export AGENAHOME="c:/agena"
#export MAINTARGETDIR="c:/agena/installers/mac"
#export AGENATARGET_USR="$MAINTARGETDIR/agena/usr"
#export AGENATARGET_DOCS="$MAINTARGETDIR/agena/Library/Documentation/Agena"

# create directories if necessary

mkdir -p $MAINTARGETDIR
mkdir -p $MAINTARGETDIR/agena
mkdir -p $MAINTARGETDIR/agena/usr
mkdir -p $MAINTARGETDIR/agena/usr/agena
mkdir -p $MAINTARGETDIR/agena/usr/agena/lib
mkdir -p $MAINTARGETDIR/agena/usr/agena/data
mkdir -p $MAINTARGETDIR/agena/usr/agena/share
mkdir -p $MAINTARGETDIR/agena/usr/agena/share/icons
mkdir -p $MAINTARGETDIR/agena/usr/agena/share/schemes
mkdir -p $MAINTARGETDIR/agena/usr/agena/share/scripting
mkdir -p $MAINTARGETDIR/agena/usr/local
mkdir -p $MAINTARGETDIR/agena/usr/local/bin
mkdir -p $MAINTARGETDIR/agena/usr/local/lib
mkdir -p $MAINTARGETDIR/agena/Library
mkdir -p $MAINTARGETDIR/agena/Library/Documentation
mkdir -p $MAINTARGETDIR/agena/Library/Documentation/Agena

# Copy files to be distributed to target folders

# Documentation files
cp $AGENAHOME/doc/agena-crashcourse.pdf $AGENATARGET_DOCS
cp $AGENAHOME/doc/agena.pdf $AGENATARGET_DOCS
cp $AGENAHOME/doc/agena.xls $AGENATARGET_DOCS
cp $AGENAHOME/doc/ascii.xls $AGENATARGET_DOCS
cp $AGENAHOME/doc/regex.txt $AGENATARGET_DOCS

# Data files
cp $AGENAHOME/data/langreg.csv $AGENATARGET_USR/agena/data
cp $AGENAHOME/data/viking2.csv $AGENATARGET_USR/agena/data
cp $AGENAHOME/data/viking2.txt $AGENATARGET_USR/agena/data
cp $AGENAHOME/data/airlines.csv $AGENATARGET_USR/agena/data
cp $AGENAHOME/data/airlines.txt $AGENATARGET_USR/agena/data
cp $AGENAHOME/data/sunspots.csv $AGENATARGET_USR/agena/data
cp $AGENAHOME/data/sunspots.txt $AGENATARGET_USR/agena/data

# Library files
cp $AGENAHOME/lib/aconv.agn $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/ads.agn $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/ads.so $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/agenaini.spl $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/ansi.agn $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/astro.agn $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/astro.so $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/bimaps.agn $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/bimaps.so $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/bloom.so $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/clock.agn $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/clock.so $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/com.so $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/compat.agn $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/cordic.so $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/curses.agn $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/curses.so $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/divs.agn $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/double.agn $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/double.so $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/dual.agn $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/dual.so $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/fastmath.so $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/fractals.agn $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/fractals.so $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/gdi.agn $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/gdi.so $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/gzip.so $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/hashes.agn $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/hashes.so $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/heaps.agn $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/heaps.so $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/json.agn $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/library.agn $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/mapm.agn $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/mapm.so $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/mp.agn $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/mpf.agn $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/net.agn $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/net.so $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/rbtree.so $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/regex.so $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/skycrane.agn $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/skycrane.so $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/tar.agn $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/testlib.so $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/xml.agn $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/xml.so $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/zx.so $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/kiss.agn $AGENATARGET_USR/agena/lib
cp $AGENAHOME/lib/maple.agn $AGENATARGET_USR/agena/lib

# Scheme files
cp $AGENAHOME/share/schemes/agena.lang $AGENATARGET_USR/agena/share/schemes
cp $AGENAHOME/share/schemes/agena.xml $AGENATARGET_USR/agena/share/schemes
cp $AGENAHOME/share/schemes/agena.dat $AGENATARGET_USR/agena/share/schemes
cp $AGENAHOME/share/schemes/agena.sch $AGENATARGET_USR/agena/share/schemes
cp $AGENAHOME/share/schemes/nedit.rc $AGENATARGET_USR/agena/share/schemes
cp $AGENAHOME/share/schemes/readme.txt $AGENATARGET_USR/agena/share/schemes

# Icon files
cp $AGENAHOME/share/icons/agena.ico $AGENATARGET_USR/agena/share/icons
cp $AGENAHOME/share/icons/agena256.ico $AGENATARGET_USR/agena/share/icons
cp $AGENAHOME/share/icons/aedit256.ico $AGENATARGET_USR/agena/share/icons
cp $AGENAHOME/share/icons/agena.png $AGENATARGET_USR/agena/share/icons
cp $AGENAHOME/share/icons/agena128x128.ico $AGENATARGET_USR/agena/share/icons
cp $AGENAHOME/share/icons/agena128x128.png $AGENATARGET_USR/agena/share/icons
cp $AGENAHOME/share/icons/agena64x64.ico $AGENATARGET_USR/agena/share/icons
cp $AGENAHOME/share/icons/agena64x64.png $AGENATARGET_USR/agena/share/icons
cp $AGENAHOME/share/icons/agena8b.gif $AGENATARGET_USR/agena/share/icons
cp $AGENAHOME/share/icons/agena8b.ico $AGENATARGET_USR/agena/share/icons
cp $AGENAHOME/share/icons/agenasmall.ico $AGENATARGET_USR/agena/share/icons
cp $AGENAHOME/share/icons/agenasmall.png $AGENATARGET_USR/agena/share/icons

# Scripting samples
cp $AGENAHOME/share/scripting/ln.agn $AGENATARGET_USR/agena/share/scripting
cp $AGENAHOME/share/scripting/getopt.agn $AGENATARGET_USR/agena/share/scripting
cp $AGENAHOME/share/scripting/whereis.agn $AGENATARGET_USR/agena/share/scripting
cp $AGENAHOME/share/scripting/whereis.bat $AGENATARGET_USR/agena/share/scripting
cp $AGENAHOME/share/scripting/whereis.cmd $AGENATARGET_USR/agena/share/scripting

# Change Log et cetera
cp $AGENAHOME/change.log $AGENATARGET_USR/agena
cp $AGENAHOME/ports/sragena-102/README.srglue $AGENATARGET_USR/agena

# Binary and shared C libraries
cp $AGENAHOME/src/libagena.a $AGENATARGET_USR/local/lib
cp $AGENAHOME/src/licence $AGENATARGET_USR/local/lib
cp $AGENAHOME/src/agena $AGENATARGET_USR/local/bin
cp $AGENAHOME/ports/sragena-102/src/srglue $AGENATARGET_USR/local/bin
cp $AGENAHOME/ports/sragena-102/src/sragena $AGENATARGET_USR/local/bin

cp $AGENAHOME/../fltk-1.3.8/editor/agenaedit $AGENATARGET_USR/local/bin
cp -r $AGENAHOME/../fltk-1.3.8/editor/agenaedit.app $AGENATARGET_USR/local/bin
chmod a+x $AGENATARGET_USR/local/bin/agenaedit

# position: owner & group & other
# 7 = read (1) + write (2) + execute (4) = 1 + 2 + 4 = 7
# 5 = read + execute
chmod -R 755 $AGENATARGET_USR/agena
chmod 755 $AGENATARGET_USR/local/bin/agena
chmod 755 $AGENATARGET_USR/local/bin/srglue
chmod 755 $AGENATARGET_USR/local/bin/sragena
chmod 755 $AGENATARGET_USR/local/lib/libagena.a
