#ifndef double_h
#define double_h

#include "lstate.h"
#include "sunpro.h"


#define longdouble double

#define DLong ieee_double_shape_type

#define checkdouble(L, n) (DLong *)luaL_checkudata(L, n, "doublevalue")

#define getdoublevalue(L,idx) (((DLong *)lua_touserdata(L, (idx)))->value)

#define checkandgetdouble(L,idx) (((DLong *)luaL_checkudata(L, (idx), "doublevalue"))->value)

#define checkandgetdoublenum(L,idx) ({ \
  longdouble __x = (agn_isnumber(L, (idx))) ? agn_tonumber(L, (idx)) : (checkandgetdouble(L, (idx))); \
  (__x); \
})

/*
#define getdoublenum(L,d,idx,procname) { \
  if (agn_isnumber(L, (idx))) { \
    d.d = agn_tonumber(L, (idx)); \
  } else { \
    d.d = 0; \
    luaL_error(L, "Error in " LUA_QS ": number expected, got %s.", procname, luaL_typename(L, idx)); \
  } \
}
*/

#define createdouble(L,x) { \
  DLong *__d = (DLong *)lua_newuserdata(L, sizeof(DLong)); \
  lua_setmetatabletoobject(L, -1, "doublevalue", 1); \
  __d->value = (x); \
}

#endif
