/*
** $Id: lcomplex.h v 0.1, based on ltable.h v2.10 2006/01/10 13:13:06 roberto Exp $
** Agena Complex Numbers
** See Copyright Notice in agena.h
*/

#ifndef lcomplex_h
#define lcomplex_h

#include "lobject.h"
#include "agnhlps.h"

#ifndef PROPCMPLX

#include "agnconf.h"  /* for definition of I */
#include <complex.h>
#define complexreal(t)     (creal((t->value.c)))
#define compleximag(t)     (cimag((t->value.c)))

#else

#define complexreal(t)     (t->value.c[0])
#define compleximag(t)     (t->value.c[1])

#endif

#define agnCmplx_create(z,re,im) { \
  z[0] = (re); \
  z[1] = (im); \
}

#define agnCmplx_add(z,a,b,c,d)    agnCmplx_create((z), ((a)+(c)), ((b)+(d)))
#define agnCmplx_sub(z,a,b,c,d)    agnCmplx_create((z), ((a)-(c)), ((b)-(d)))
#define agnCmplx_mul(z,a,b,c,d)    agnCmplx_create((z), ((a)*(c)-(b)*(d)), ((a)*(d)+(b)*(c)))
#define agnCmplx_div(z,a,b,c,d)    \
    {lua_Number (e) = ((c)*(c)+(d)*(d)); agnCmplx_create((z), ((a)*(c)+(b)*(d))/((e)), ((b)*(c)-(a)*(d))/(e)); }
#define agnCmplx_recip(z,c,d)    \
    {lua_Number (e) = ((c)*(c)+(d)*(d)); agnCmplx_create((z), (c)/(e), (e == 0) ? AGN_NAN : ( (d != 0) ? (-(d))/(e) : 0 ) ); }  /* avoid -0 which confuses inverse trigs */

#ifdef PROPCMPLX
#define agnCmplx_sqrt(z,a,b) { \
  lua_Number __re, __im; \
  slm_csqrt(a, b, &__re, &__im); \
  agnCmplx_create((z), __re, __im); \
}

#define agnCmplx_log(z,a,b) { \
  lua_Number __re, __im; \
  tools_clog(a, b, &__re, &__im); \
  agnCmplx_create((z), __re, __im); \
}
#endif

#endif

