@echo off
rem To build and install the additional libraries, execute this file in the \agena\src subfolder
rem in a plain NT shell, and not in MinGW.

set gccopts=-Wall -Wno-attributes -pipe -O3 -g -shared -I. -L. -lagena -fgnu89-inline
set gccshortopts=-Wall -O3 -g -fgnu89-inline -shared -I. -L.
set gccfileopts=-pipe -O3 -g -DLUA_BUILD_AS_DLL -fgnu89-inline -Wno-attributes
set gcccursesopts=-pipe -O3 -g -DLUA_BUILD_AS_DLL -DHAVE_NCURSES_H -fgnu89-inline -Wno-attributes
set gccfinalopts=-pipe -O3 -g -shared -static-libgcc -fpic -fgnu89-inline -Wno-attributes
set offs=-Wno-int-to-pointer-cast -Wno-pointer-to-int-cast

set OLDPATH=%PATH%
set PATH=c:\MinGW\bin;%PATH%

del ival.o ads.o fractals.o phq.o net.o interp.o rlhmath.o astro.o skycrane.o hashes.o sunriset.o moon.o fastmath.o dual.o aconv.o com.o xml.o gzip.o mp.o mpf.o heaps.o mapm.o regex.o testlib.o double.o curses.o cordic.o

echo Building ival.
gcc %gccfileopts% -c -o ival.o ival.c
gcc %gccfinalopts% -o ival.dll ival.o -L. -lagena ../ports/ival/src/fi_lib.a

echo Building ADS.
gcc %offs% %gccfileopts% -c -o ads.o ads.c
gcc -O3 -shared -static-libgcc -fgnu89-inline -fpic -o ads.dll ads.o vecoff64.o -L. -lagena

echo Building fractals.
gcc %gccopts% -o fractals.dll fractals.c

echo Building astro.
gcc %gccfileopts% -c -o sunriset.o sunriset.c
gcc %gccfileopts% -c -o moon.o moon.c
gcc %gccfileopts% -c -o astro.o astro.c
gcc %gccfinalopts% -o astro.dll astro.o agnt64.o sofa.o sdncal.o moon.o sunriset.o -L. -lagena

echo Building net.
gcc %gccfileopts% -c -o net.o net.c
gcc %gccfinalopts% -o net.dll net.o -L. -lwsock32 -lwininet -lmswsock -lWs2_32 -lagena

echo Building skycrane.
gcc %gccopts% -o skycrane.dll skycrane.c

echo Building hashes.
gcc %gccopts% -o hashes.dll hashes.c

echo Building zx.
gcc %gccopts% -o zx.dll zx.c

echo Building bloom.
gcc %gccopts% -o bloom.dll bloom.c

echo Building cuckoo.
gcc %gccopts% -o cuckoo.dll cuckoo.c

echo Building clock.
gcc %gccopts% -o clock.dll clock.c

echo Building fastmath.
gcc %gccopts% -Wno-strict-aliasing -o fastmath.dll fastmath.c

gcc %gccopts% -o dual.dll dual.c

echo Building mp.
set gmplibs=-lgmp -lagena
gcc %gccshortopts% -o mp.dll mp.c %gmplibs%

echo Building mpf.
rem DYNAMIC LINKING with MPFR
set mpfropts=-Wall -O3 -fgnu89-inline -shared
set mpfrlibs=-I../ports/mpfr-4.2.1/src -L../ports/mpfr-4.2.1/src/.libs -lmpfr -I. -L. -lgmp -I. -L. -lagena
gcc %mpfropts% -o mpf.dll mpf.c %mpfrlibs%

echo Building cordic.
gcc %gccopts% -o cordic.dll cordic.c

echo Buildung com.
gcc %gccopts% -DPLUS -o com.dll com.c luasys.c charbuf.c

echo Buildung aconv.
set aconvlibs=-lagena -liconv
gcc %gccopts% -o aconv.dll aconv.c %aconvlibs%

echo Buildung curses.
set gcccursesopts=-O3 -DLUA_BUILD_AS_DLL -DHAVE_NCURSES_H -fgnu89-inline -Wno-attributes
gcc %gcccursesopts% -c -o curses.o curses.c
gcc %gccfinalopts% -o curses.dll curses.o -L. -lagena -lncurses

echo Buildung xml.
set expatlibs=-lagena -lexpat
gcc %gccopts% -o xml.dll xml.c %expatlibs%

echo Buildung regex.
set regexlibs=-lagena -lpcre2-posix -lpcre2-8
gcc %gccshortopts% -DPCRE2_CODE_UNIT_WIDTH=8 -o regex.dll regex.c regex_f.c regex.h regexcom.c regexcom.h regexalg.h %regexlibs%

echo Buildung gzip.
set zlibs=-lagena -lz
gcc %gccopts% -o gzip.dll gzip.c %zlibs%

echo Buildung mapm.
set mapmlibs=-lagena -lmapm
gcc %gccopts% -o mapm.1.dll mapm.c %mapmlibs%
rename mapm.1.dll mapm.dll

echo Building heaps.
gcc %gccopts% -o heaps.dll heaps.c

echo Building testlib.
gcc %gccopts% -o testlib.dll testlib.c

echo Building double.
gcc %gccopts% -o double.dll double.c

echo Building rbtree.
gcc %gccopts% -Wno-maybe-uninitialized -o rbtree.dll rbtree.c

echo Building bimaps
gcc %gccopts% -Wno-maybe-uninitialized -o bimaps.dll bimaps.c

rem strip --strip-unneeded *.dll  MinGW/GCC 10.x's strip does not accept wildcards any longer
echo.
echo Slimming and moving packages.
strip --strip-unneeded ads.dll
copy ads.dll ..\lib >> NUL
strip --strip-unneeded fractals.dll
copy fractals.dll ..\lib >> NUL
strip --strip-unneeded net.dll
copy net.dll ..\lib >> NUL
strip --strip-unneeded astro.dll
copy astro.dll ..\lib >> NUL
strip --strip-unneeded skycrane.dll
copy skycrane.dll ..\lib >> NUL
strip --strip-unneeded hashes.dll
copy hashes.dll ..\lib >> NUL
strip --strip-unneeded zx.dll
copy zx.dll ..\lib >> NUL
strip --strip-unneeded bloom.dll
copy bloom.dll ..\lib >> NUL
strip --strip-unneeded cuckoo.dll
copy cuckoo.dll ..\lib >> NUL
strip --strip-unneeded fastmath.dll
copy fastmath.dll ..\lib >> NUL
strip --strip-unneeded clock.dll
copy clock.dll ..\lib >> NUL
strip --strip-unneeded dual.dll
copy dual.dll ..\lib >> NUL
strip --strip-unneeded mp.dll
copy mp.dll ..\lib >> NUL
strip --strip-unneeded mpf.dll
copy mpf.dll ..\lib >> NUL
strip --strip-unneeded com.dll
copy com.dll ..\lib >> NUL
strip --strip-unneeded aconv.dll
copy aconv.dll ..\lib >> NUL
strip --strip-unneeded curses.dll
copy curses.dll ..\lib >> NUL
strip --strip-unneeded xml.dll
copy xml.dll ..\lib >> NUL
strip --strip-unneeded regex.dll
copy regex.dll ..\lib >> NUL
strip --strip-unneeded gzip.dll
copy gzip.dll ..\lib >> NUL
strip --strip-unneeded heaps.dll
copy heaps.dll ..\lib >> NUL
strip --strip-unneeded mapm.dll
copy mapm.dll ..\lib >> NUL
strip --strip-unneeded testlib.dll
copy testlib.dll ..\lib >> NUL
strip --strip-unneeded double.dll
copy double.dll ..\lib >> NUL
strip --strip-unneeded rbtree.dll
copy rbtree.dll ..\lib >> NUL
strip --strip-unneeded bimaps.dll
copy bimaps.dll ..\lib >> NUL
strip --strip-unneeded cordic.dll
copy cordic.dll ..\lib >> NUL
strip --strip-unneeded ival.dll
copy ival.dll ..\lib >> NUL

echo Installed all libraries into Agena /lib folder.

del aconv.dll
del ads.dll
del astro.dll
del bimaps.dll
del bloom.dll
del clock.dll
del com.dll
del cordic.dll
del cuckoo.dll
del curses.dll
del double.dll
del dual.dll
del fastmath.dll
del fractals.dll
del gzip.dll
del hashes.dll
del heaps.dll
del ival.dll
del mapm.dll
del mp.dll
del mpf.dll
del net.dll
del rbtree.dll
del regex.dll
del skycrane.dll
del testlib.dll
del xml.dll
del zx.dll

set aconvlibs=
set curseslibs=
set expatlibs=
set gccfileopts=
set gcccursesopts=
set gccfinalopts=
set gccopts=
set gccshortopts=
set gmplibs=
set gmpopts=
set mapmlibs=
set mpfrlibs=
set mpfropts=
set offs=
set PATH=%OLDPATH%
set OLDPATH=
set regexlibs=
set regexopts=
set zlibs=

rem ******************************************************************
rem old depcrecated packages
rem ******************************************************************

rem echo Building compress.
rem gcc %gccopts% -o compress.dll compress.c lcompress.c agnhlps.c

rem echo Building words.
rem gcc %gccopts% -o words.dll words.c

rem echo Building phonetiQs.
rem gcc %gccopts% -o phq.dll plus/phq.c
rem copy phq.dll ..\phq >> NUL
rem del phq.dll