/*
    This file is part of the CLib sub-project of the FreeDOS project
    Copyright (C) 1997 by the author see below

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $Id: _CLIB.H 1.2 1998/01/29 07:10:17 ska Exp $
   $Locker:  $	$Name:  $	$State: Exp $

	Internally used definitions, typedefs etc. for the CLib

*/

#ifndef ___CLIB_H_
#define ___CLIB_H_

#include <stdlib.h>
#include <assert.h>		/* All CLib uses assert() */

/* Generate a pointers & references */
#define dRef(ref) *(dword*)(&ref)		/* dword reference */
#define wRef(ref) *(word*)(&ref)		/* word reference */
#define bRef(ref) *(byte*)(&ref)		/* byte reference */
#define fPtr(addr) (void far*)(addr)	/* far pointer */
#define dPtr(addr) ((dword)(void far*)(addr))	/* far pointer */

/* Aliases for some values */
#define NUL '\0'

/* standard type for CLib */
typedef enum {false = 0, true = 1} boolean;

extern void _CLibFunc _dummyFct(void);		/* do nothing dummy function */

#endif
