/*
    This file is part of the CLib sub-project of the FreeDOS project
    Copyright (C) 1997 by the author see below

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: GETDCWD.C $
   $Locker:  $	$Name:  $	$State: Exp $

	char * getdcwd95(int drive, char *buf, int buflen)

	Get current working directory of specified drive
	including the drive spec.

	Input:
		drive:	0 == current working disk
				1 == A:
				2 == B:
				 ...
		If buflen == 0, buflen is assumed to be the requested size
		If buf != NULL, sizeof(buf) >= buflen
		If buf == NULL, a buffer of buflen bytes is malloc'ed

	Return:
		NULL on failure, incl. buflen < required size; malloc() failed
		else on success

	Note:
		<none>

	Conforms to:
		<none>

	See also:
		getcwd, getdisk, chdir, getcurdir

	Target compilers:
		Any C compiler

	Origin:
		1997/10/10 Steffen Kaiser (ska)

	Revised by:
		<none>

	File Revision:    Revision 1.2  1997/10/27 05:43:49  ska
*/

#include <_clib.h>			/* standard include, must be the first! */
#include <alloc.h>
#include <dir.h>
#include <dos.h>
#include <errno.h>
#include <limits.h>
#include <string.h>

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: GETDCWD.C 1.2 1997/10/27 05:43:49 ska Exp $";
#endif

_CLibFunc char *
getdcwd(int drive
         ,char *buf
         ,int buflen)
{	
	char hbuf[PATH_MAX];		/* POSIX name */

	if(getcurdir(drive, hbuf))	/* get the directory */
		return NULL;

/* Construct the fully-qualified path */
	if(!buflen)			/* assume the buffer has a perfect fitting size */
		buflen = strlen(hbuf) + 4;
	else if(buflen < strlen(hbuf) + 4) {	/* buffer too small */
		errno = ERANGE;
		return NULL;
	}
	if(!buf && (buf = malloc(buflen)) == NULL)
		return NULL;

	if(*hbuf == '\\') {
		if(hbuf[1] ==  '\\')		/* UNC filename */
			/* OK, we've wasted 4 bytes if buflen == 0 && buf == NULL */
			return strcpy(buf, hbuf);

		/* else root directory */
		strcpy(&buf[2], hbuf);
	}
	else {					/* subdirectory */
		buf[2] = '\\';
		strcpy(&buf[3], hbuf);
	}

	/* prepend the drive letter */
	if((*buf = 'A' - 1 + drive) == 'A' - 1)		/* current disk */
		*buf = 'A' + getdisk();
	buf[1] = ':';

	return buf;
}
