/*
    This file is part of the CLib sub-project of the FreeDOS project
    Copyright (C) 1997 by the author see below

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: REMOVE.C $
   $Locker:  $	$Name:  $	$State: Exp $

	int remove(char *fnam)

	Remove/unlink/delete file.

	Input:
		fnam != NULL

	Return:
		o: on success
		else: on failure

	Note:
		With LFN support this call will try the Win95 API first, if this
		call fails it tries the DOS API.

	Conforms to:
		ANSI

	See also:
		unlink

	Target compilers:
		Any C compiler

	Origin:
		1997/10/10 Steffen Kaiser (ska)

	Revised by:
		<none>

	File Revision:    Revision 1.2  1997/10/27 05:43:49  ska
*/

#include <_clib.h>			/* standard include, must be the first! */
#include <dir.h>
#include <dos.h>

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: REMOVE.C 1.2 1997/10/27 05:43:49 ska Exp $";
#endif

_CLibFunc int
remove(char const * const fnam)
{	struct REGPACK r;

	assert(fnam != NULL);

	r.r_ds = FP_SEG(fnam);
	r.r_dx = FP_OFF(fnam);
	r.r_si = r.r_cx = 0;
	return _callLFN(0x41, &r);
}
