/*
    This file is part of the CLib sub-project of the FreeDOS project
    Copyright (C) 1997 by the author see below

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: REWINDDI.C $
   $Locker:  $	$Name:  $	$State: Exp $

	int rewinddir(DIR *dirp)

	Restart the scanning of the directory and perform the very first
	search.

	Input:
		dirp != NULL && must point to a structure returned by opendir()

	Return:
		0: if seek was successful
		!= 0: otherwise

	Note:
		<none>

	Conforms to:
		<none>

	See also:
		opendir

	Target compilers:
		Any C compiler

	Origin:
		Steffen Kaiser (ska)

	Revised by:
		<none>

	File Revision:    Revision 1.1  1997/10/27 05:43:49  ska
*/

#include <_clib.h>			/* standard include, must be the first! */
#include <dirent.h>

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: REWINDDI.C 1.1 1997/10/27 05:43:49 ska Exp $";
#endif

_CLibFunc int
rewinddir(DIR * const dirp)
{	
	findstop(&dirp->dd_dta);
	dirp->dd_filled = true;		/* don't discard the actually filled ffblk */
	return dirp->dd_stat = findfirst(dirp->dd_dir, &dirp->dd_dta, _DIR_ATTRIB);
}
