/*
    This file is part of the CLib sub-project of the FreeDOS project
    Copyright (C) 1997 by the author see below

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: T.C $
   $Locker:  $	$Name:  $	$State: Exp $

	Test program.

*/

#include <_clib.h>
#include <dir.h>
#include <dirent.h>
#include <io.h>
#include <fcntl.h>
#include <process.h>
#include <string.h>
#include <sys/stat.h>

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: T.C 1.1 1997/10/27 05:43:49 ska Exp $";
#endif

#define NULL ((void*)0)

void _assert(char const * const condition
       ,char const * const filename
       ,long linenr)
{_abort("Abort.");}

void xwrite(char *s)
{	write(2, s, strlen(s));
	write(2, "\r\n", 2);
}
void xxwrite(char *s1, char *s2)
{	write(2, s1, strlen(s1));
	xwrite(s2);
}
void err(char *s)
{	xwrite(s);
	exit(30);
}

main(void)
{	char buf[1024], *p;
	struct ffblk ff;
	DIR *dir;
	struct dirent *dentry;

	xwrite(mkdir("test directory")? "mkdir failed": "mkdir succeeded");
	xwrite(chdir("test directory")? "chdir failed": "chdir succeeded");
	xwrite(chdir("..")? "chdir .. failed": "chdir .. succeeded");
	xwrite(rmdir("test directory")? "rmdir failed": "rmdir succeeded");

	if(getcurdir(0, buf))	xwrite("Getcurdir failed");
	else xxwrite("curdir: ", buf);
	if((p = getcwd(NULL, 1024)) == NULL)	xwrite("Getcwd failed");
	else xxwrite("cwd: ", p);
	if((p = getdcwd(3, NULL, 1024)) == NULL)	xwrite("Getdcwd c: failed");
	else xxwrite("cwd C: ", p);

	close(open("test.fil", O_CREAT | O_RDONLY, S_IWRITE));
	xwrite(rename("test.fil", "test.xfile")? "rename failed": "rename succeeded");
	xwrite(remove("test.xfile")? "remove failed": "remove succeeded");

	xwrite("Found files in \\*.*");
	if(findfirst("\\*.*", &ff, FA_DIREC) == 0) do {
		xwrite(ff.ff_name);
	} while(findnext(&ff) == 0);

	rmdir("testdirectory");
	if(mkdir("testdirectory"))
		err("Cannot make testdirectory");
	if((dir = opendir("testdi~1")) == NULL)
		xwrite("Error opendir() ");
	else {
		xwrite("files in testdi~1:");
		while((dentry = readdir(dir)) != NULL)
			xwrite(dentry->d_name);
		closedir(dir);
	}
	rmdir("testdirectory");

	return 0;
}
