/*
    This file is part of the CLib sub-project of the FreeDOS project
    Copyright (C) 1997 by the author see below

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: _CALLLFN.C $
   $Locker:  $	$Name:  $	$State: Exp $

	int _callLFN(int fct, struct REGPACK *rp)

	Calls the Win95 LFN API with functions fct. If the call fails, the
	normal DOS API is called. This function assumes that LFN and normal
	API don't differ except in how to identify the function number
	to be invoked.

	Input:
		rp != NULL

	Return:
		OS error code
		*rp updated

	Note:
		<none>

	Conforms to:
		<none>

	See also:
		_callDOS

	Target compilers:
		Any C compiler

	Origin:
		1997/10/10 Steffen Kaiser (ska)

	Revised by:
		<none>

	File Revision:    Revision 1.3  1998/01/29 07:10:08  ska
*/

#include <_clib.h>			/* standard include, must be the first! */
#include <dos.h>
#include <errno.h>
#include <string.h>

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: _CALLLFN.C 1.3 1998/01/29 07:10:08 ska Exp $";
#endif

_CLibFunc int _callLFN(const int fct, struct REGPACK * const rp)
{	REG int errnr;
#ifdef LFN_WIN95
	struct REGPACK r;			/* temporary stack for the registers */

	memcpy(&r, rp, sizeof(r));		/* save registers for DOS API */
	rp->r_ax = 0x7100 | fct;		/* LFN API fucntion number */

	if(((errnr = _callDOS(rp)) == 1 || errnr == 0x7100)) {
		/* LFN API failed --> try DOS API */
		r.r_ax = fct << 8;				/* DOS API function number */
		memcpy(rp, &r, sizeof(r));		/* restore original values */
		errnr = _callDOS(rp);
	}
#else	/* !LFN_WIN95 */
	errnr = _callDOS(rp);
#endif /* LFN_WIN95 */

	if(errnr) errno = errnr;			/* keep error code */

	return errnr;		/* success */
}
