/*
    This file is part of the CLib sub-project of the FreeDOS project
    Copyright (C) 1997 by the author see below

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: FTELL.C $
   $Locker:  $	$Name:  $	$State: Exp $

	off_t ftell(FILE *fp)

	Return the current position within the stream.

	Input:
		fp != NULL; a valid FILE pointer

	Return:
		-1: on failure
		else: the current position within the stream

	Note:
		This position can also be used for the handle-based IO.

	Conforms to:
		ANSI

	See also:
		fseek

	Target compilers:
		Any C compiler

	Origin:
		1997/11/03 Robert de Bath (see CONTRIB\STDIO2.ZIP)

	Revised by:
		1997/11/23 Steffen Kaiser (ska)

	File Revision:    Revision 1.2  1998/01/29 07:10:01  ska
*/

#include <_clib.h>			/* standard include, must be the first! */
#include "stdio.h"
#include <io.h>				/* tell() */

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: FTELL.C 1.2 1998/01/29 07:10:01 ska Exp $";
#endif

_CLibFunc off_t
ftell(FILE *fp)
{
	off_t pos;
	
	assert(fp != NULL);
	
	pos = tell(fp->fd);

	if(pos == _SEEK_FAIL)
		return (off_t)-1;			/* tell failed -> ftell() fails, too */

	switch(fp->mode & (__MODE_READING | __MODE_WRITING)) {
	case __MODE_READING:	/* in read mode the handle's position
						is behind the buffered data */
		return pos + (fp->bufread - fp->bufpos);
	
	case __MODE_WRITING:	/* in write mode the handle's position
						is before the buffered data */
		return pos + (fp->bufpos - fp->bufstart);
	}

	return pos;			/* If there is no data buffered currently,
						the handle's position is the stream position */
}
