/*
    This file is part of the CLib sub-project of the FreeDOS project
    Copyright (C) 1997 by the author see below

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: SETBUFFE.C $
   $Locker:  $	$Name:  $	$State: Exp $

	void setbuffer(FILE *fp, char *buf, size_t size)
	void setbuf(FILE *fp, char *buf)

	(De-)Associate a buffer to/from the stream.

	setbuf() is a macro and assumes size == BUFSIZ.

	If buf == NULL, the stream is put into unbuffered mode. Any dynamically
	allocated buffer is freed.

	If buf != NULL, the stream is assocated with the static buffer and
	is brought into full-buffering. Any previous dynamically associated
	buffer is freed.

	Note: Setting an automatic (local) array as buffer is quite
	dangerous, because this buffer does no longer exists if the
	function, in which this buffer was defined, exits.

	Input:
		size > 0
		fp != NULL, a valid FILE pointer

	Return:
		<none>

	Note:
		setbuffer() is invoked by setvbuf().

	Conforms to:
		???

	See also:
		fopen, setvbuf

	Target compilers:
		Any C compiler

	Origin:
		1997/11/03 Robert de Bath (see CONTRIB\STDIO2.ZIP)

	Revised by:
		1997/11/23 Steffen Kaiser (ska)

	File Revision:    Revision 1.2  1998/01/29 07:10:01  ska
*/

#include <_clib.h>			/* standard include, must be the first! */
#include "stdio.h"
#include <alloc.h>			/* free() */

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: SETBUFFE.C 1.2 1998/01/29 07:10:01 ska Exp $";
#endif

_CLibFunc void
setbuffer(FILE *fp, char *buf, size_t size)
{
	assert(fp != NULL);

   fflush(fp);
   if( fp->mode & __MODE_FREEBUF ) free(fp->bufstart);
   fp->mode &= ~(__MODE_FREEBUF|__MODE_BUF);

   if(!buf) {
      fp->bufstart = fp->unbuf;
      fp->bufend = fp->unbuf + sizeof(fp->unbuf);
      fp->mode |= _IONBF;
   }
   else {
      fp->bufstart = buf;
      fp->bufend = buf + size;
      fp->mode |= _IOFBF;
   }
   fp->bufpos = fp->bufread = fp->bufwrite = fp->bufstart;
}
