/*
    This file is part of the CLib sub-project of the FreeDOS project
    Copyright (C) 1997 by the author see below

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: STDERR.C $
   $Locker:  $	$Name:  $	$State: Exp $

	FILE stderr;

	Definition & initialization of stderr.
	If the macro FIO_NB_STDERR is defined in _CONF.H, stderr is not
	associated with a buffer by default.

	stderr is supposed to not buffer the output. This permits immediate
	display of each message without delay. Note: "not-buffered" does not
	mean that all characters are to be transfered character-by-character.
	It does only mean that no pending output should be kept.

	Input:
		<none>

	Return:
		<none>

	Note:
		stderr is unbuffered by default

	Conforms to:
		ANSI

	See also:
		stdout, stdin, getchar, getc, fopen

	Target compilers:
		Any C compiler

	Origin:
		1997/11/03 Robert de Bath (see CONTRIB\STDIO2.ZIP)

	Revised by:
		1997/11/23 Steffen Kaiser (ska)

	File Revision:    Revision 1.1  1997/11/26 04:03:45  ska
*/

#include <_clib.h>			/* standard include, must be the first! */
#include "stdio.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: STDERR.C 1.1 1997/11/26 04:03:45 ska Exp $";
#endif

#ifdef FIO_NB_STDERR			/* unbuffered mode */
#define buffer (stderr->unbuf)
#define bufmode _IONBF
#else	/* FIO_NB_STDERR */
static char buffer[BUFSIZ];
#define bufmode _IOFBF
#endif	/* FIO_NB_STDERR */

_CLibVar FILE
stderr[1] = {
   {buffer, buffer, buffer, buffer, buffer + sizeof(buffer),
    2, bufmode | __MODE_WRITE | __MODE_IOTRAN}
};
