/*
    This file is part of the CLib sub-project of the FreeDOS project
    Copyright (C) 1997 by the author see below

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: STDOUT.C $
   $Locker:  $	$Name:  $	$State: Exp $

	FILE stdout;

	Definition & initialization of stdout.
	If the macro FIO_NB_STDOUT is defined in _CONF.H, stdout is not
	associated with a buffer by default.

	Input:
		<none>

	Return:
		<none>

	Note:
		stdout is line buffered by default, if the stream is connected
		to TTY during the initialization phase

	Conforms to:
		ANSI

	See also:
		stdin, stderr, getchar, getc, fopen

	Target compilers:
		Any C compiler

	Origin:
		1997/11/03 Robert de Bath (see CONTRIB\STDIO2.ZIP)

	Revised by:
		1997/11/23 Steffen Kaiser (ska)

	File Revision:    Revision 1.1  1997/11/26 04:03:45  ska
*/

#include <_clib.h>			/* standard include, must be the first! */
#include "stdio.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: STDOUT.C 1.1 1997/11/26 04:03:45 ska Exp $";
#endif

#ifdef FIO_NB_STDOUT			/* unbuffered mode */
#define buffer (stdout->unbuf)
#define bufmode _IONBF
#else	/* FIO_NB_STDOUT */
static char buffer[BUFSIZ];
#define bufmode _IOFBF
#endif	/* FIO_NB_STDOUT */

_CLibVar FILE
stdout[1] = {
   {buffer, buffer, buffer, buffer, buffer + sizeof(buffer),
    1, bufmode | __MODE_WRITE | __MODE_IOTRAN}
};
