/*
    This file is part of the CLib sub-project of the FreeDOS project
    Copyright (C) 1997 by the author see below

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: T.C $
   $Locker:  $	$Name:  $	$State: Exp $

	Test program FIO

*/

#include <stdio.h>
#include <string.h>
#include <process.h>
#include <stdlib.h>

main(void)
{	FILE *f;
	char buf[1024];
	char num[33];
	int cnt;

	if((f = fopen("testfile", "wt")) == NULL) {
		puts("Open failed");
		exit(30);
	}

	fputs("Strongo !\n", f);
	if(fseek(f, 3, SEEK_SET) == -1) {
		puts("Seek #1 failed");
	}
	if(putc('e', f) != 'e')
		puts("putc('e') failed");
	if(fseek(f, 2, SEEK_CUR) == -1)
		puts("Seek #2 failed");
	fputs("th", f);
	putc('\n', f);
	if(freopen("testfile", "rt", f) == NULL) {
		puts("Reopen failed");
		exit(31);
	}

	cnt = 0;
	while(fgets(buf, sizeof(buf), f)) {
		itoa(++cnt, num, 10);
		fputs(num, stdout);
		putc(' ', stdout);
		fputs(buf, stdout);
	}

	fclose(f);

	printf("Hello world!\n");
	printf("int(1234) = %d oct(01234) = %o hex(0x1234) = %x\n", 1234, 01234, 0x1234);
	return 0;
}
