/*
    This file is part of the CLib sub-project of the FreeDOS project
    Copyright (C) 1997 by the author see below

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: _HPFIND.C $
   $Locker: ska $	$Name:  $	$State: Exp $

	void *_heapfind(void *poi, void **prev)

	Find a previously allocated area in the heap.
	poi must be a pointer returned by malloc() or an equivalent;
	not a pointer to a node.

	Input:
		prev either NULL or points to a valid variable

	Return:
		NULL: poi not found
		else: poi found, return pointer to node
		*prev is updated to the previous node, if prev != NULL
		If *prev == NULL, this is the very first node of the heap

	Note:
		Local heap only

	Conforms to:
		<none>

	See also:
		free

	Target compilers:
		Any C compiler

	Origin:
		1997/10/10 Steffen Kaiser (ska)

	Revised by:
		<none>

	File Revision:    Revision 1.3  1998/02/11 07:40:34  ska
*/

#include <_clib.h>			/* standard include, must be the first! */
#include <_alloc.h>

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: _HPFIND.C 1.3 1998/02/11 07:40:34 ska Exp ska $";
#endif

_CLibFunc _pHeapNode
_heapfind(void const ___PTR * const poi
         ,_pHeapNode * const prev)
{	REG _pHeapNode p, prv;

	assert(_heap != NULL);

#if _IN_ALLOC == 0 		/* local heap */
#define TESTPOI   p <= poi
#else	/* _IN_ALLOC != 0 */
	/* in far heap "p <= poi" can fail because of fragmentation */
#ifdef DEBUG_HEAP
#define TESTPOI   _frgident(p)
#else 
#define TESTPOI   _frgident(p)
#endif
#endif	/* _IN_ALLOC == 0 */

	if(poi) {
		for(p = _heap, prv = NULL ; p->type != HEAP_END &&	TESTPOI
		 ; prv = p, p = nxtNode(p))
			if(nodeData(p) == poi) {		/* node found! */
				if(prev) *prev = prv;
				return p;
			}
	}

	return NULL;				/* node not found */
}
