/*
    This file is part of the CLib sub-project of the FreeDOS project
    Copyright (C) 1997 by the author see below

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: ASSERT.H $
   $Locker:  $	$Name:  $	$State: Exp $

	Assertation declaration

*/

#ifndef __ASSERT_H
#define __ASSERT_H

extern void _CLibFunc _assert(char const * const condition
						, char const * const filename
						, long linenr);

#undef assert

#ifdef NDEBUG
#define assert(cond)
#define _assert2(cond, mesg)

#else
	/* we cannot use if() as this would cause to many problems */
#define assert(cond)   ((cond)? (void)0: _assert(#cond, __FILE__, __LINE__))

#define _assert2(cond,mesg)   		\
	((cond)? (void)0: _assert(mesg, __FILE__, __LINE__))

#endif

#endif
