/*
    This file is part of the CLib sub-project of the FreeDOS project
    Copyright (C) 1997 by the author see below

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: IOCTL.C $
   $Locker:  $	$Name:  $	$State: Exp $

	int ioctl(int fd, int fct [, void *argp [, int argi]]);

	Generic IO control.

	This function is an interface to the system depended handle-based
	generic IO control system call. It is available in Unix, but also
	in this system there is no standard for this function.

	The use of ioctl() is highly unportable!

	fd is an opened file descriptor or a drive ID (0 == default, 1 == A:
	2 == B: ...).

	fct is one of:
		0	Get device info
		1	Set device info
		2	Read argi bytes from the device control channel of fd to argp
		3	Write argi bytes from argp to the device control channel of fd
		4	Read argi bytes from the control channel of drive fd to argp
		5	Write argi bytes from argp to the control channel of drive fd
		6	Get input status (0 == not ready || EOF; != 0: pending data)
		7	Get output status (0 == bot ready; != 0: data may be written)
		8	Check if drive fd is removeable (DOS 3+)
		9	Check if drive fd is remote (DOS 3.1+)
		10	Check if descriptor fd is remote (DOS 3.1+)

	Input:
		if any input parameter is invalid, the result is
		unpredictable!

	Return:
		-1: if system call failed
		else: return value of system call

	Note:
		-1 might not always mean an error

	Conforms to:
		<none>

	See also:

	Target compilers:
		Any C compiler

	Origin:
		Steffen Kaiser (ska)

	Revised by:
		<none>

	File Revision:    Revision 1.1  1997/11/18 04:24:50  ska
*/

#include <_clib.h>			/* standard include, must be the first! */
#include <dos.h>
#define _IN_IOCTL
#include <io.h>

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: IOCTL.C 1.1 1997/11/18 04:24:50 ska Exp $";
#endif

_CLibFunc int
ioctl(int fd, int fct, void *argp, int argi)
{	struct REGPACK r;

	r.r_ax = 0x4400 | fct;
	r.r_bx = fd;
	r.r_dx = FP_OFF(argp);
	r.r_ds = FP_SEG(argp);
	r.r_cx = argi;

	return _callDOS(&r)? -1: r.r_ax;
}
