/*
    This file is part of the CLib sub-project of the FreeDOS project
    Copyright (C) 1997 by the author see below

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: LOCK.C $
   $Locker:  $	$Name:  $	$State: Exp $

	int lock(int fd, off_t offset, long length)

	Locks an area of the file. Under DOS, the SHARE utilty must be loaded
	to have any locking mechanism on the local drives.

	Input:
		length > 0

	Return:
		0: area locked
		-1: failure
		1: this area is already locked

	Note:
		<none>

	Conforms to:
		<none>

	See also:
		open

	Target compilers:
		Any C compiler

	Origin:
		1997/10/10 Steffen Kaiser (ska)

	Revised by:
		<none>

	File Revision:    Revision 1.1  1997/10/13 07:06:59  ska
*/

#include <_clib.h>			/* standard include, must be the first! */
#include <io.h>
#include <sys/locking.h>

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: LOCK.C 1.1 1997/10/13 07:06:59 ska Exp $";
#endif

_CLibFunc int
lock(const int fd
    ,const off_t offset
    ,const long length)
{	assert(length > 0);

	return _locking(fd, LK_LOCK, offset, length);
}
