/*
    This file is part of the CLib sub-project of the FreeDOS project
    Copyright (C) 1997 by the author see below

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: MEMSET.C $
   $Locker:  $	$Name:  $	$State: Exp $

	void *memset(void *s, int ch, size_t length)

	Fill a memory area of length bytes with the character ch.

	Input:
		s != NULL

	Return:
		s

	Note:
		<none>

	Conforms to:
		ANSI

	See also:

	Target compilers:
		Any C compiler

	Origin:
		1997/10/10 Steffen Kaiser (ska)

	Revised by:
		<none>

	File Revision:    Revision 1.2  1998/02/08 04:55:59  ska
*/

#include <_clib.h>			/* standard include, must be the first! */
#include <_string.h>

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: MEMSET.C 1.2 1998/02/08 04:55:59 ska Exp $";
#endif

_CLibFunc void ___PTR *memset(void ___PTR * const s
 , int ch, size_t length)
{	REG char_t ___PTR *p;

	assert(s != NULL);

	p = s;
	if(length)
		do *p++ = ch;
		while(--length);
	return s;
}
