/*
    This file is part of the CLib sub-project of the FreeDOS project
    Copyright (C) 1997 by the author see below

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: STRCTOP.C $
   $Locker:  $	$Name:  $	$State: Exp $

	char_t *strctop(char_t *str)

	Transform a C string into a PString (Pascal string).

	Input:
		str != NULL
		str must have enough room to hold the PString. The macro
		PSTRSPACE from <limits.h> holds how many bytes are required
		in addition to the string itself and the C-style NUL byte.
		Usually PSTRSPACE is 0 (zero).

	Return:
		str: on success
		NULL: if C string to long

	Note:
		PStrings conforms to this syntax:
			<length><char1><char2>...<charN>
		all are of the type (byte), <char_t?> may be NUL.

	Conforms to:
		<none>

	See also:
		strplen, strpval, strptoc

	Target compilers:
		Any C compiler

	Origin:
		1997/10/10 Steffen Kaiser (ska)

	Revised by:
		<none>

	File Revision:    Revision 1.2  1998/02/08 04:55:59  ska
*/

#include <_clib.h>			/* standard include, must be the first! */
#include <_string.h>

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: STRCTOP.C 1.2 1998/02/08 04:55:59 ska Exp $";
#endif

_CLibFunc char_t ___PTR *strctop(char_t ___PTR * const str)
{	REG size_t length;

	assert(str != NULL);

	if((length = strlen(str)) > PSTRMAXLENGTH)
		return NULL; 	/* too long */
	
	memmove(strpval(str), str, length);	/* overwrite NUL byte */
	*(pstr_t*)str = length;		/* save the length of the string */
	return str;
}
