/*
    This file is part of the CLib sub-project of the FreeDOS project
    Copyright (C) 1997 by the author see below

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: STRNCMP.C $
   $Locker:  $	$Name:  $	$State: Exp $

	int strncmp(char_t const *s1, char_t const *s2, size_t length)

	Determine the lexical order of both strings up to length bytes.

	Input:
		s1 != NULL
		s2 != NULL

	Return:
		 <0: if s1 < s2
		==0: if s1 == s2
		 >0: if s1 > s2

	Note:
		The characters of the strings are interpreted (unsigned)
		length is treated unsigned

	Conforms to:
		ANSI C

	See also:
		strcmp, memcmp

	Target compilers:
		Any C compiler

	Origin:
		1997/10/10 Steffen Kaiser (ska)

	Revised by:
		<none>

	File Revision:    Revision 1.2  1998/02/08 04:55:59  ska
*/

#include <_clib.h>			/* standard include, must be the first! */
#include <_string.h>

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: STRNCMP.C 1.2 1998/02/08 04:55:59 ska Exp $";
#endif

_CLibFunc int strncmp(char_t const ___PTR *s1
 , char_t const ___PTR *s2, size_t length)
{
	assert(s1 != NULL);
	assert(s2 != NULL);

	return memcmp(s1, s2, _strnlen(s1, length));
}
