/*
    This file is part of the CLib sub-project of the FreeDOS project
    Copyright (C) 1997 by the author see below

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: STRPBRK.C $
   $Locker:  $	$Name:  $	$State: Exp $

	char_t *strpbrk(char_t *str, char_t *chset)

	Search for the first character of str that is a member of the
	character set chset.

	Input:
		str != NULL
		chset != NULL

	Return:
		NULL if no character of str are in chset || str == ""
		pointer to the first character of str in chset, otherwise

	Note:
		<none>

	Conforms to:
		<none>

	See also:
		strcspn

	Target compilers:
		Any C compiler

	Origin:
		1997/10/10 Steffen Kaiser (ska)

	Revised by:
		<none>

	File Revision:    Revision 1.2  1998/02/08 04:55:59  ska
*/

#include <_clib.h>			/* standard include, must be the first! */
#include <_string.h>

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: STRPBRK.C 1.2 1998/02/08 04:55:59 ska Exp $";
#endif

_CLibFunc char_t ___PTR *strpbrk(char_t const ___PTR *str
 , char_t const ___PTR * const chset)
{	assert(str != NULL);
	assert(chset != NULL);

	for(; *str; ++str)
		if(strchr(chset, *str))
			return (char_t ___PTR*)str;

	return (char_t ___PTR*)str;
}
