/*
    This file is part of the CLib sub-project of the FreeDOS project
    Copyright (C) 1997 by the author see below

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: _TOSTRBU.C $
   $Locker:  $	$Name:  $	$State: Exp $

	char_t __tostrbuf[]

	Internal buffer for all _*tostr() functions. It is large enough
	to hold any of the result, including the NUL terminator. This
	buffer is overwritten each time, such function is invoked!

	Input:
		<none>

	Return:
		<none>

	Note:
		<none>

	Conforms to:
		<none>

	See also:
		_ltostr, _itostr

	Target compilers:
		Any C compiler

	Origin:
		Steffen Kaiser (ska)

	Revised by:
		<none>

	File Revision:    Revision 1.1  1997/11/18 04:24:40  ska
*/

#include <_clib.h>			/* standard include, must be the first! */
#include <stdlib.h>

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: _TOSTRBU.C 1.1 1997/11/18 04:24:40 ska Exp $";
#endif

/* Currently the longest result is a (unsigned long int) value with
	radix == 2. */
_CLibVar char_t __tostrbuf[sizeof(unsigned long) * 8 + 1];
