/*
    This file is part of the CLib sub-project of the FreeDOS project
    Copyright (C) 1997 by the author see below

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: _CEXIT.C $
   $Locker:  $	$Name:  $	$State: Exp $

	void _cexit(void)
	int __atexitIdx;
	atexit_t __atexitFcts[MAX_ATEXIT];

	Perform high-level cleanup of the process, any IO buffers are flushed,
	additional memory is free'ed, opened files are closed, the atexit()
	functions are invoked.

	It is possible to continue the program execution, thus, the caller
	must assume that, except local variables, no information created
	by the process is still available, but the caller cannot assume that
	the cleanup has made all ressources available to the application as
	if the application would be invoked presently.

	The variables are declared here because:
		_cexit() is the only function doing something useful with the
		stored values there, thus, atexit() without _cexit() is _very_
		unlikely.

	Input:
		<none>

	Return:

	Note:
		<none>

	Conforms to:
		<none>

	See also:
		exit, _exit, _c_exit

	Target compilers:
		Any C compiler

	Origin:
		1997/10/10 Steffen Kaiser (ska)

	Revised by:
		<none>

	File Revision:    Revision 1.1  1997/10/13 07:09:10  ska
*/

#include <_clib.h>			/* standard include, must be the first! */
#include <_process.h>

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: _CEXIT.C 1.1 1997/10/13 07:09:10 ska Exp $";
#endif

/* Note:
	The registered functions to be invoked before terminating the program
	are organized in an internal array of functions with 
		(MAX_ATEXIT - STD_ATEXIT) slots available for the program itself.
	The lowest STD_ATEXIT slots are used for the CLib internal cleanup.

	When _cexit() is invoked all but the standard functions are unregistered
	after their execution.

	By default, all slots of the standard functions are pre-initialized with
	"_dummyFct". This function simply does nothing, but it enables the
	execution of the functions without the "if(__atexit[idx])" check.
	Furthermore because the real functions are _not_ listed there,
	there are not included if the program does not use the specific
	portion of the CLib, e.g. if the program makes no use of the
	FILE pointer based IO, this list does not auto-included the "close"
	part of this portion.

	Each portion of the CLib that requires a specific exit() function
	will set its slot at the proper place, e.g. the FIO portion upon
	a succcessful open.
*/

/* Index into the __atexitFcts[] array.
	The first STD_ATEXIT slots are reserved for the CLib internal */

_CLibVar int __atexitIdx = STD_ATEXIT;


_CLibVar atexit_t __atexitFcts[MAX_ATEXIT + STD_ATEXIT] = {
/* last invoked function */
	/* free'ing additional memory */	_dummyFct,
	/* closing file handles */			_dummyFct,
	/* file pointer based */			_dummyFct,
	/* all the other slots are free for the program */
/* first invoked function */
};



/* Well, because not all of the CLib is already implemeted, this function
	is nothing more than a skeleton , to be filled as new sources are
	added to the CLibrary. */
_CLibFunc void _cexit(void)
{	

	/* The registered functions are unregistered for the case when the
		process is not terminated upon exit of _cexit() */
	/* The first registered functions (STD_ATEXIT) are the functions
		that clean up the CLib internals. */
	while(__atexitIdx)
		(__atexitFcts[--__atexitIdx])();
	__atexitIdx = STD_ATEXIT;		/* reenable the standard cleanup functions */
}
