{
    Copyright (C) 2021 Jerome Shidel
    BSD 3-Clause License
}

program Drive_Diagnostics;

uses NLS, DrvUtils, DrvMsgs, Strings;

    const
        AppName = 'DrvUtils';
        AppVer  = '2021-08-26';
        Floppies : word = 0;

procedure BIOSDriveParams(Drv : Word);
var
    Params : TDriveParams;
    S : String;
begin
    { if not ((Drv <= 2) or ((Drv >=$80) and (Drv <= $80 + TotalFixedDrives))) then exit; }
    FillChar(Params, Sizeof(Params), 0);
    if GetDriveParams(Drv, Params) then begin
        if (Drv < 2) and (Params.Kind <> 0) then
            Floppies := Drv + 1;
        WriteLn(
            FormatNLS(miBIOSDriveCheck, HexByte(Drv) + NlsDelim + GetRawNLS(miTrue), True)
        );
        S := GetRawNLS(miBIOSDriveKind + '.' + byteHex(Params.Kind));
        if S = '' then
            S := GetRawNLS(miBIOSDriveKind + '.?');
        S := S + NlsDelim +
            HexByte(Params.Kind) + NlsDelim +
            HexPtr(Params.ParamTable) + NlsDelim;
        if Drv < $80 then
            WriteLn(FormatNLS(miBIOSDriveKind, S, True));
        WriteLn(FormatNLS(miBIOSDriveCount, HexByte(Params.Count), True));
        S := HexByte(Params.Heads) + NlsDelim +
            HexByte(Params.Sectors) + NlsDelim +
            HexWord(Params.Cylinders) + NlsDelim;
        WriteLn(FormatNLS(miBIOSDriveCHS, S, True));
    end else if (Drv <= 2) or ((Drv >=$80) and (Drv <= $80 + TotalFixedDrives)) then begin
        WriteLn(
            FormatNLS(miBIOSDriveCheck, HexByte(Drv) + NlsDelim + BIOSError(DrvError), True)
        );
    end;
end;

procedure DOSDriveInfo(Drv : word);
var
    S: String;
begin
    if (Drv < 3) and (Drv > Floppies) then exit;
    WriteLn(FormatNLS(miDriveLetter, chr(64+Drv), false));
    WriteLn(FormatNLS(miDriveRemovable, TFDOSError(DriveRemovable(Drv), DrvError), True));
    WriteLn(FormatNLS(miDriveRemote,
        FlagsDOSError(miDriveRemote, DriveRemote(Drv) and drfRemoteMask, DrvError)
        , True));
end;


procedure BiosDrives;
var
    I : byte;
begin
    WriteLn(GetLongNLS(miBIOSEquipList), TrueFalse(GetEquipmentList and 1 = 1));
    WriteLn(GetLongNLS(miTotalFixedDrives), HexByte(TotalFixedDrives));
    for I := 0 to $ff do BIOSDriveParams(I);
end;

procedure DosDrives;
var
    I : byte;
begin
    WriteLn;
    for I := 1 to 26 do DOSDriveInfo(I);
end;

procedure CDDrives;
var
    S, C : String;
    I : Word;
begin
    WriteLn;
    S := '';
    C := GetRawNLS(miResultsSeparator);
    for I := 1 to 26 do
        if CDDrive(I) then begin
            if S <> '' then S := S + C;
            S := S + Char(64 + I) + ':';
        end;
    if S = '' then
        S := GetRawNLS('DRIVE.CDROM.NONE');
    WriteLn(FormatNLS(miCDDrives, S, True));
end;

procedure Execute;
begin
    WriteLn(AppName, ' (' , AppVer, ')');
    WriteLn(GetRawNLS(miAppDescription));
    WriteLn;
    BiosDrives;
    DosDrives;
    CDDrives;
    WriteLn(GetRawNLS(miAppDone));
end;

begin
    Execute;
end.