{
    Copyright (C) 2021 Jerome Shidel
    BSD 3-Clause License
}
unit DrvMsgs;

interface

const
    miAppDescription    = 'APP.DESCRIPTION';
    miBIOSEquipList     = 'BIOS.EQUIP.FLOP';
    miTotalFixedDrives  = 'MEM.FIXED.TOTAL';
    miBiosDriveCheck    = 'BIOS.DRIVE.CHECK';
    miBiosDriveKind     = 'BIOS.DRIVE.KIND';
    miBiosDriveCount    = 'BIOS.DRIVE.COUNT';
    miBiosDriveCHS      = 'BIOS.DRIVE.CHS';
    miDriveLetter       = 'DRIVE.LETTER';
    miDriveRemovable    = 'DRIVE.REMOVABLE';
    miDriveRemote       = 'DRIVE.REMOTE';
    miCDDrives          = 'DRIVE.CDROM';
    miAppDone           = 'APP.DONE';

implementation

uses NLS;

procedure BuiltInEnglish; assembler;
asm
    db '; LONG.COLUMN.WIDTH= is a setting and not text',0
    db 'LONG.COLUMN.WIDTH',     '=', '16',0

    db 'APP.DESCRIPTION',       '=', '(a programmer',$27,'s disk '
    db 'diagnostic utility, work in progress)',0

    db 'APP.DONE',              '=', 'Done for now. :-)',0

    db 'TRUE',                  '=', 'TRUE',0
    db 'FALSE',                 '=', 'false',0

    db 'SEPARATOR.LONG',        '=', ' ',0
    db 'SEPARATOR.RESULTS',     '=', ', ',0

    db 'BIOS.EQUIP.FLOP.LONG',  '=', 'INT 11',0
    db 'BIOS.EQUIP.FLOP',       '=', 'Floppy Present: ',0

    db 'BIOS.DRIVE.CHECK.LONG', '=', 'INT 13,08',0
    db 'BIOS.DRIVE.CHECK',      '=', 'Drive %0: %1',0

    db 'MEM.FIXED.TOTAL.LONG',  '=', 'MEM 0040:0075',0
    db 'MEM.FIXED.TOTAL',       '=', 'Total Fixed Drives: ',0

    db 'BIOS.ERROR.MSG',        '=', 'BIOS Error #%0: %1',0
    db 'BIOS.ERROR.?',          '=', 'unknown error',0
    db 'BIOS.ERROR.0',          '=', 'no error',0
    db 'BIOS.ERROR.1',          '=', 'invalid request to controller',0

    db 'BIOS.DRIVE.KIND',       '=', 'type: %0, %1 [%2]',0
    db 'BIOS.DRIVE.COUNT',      '=', 'drives: %0',0
    db 'BIOS.DRIVE.CHS',        '=', '%0 heads, %1 sectors, %2 cylinders',0

    db 'BIOS.DRIVE.KIND.?',     '=', 'unknown',0
    db 'BIOS.DRIVE.KIND.01',    '=', '360K',0
    db 'BIOS.DRIVE.KIND.02',    '=', '1.2M',0
    db 'BIOS.DRIVE.KIND.03',    '=', '720K',0
    db 'BIOS.DRIVE.KIND.04',    '=', '1.44M',0
    db 'BIOS.DRIVE.KIND.05',    '=', 'sometimes 2.88M',0
    db 'BIOS.DRIVE.KIND.06',    '=', '2.88M',0
    db 'BIOS.DRIVE.KIND.10',    '=', 'ATAPI',0

    db 'DOS.ERROR.MSG',        '=', 'DOS Error #%0: %1',0
    db 'DOS.ERROR.?',          '=', 'unknown error',0
    db 'DOS.ERROR.1',          '=', 'invalid function number',0
    db 'DOS.ERROR.15',         '=', 'invalid drive',0

    db 'DRIVE.LETTER',          '=', 'Drive %0:',0
    db 'DRIVE.REMOVABLE.LONG',  '=', 'INT 21,4408',0
    db 'DRIVE.REMOVABLE',       '=', 'Removable: %0',0

    db 'DRIVE.REMOTE.LONG',     '=', 'INT 21,4409',0
    db 'DRIVE.REMOTE',          '=', 'Remote flags: %0 %1',0

    db 'DRIVE.REMOTE.FLAG',     '=', '%0 %1',0
    db 'DRIVE.REMOTE.FLAG.?',   '=', 'unknown',0
    db 'DRIVE.REMOTE.FLAG.NONE','=', 'none',0
    db 'DRIVE.REMOTE.FLAG.0200','=', 'No Direct I/O',0
    db 'DRIVE.REMOTE.FLAG.1000','=', 'Is Remote',0
    db 'DRIVE.REMOTE.FLAG.2000','=', 'Media ID Required',0
    db 'DRIVE.REMOTE.FLAG.8000','=', 'Is Substituted',0

    db 'DRIVE.CDROM.LONG',      '=', 'INT 2F,1500',0
    db 'DRIVE.CDROM',           '=', 'CD-ROM Drives: %0',0
    db 'DRIVE.CDROM.NONE',      '=', 'not present',0

    db 0
end;

var
    OldExit : pointer;

procedure Finalize; far;
begin
    ExitProc := OldExit;
    BuiltInLanguage := nil;
end;

procedure Initialize;
begin
    BuiltInLanguage := @BuiltInEnglish;
    OldExit := ExitProc;
    ExitProc := @Finalize;
end;

begin
    Initialize;
end.