; Copyright (C) 2021 Jerome Shidel
; BSD 3-Clause License

; NASM 2.14rc0 for DOS

use16

cpu 8086

%include "TPASCAL.INC"

section PASCAL_DATA

section PASCAL_SHARED

    extern        BuiltInLanguage ; pointer
    extern        UserLanguage ; pointer
    extern        NLSError ; word

section PASCAL_CODE

; function GetNLSRaw(const ID : String) : string;
pascal_func GetRawNLS, string, string
    push    ds
    push    ds
    pop     dx
    xor     bx, bx

	les     di, PARAM_1
	xor     ch, ch
	mov     cl, [es:di]
	inc     di
	cmp     cl, bl
	je      GetRawNLS_NotFound
	cld

GetRawNLS_TestUser:
	lds     si, [UserLanguage]
	push    ds
	pop     ax
	cmp     ax, bx
	jne     GetRawNLS_SearchUser
	cmp     si, bx
	jne     GetRawNLS_SearchUser
	jmp     GetRawNLS_TestBuiltIn

GetRawNLS_SearchUser:
    call    GetRawNLS_Search
    jnc     GetRawNLS_Found

GetRawNLS_TestBuiltIn:
    push    dx
    pop     ds
	lds     si, [BuiltInLanguage]
	push    ds
	pop     ax
	cmp     ax, bx
	jne     GetRawNLS_SearchBuiltIn
	cmp     si, bx
	jne     GetRawNLS_SearchBuiltIn

GetRawNLS_SearchBuiltIn:
    call    GetRawNLS_Search
    jnc     GetRawNLS_Found
    jmp     GetRawNLS_NotFound

GetRawNLS_Search:
    push    di
    push    cx

GetRawNLS_Compare:
    lodsb
    cmp     al, bl
	je      GetRawNLS_SearchNotFound
    cmp     al, '='
	je      GetRawNLS_NotMatch
    mov     ah, [es:di]
    inc     di
    cmp     al, ah
    jne     GetRawNLS_NotMatch
    loop    GetRawNLS_Compare
    lodsb
    cmp     al, '='
	jne     GetRawNLS_NotMatch
    clc
    jmp     GetRawNLS_Matched

GetRawNLS_NotMatch:
    pop     cx
    pop     di
GetRawNLS_SearchEOL:
    lodsb
    cmp     al, bl
    jne     GetRawNLS_SearchEOL
    jmp     GetRawNLS_Search

GetRawNLS_SearchNotFound:
    stc
GetRawNLS_Matched:
    pop     cx
    pop     di
    ret

GetRawNLS_Found:
	les     di, RESULT
	xor     cx, cx
	push    di
	inc     di
GetRawNLS_CopyLoop:
    cmp     cx, 255
    je      GetRawNLS_Copied
    lodsb
    cmp     al, bl
    je      GetRawNLS_Copied
    inc     cx
    stosb
    jmp     GetRawNLS_CopyLoop

GetRawNLS_Copied:
    xor     ch, ch
    jmp     GetRawNLS_CopyDone

GetRawNLS_NotFound:
    mov     ch, 1
	les     di, RESULT
	xor     cl, cl
	push    di
GetRawNLS_CopyDone:
	pop     di
	mov     al, cl
	stosb
    pop     ds
    mov     [NLSError], ch

pascal_end


