unit vnm_fn;
{****************************************************************************}
{Unit VNM_FN - it is a addon unit for graphics library VenomGFX.             }
{It brings a loader for .FN bitmap font file.                                }
{****************************************************************************}

{$IFDEF VER2}{$DEFINE NEWFPC}{$ENDIF}
{$IFDEF VER3}{$DEFINE NEWFPC}{$ENDIF}
{$IFDEF NEWFPC}{$CALLING OLDFPCCALL}{$ENDIF}
interface
uses VnmFnHlp;

type
PFontFN = ^TFontFN;
TFontFN = object(TBitMapZnaky256)
{vnitrnijmeno:string[32];}
maxpred,maxza,maxnad,maxpod:shortint;

Constructor Init;
Function Load_single_FN(s:string):boolean;
Function VyskaRadky:byte;virtual;
Function VratVelikost:byte;virtual;
Destructor Done;virtual;
end;

Function Load_FN_font(s:string;size:longint):pointer;
Function Zkontroluj_Format_FN(s:string):boolean;

var global_fn_loader_popisek:string;

const vnm_fn_dbg:byte=0;

implementation
uses GrpFile,VenomGFX,VenomMng;


const
     fnmagic = 'mon ';


function MyVal (S: string): longint;
var
  Pom2 : Integer;
  pom1 : longint;
begin { MyVal }
  Val (S, Pom1, Pom2);
  MyVal := Pom1;
end;  { MyVal }


Constructor TFontFN.Init;
begin
inherited Init(0);
prop:=true;
format:=FNFMT_FN;
{vnitrnijmeno:='';}
end;


Function Zkontroluj_Format_FN(s:string):boolean;
var grp:TGrpStream;
    mgl:byte;
    ss:string;

begin
grp.Init(DoplnJmenoFontu(s),grpOpenRead);
if grp.status<>grpOK then Exit(false);
if grp.GetSize<15 then
   begin
   grp.Done;
   Exit(false);
   end;

mgl:=Length(fnmagic);

ss[0]:=char(mgl);
grp.Read(ss[1],mgl);
grp.Done;
if ss<>fnmagic then Exit(false);  {konrola zahlavi}
Zkontroluj_Format_FN:=true;
end;




Function TFontFN.Load_single_FN(s:string):boolean;
var grp:TGrpStream;
    a,b,c,l,v,w:longint;
    z2,z3,t:^byte;
    n,m,oo:word;
    mgl,ftbyte:byte;
    p:pchar;
    ss,s2:string;
    pracbuf:array[0..4095] of byte;
    z:pointer;

begin
ss:=DoplnJmenoFontu(s);
grp.Init(ss,grpOpenRead);
if grp.status<>grpOK then Exit(false);

mgl:=Length(fnmagic);

ss[0]:=char(mgl);
grp.Read(ss[1],mgl);
if ss<>fnmagic then begin grp.Done;Exit(false);end;  {konrola zahlavi}

l:=grp.GetSize-mgl;

GetMem(p,l);             {pripravim si pamet}
grp.ReadStream(p^,l);    {nahraju do ni zbytek souboru}
grp.Done;                {ted uz muzu soubor zavrit}

a:=IndexByte(p^,l,0);    {kde v bufferu je prvni ASCII 0 ?}

kodova_stranka:=895;     {fallback}

if a<>0 then
   begin
   ss[0]:=char(a);
   Move(p^,ss[1],a);
   b:=Pos('<CP=',ss);
   c:=b+7;
   w:=b+4;
   for v:=w to b+10 do
       if ss[v]='>' then begin c:=v;break;end;
   if b=1 then
      begin
      s2:=Copy(ss,w,c-w);
      delete(ss,b,c-b+1);
      kodova_stranka:=MyVal(s2);
      end;
   global_fn_loader_popisek:=ss;
   end
   else global_fn_loader_popisek:='';

maxpred     :=127;
maxza       :=-127;
maxnad      :=127;
maxpod      :=-127;

first:=byte(p[a+1]);
last:=byte(p[a+2]);
if last>0 then pocetzn:=last-first+1;

so:=shortint(p[a+3]);
su:=shortint(p[a+4]);
sosu:=so+su;
vel:=so+su;
add:=shortint(p[a+5]);
ftbyte:=byte(p[a+6]);

z:=@pracbuf;
for b:=0 to 255 do Znaky256[b].Init;
{vsechny znaky jsou sice zinicializovane, ale bitmapa je NIL, rozmery 0
 DATA=nil a paramatr READY je 0}

for b:=first to last do
    begin
    c:=(b-first)*7+a+mgl;
    znaky256[b].relx:=shortint(p[c+0]);
    znaky256[b].rely:=shortint(p[c+1]);
    znaky256[b].sirka:=byte(p[c+2]);
    znaky256[b].vyska:=byte(p[c+3]);
    znaky256[b].shift:=shortint(p[c+4]);
    znaky256[b].ready:=2;


{debug} {if (znaky256[b].sirka=0) or (znaky256[b].sirka>200) then
           begin
           writeln('divna sirka, znak: ',b,'...sirka: ',znaky256[b].sirka);
           readln;
           end;}

    if znaky256[b].sirka>max_sirka_bitmapy
       then max_sirka_bitmapy:=znaky256[b].sirka;

    v:=znaky256[b].sirka*znaky256[b].vyska; {pocet bodu, ze kterych znak je}
    if v>0 then   {znaky typu mezera maji SIRKA=0. Pro ty nebudu alokovat bitmapu}
       begin
       GetMem(znaky256[b].data,v); {alokuje bitmapu}
       w:=longint(p[c+5])+longint(p[c+6])*256;

       n:=(znaky256[b].sirka+7) div 8;
       t:=znaky256[b].data;     { zapisovaci pointer nastavi na bitmapu }
       for oo:=0 to znaky256[b].vyska-1 do
           begin
           z2:=z;
           for m:=0 to n-1 do
               begin
               ZnakBuf_Expand(byte(p[w-mgl+oo*n+m]),z2);
               inc(z2,8);
               end;
           Move(z^,t^,znaky256[b].sirka);
           inc(t,znaky256[b].sirka);
           end;

      {znak jsme dekomprimovali, ale ted ho prekvapive budu znovu komprimovat}
      {predchozi komprese totiz pakovala jednotlive radky zvlast, kdezto ja
      zapakuju celou bitmapu vcelku}
      znaky256[b].Komprimuj;
      end
      else begin     { V<=0 }
      if (znaky256[b].sirka=0) and (znaky256[b].shift=0)
         then begin      {tyto znaky budeme povazovat za nedefinovane}
         dec(pocetzn);
         if b=first then inc(first);
         if b=last then dec(last);
         znaky256[b].Done;
         end;

      end;

      with znaky256[b] do
         begin
         if relX<maxpred       then maxpred :=relX;
         if relY<maxnad        then maxnad  :=relY;
         if relX+sirka-1>maxza  then maxza   :=relX+sirka-1;
         if relY+vyska-1>maxpod then maxpod  :=relY+vyska-1;
         end;{with}
      end; {for}

if pocetzn=0 then begin first:=0;last:=0;end;

system.FreeMem(p,l);
Load_single_FN:=true;
end;


Function TFontFN.VyskaRadky:byte;
begin
VyskaRadky:=so+su;
end;


Function TFontFN.VratVelikost:byte;
begin
VratVelikost:=vel;
end;


Destructor TFontFN.Done;
begin
inherited Done;
end;


Function Load_FN_font(s:string;size:longint):pointer;
var a,b:byte;
    grp:TGrpStream;
    n:string;
    l:longint;
    ok:boolean;
    pf:PFontFN;
    hf:PObecnyFont;

begin
pf:=New(PFontFN,Init);
pf^.rez:=NazevBezCesty(s);
if vnm_fn_dbg>0 then
   a:=a;  {/debug}
ok:=pf^.Load_single_FN(s);
if ok=false then begin Dispose(pf,Done);Exit(nil);end;

hf:=New(PObecnyFont,Init);
hf^.fdata:=pf;
pf^.rukojet:=hf;
hf^.typzdroje:=2;
{0 = nevyplneno/neznamo
 1 = VGA
 2 = samostatne nacteno (nikoliv v kontejneru)
 3 = bitmapovy kontejner (napr. GRP soubor)
 4 = vektorovy kontejner
}
Load_FN_font:=hf;
end;


Function FN_font_setstyle(fnt:pointer;podfunkce,param1,param2:longint):pointer;
var hf:PObecnyFont;
    n,m:byte;
begin
hf:=fnt;
if podfunkce=2 then
   if (param1 and prop_fn)<>0
      then VNMFN_PROP_MODE:=true
      else VNMFN_PROP_MODE:=false;
FN_font_setstyle:=hf;
end;


Function FN_Font_PrepChar(fnt:pointer;znak:word):pointer;
var hf:PObecnyFont;
begin
hf:=fnt;
FN_Font_PrepChar:=hf^.FData^.PrepChar(znak);
end;



Procedure FN_font_OutText(kam:pointer;x,y:longint;s:string;fnt:pointer;color:word);
var hf:PObecnyFont;
    pf:PFontFN;

begin
if fnt<>nil then
   begin
   hf:=fnt;
   pf:=PFontFN(hf^.fdata);
   VnmFnHlp_OutText(kam,x,y,s,pf,color);
   end;
end;


Function FN_Font_GetInfo(fnt:pointer;param1,param2:longint):longint;
var hf:PObecnyFont;
    i:longint;

begin
hf:=fnt;
i:=hf^.GetInfo(param1,param2);
FN_Font_GetInfo:=i;
end;


Function FN_Font_delete(fnt:pointer;mode:byte):boolean;
var hf:PObecnyFont;
begin
hf:=fnt;
Dispose(hf,Done);       {automaticky smaze i hf^.FData (ve formatu PFontFN)}
FN_Font_delete:=true;
end;


Procedure Register_FN_Loader;
begin
RegisterFontEngine('FN',
                   @Load_FN_font,
                   @FN_Font_PrepChar,
                   @FN_Font_OutText,
                   @FN_Font_setstyle,
                   @FN_Font_GetInfo,
                   @FN_Font_delete);

end;




begin
Register_FN_Loader;
end.
