
LPBYTE typedef ptr byte
LPDWORD typedef ptr DWORD

ifndef HWND
HWND typedef DWORD
endif
ifndef HICON
HICON typedef DWORD
endif
ifndef WPARAM
WPARAM typedef DWORD
endif
ifndef LPARAM
LPARAM typedef DWORD
endif

LPWAVEFORMATEX typedef ptr WAVEFORMATEX
LPWAVEFILTER typedef ptr WAVEFILTER

FOURCC typedef DWORD

DECLARE_HANDLE macro x
	exitm <x typedef DWORD>
	endm

ifndef DRV_MAPPER_PREFERRED_INPUT_GET
DRV_MAPPER_PREFERRED_INPUT_GET	EQU	( DRV_USER + 0 )
endif 

ifndef DRV_MAPPER_PREFERRED_OUTPUT_GET
DRV_MAPPER_PREFERRED_OUTPUT_GET	EQU	( DRV_USER + 2 )
endif 

ifndef DRVM_MAPPER_STATUS
DRVM_MAPPER	EQU	2000h
DRVM_MAPPER_STATUS	EQU	( DRVM_MAPPER + 0 )
endif 

ifndef WIDM_MAPPER_STATUS
WIDM_MAPPER_STATUS	EQU	( DRVM_MAPPER_STATUS + 0 )
WAVEIN_MAPPER_STATUS_DEVICE	EQU	0
WAVEIN_MAPPER_STATUS_MAPPED	EQU	1
WAVEIN_MAPPER_STATUS_FORMAT	EQU	2
endif 

ifndef WODM_MAPPER_STATUS
WODM_MAPPER_STATUS	EQU	( DRVM_MAPPER_STATUS + 0 )
WAVEOUT_MAPPER_STATUS_DEVICE	EQU	0
WAVEOUT_MAPPER_STATUS_MAPPED	EQU	1
WAVEOUT_MAPPER_STATUS_FORMAT	EQU	2
endif 

ACMAPI	EQU	<WINAPI>

DECLARE_HANDLE( HACMDRIVERID)
PHACMDRIVERID typedef ptr HACMDRIVERID
LPHACMDRIVERID typedef ptr HACMDRIVERID
DECLARE_HANDLE( HACMDRIVER)
PHACMDRIVER typedef ptr HACMDRIVER
LPHACMDRIVER typedef ptr HACMDRIVER
DECLARE_HANDLE( HACMSTREAM)
PHACMSTREAM typedef ptr HACMSTREAM
LPHACMSTREAM typedef ptr HACMSTREAM
DECLARE_HANDLE( HACMOBJ)
PHACMOBJ typedef ptr HACMOBJ
LPHACMOBJ typedef ptr HACMOBJ

ifndef _MMRESULT_
_MMRESULT_	EQU	<>
MMRESULT typedef DWORD
endif 

ACMERR_BASE	EQU	512
ACMERR_NOTPOSSIBLE	EQU	( ACMERR_BASE + 0 )
ACMERR_BUSY	EQU	( ACMERR_BASE + 1 )
ACMERR_UNPREPARED	EQU	( ACMERR_BASE + 2 )
ACMERR_CANCELED	EQU	( ACMERR_BASE + 3 )
MM_ACM_OPEN	EQU	<( MM_STREAM_OPEN )>
MM_ACM_CLOSE	EQU	<( MM_STREAM_CLOSE )>
MM_ACM_DONE	EQU	<( MM_STREAM_DONE )>


ACM_METRIC_COUNT_DRIVERS	EQU	1
ACM_METRIC_COUNT_CODECS	EQU	2
ACM_METRIC_COUNT_CONVERTERS	EQU	3
ACM_METRIC_COUNT_FILTERS	EQU	4
ACM_METRIC_COUNT_DISABLED	EQU	5
ACM_METRIC_COUNT_HARDWARE	EQU	6
ACM_METRIC_COUNT_LOCAL_DRIVERS	EQU	20
ACM_METRIC_COUNT_LOCAL_CODECS	EQU	21
ACM_METRIC_COUNT_LOCAL_CONVERTERS	EQU	22
ACM_METRIC_COUNT_LOCAL_FILTERS	EQU	23
ACM_METRIC_COUNT_LOCAL_DISABLED	EQU	24
ACM_METRIC_HARDWARE_WAVE_INPUT	EQU	30
ACM_METRIC_HARDWARE_WAVE_OUTPUT	EQU	31
ACM_METRIC_MAX_SIZE_FORMAT	EQU	50
ACM_METRIC_MAX_SIZE_FILTER	EQU	51
ACM_METRIC_DRIVER_SUPPORT	EQU	100
ACM_METRIC_DRIVER_PRIORITY	EQU	101

proto_ACMDRIVERENUMCB typedef proto stdcall :HACMDRIVERID,:DWORD,:DWORD
ACMDRIVERENUMCB typedef ptr proto_ACMDRIVERENUMCB

ACM_DRIVERENUMF_NOLOCAL	EQU	40000000h
ACM_DRIVERENUMF_DISABLED	EQU	80000000h

ACM_DRIVERADDF_FUNCTION	EQU	00000003h
ACM_DRIVERADDF_NOTIFYHWND	EQU	00000004h
ACM_DRIVERADDF_TYPEMASK	EQU	00000007h
ACM_DRIVERADDF_LOCAL	EQU	00000000h
ACM_DRIVERADDF_GLOBAL	EQU	00000008h

proto_ACMDRIVERPROC typedef proto stdcall :DWORD,:HACMDRIVERID,:DWORD,:LPARAM,:LPARAM
ACMDRIVERPROC typedef ptr proto_ACMDRIVERPROC
LPACMDRIVERPROC typedef ptr ACMDRIVERPROC

ACMDM_USER	EQU	( DRV_USER + 0000h )
ACMDM_RESERVED_LOW	EQU	( DRV_USER + 2000h )
ACMDM_RESERVED_HIGH	EQU	( DRV_USER + 2FFFh )
ACMDM_BASE	EQU	<ACMDM_RESERVED_LOW>
ACMDM_DRIVER_ABOUT	EQU	( ACMDM_BASE + 11 )

ACM_DRIVERPRIORITYF_ENABLE	EQU	00000001h
ACM_DRIVERPRIORITYF_DISABLE	EQU	00000002h
ACM_DRIVERPRIORITYF_ABLEMASK	EQU	00000003h
ACM_DRIVERPRIORITYF_BEGIN	EQU	00010000h
ACM_DRIVERPRIORITYF_END	EQU	00020000h
ACM_DRIVERPRIORITYF_DEFERMASK	EQU	00030000h

ACMDRIVERDETAILS_SHORTNAME_CHARS	EQU	32
ACMDRIVERDETAILS_LONGNAME_CHARS	EQU	128
ACMDRIVERDETAILS_COPYRIGHT_CHARS	EQU	80
ACMDRIVERDETAILS_LICENSING_CHARS	EQU	128
ACMDRIVERDETAILS_FEATURES_CHARS	EQU	512

ACMDRIVERDETAILSA	struct 
cbStruct	DWORD	?
fccType	FOURCC	?
fccComp	FOURCC	?
wMid	WORD	?
wPid	WORD	?
vdwACM	DWORD	?
vdwDriver	DWORD	?
fdwSupport	DWORD	?
cFormatTags	DWORD	?
cFilterTags	DWORD	?
hicon	HICON	?
szShortName	SBYTE ACMDRIVERDETAILS_SHORTNAME_CHARS dup (?)
szLongName	SBYTE ACMDRIVERDETAILS_LONGNAME_CHARS dup (?)
szCopyright	SBYTE ACMDRIVERDETAILS_COPYRIGHT_CHARS dup (?)
szLicensing	SBYTE ACMDRIVERDETAILS_LICENSING_CHARS dup (?)
szFeatures	SBYTE ACMDRIVERDETAILS_FEATURES_CHARS dup (?)
ACMDRIVERDETAILSA	ends

PACMDRIVERDETAILSA typedef ptr ACMDRIVERDETAILSA
LPACMDRIVERDETAILSA typedef ptr ACMDRIVERDETAILSA

ACMDRIVERDETAILS	EQU	<ACMDRIVERDETAILSA>
PACMDRIVERDETAILS	EQU	<PACMDRIVERDETAILSA>
LPACMDRIVERDETAILS	EQU	<LPACMDRIVERDETAILSA>

ACMDRIVERDETAILS_FCCTYPE_AUDIOCODEC	EQU	<mmioFOURCC ( 'a' , 'u' , 'd' , 'c' )>
ACMDRIVERDETAILS_FCCCOMP_UNDEFINED	EQU	<mmioFOURCC ( '\0' , '\0' , '\0' , '\0' )>
ACMDRIVERDETAILS_SUPPORTF_CODEC	EQU	00000001h
ACMDRIVERDETAILS_SUPPORTF_CONVERTER	EQU	00000002h
ACMDRIVERDETAILS_SUPPORTF_FILTER	EQU	00000004h
ACMDRIVERDETAILS_SUPPORTF_HARDWARE	EQU	00000008h
ACMDRIVERDETAILS_SUPPORTF_ASYNC	EQU	00000010h
ACMDRIVERDETAILS_SUPPORTF_LOCAL	EQU	40000000h
ACMDRIVERDETAILS_SUPPORTF_DISABLED	EQU	80000000h


ACMFORMATTAGDETAILS_FORMATTAG_CHARS	EQU	48

ACMFORMATTAGDETAILSA	struct 
cbStruct	DWORD	?
dwFormatTagIndex	DWORD	?
dwFormatTag	DWORD	?
cbFormatSize	DWORD	?
fdwSupport	DWORD	?
cStandardFormats	DWORD	?
szFormatTag	SBYTE ACMFORMATTAGDETAILS_FORMATTAG_CHARS dup (?)
ACMFORMATTAGDETAILSA	ends

PACMFORMATTAGDETAILSA typedef ptr ACMFORMATTAGDETAILSA
LPACMFORMATTAGDETAILSA typedef ptr ACMFORMATTAGDETAILSA

ACMFORMATTAGDETAILS	EQU	<ACMFORMATTAGDETAILSA>
PACMFORMATTAGDETAILS	EQU	<PACMFORMATTAGDETAILSA>
LPACMFORMATTAGDETAILS	EQU	<LPACMFORMATTAGDETAILSA>


ACM_FORMATTAGDETAILSF_INDEX	EQU	00000000h
ACM_FORMATTAGDETAILSF_FORMATTAG	EQU	00000001h
ACM_FORMATTAGDETAILSF_LARGESTSIZE	EQU	00000002h
ACM_FORMATTAGDETAILSF_QUERYMASK	EQU	0000000Fh

proto_ACMFORMATTAGENUMCBA typedef proto stdcall :HACMDRIVERID,:LPACMFORMATTAGDETAILSA,:DWORD,:DWORD
ACMFORMATTAGENUMCBA typedef ptr proto_ACMFORMATTAGENUMCBA
ACMFORMATTAGENUMCB	EQU	<ACMFORMATTAGENUMCBA>

ACMFORMATDETAILS_FORMAT_CHARS	EQU	128

ACMFORMATDETAILSA	struct 
cbStruct	DWORD	?
dwFormatIndex	DWORD	?
dwFormatTag	DWORD	?
fdwSupport	DWORD	?
pwfx	LPWAVEFORMATEX	?
cbwfx	DWORD	?
szFormat	SBYTE ACMFORMATDETAILS_FORMAT_CHARS dup (?)
ACMFORMATDETAILSA	ends

PACMFORMATDETAILSA typedef ptr ACMFORMATDETAILSA
LPACMFORMATDETAILSA typedef ptr ACMFORMATDETAILSA

ACMFORMATDETAILS	EQU	<ACMFORMATDETAILSA>
PACMFORMATDETAILS	EQU	<PACMFORMATDETAILSA>
LPACMFORMATDETAILS	EQU	<LPACMFORMATDETAILSA>

ACM_FORMATDETAILSF_INDEX	EQU	00000000h
ACM_FORMATDETAILSF_FORMAT	EQU	00000001h
ACM_FORMATDETAILSF_QUERYMASK	EQU	0000000Fh

proto_ACMFORMATENUMCBA typedef proto stdcall :HACMDRIVERID,:LPACMFORMATDETAILSA,:DWORD,:DWORD
ACMFORMATENUMCBA typedef ptr proto_ACMFORMATENUMCBA
ACMFORMATENUMCB	EQU	<ACMFORMATENUMCBA>

ACM_FORMATENUMF_WFORMATTAG	EQU	00010000h
ACM_FORMATENUMF_NCHANNELS	EQU	00020000h
ACM_FORMATENUMF_NSAMPLESPERSEC	EQU	00040000h
ACM_FORMATENUMF_WBITSPERSAMPLE	EQU	00080000h
ACM_FORMATENUMF_CONVERT	EQU	00100000h
ACM_FORMATENUMF_SUGGEST	EQU	00200000h
ACM_FORMATENUMF_HARDWARE	EQU	00400000h
ACM_FORMATENUMF_INPUT	EQU	00800000h
ACM_FORMATENUMF_OUTPUT	EQU	01000000h


ACM_FORMATSUGGESTF_WFORMATTAG	EQU	00010000h
ACM_FORMATSUGGESTF_NCHANNELS	EQU	00020000h
ACM_FORMATSUGGESTF_NSAMPLESPERSEC	EQU	00040000h
ACM_FORMATSUGGESTF_WBITSPERSAMPLE	EQU	00080000h
ACM_FORMATSUGGESTF_TYPEMASK	EQU	00FF0000h

ACMHELPMSGSTRINGA	EQU	<"acmchoose_help">
ACMHELPMSGSTRINGW	EQU	<L("acmchoose_help")>
ACMHELPMSGCONTEXTMENUA	EQU	<"acmchoose_contextmenu">
ACMHELPMSGCONTEXTMENUW	EQU	<L("acmchoose_contextmenu")>
ACMHELPMSGCONTEXTHELPA	EQU	<"acmchoose_contexthelp">
ACMHELPMSGCONTEXTHELPW	EQU	<L("acmchoose_contexthelp")>
ACMHELPMSGSTRING	EQU	<ACMHELPMSGSTRINGA>
ACMHELPMSGCONTEXTMENU	EQU	<ACMHELPMSGCONTEXTMENUA>
ACMHELPMSGCONTEXTHELP	EQU	<ACMHELPMSGCONTEXTHELPA>

MM_ACM_FORMATCHOOSE	EQU	8000h
FORMATCHOOSE_MESSAGE	EQU	0
FORMATCHOOSE_FORMATTAG_VERIFY	EQU	( FORMATCHOOSE_MESSAGE + 0 )
FORMATCHOOSE_FORMAT_VERIFY	EQU	( FORMATCHOOSE_MESSAGE + 1 )
FORMATCHOOSE_CUSTOM_VERIFY	EQU	( FORMATCHOOSE_MESSAGE + 2 )

proto_ACMFORMATCHOOSEHOOKPROCA typedef proto stdcall :HWND,:DWORD,:WPARAM,:LPARAM
ACMFORMATCHOOSEHOOKPROCA typedef ptr proto_ACMFORMATCHOOSEHOOKPROCA
ACMFORMATCHOOSEHOOKPROC	EQU	<ACMFORMATCHOOSEHOOKPROCA>

ACMFORMATCHOOSEA	struct 
cbStruct	DWORD	?
fdwStyle	DWORD	?
hwndOwner	HWND	?
pwfx	LPWAVEFORMATEX	?
cbwfx	DWORD	?
pszTitle	LPSTR	?
szFormatTag	SBYTE ACMFORMATTAGDETAILS_FORMATTAG_CHARS dup (?)
szFormat	SBYTE ACMFORMATDETAILS_FORMAT_CHARS dup (?)
pszName	LPSTR	?
cchName	DWORD	?
fdwEnum	DWORD	?
pwfxEnum	LPWAVEFORMATEX	?
hInstance	HINSTANCE	?
pszTemplateName	LPSTR	?
lCustData	LPARAM	?
pfnHook	ACMFORMATCHOOSEHOOKPROCA	?
ACMFORMATCHOOSEA	ends

PACMFORMATCHOOSEA typedef ptr ACMFORMATCHOOSEA
LPACMFORMATCHOOSEA typedef ptr ACMFORMATCHOOSEA

ACMFORMATCHOOSE	EQU	<ACMFORMATCHOOSEA>
PACMFORMATCHOOSE	EQU	<PACMFORMATCHOOSEA>
LPACMFORMATCHOOSE	EQU	<LPACMFORMATCHOOSEA>

ACMFORMATCHOOSE_STYLEF_SHOWHELP	EQU	00000004h
ACMFORMATCHOOSE_STYLEF_ENABLEHOOK	EQU	00000008h
ACMFORMATCHOOSE_STYLEF_ENABLETEMPLATE	EQU	00000010h
ACMFORMATCHOOSE_STYLEF_ENABLETEMPLATEHANDLE	EQU	00000020h
ACMFORMATCHOOSE_STYLEF_INITTOWFXSTRUCT	EQU	00000040h
ACMFORMATCHOOSE_STYLEF_CONTEXTHELP	EQU	00000080h

ACMFILTERTAGDETAILS_FILTERTAG_CHARS	EQU	48

ACMFILTERTAGDETAILSA	struct 
cbStruct	DWORD	?
dwFilterTagIndex	DWORD	?
dwFilterTag	DWORD	?
cbFilterSize	DWORD	?
fdwSupport	DWORD	?
cStandardFilters	DWORD	?
szFilterTag	SBYTE ACMFILTERTAGDETAILS_FILTERTAG_CHARS dup (?)
ACMFILTERTAGDETAILSA	ends

PACMFILTERTAGDETAILSA typedef ptr ACMFILTERTAGDETAILSA
LPACMFILTERTAGDETAILSA typedef ptr ACMFILTERTAGDETAILSA

ACMFILTERTAGDETAILS	EQU	<ACMFILTERTAGDETAILSA>
PACMFILTERTAGDETAILS	EQU	<PACMFILTERTAGDETAILSA>
LPACMFILTERTAGDETAILS	EQU	<LPACMFILTERTAGDETAILSA>

ACM_FILTERTAGDETAILSF_INDEX	EQU	00000000h
ACM_FILTERTAGDETAILSF_FILTERTAG	EQU	00000001h
ACM_FILTERTAGDETAILSF_LARGESTSIZE	EQU	00000002h
ACM_FILTERTAGDETAILSF_QUERYMASK	EQU	0000000Fh

proto_ACMFILTERTAGENUMCBA typedef proto stdcall :HACMDRIVERID,:LPACMFILTERTAGDETAILSA,:DWORD,:DWORD
ACMFILTERTAGENUMCBA typedef ptr proto_ACMFILTERTAGENUMCBA
ACMFILTERTAGENUMCB	EQU	<ACMFILTERTAGENUMCBA>

ACMFILTERDETAILS_FILTER_CHARS	EQU	128

ACMFILTERDETAILSA	struct 
cbStruct	DWORD	?
dwFilterIndex	DWORD	?
dwFilterTag	DWORD	?
fdwSupport	DWORD	?
pwfltr	LPWAVEFILTER	?
cbwfltr	DWORD	?
szFilter	SBYTE ACMFILTERDETAILS_FILTER_CHARS dup (?)
ACMFILTERDETAILSA	ends

PACMFILTERDETAILSA typedef ptr ACMFILTERDETAILSA
LPACMFILTERDETAILSA typedef ptr ACMFILTERDETAILSA

ACMFILTERDETAILS	EQU	<ACMFILTERDETAILSA>
PACMFILTERDETAILS	EQU	<PACMFILTERDETAILSA>
LPACMFILTERDETAILS	EQU	<LPACMFILTERDETAILSA>

ACM_FILTERDETAILSF_INDEX	EQU	00000000h
ACM_FILTERDETAILSF_FILTER	EQU	00000001h
ACM_FILTERDETAILSF_QUERYMASK	EQU	0000000Fh

proto_ACMFILTERENUMCBA typedef proto stdcall :HACMDRIVERID,:LPACMFILTERDETAILSA,:DWORD,:DWORD
ACMFILTERENUMCBA typedef ptr proto_ACMFILTERENUMCBA
ACMFILTERENUMCB	EQU	<ACMFILTERENUMCBA>

ACM_FILTERENUMF_DWFILTERTAG	EQU	00010000h
MM_ACM_FILTERCHOOSE	EQU	8000h
FILTERCHOOSE_MESSAGE	EQU	0
FILTERCHOOSE_FILTERTAG_VERIFY	EQU	( FILTERCHOOSE_MESSAGE + 0 )
FILTERCHOOSE_FILTER_VERIFY	EQU	( FILTERCHOOSE_MESSAGE + 1 )
FILTERCHOOSE_CUSTOM_VERIFY	EQU	( FILTERCHOOSE_MESSAGE + 2 )

proto_ACMFILTERCHOOSEHOOKPROCA typedef proto stdcall :HWND,:DWORD,:WPARAM,:LPARAM
ACMFILTERCHOOSEHOOKPROCA typedef ptr proto_ACMFILTERCHOOSEHOOKPROCA
ACMFILTERCHOOSEHOOKPROC	EQU	<ACMFILTERCHOOSEHOOKPROCA>

ACMFILTERCHOOSEA	struct 
cbStruct	DWORD	?
fdwStyle	DWORD	?
hwndOwner	HWND	?
pwfltr	LPWAVEFILTER	?
cbwfltr	DWORD	?
pszTitle	LPSTR	?
szFilterTag	SBYTE ACMFILTERTAGDETAILS_FILTERTAG_CHARS dup (?)
szFilter	SBYTE ACMFILTERDETAILS_FILTER_CHARS dup (?)
pszName	LPSTR	?
cchName	DWORD	?
fdwEnum	DWORD	?
pwfltrEnum	LPWAVEFILTER	?
hInstance	HINSTANCE	?
pszTemplateName	LPSTR	?
lCustData	LPARAM	?
pfnHook	ACMFILTERCHOOSEHOOKPROCA	?
ACMFILTERCHOOSEA	ends

PACMFILTERCHOOSEA typedef ptr ACMFILTERCHOOSEA
LPACMFILTERCHOOSEA typedef ptr ACMFILTERCHOOSEA

ACMFILTERCHOOSE	EQU	<ACMFILTERCHOOSEA>
PACMFILTERCHOOSE	EQU	<PACMFILTERCHOOSEA>
LPACMFILTERCHOOSE	EQU	<LPACMFILTERCHOOSEA>

ACMFILTERCHOOSE_STYLEF_SHOWHELP	EQU	00000004h
ACMFILTERCHOOSE_STYLEF_ENABLEHOOK	EQU	00000008h
ACMFILTERCHOOSE_STYLEF_ENABLETEMPLATE	EQU	00000010h
ACMFILTERCHOOSE_STYLEF_ENABLETEMPLATEHANDLE	EQU	00000020h
ACMFILTERCHOOSE_STYLEF_INITTOFILTERSTRUCT	EQU	00000040h
ACMFILTERCHOOSE_STYLEF_CONTEXTHELP	EQU	00000080h

ifdef _WIN64
_DRVRESERVED	EQU	15
else 
_DRVRESERVED	EQU	10
endif 

ACMSTREAMHEADER	struct 
cbStruct	DWORD	?
fdwStatus	DWORD	?
dwUser	DWORD	?
pbSrc	LPBYTE	?
cbSrcLength	DWORD	?
cbSrcLengthUsed	DWORD	?
dwSrcUser	DWORD	?
pbDst	LPBYTE	?
cbDstLength	DWORD	?
cbDstLengthUsed	DWORD	?
dwDstUser	DWORD	?
dwReservedDriver	DWORD _DRVRESERVED dup (?)
ACMSTREAMHEADER	ends

PACMSTREAMHEADER typedef ptr ACMSTREAMHEADER
LPACMSTREAMHEADER typedef ptr ACMSTREAMHEADER

ACMSTREAMHEADER_STATUSF_DONE	EQU	00010000h
ACMSTREAMHEADER_STATUSF_PREPARED	EQU	00020000h
ACMSTREAMHEADER_STATUSF_INQUEUE	EQU	00100000h

ACM_STREAMOPENF_QUERY			EQU	00000001h
ACM_STREAMOPENF_ASYNC			EQU	00000002h
ACM_STREAMOPENF_NONREALTIME		EQU	00000004h

ACM_STREAMSIZEF_SOURCE			EQU	00000000h
ACM_STREAMSIZEF_DESTINATION		EQU	00000001h
ACM_STREAMSIZEF_QUERYMASK		EQU	0000000Fh

ACM_STREAMCONVERTF_BLOCKALIGN	EQU	00000004h
ACM_STREAMCONVERTF_START		EQU	00000010h
ACM_STREAMCONVERTF_END			EQU	00000020h

acmGetVersion			proto stdcall 
acmMetrics				proto stdcall :HACMOBJ, :DWORD, :LPVOID
acmDriverDetailsA		proto stdcall :HACMDRIVERID, :LPACMDRIVERDETAILSA, :DWORD
acmDriverEnum			proto stdcall :ACMDRIVERENUMCB, :DWORD, :DWORD
acmDriverID				proto stdcall :HACMOBJ, :LPHACMDRIVERID, :DWORD
acmDriverAddA			proto stdcall :LPHACMDRIVERID, :HINSTANCE, :LPARAM, :DWORD, :DWORD
acmDriverRemove			proto stdcall :HACMDRIVERID, :DWORD
acmDriverOpen			proto stdcall :LPHACMDRIVER, :HACMDRIVERID, :DWORD
acmDriverClose			proto stdcall :HACMDRIVER, :DWORD
acmDriverMessage		proto stdcall :HACMDRIVER, :DWORD, :LPARAM, :LPARAM
acmDriverPriority		proto stdcall :HACMDRIVERID, :DWORD, :DWORD
acmFormatTagDetailsA	proto stdcall :HACMDRIVER, :LPACMFORMATTAGDETAILSA, :DWORD
acmFormatTagEnumA		proto stdcall :HACMDRIVER, :LPACMFORMATTAGDETAILSA, :ACMFORMATTAGENUMCBA, :DWORD, :DWORD
acmFormatDetailsA		proto stdcall :HACMDRIVER, :LPACMFORMATDETAILSA, :DWORD
acmFormatSuggest		proto stdcall :HACMDRIVER, :LPWAVEFORMATEX, :LPWAVEFORMATEX, :DWORD, :DWORD
acmFormatEnumA			proto stdcall :HACMDRIVER, :LPACMFORMATDETAILSA, :ACMFORMATENUMCBA, :DWORD, :DWORD
acmFormatChooseA		proto stdcall :LPACMFORMATCHOOSEA
acmFilterTagDetailsA	proto stdcall :HACMDRIVER, :LPACMFILTERTAGDETAILSA, :DWORD
acmFilterTagEnumA		proto stdcall :HACMDRIVER, :LPACMFILTERTAGDETAILSA, :ACMFILTERTAGENUMCBA, :DWORD, :DWORD
acmFilterDetailsA 		proto stdcall :HACMDRIVER, :LPACMFILTERDETAILSA, :DWORD
acmFilterEnumA			proto stdcall :HACMDRIVER, :LPACMFILTERDETAILSA, :ACMFILTERENUMCBA, :DWORD, :DWORD
acmFilterChooseA		proto stdcall :LPACMFILTERCHOOSEA

acmStreamOpen			proto stdcall :LPHACMSTREAM, :HACMDRIVER, :LPWAVEFORMATEX, :LPWAVEFORMATEX, :LPWAVEFILTER, :DWORD, :DWORD, :DWORD
acmStreamClose			proto stdcall :HACMSTREAM, :DWORD
acmStreamSize			proto stdcall :HACMSTREAM, :DWORD, :LPDWORD, :DWORD
acmStreamReset			proto stdcall :HACMSTREAM, :DWORD
acmStreamMessage		proto stdcall :HACMSTREAM, :DWORD, :LPARAM, :LPARAM
acmStreamConvert		proto stdcall :HACMSTREAM, :LPACMSTREAMHEADER, :DWORD
acmStreamPrepareHeader	proto stdcall :HACMSTREAM, :LPACMSTREAMHEADER, :DWORD
acmStreamUnprepareHeader proto stdcall :HACMSTREAM, :LPACMSTREAMHEADER, :DWORD

acmDriverAdd		EQU	<acmDriverAddA>
acmDriverDetails	EQU	<acmDriverDetailsA>
acmFormatTagDetails	EQU	<acmFormatTagDetailsA>
acmFormatTagEnum	EQU	<acmFormatTagEnumA>
acmFormatDetails	EQU	<acmFormatDetailsA>
acmFormatEnum		EQU	<acmFormatEnumA>
acmFormatChoose		EQU	<acmFormatChooseA>
acmFilterTagDetails	EQU	<acmFilterTagDetailsA>
acmFilterTagEnum	EQU	<acmFilterTagEnumA>
acmFilterDetails	EQU	<acmFilterDetailsA>
acmFilterEnum		EQU	<acmFilterEnumA>
acmFilterChoose		EQU	<acmFilterChooseA>

