/****************************************************************************
*
* Description:  table of instructions. Other reserved words see special.h
*
****************************************************************************/

/* The order of items for an opcode (ins + insn) is IMPORTANT!
 * And op1 has a higher precedence than op2.
 * operands with type OP_A should be before OP_Rx & OP_R
 * operands with type OP_M should follow OP_Mx
 * operands with type OP_R should follow OP_Rx
 * operands with type OP_I should follow OP_Ix
 */

/* v1.96: the table needn't be sorted anymore, but
 * "additional" (=insn) entries must still be located after the
 * main (=ins) entry. These entries must have a <suffix> so that <tok> +
 * <suffix> gives a unique identifier.
 */

/* branch instructions */
/* there are some macros in codegen.h which rely on the order of the
 * branch tokens. To satisfy those make sure:
 * - the branch instructions are in order CALL, JMP, Jcc, JeCXZ, LOOPcc
 * - no other instruction between these
 */

/*   tok   (suffix)             op1-3                      b1_inf op_dir rm_inf opcode   rm_byte       cpu      prefix */

ins (CALL, call,                OpCls( I16,  NONE,  NONE  ), 0,      0,  no_RM,  0xE8,     0x00,       P_86,        0)
insn(CALL, 1,                   OpCls( I32,  NONE,  NONE  ), 0,      0,  no_RM,  0xE8,     0x00,       P_386,       0)
insn(CALL, 2,                   OpCls( RGT8, NONE,  NONE  ), 0,      0,  no_WDS, 0xFF,     0x10,       P_86,        0)
insn(CALL, 3,                   OpCls( M32,  NONE,  NONE  ), F_32,   0,  no_WDS, 0xFF,     0x10,       P_386,       0)
insn(CALL, 4,                   OpCls( M16,  NONE,  NONE  ), F_16,   0,  no_WDS, 0xFF,     0x10,       P_86,        0)
/* start entries for FAR call */
insm(CALL, 6,                   OpCls( I32,  NONE,  NONE  ), F_16,   0,  no_RM,  0x9A,     0x00,       P_86,        0)
insn(CALL, 7,                   OpCls( I48,  NONE,  NONE  ), F_32,   0,  no_RM,  0x9A,     0x00,       P_386,       0)
insn(CALL, 8,                   OpCls( M32,  NONE,  NONE  ), F_16,   0,  no_WDS, 0xFF,     0x18,       P_86,        0)
insn(CALL, 9,                   OpCls( M48,  NONE,  NONE  ), F_32,   0,  no_WDS, 0xFF,     0x18,       P_386,       0)
ins (JMP, jmp,                  OpCls( I8,   NONE,  NONE  ), 0,      0,  no_RM,  0xEB,     0x00,       P_86,        0)
insn(JMP, 1,                    OpCls( I16,  NONE,  NONE  ), 0,      0,  no_RM,  0xE9,     0x00,       P_86,        0)
insn(JMP, 2,                    OpCls( I32,  NONE,  NONE  ), 0,      0,  no_RM,  0xE9,     0x00,       P_386,       0)
insn(JMP, 3,                    OpCls( RGT8, NONE,  NONE  ), 0,      0,  no_WDS, 0xFF,     0x20,       P_86,        0)
insn(JMP, 4,                    OpCls( M32,  NONE,  NONE  ), F_32,   0,  no_WDS, 0xFF,     0x20,       P_386,       0)
insn(JMP, 5,                    OpCls( M16,  NONE,  NONE  ), F_16,   0,  no_WDS, 0xFF,     0x20,       P_86,        0)
/* entries for FAR jmp */
insm(JMP, 7,                    OpCls( I32,  NONE,  NONE  ), F_16,   0,  no_RM,  0xEA,     0x00,       P_86,        0)
insn(JMP, 8,                    OpCls( I48,  NONE,  NONE  ), F_32,   0,  no_RM,  0xEA,     0x00,       P_386,       0)
insn(JMP, 9,                    OpCls( M32,  NONE,  NONE  ), F_16,   0,  no_WDS, 0xFF,     0x28,       P_86,        0)
insn(JMP, 10,                   OpCls( M48,  NONE,  NONE  ), F_32,   0,  no_WDS, 0xFF,     0x28,       P_386,       0)

// for conditional jumps, the SHORT version must always be first!
#define jcc( cond, code, condlc )      \
ins (J##cond, j##condlc,        OpCls( I8,   NONE,  NONE  ), 0,      0,  no_RM, 0x70+code, 0x00,       P_86,        0) \
insn(J##cond, 1,                OpCls( I,    NONE,  NONE  ), F_0F,   0,  no_RM, 0x80+code, 0x00,       P_386,       0)

jcc( A,   0x7,   a )
jcc( AE,  0x3,  ae )
jcc( B,   0x2,   b )
jcc( BE,  0x6,  be )
jcc( C,   0x2,   c )
jcc( E,   0x4,   e )
jcc( G,   0xf,   g )
jcc( GE,  0xd,  ge )
jcc( L,   0xc,   l )
jcc( LE,  0xe,  le )
jcc( NA,  0x6,  na )
jcc( NAE, 0x2, nae )
jcc( NB,  0x3,  nb )
jcc( NBE, 0x7, nbe )
jcc( NC,  0x3,  nc )
jcc( NE,  0x5,  ne )
jcc( NG,  0xe,  ng )
jcc( NGE, 0xc, nge )
jcc( NL,  0xd,  nl )
jcc( NLE, 0xf, nle )
jcc( NO,  0x1,  no )
jcc( NP,  0xb,  np )
jcc( NS,  0x9,  ns )
jcc( NZ,  0x5,  nz )
jcc( O,   0x0,   o )
jcc( P,   0xa,   p )
jcc( PE,  0xa,  pe )
jcc( PO,  0xb,  po )
jcc( S,   0x8,   s )
jcc( Z,   0x4,   z )

#undef jcc

insx(JCXZ,   jcxz,              OpCls( I8,   NONE,  NONE  ), F_16A,  0,  no_RM,  0xE3,     0x00,       P_86,        0, RWF_IA32)
ins (JECXZ,  jecxz,             OpCls( I8,   NONE,  NONE  ), F_32A,  0,  no_RM,  0xE3,     0x00,       P_386,       0)
#if AMD64_SUPPORT
insx(JRCXZ,  jrcxz,             OpCls( I8,   NONE,  NONE  ), 0,      0,  no_RM,  0xE3,     0x00,       P_64,        0, RWF_X64)
#endif
ins (LOOP,   loop,              OpCls( I8,   NONE,  NONE  ), 0,      0,  no_RM,  0xE2,     0x00,       P_86,        0)
ins (LOOPE,  loope,             OpCls( I8,   NONE,  NONE  ), 0,      0,  no_RM,  0xE1,     0x00,       P_86,        0)
ins (LOOPZ,  loopz,             OpCls( I8,   NONE,  NONE  ), 0,      0,  no_RM,  0xE1,     0x00,       P_86,        0)
ins (LOOPNE, loopne,            OpCls( I8,   NONE,  NONE  ), 0,      0,  no_RM,  0xE0,     0x00,       P_86,        0)
ins (LOOPNZ, loopnz,            OpCls( I8,   NONE,  NONE  ), 0,      0,  no_RM,  0xE0,     0x00,       P_86,        0)
ins (LOOPD,  loopd,             OpCls( I8,   NONE,  NONE  ), F_32A,  0,  no_RM,  0xE2,     0x00,       P_386,       0)
ins (LOOPED, looped,            OpCls( I8,   NONE,  NONE  ), F_32A,  0,  no_RM,  0xE1,     0x00,       P_386,       0)
ins (LOOPZD, loopzd,            OpCls( I8,   NONE,  NONE  ), F_32A,  0,  no_RM,  0xE1,     0x00,       P_386,       0)
ins (LOOPNED,loopned,           OpCls( I8,   NONE,  NONE  ), F_32A,  0,  no_RM,  0xE0,     0x00,       P_386,       0)
ins (LOOPNZD,loopnzd,           OpCls( I8,   NONE,  NONE  ), F_32A,  0,  no_RM,  0xE0,     0x00,       P_386,       0)
insx(LOOPW,  loopw,             OpCls( I8,   NONE,  NONE  ), F_16A,  0,  no_RM,  0xE2,     0x00,       P_86,        0, RWF_IA32)
insx(LOOPEW, loopew,            OpCls( I8,   NONE,  NONE  ), F_16A,  0,  no_RM,  0xE1,     0x00,       P_86,        0, RWF_IA32)
insx(LOOPZW, loopzw,            OpCls( I8,   NONE,  NONE  ), F_16A,  0,  no_RM,  0xE1,     0x00,       P_86,        0, RWF_IA32)
insx(LOOPNEW,loopnew,           OpCls( I8,   NONE,  NONE  ), F_16A,  0,  no_RM,  0xE0,     0x00,       P_86,        0, RWF_IA32)
insx(LOOPNZW,loopnzw,           OpCls( I8,   NONE,  NONE  ), F_16A,  0,  no_RM,  0xE0,     0x00,       P_86,        0, RWF_IA32)

/* arith instructions. Masm v6 encodes operand types R,R differently
 * (direction bit is NOT set). JWasm does like Masm v8+.
 */

#define ari( name, namelc, code, lock )      \
ins (name, namelc,              OpCls( RGT8, I8,    NONE  ), 0,      0,  no_WDS, 0x83,     code,       P_86,        0) \
insn(name, 1,                   OpCls( R,    R_MS,  NONE  ), 0,      1,  0,      code+2,   0x00,       P_86,        0) \
insn(name, 3,                   OpCls( A,    I,     NONE  ), 0,      0,  no_RM,  code+4,   0x00,       P_86,        0) \
insn(name, 4,                   OpCls( R,    I,     NONE  ), 0,      0,  0,      0x80,     code,       P_86,        0) \
insn(name, 6,                   OpCls( MGT8, I8,    NONE  ), 0,      0,  no_WDS, 0x83,     code,       P_86,        lock) \
insn(name, 7,                   OpCls( MS,   R,     NONE  ), 0,      0,  0,      code,     0x00,       P_86,        lock) \
insn(name, 8,                   OpCls( MS,   I,     NONE  ), 0,      0,  0,      0x80,     code,       P_86,        lock)

/* v2.02: entries 5+6 replaced by 6 */
/* v2.06: entries 1+2 replaced by 1 */
/* v2.11: added AP_LOCK argument, because CMP isn't supposed to accept this prefix */

ari( ADD, add, 0x00, AP_LOCK )
ari(  OR,  or, 0x08, AP_LOCK )
ari( ADC, adc, 0x10, AP_LOCK )
ari( SBB, sbb, 0x18, AP_LOCK )
ari( AND, and, 0x20, AP_LOCK )
ari( SUB, sub, 0x28, AP_LOCK )
ari( XOR, xor, 0x30, AP_LOCK )
ari( CMP, cmp, 0x38, 0 )

#undef ari

/* std bitshift instructions */
#define bsi( name, namelc, code )      \
ins (name, namelc,              OpCls( R_MS,  CL_ONLY,    NONE  ), 0,      0,  0,      0xD2,     code,       P_86,        0) \
insn(name, 1,                   OpCls( R_MS,  I_1,        NONE  ), 0,      0,  0,      0xD0,     code,       P_86,        0) \
insn(name, 2,                   OpCls( R_MS,  I8_U,       NONE  ), 0,      0,  0,      0xC0,     code,       P_186,       0)

bsi( RCL, rcl, 0x10 )
bsi( RCR, rcr, 0x18 )
bsi( ROL, rol, 0x00 )
bsi( ROR, ror, 0x08 )
bsi( SAL, sal, 0x20 )
bsi( SAR, sar, 0x38 )
bsi( SHL, shl, 0x20 )
bsi( SHR, shr, 0x28 )

#undef bsi

/* string instructions */

ins (CMPS,  cmps,               OpCls( MS,       MS,         NONE ), 0,      0,  no_RM,  0xA6,     0x00,       P_86,        AP_REPxx)
ins (CMPSB, cmpsb,              OpCls( NONE,     NONE,       NONE ), 0,      0,  no_RM,  0xA6,     0x00,       P_86,        AP_REPxx)
insn(CMPSB, 1,                  OpCls( M08,      M08,        NONE ), 0,      0,  no_RM,  0xA6,     0x00,       P_86,        AP_REPxx)
ins (CMPSW, cmpsw,              OpCls( NONE,     NONE,       NONE ), F_16,   0,  no_RM,  0xA7,     0x00,       P_86,        AP_REPxx)
insn(CMPSW, 1,                  OpCls( M16,      M16,        NONE ), F_16,   0,  no_RM,  0xA7,     0x00,       P_86,        AP_REPxx)
ins (CMPSD, cmpsd,              OpCls( NONE,     NONE,       NONE ), F_32,   0,  no_RM,  0xA7,     0x00,       P_386,       AP_REPxx)
insn(CMPSD, 1,                  OpCls( M32,      M32,        NONE ), F_32,   0,  no_RM,  0xA7,     0x00,       P_386,       AP_REPxx)
insn(CMPSD, 2,                  OpCls( XMM,      XMM_M64,    I8_U ), F_F20F, 1,  no_WDS, 0xC2,     0x00,       P_686|P_SSE2,0)
ins (INS,   ins,                OpCls( MS,       DX_ONLY,    NONE ), 0,      0,  no_RM,  0x6C,     0x00,       P_186,       AP_REP)
ins (INSB,  insb,               OpCls( NONE,     NONE,       NONE ), 0,      0,  no_RM,  0x6C,     0x00,       P_186,       AP_REP)
insn(INSB,  1,                  OpCls( M08,      DX_ONLY,    NONE ), 0,      0,  no_RM,  0x6C,     0x00,       P_186,       AP_REP)
ins (INSW,  insw,               OpCls( NONE,     NONE,       NONE ), F_16,   0,  no_RM,  0x6D,     0x00,       P_186,       AP_REP)
insn(INSW,  1,                  OpCls( M16,      DX_ONLY,    NONE ), F_16,   0,  no_RM,  0x6D,     0x00,       P_186,       AP_REP)
ins (INSD,  insd,               OpCls( NONE,     NONE,       NONE ), F_32,   0,  no_RM,  0x6D,     0x00,       P_386,       AP_REP)
insn(INSD,  1,                  OpCls( M32,      DX_ONLY,    NONE ), F_32,   0,  no_RM,  0x6D,     0x00,       P_386,       AP_REP)
ins (LODS,  lods,               OpCls( MS,       NONE,       NONE ), 0,      0,  no_RM,  0xAC,     0x00,       P_86,        AP_REP)
ins (LODSB, lodsb,              OpCls( NONE,     NONE,       NONE ), 0,      0,  no_RM,  0xAC,     0x00,       P_86,        AP_REP)
insn(LODSB, 1,                  OpCls( M08,      NONE,       NONE ), 0,      0,  no_RM,  0xAC,     0x00,       P_86,        AP_REP)
ins (LODSW, lodsw,              OpCls( NONE,     NONE,       NONE ), F_16,   0,  no_RM,  0xAD,     0x00,       P_86,        AP_REP)
insn(LODSW, 1,                  OpCls( M16,      NONE,       NONE ), F_16,   0,  no_RM,  0xAD,     0x00,       P_86,        AP_REP)
ins (LODSD, lodsd,              OpCls( NONE,     NONE,       NONE ), F_32,   0,  no_RM,  0xAD,     0x00,       P_386,       AP_REP)
insn(LODSD, 1,                  OpCls( M32,      NONE,       NONE ), F_32,   0,  no_RM,  0xAD,     0x00,       P_386,       AP_REP)
ins (MOVS,  movs,               OpCls( MS,       MS,         NONE ), 0,      0,  no_RM,  0xA4,     0x00,       P_86,        AP_REP)
ins (MOVSB, movsb,              OpCls( NONE,     NONE,       NONE ), 0,      0,  no_RM,  0xA4,     0x00,       P_86,        AP_REP)
insn(MOVSB, 1,                  OpCls( M08,      M08,        NONE ), 0,      0,  no_RM,  0xA4,     0x00,       P_86,        AP_REP)
ins (MOVSW, movsw,              OpCls( NONE,     NONE,       NONE ), F_16,   0,  no_RM,  0xA5,     0x00,       P_86,        AP_REP)
insn(MOVSW, 1,                  OpCls( M16,      M16,        NONE ), F_16,   0,  no_RM,  0xA5,     0x00,       P_86,        AP_REP)
ins (MOVSD, movsd,              OpCls( NONE,     NONE,       NONE ), F_32,   0,  no_RM,  0xA5,     0x00,       P_386,       AP_REP)
insn(MOVSD, 1,                  OpCls( M32,      M32,        NONE ), F_32,   0,  no_RM,  0xA5,     0x00,       P_386,       AP_REP)
insn(MOVSD, 2,                  OpCls( XMM,      XMM_M64,    NONE ), F_F20F, 1,  no_WDS, 0x10,     0x00,       P_686|P_SSE2,0)
insn(MOVSD, 3,                  OpCls( M64,      XMM,        NONE ), F_F20F, 0,  no_WDS, 0x11,     0x00,       P_686|P_SSE2,0)
ins (OUTS,  outs,               OpCls( DX_ONLY,  MS,         NONE ), 0,      0,  no_RM,  0x6E,     0x00,       P_186,       AP_REP)
ins (OUTSB, outsb,              OpCls( NONE,     NONE,       NONE ), 0,      0,  no_RM,  0x6E,     0x00,       P_186,       AP_REP)
insn(OUTSB, 1,                  OpCls( DX_ONLY,  M08,        NONE ), 0,      0,  no_RM,  0x6E,     0x00,       P_186,       AP_REP)
ins (OUTSW, outsw,              OpCls( NONE,     NONE,       NONE ), F_16,   0,  no_RM,  0x6F,     0x00,       P_186,       AP_REP)
insn(OUTSW, 1,                  OpCls( DX_ONLY,  M16,        NONE ), F_16,   0,  no_RM,  0x6F,     0x00,       P_186,       AP_REP)
ins (OUTSD, outsd,              OpCls( NONE,     NONE,       NONE ), F_32,   0,  no_RM,  0x6F,     0x00,       P_386,       AP_REP)
insn(OUTSD, 1,                  OpCls( DX_ONLY,  M32,        NONE ), F_32,   0,  no_RM,  0x6F,     0x00,       P_386,       AP_REP)
ins (SCAS,  scas,               OpCls( MS,       NONE,       NONE ), 0,      0,  no_RM,  0xAE,     0x00,       P_86,        AP_REPxx)
ins (SCASB, scasb,              OpCls( NONE,     NONE,       NONE ), 0,      0,  no_RM,  0xAE,     0x00,       P_86,        AP_REPxx)
insn(SCASB, 1,                  OpCls( M08,      NONE,       NONE ), 0,      0,  no_RM,  0xAE,     0x00,       P_86,        AP_REPxx)
ins (SCASW, scasw,              OpCls( NONE,     NONE,       NONE ), F_16,   0,  no_RM,  0xAF,     0x00,       P_86,        AP_REPxx)
insn(SCASW, 1,                  OpCls( M16,      NONE,       NONE ), F_16,   0,  no_RM,  0xAF,     0x00,       P_86,        AP_REPxx)
ins (SCASD, scasd,              OpCls( NONE,     NONE,       NONE ), F_32,   0,  no_RM,  0xAF,     0x00,       P_386,       AP_REPxx)
insn(SCASD, 1,                  OpCls( M32,      NONE,       NONE ), F_32,   0,  no_RM,  0xAF,     0x00,       P_386,       AP_REPxx)
ins (STOS,  stos,               OpCls( MS,       NONE,       NONE ), 0,      0,  no_RM,  0xAA,     0x00,       P_86,        AP_REP)
ins (STOSB, stosb,              OpCls( NONE,     NONE,       NONE ), 0,      0,  no_RM,  0xAA,     0x00,       P_86,        AP_REP)
insn(STOSB, 1,                  OpCls( M08,      NONE,       NONE ), 0,      0,  no_RM,  0xAA,     0x00,       P_86,        AP_REP)
ins (STOSW, stosw,              OpCls( NONE,     NONE,       NONE ), F_16,   0,  no_RM,  0xAB,     0x00,       P_86,        AP_REP)
insn(STOSW, 1,                  OpCls( M16,      NONE,       NONE ), F_16,   0,  no_RM,  0xAB,     0x00,       P_86,        AP_REP)
ins (STOSD, stosd,              OpCls( NONE,     NONE,       NONE ), F_32,   0,  no_RM,  0xAB,     0x00,       P_386,       AP_REP)
insn(STOSD, 1,                  OpCls( M32,      NONE,       NONE ), F_32,   0,  no_RM,  0xAB,     0x00,       P_386,       AP_REP)

/* instructions invalid for IA32+ */

insx(AAA, aaa,                  OpCls( NONE,     NONE,       NONE ), 0,      0,  no_RM,  0x37,     0x00,       P_86,        0, RWF_IA32 )
insx(AAD, aad,                  OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xD5,     0x0A,       P_86,        0, RWF_IA32 )
insx(AAM, aam,                  OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xD4,     0x0A,       P_86,        0, RWF_IA32 )
insx(AAS, aas,                  OpCls( NONE,     NONE,       NONE ), 0,      0,  no_RM,  0x3F,     0x00,       P_86,        0, RWF_IA32 )
insx(DAA, daa,                  OpCls( NONE,     NONE,       NONE ), 0,      0,  no_RM,  0x27,     0x00,       P_86,        0, RWF_IA32 )
insx(DAS, das,                  OpCls( NONE,     NONE,       NONE ), 0,      0,  no_RM,  0x2F,     0x00,       P_86,        0, RWF_IA32 )
insx(LDS, lds,                  OpCls( RGT8,     MFPTR,      NONE ), 0,      1,  no_WDS, 0xC5,     0x00,       P_86,        0, RWF_IA32 )
insx(LES, les,                  OpCls( RGT8,     MFPTR,      NONE ), 0,      1,  no_WDS, 0xC4,     0x00,       P_86,        0, RWF_IA32 )
insx(POPA,  popa,               OpCls( NONE,     NONE,       NONE ), 0,      0,  no_RM,  0x61,     0x00,       P_186,       0, RWF_IA32 )
insx(POPAD, popad,              OpCls( NONE,     NONE,       NONE ), F_32,   0,  no_RM,  0x61,     0x00,       P_386,       0, RWF_IA32 )
insx(POPAW, popaw,              OpCls( NONE,     NONE,       NONE ), F_16,   0,  no_RM,  0x61,     0x00,       P_186,       0, RWF_IA32 )
insx(POPFD, popfd,              OpCls( NONE,     NONE,       NONE ), F_32,   0,  no_RM,  0x9D,     0x00,       P_386,       0, RWF_IA32 )
insx(PUSHA,  pusha,             OpCls( NONE,     NONE,       NONE ), 0,      0,  no_RM,  0x60,     0x00,       P_186,       0, RWF_IA32 )
insx(PUSHAD, pushad,            OpCls( NONE,     NONE,       NONE ), F_32,   0,  no_RM,  0x60,     0x00,       P_386,       0, RWF_IA32 )
insx(PUSHAW, pushaw,            OpCls( NONE,     NONE,       NONE ), F_16,   0,  no_RM,  0x60,     0x00,       P_186,       0, RWF_IA32 )
insx(PUSHFD, pushfd,            OpCls( NONE,     NONE,       NONE ), F_32,   0,  no_RM,  0x9C,     0x00,       P_386,       0, RWF_IA32 )
insx(PUSHD,  pushd,             OpCls( I8,       NONE,       NONE ), F_32,   0,  no_RM,  0x6A,     0x00,       P_386,       0, RWF_IA32 )
insn(PUSHD,  1,                 OpCls( I32,      NONE,       NONE ), F_32,   0,  no_RM,  0x68,     0x00,       P_386,       0)
insn(PUSHD,  2,                 OpCls( R32,      NONE,       NONE ), 0,      0,  R_in_OP,0x50,     0x00,       P_386,       0)
insn(PUSHD,  3,                 OpCls( SR86,     NONE,       NONE ), 0,      1,  R_in_OP,0x06,     0x00,       P_86,        0)
insn(PUSHD,  4,                 OpCls( SR,       NONE,       NONE ), F_0F,   1,  R_in_OP,0x80,     0x00,       P_386,       0)
insn(PUSHD,  5,                 OpCls( M32,      NONE,       NONE ), 0,      0,  0,      0xFF,     0x30,       P_386,       0)
/* unlike their names suggest, RETD/RETW will always create a 32-/16-bit far ret */
insx(RETD, retd,                OpCls( I16,      NONE,       NONE ), F_32,   0,  no_RM,  0xCA,     0x00,       P_386,       0, RWF_IA32 )
insn(RETD, 1,                   OpCls( NONE,     NONE,       NONE ), F_32,   0,  no_RM,  0xCB,     0x00,       P_386,       0)
insx(RETW, retw,                OpCls( I16,      NONE,       NONE ), F_16,   0,  no_RM,  0xCA,     0x00,       P_86,        0, RWF_IA32 )
insn(RETW, 1,                   OpCls( NONE,     NONE,       NONE ), F_16,   0,  no_RM,  0xCB,     0x00,       P_86,        0)

/* protected-mode instructions */
/* some (i.e. SMSW) also work with 32bit register as first operand, but Masm won't accept.
 * to make JWasm accept, change OP_R16 to OP_RGT8
 */

ins (ARPL, arpl,                OpCls( R16_M16,  R16,      NONE ), 0,       0,  no_WDS, 0x63,     0x00,       P_286,       0)
ins (LLDT, lldt,                OpCls( R16_M16,  NONE,     NONE ), F_0FNO66,0,  no_WDS, 0x00,     0x10,       P_286p,      0)
ins (LMSW, lmsw,                OpCls( R16_M16,  NONE,     NONE ), F_0FNO66,0,  no_WDS, 0x01,     0x30,       P_286p,      0)
ins (LTR,  ltr,                 OpCls( R16_M16,  NONE,     NONE ), F_0FNO66,0,  no_WDS, 0x00,     0x18,       P_286p,      0)
ins (SLDT, sldt,                OpCls( R16_M16,  NONE,     NONE ), F_0FNO66,0,  no_WDS, 0x00,     0x00,       P_286,       0)
ins (SMSW, smsw,                OpCls( R16_M16,  NONE,     NONE ), F_0FNO66,0,  no_WDS, 0x01,     0x20,       P_286,       0)
ins (STR,  str,                 OpCls( R16_M16,  NONE,     NONE ), F_0FNO66,0,  no_WDS, 0x00,     0x08,       P_286,       0)
ins (VERR, verr,                OpCls( R16_M16,  NONE,     NONE ), F_0FNO66,0,  no_WDS, 0x00,     0x20,       P_286,       0)
ins (VERW, verw,                OpCls( R16_M16,  NONE,     NONE ), F_0FNO66,0,  no_WDS, 0x00,     0x28,       P_286,       0)
/* v2.06: obsolete */
//insn(ARPL, 1,                   OP_M16,      OP_R16,       OP_NONE, 0,       0,  no_WDS, 0x63,     0x00,       P_286,       0)
//insn(LLDT, 1,                   OP_M16,      OP_NONE,      OP_NONE, F_0FNO66,0,  no_WDS, 0x00,     0x10,       P_286p,      0)
//insn(LMSW, 1,                   OP_M16,      OP_NONE,      OP_NONE, F_0FNO66,0,  no_WDS, 0x01,     0x30,       P_286p,      0)
//insn(LTR,  1,                   OP_M16,      OP_NONE,      OP_NONE, F_0FNO66,0,  no_WDS, 0x00,     0x18,       P_286p,      0)
//insn(SLDT, 1,                   OP_M16,      OP_NONE,      OP_NONE, F_0FNO66,0,  no_WDS, 0x00,     0x00,       P_286,       0)
//insn(SMSW, 1,                   OP_M16,      OP_NONE,      OP_NONE, F_0FNO66,0,  no_WDS, 0x01,     0x20,       P_286,       0)
//insn(STR,  1,                   OP_M16,      OP_NONE,      OP_NONE, F_0FNO66,0,  no_WDS, 0x00,     0x08,       P_286,       0)
//insn(VERR, 1,                   OP_M16,      OP_NONE,      OP_NONE, F_0FNO66,0,  no_WDS, 0x00,     0x20,       P_286,       0)
//insn(VERW, 1,                   OP_M16,      OP_NONE,      OP_NONE, F_0FNO66,0,  no_WDS, 0x00,     0x28,       P_286,       0)

/* one-operand register/memory instructions */

ins (DIV, div,                  OpCls( R,        NONE,       NONE ), 0,      0,  0,      0xF6,     0x30,       P_86,        0)
insn(DIV, 1,                    OpCls( M08,      NONE,       NONE ), 0,      0,  0,      0xF6,     0x30,       P_86,        0)
insn(DIV, 2,                    OpCls( MGT8,     NONE,       NONE ), 0,      0,  0,      0xF7,     0x30,       P_86,        0)
ins (IDIV, idiv,                OpCls( R,        NONE,       NONE ), 0,      0,  0,      0xF6,     0x38,       P_86,        0)
insn(IDIV, 1,                   OpCls( M08,      NONE,       NONE ), 0,      0,  0,      0xF6,     0x38,       P_86,        0)
insn(IDIV, 2,                   OpCls( MGT8,     NONE,       NONE ), 0,      0,  0,      0xF7,     0x38,       P_86,        0)
ins (MUL, mul,                  OpCls( R,        NONE,       NONE ), 0,      0,  0,      0xF6,     0x20,       P_86,        0)
insn(MUL, 1,                    OpCls( M08,      NONE,       NONE ), 0,      0,  0,      0xF6,     0x20,       P_86,        0)
insn(MUL, 2,                    OpCls( MGT8,     NONE,       NONE ), 0,      0,  0,      0xF7,     0x20,       P_86,        0)
ins (NEG, neg,                  OpCls( R,        NONE,       NONE ), 0,      0,  0,      0xF6,     0x18,       P_86,        0)
insn(NEG, 1,                    OpCls( M08,      NONE,       NONE ), 0,      0,  0,      0xF6,     0x18,       P_86,        AP_LOCK)
insn(NEG, 2,                    OpCls( MGT8,     NONE,       NONE ), 0,      0,  0,      0xF7,     0x18,       P_86,        AP_LOCK)
ins (NOT, not,                  OpCls( R,        NONE,       NONE ), 0,      0,  0,      0xF6,     0x10,       P_86,        0)
insn(NOT, 1,                    OpCls( M08,      NONE,       NONE ), 0,      0,  0,      0xF6,     0x10,       P_86,        AP_LOCK)
insn(NOT, 2,                    OpCls( MGT8,     NONE,       NONE ), 0,      0,  0,      0xF7,     0x10,       P_86,        AP_LOCK)

/* prefixes. must start with LOCK, end with REPZ and be consecutive */
ins (LOCK,  lock,               OpCls( NONE,     NONE,       NONE ), 0,      0,  no_RM,  0xF0,     0,          P_86,        AP_LOCK)
ins (REP,   rep,                OpCls( NONE,     NONE,       NONE ), 0,      0,  no_RM,  0xF3,     0,          P_86,        AP_REP)
ins (REPE,  repe,               OpCls( NONE,     NONE,       NONE ), 0,      0,  no_RM,  0xF3,     0,          P_86,        AP_REPxx)
ins (REPNE, repne,              OpCls( NONE,     NONE,       NONE ), 0,      0,  no_RM,  0xF2,     0,          P_86,        AP_REPxx)
ins (REPNZ, repnz,              OpCls( NONE,     NONE,       NONE ), 0,      0,  no_RM,  0xF2,     0,          P_86,        AP_REPxx)
ins (REPZ,  repz,               OpCls( NONE,     NONE,       NONE ), 0,      0,  no_RM,  0xF3,     0,          P_86,        AP_REPxx)

/* BTx */

ins (BT, bt,                    OpCls( RGT8,     RGT8,       NONE ), F_0F,   0,  no_WDS, 0xA3,     0x00,       P_386,       0)
insn(BT,   1,                   OpCls( RGT8,     I8_U,       NONE ), F_0F,   0,  no_WDS, 0xBA,     0x20,       P_386,       0)
insn(BT,   2,                   OpCls( MGT8,     RGT8,       NONE ), F_0F,   0,  no_WDS, 0xA3,     0x00,       P_386,       0)
insn(BT,   3,                   OpCls( MGT8,     I8_U,       NONE ), F_0F,   0,  no_WDS, 0xBA,     0x20,       P_386,       0)
ins (BTC, btc,                  OpCls( RGT8,     RGT8,       NONE ), F_0F,   0,  no_WDS, 0xBB,     0x00,       P_386,       0)
insn(BTC,  1,                   OpCls( RGT8,     I8_U,       NONE ), F_0F,   0,  no_WDS, 0xBA,     0x38,       P_386,       0)
insn(BTC,  2,                   OpCls( MGT8,     RGT8,       NONE ), F_0F,   0,  no_WDS, 0xBB,     0x00,       P_386,       AP_LOCK)
insn(BTC,  3,                   OpCls( MGT8,     I8_U,       NONE ), F_0F,   0,  no_WDS, 0xBA,     0x38,       P_386,       AP_LOCK)
ins (BTR, btr,                  OpCls( RGT8,     RGT8,       NONE ), F_0F,   0,  no_WDS, 0xB3,     0x00,       P_386,       0)
insn(BTR,  1,                   OpCls( RGT8,     I8_U,       NONE ), F_0F,   0,  no_WDS, 0xBA,     0x30,       P_386,       0)
insn(BTR,  2,                   OpCls( MGT8,     RGT8,       NONE ), F_0F,   0,  no_WDS, 0xB3,     0x00,       P_386,       AP_LOCK)
insn(BTR,  3,                   OpCls( MGT8,     I8_U,       NONE ), F_0F,   0,  no_WDS, 0xBA,     0x30,       P_386,       AP_LOCK)
ins (BTS, bts,                  OpCls( RGT8,     RGT8,       NONE ), F_0F,   0,  no_WDS, 0xAB,     0x00,       P_386,       0)
insn(BTS,  1,                   OpCls( RGT8,     I8_U,       NONE ), F_0F,   0,  no_WDS, 0xBA,     0x28,       P_386,       0)
insn(BTS,  2,                   OpCls( MGT8,     RGT8,       NONE ), F_0F,   0,  no_WDS, 0xAB,     0x00,       P_386,       AP_LOCK)
insn(BTS,  3,                   OpCls( MGT8,     I8_U,       NONE ), F_0F,   0,  no_WDS, 0xBA,     0x28,       P_386,       AP_LOCK)

/* set/reset flags */

ins (CMC, cmc,                  OpCls( NONE,     NONE,       NONE ), 0,      0,  no_RM,  0xF5,     0x00,       P_86,        0)
ins (CLC, clc,                  OpCls( NONE,     NONE,       NONE ), 0,      0,  no_RM,  0xF8,     0x00,       P_86,        0)
ins (STC, stc,                  OpCls( NONE,     NONE,       NONE ), 0,      0,  no_RM,  0xF9,     0x00,       P_86,        0)
ins (CLI, cli,                  OpCls( NONE,     NONE,       NONE ), 0,      0,  no_RM,  0xFA,     0x00,       P_86,        0)
ins (STI, sti,                  OpCls( NONE,     NONE,       NONE ), 0,      0,  no_RM,  0xFB,     0x00,       P_86,        0)
ins (CLD, cld,                  OpCls( NONE,     NONE,       NONE ), 0,      0,  no_RM,  0xFC,     0x00,       P_86,        0)
ins (STD, std,                  OpCls( NONE,     NONE,       NONE ), 0,      0,  no_RM,  0xFD,     0x00,       P_86,        0)

/* INC/DEC. (hack for 64-bit in reswords.c!) */

ins (INC, inc,                  OpCls( RGT8,     NONE,       NONE ), 0,      0,  R_in_OP,0x40,     0x00,       P_86,        0)
insn(INC, 1,                    OpCls( R,        NONE,       NONE ), 0,      0,  0,      0xFE,     0x00,       P_86,        0)
insn(INC, 2,                    OpCls( M08,      NONE,       NONE ), 0,      0,  0,      0xFE,     0x00,       P_86,        AP_LOCK)
insn(INC, 3,                    OpCls( MGT8,     NONE,       NONE ), 0,      0,  0,      0xFF,     0x00,       P_86,        AP_LOCK)
ins (DEC, dec,                  OpCls( RGT8,     NONE,       NONE ), 0,      0,  R_in_OP,0x48,     0x00,       P_86,        0)
insn(DEC, 1,                    OpCls( R,        NONE,       NONE ), 0,      0,  0,      0xFE,     0x08,       P_86,        0)
insn(DEC, 2,                    OpCls( M08,      NONE,       NONE ), 0,      0,  0,      0xFE,     0x08,       P_86,        AP_LOCK)
insn(DEC, 3,                    OpCls( MGT8,     NONE,       NONE ), 0,      0,  0,      0xFF,     0x08,       P_86,        AP_LOCK)

/* PUSH/POP (16- and 32-bit only) */

ins (PUSH,  push,               OpCls( R16_R32,  NONE,       NONE ), 0,     0,  R_in_OP,0x50,     0x00,       P_86,        0)
insn(PUSH, 1,                   OpCls( I8,       NONE,       NONE ), 0,     0,  no_RM,  0x6A,     0x00,       P_186,       0)
insn(PUSH, 2,                   OpCls( I,        NONE,       NONE ), 0,     0,  no_RM,  0x68,     0x00,       P_186,       0)
insn(PUSH, 3,                   OpCls( SR86,     NONE,       NONE ), 0,     1,  R_in_OP,0x06,     0x00,       P_86,        0)
insn(PUSH, 4,                   OpCls( SR,       NONE,       NONE ), F_0F,  1,  R_in_OP,0x80,     0x00,       P_386,       0)
insn(PUSH, 5,                   OpCls( M16_M32,  NONE,       NONE ), 0,     0,  0,      0xFF,     0x30,       P_86,        0)
ins (POP, pop,                  OpCls( R16_R32,  NONE,       NONE ), 0,     0,  R_in_OP,0x58,     0x00,       P_86,        0)
insn(POP, 1,                    OpCls( SR86,     NONE,       NONE ), 0,     1,  R_in_OP,0x07,     0x00,       P_86,        0)
insn(POP, 2,                    OpCls( SR,       NONE,       NONE ), F_0F,  1,  R_in_OP,0x81,     0x00,       P_386,       0)
insn(POP, 3,                    OpCls( M16_M32,  NONE,       NONE ), 0,     0,  0,      0x8F,     0x00,       P_86,        0)
ins (PUSHW,  pushw,             OpCls( I8,       NONE,       NONE ), F_16,  0,  no_RM,  0x6A,     0x00,       P_186,       0)
insn(PUSHW,  1,                 OpCls( I16,      NONE,       NONE ), F_16,  0,  no_RM,  0x68,     0x00,       P_186,       0)
/* v2.15: PUSHW for segment registers added, although NO size prefix will be emitted due to masm compatibility */
insn(PUSHW,  2,                 OpCls( SR86,     NONE,       NONE ), 0,     1,  R_in_OP,0x06,     0x00,       P_86,        0)
insn(PUSHW,  3,                 OpCls( SR,       NONE,       NONE ), F_0F,  1,  R_in_OP,0x80,     0x00,       P_386,       0)
/* v2.20: PUSHW added for memory operands ( masm compatibility ) */
insn(PUSHW,  4,                 OpCls( M16,      NONE,       NONE ), 0,     0,  0,      0xFF,     0x30,       P_86,        0)
ins (PUSHF,  pushf,             OpCls( NONE,     NONE,       NONE ), F_16,  0,  no_RM,  0x9C,     0x00,       P_86,        0)
ins (POPF,  popf,               OpCls( NONE,     NONE,       NONE ), F_16,  0,  no_RM,  0x9D,     0x00,       P_86,        0)

/* MOV */

ins (MOV, mov,                  OpCls( A,        MS,         NONE ), 0,      1,  no_RM,  0xA0,     0x00,       P_86,        0)
insn(MOV, 1,                    OpCls( R,        R_MS,       NONE ), 0,      1,  0,      0x8A,     0x00,       P_86,        0)
insn(MOV, 2,                    OpCls( R8,       I,          NONE ), 0,      0,  R_in_OP,0xB0,     0x00,       P_86,        0)
insn(MOV, 3,                    OpCls( R16_R32,  I,          NONE ), 0,      0,  R_in_OP,0xB8,     0x00,       P_86,        0)
#if AMD64_SUPPORT
insn(MOV, 4,                    OpCls( R64,      I,          NONE ), 0,      0,  0,      0xC6,     0x00,       P_64,        0)
insn(MOV, 5,                    OpCls( R64,      I64,        NONE ), 0,      0,  R_in_OP,0xB8,     0x00,       P_64,        0)
#endif
insn(MOV, 6,                    OpCls( RGT8,     SR,         NONE ), 0,      0,  no_WDS, 0x8C,     0xC0,       P_86,        0)
insn(MOV, 7,                    OpCls( SR,       RGT8,       NONE ), 0,      1,  no_WDS, 0x8E,     0xC0,       P_86,        0)
insn(MOV, 8,                    OpCls( SR,       MS,         NONE ), 0,      1,  no_WDS, 0x8E,     0x00,       P_86,        0)
insn(MOV, 9,                    OpCls( MS,       A,          NONE ), 0,      0,  no_RM,  0xA2,     0x00,       P_86,        0)
insn(MOV, 10,                   OpCls( MS,       R,          NONE ), 0,      0,  0,      0x88,     0x00,       P_86,        0)
insn(MOV, 11,                   OpCls( MS,       I,          NONE ), 0,      0,  0,      0xC6,     0x00,       P_86,        0)
insn(MOV, 12,                   OpCls( MS,       SR,         NONE ), 0,      0,  no_WDS, 0x8C,     0x00,       P_86,        0)
/* move to/from special registers are privileged, but masm accepts them w/o the cpu 'p' suffix */
insn(MOV, 13,                   OpCls( RGT16,    RSPEC,      NONE ), F_0FNO66,0, no_WDS, 0x20,     0xC0,       P_386,       0)
insn(MOV, 14,                   OpCls( RSPEC,    RGT16,      NONE ), F_0FNO66,1, no_WDS, 0x22,     0xC0,       P_386,       0)

/* rest */

ins (BOUND_, bound,             OpCls( RGT8,     MS,         NONE ), 0,      1,  no_WDS, 0x62,     0x00,       P_186,       0)
ins (BSF, bsf,                  OpCls( RGT8,     RGT8_MS,    NONE ), F_0F,   1,  no_WDS, 0xBC,     0x00,       P_386,       0)
ins (BSR, bsr,                  OpCls( RGT8,     RGT8_MS,    NONE ), F_0F,   1,  no_WDS, 0xBD,     0x00,       P_386,       0)
ins (BSWAP, bswap,              OpCls( RGT16,    NONE,       NONE ), F_0F,   0,  R_in_OP,0xC8,     0x00,       P_486,       0)
ins (CBW, cbw,                  OpCls( NONE,     NONE,       NONE ), F_16,   0,  no_RM,  0x98,     0x00,       P_86,        0)
ins (CDQ, cdq,                  OpCls( NONE,     NONE,       NONE ), F_32,   0,  no_RM,  0x99,     0x00,       P_386,       0)
ins (CWD, cwd,                  OpCls( NONE,     NONE,       NONE ), F_16,   0,  no_RM,  0x99,     0x00,       P_86,        0)
ins (CWDE, cwde,                OpCls( NONE,     NONE,       NONE ), F_32,   0,  no_RM,  0x98,     0x00,       P_386,       0)
ins (CLTS, clts,                OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0x0F,     0x06,       P_286p,      0)
ins (CMPXCHG, cmpxchg,          OpCls( R,        R,          NONE ), F_0F,   0,  0,      0xB0,     0x00,       P_486,       0)
insn(CMPXCHG, 1,                OpCls( MS,       R,          NONE ), F_0F,   0,  0,      0xB0,     0x00,       P_486,       AP_LOCK)
ins (CMPXCHG8B, cmpxchg8b,      OpCls( M64,      NONE,       NONE ), F_0F,   0,  0,      0xC7,     0x08,       P_586,       AP_LOCK)
ins (CPUID, cpuid,              OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0x0F,     0xA2,       P_586,       0)
ins (ENTER, enter,              OpCls( I16,      I8_U,       NONE ), 0,      0,  no_RM,  0xC8,     0x00,       P_186,       0)
ins (HLT, hlt,                  OpCls( NONE,     NONE,       NONE ), 0,      0,  no_RM,  0xF4,     0x00,       P_86,        0)
ins (IMUL, imul,                OpCls( R,        NONE,       NONE ), 0,      0,  0,      0xF6,     0x28,       P_86,        0)
insn(IMUL, 2,                   OpCls( M08,      NONE,       NONE ), 0,      0,  0,      0xF6,     0x28,       P_86,        0)
insn(IMUL, 3,                   OpCls( MGT8,     NONE,       NONE ), 0,      0,  0,      0xF7,     0x28,       P_86,        0)
insn(IMUL, 4,                   OpCls( RGT8,     R_MS,       NONE ), F_0F,   1,  no_WDS, 0xAF,     0x00,       P_386,       0)
insn(IMUL, 6,                   OpCls( RGT8,     I8,         NONE ), 0,      1,  no_WDS, 0x6B,     0x00,       P_186,       0)
insn(IMUL, 7,                   OpCls( RGT8,     I,          NONE ), 0,      1,  no_WDS, 0x69,     0x00,       P_186,       0)
insn(IMUL, 8,                   OpCls( RGT8,     R_MS,       I8_U ), 0,      1,  no_WDS, 0x6B,     0x00,       P_186,       0)
insn(IMUL, 9,                   OpCls( RGT8,     R_MS,       I    ), 0,      1,  no_WDS, 0x69,     0x00,       P_186,       0)
ins (IN, in,                    OpCls( A,        DX_ONLY,    NONE ), 0,      0,  no_RM,  0xEC,     0x00,       P_86,        0)
insn(IN, 1,                     OpCls( A,        I8_U,       NONE ), 0,      0,  no_RM,  0xE4,     0x00,       P_86,        0)
ins (INT, int,                  OpCls( I_3,      NONE,       NONE ), 0,      0,  no_RM,  0xCC,     0x00,       P_86,        0)
insn(INT, 1,                    OpCls( I8_U,     NONE,       NONE ), 0,      0,  no_RM,  0xCD,     0x00,       P_86,        0)
ins (INTO, into,                OpCls( NONE,     NONE,       NONE ), 0,      0,  no_RM,  0xCE,     0x00,       P_86,        0)
/* invd and invlpg are privileged, but masm accepts them w/o the cpu 'p' suffix */
ins (INVD, invd,                OpCls( NONE,     NONE,       NONE ), F_0F,   0,  no_RM,  0x08,     0x00,       P_486,       0)
ins (INVLPG, invlpg,            OpCls( M_ANY,    NONE,       NONE ), F_0F,   0,  no_WDS, 0x01,     0x38,       P_486,       0)
ins (IRET, iret,                OpCls( NONE,     NONE,       NONE ), F_16,   0,  no_RM,  0xCF,     0x00,       P_86,        0)
ins (IRETD, iretd,              OpCls( NONE,     NONE,       NONE ), F_32,   0,  no_RM,  0xCF,     0x00,       P_386,       0)
/* the F-suffix variants of IRET/IRETD are just aliases and pretty useless.
 * In Masm v8+, IRETF has disappeared, but IRETDF is still there.
 */
ins (IRETF, iretf,              OpCls( NONE,     NONE,       NONE ), F_16,   0,  no_RM,  0xCF,     0x00,       P_86,        0)
ins (IRETDF, iretdf,            OpCls( NONE,     NONE,       NONE ), F_32,   0,  no_RM,  0xCF,     0x00,       P_386,       0)
ins (LAHF, lahf,                OpCls( NONE,     NONE,       NONE ), 0,      0,  no_RM,  0x9F,     0x00,       P_86,        0)
ins (LAR, lar,                  OpCls( RGT8,     RGT8_MS,    NONE ), F_0F,   1,  no_WDS, 0x02,     0x00,       P_286,       0)
ins (LSL, lsl,                  OpCls( RGT8,     RGT8_MS,    NONE ), F_0F,   1,  no_WDS, 0x03,     0x00,       P_286,       0)
ins (LEA, lea,                  OpCls( RGT8,     MS,         NONE ), 0,      1,  no_WDS, 0x8D,     0x00,       P_86,        0)
ins (LEAVE, leave,              OpCls( NONE,     NONE,       NONE ), 0,      0,  no_RM,  0xC9,     0x00,       P_186,       0)
ins (LFS, lfs,                  OpCls( RGT8,     MFPTR,      NONE ), F_0F,   1,  no_WDS, 0xB4,     0x00,       P_386,       0)
ins (LGS, lgs,                  OpCls( RGT8,     MFPTR,      NONE ), F_0F,   1,  no_WDS, 0xB5,     0x00,       P_386,       0)
ins (LSS, lss,                  OpCls( RGT8,     MFPTR,      NONE ), F_0F,   1,  no_WDS, 0xB2,     0x00,       P_386,       0)
ins (LGDT, lgdt,                OpCls( M48,      NONE,       NONE ), F_0F,   0,  no_WDS, 0x01,     0x10,       P_286p,      0)
ins (LIDT, lidt,                OpCls( M48,      NONE,       NONE ), F_0F,   0,  no_WDS, 0x01,     0x18,       P_286p,      0)
ins (MOVSX, movsx,              OpCls( RGT8,     R_MS,       NONE ), F_0F,   1,  0,      0xBE,     0x00,       P_386,       0)
ins (MOVZX, movzx,              OpCls( RGT8,     R_MS,       NONE ), F_0F,   1,  0,      0xB6,     0x00,       P_386,       0)
ins (NOP, nop,                  OpCls( NONE,     NONE,       NONE ), 0,      0,  no_RM,  0x90,     0x00,       P_86,        0)
ins (OUT, out,                  OpCls( DX_ONLY,  A,          NONE ), 0,      0,  no_RM,  0xEE,     0x00,       P_86,        0)
insn(OUT, 1,                    OpCls( I8_U,     A,          NONE ), 0,      0,  no_RM,  0xE6,     0x00,       P_86,        0)

ins (RDMSR, rdmsr,              OpCls( NONE,     NONE,       NONE ), F_0F,   0,  no_RM,  0x32,     0x00,       P_586,       0)
/* v2.11: RDPMC is accepted with .586 ( was: .686 ) */
ins (RDPMC, rdpmc,              OpCls( NONE,     NONE,       NONE ), F_0F,   0,  no_RM,  0x33,     0x00,       P_586,       0)
ins (RDTSC, rdtsc,              OpCls( NONE,     NONE,       NONE ), F_0F,   0,  no_RM,  0x31,     0x00,       P_586,       0)
ins (RDTSCP, rdtscp,            OpCls( NONE,     NONE,       NONE ), F_0F,   0,  no_WDS, 0x01,     0xF9,       P_686,       0)
ins (RET,  ret,                 OpCls( I16,      NONE,       NONE ), 0,      0,  no_RM,  0xC2,     0x00,       P_86,        0)
insn(RET,  1,                   OpCls( NONE,     NONE,       NONE ), 0,      0,  no_RM,  0xC3,     0x00,       P_86,        0)
ins (RETN, retn,                OpCls( I16,      NONE,       NONE ), 0,      0,  no_RM,  0xC2,     0x00,       P_86,        0)
insn(RETN, 1,                   OpCls( NONE,     NONE,       NONE ), 0,      0,  no_RM,  0xC3,     0x00,       P_86,        0)
ins (RETF, retf,                OpCls( I16,      NONE,       NONE ), 0,      0,  no_RM,  0xCA,     0x00,       P_86,        0)
insn(RETF, 1,                   OpCls( NONE,     NONE,       NONE ), 0,      0,  no_RM,  0xCB,     0x00,       P_86,        0)
ins (RSM, rsm,                  OpCls( NONE,     NONE,       NONE ), F_0F,   0,  no_RM,  0xAA,     0x00,       P_586,       0)
ins (SAHF, sahf,                OpCls( NONE,     NONE,       NONE ), 0,      0,  no_RM,  0x9E,     0x00,       P_86,        0)
ins (SGDT, sgdt,                OpCls( M_ANY,    NONE,       NONE ), F_0F,   0,  no_WDS, 0x01,     0x00,       P_286,       0)
ins (SIDT, sidt,                OpCls( M_ANY,    NONE,       NONE ), F_0F,   0,  no_WDS, 0x01,     0x08,       P_286,       0)
ins (SHLD, shld,                OpCls( RGT8_MGT8,RGT8,       CL   ), F_0F,   0,  no_WDS, 0xA5,     0x00,       P_386,       0)
insn(SHLD, 1,                   OpCls( RGT8_MGT8,RGT8,       I8_U ), F_0F,   0,  no_WDS, 0xA4,     0x00,       P_386,       0)
ins (SHRD, shrd,                OpCls( RGT8_MGT8,RGT8,       CL   ), F_0F,   0,  no_WDS, 0xAD,     0x00,       P_386,       0)
insn(SHRD, 1,                   OpCls( RGT8_MGT8,RGT8,       I8_U ), F_0F,   0,  no_WDS, 0xAC,     0x00,       P_386,       0)
ins (SYSENTER, sysenter,        OpCls( NONE,     NONE,       NONE ), F_0F,   0,  no_RM,  0x34,     0x00,       P_686,       0)
ins (SYSEXIT, sysexit,          OpCls( NONE,     NONE,       NONE ), F_0F,   0,  no_RM,  0x35,     0x00,       P_686p,      0)
ins (TEST, test,                OpCls( A,        I,          NONE ), 0,      0,  no_RM,  0xA8,     0x00,       P_86,        0)
insn(TEST, 1,                   OpCls( R,        R_MS,       NONE ), 0,      1,  0,      0x84,     0x00,       P_86,        0)
insn(TEST, 3,                   OpCls( R_MS,     I,          NONE ), 0,      0,  0,      0xF6,     0x00,       P_86,        0)
insn(TEST, 4,                   OpCls( MS,       R,          NONE ), 0,      0,  0,      0x84,     0x00,       P_86,        0)
ins (UD2, ud2,                  OpCls( NONE,     NONE,       NONE ), F_0F,   0,  no_RM,  0x0B,     0x00,       P_686,       0)
ins (WAIT, wait,                OpCls( NONE,     NONE,       NONE ), 0,      0,  no_RM,  0x9B,     0x00,       P_86,        0)
/* wbinvd & wrmsr are privileged, but masm accepts them w/o the cpu 'p' suffix */
ins (WBINVD, wbinvd,            OpCls( NONE,     NONE,       NONE ), F_0F,   0,  no_RM,  0x09,     0x00,       P_486,       0)
ins (WRMSR, wrmsr,              OpCls( NONE,     NONE,       NONE ), F_0F,   0,  no_RM,  0x30,     0x00,       P_586,       0)
ins (XADD, xadd,                OpCls( R,        R,          NONE ), F_0F,   0,  0,      0xC0,     0x00,       P_486,       0)
insn(XADD, 1,                   OpCls( MS,       R,          NONE ), F_0F,   0,  0,      0xC0,     0x00,       P_486,       AP_LOCK)
ins (XCHG, xchg,                OpCls( A,        RGT8,       NONE ), 0,      0,  R_in_OP,0x90,     0x00,       P_86,        0)
insn(XCHG, 1,                   OpCls( RGT8,     A,          NONE ), 0,      0,  R_in_OP,0x90,     0x00,       P_86,        0)
insn(XCHG, 2,                   OpCls( R,        R,          NONE ), 0,      1,  0,      0x86,     0x00,       P_86,        0)
insn(XCHG, 3,                   OpCls( R,        MS,         NONE ), 0,      1,  0,      0x86,     0x00,       P_86,        AP_LOCK)
insn(XCHG, 4,                   OpCls( MS,       R,          NONE ), 0,      0,  0,      0x86,     0x00,       P_86,        AP_LOCK)
ins (XLAT, xlat,                OpCls( NONE,     NONE,       NONE ), 0,      0,  no_RM,  0xD7,     0x00,       P_86,        0)
insn(XLAT, 1,                   OpCls( M08,      NONE,       NONE ), 0,      0,  no_RM,  0xD7,     0x00,       P_86,        0)
ins (XLATB, xlatb,              OpCls( NONE,     NONE,       NONE ), 0,      0,  no_RM,  0xD7,     0x00,       P_86,        0)
insn(XLATB, 1,                  OpCls( M08,      NONE,       NONE ), 0,      0,  no_RM,  0xD7,     0x00,       P_86,        0)

ins (SETA,  seta,               OpCls( R8_M08,   NONE,       NONE ), F_0F,   0,  no_WDS, 0x97,     0x00,       P_386,       0)
ins (SETAE, setae,              OpCls( R8_M08,   NONE,       NONE ), F_0F,   0,  no_WDS, 0x93,     0x00,       P_386,       0)
ins (SETB,  setb,               OpCls( R8_M08,   NONE,       NONE ), F_0F,   0,  no_WDS, 0x92,     0x00,       P_386,       0)
ins (SETBE, setbe,              OpCls( R8_M08,   NONE,       NONE ), F_0F,   0,  no_WDS, 0x96,     0x00,       P_386,       0)
ins (SETC,  setc,               OpCls( R8_M08,   NONE,       NONE ), F_0F,   0,  no_WDS, 0x92,     0x00,       P_386,       0)
ins (SETE,  sete,               OpCls( R8_M08,   NONE,       NONE ), F_0F,   0,  no_WDS, 0x94,     0x00,       P_386,       0)
ins (SETG,  setg,               OpCls( R8_M08,   NONE,       NONE ), F_0F,   0,  no_WDS, 0x9F,     0x00,       P_386,       0)
ins (SETGE, setge,              OpCls( R8_M08,   NONE,       NONE ), F_0F,   0,  no_WDS, 0x9D,     0x00,       P_386,       0)
ins (SETL,  setl,               OpCls( R8_M08,   NONE,       NONE ), F_0F,   0,  no_WDS, 0x9C,     0x00,       P_386,       0)
ins (SETLE, setle,              OpCls( R8_M08,   NONE,       NONE ), F_0F,   0,  no_WDS, 0x9E,     0x00,       P_386,       0)
ins (SETNA, setna,              OpCls( R8_M08,   NONE,       NONE ), F_0F,   0,  no_WDS, 0x96,     0x00,       P_386,       0)
ins (SETNAE,setnae,             OpCls( R8_M08,   NONE,       NONE ), F_0F,   0,  no_WDS, 0x92,     0x00,       P_386,       0)
ins (SETNB, setnb,              OpCls( R8_M08,   NONE,       NONE ), F_0F,   0,  no_WDS, 0x93,     0x00,       P_386,       0)
ins (SETNBE,setnbe,             OpCls( R8_M08,   NONE,       NONE ), F_0F,   0,  no_WDS, 0x97,     0x00,       P_386,       0)
ins (SETNC, setnc,              OpCls( R8_M08,   NONE,       NONE ), F_0F,   0,  no_WDS, 0x93,     0x00,       P_386,       0)
ins (SETNE, setne,              OpCls( R8_M08,   NONE,       NONE ), F_0F,   0,  no_WDS, 0x95,     0x00,       P_386,       0)
ins (SETNG, setng,              OpCls( R8_M08,   NONE,       NONE ), F_0F,   0,  no_WDS, 0x9E,     0x00,       P_386,       0)
ins (SETNGE,setnge,             OpCls( R8_M08,   NONE,       NONE ), F_0F,   0,  no_WDS, 0x9C,     0x00,       P_386,       0)
ins (SETNL, setnl,              OpCls( R8_M08,   NONE,       NONE ), F_0F,   0,  no_WDS, 0x9D,     0x00,       P_386,       0)
ins (SETNLE,setnle,             OpCls( R8_M08,   NONE,       NONE ), F_0F,   0,  no_WDS, 0x9F,     0x00,       P_386,       0)
ins (SETNO, setno,              OpCls( R8_M08,   NONE,       NONE ), F_0F,   0,  no_WDS, 0x91,     0x00,       P_386,       0)
ins (SETNP, setnp,              OpCls( R8_M08,   NONE,       NONE ), F_0F,   0,  no_WDS, 0x9B,     0x00,       P_386,       0)
ins (SETNS, setns,              OpCls( R8_M08,   NONE,       NONE ), F_0F,   0,  no_WDS, 0x99,     0x00,       P_386,       0)
ins (SETNZ, setnz,              OpCls( R8_M08,   NONE,       NONE ), F_0F,   0,  no_WDS, 0x95,     0x00,       P_386,       0)
ins (SETO,  seto,               OpCls( R8_M08,   NONE,       NONE ), F_0F,   0,  no_WDS, 0x90,     0x00,       P_386,       0)
ins (SETP,  setp,               OpCls( R8_M08,   NONE,       NONE ), F_0F,   0,  no_WDS, 0x9A,     0x00,       P_386,       0)
ins (SETPE, setpe,              OpCls( R8_M08,   NONE,       NONE ), F_0F,   0,  no_WDS, 0x9A,     0x00,       P_386,       0)
ins (SETPO, setpo,              OpCls( R8_M08,   NONE,       NONE ), F_0F,   0,  no_WDS, 0x9B,     0x00,       P_386,       0)
ins (SETS,  sets,               OpCls( R8_M08,   NONE,       NONE ), F_0F,   0,  no_WDS, 0x98,     0x00,       P_386,       0)
ins (SETZ,  setz,               OpCls( R8_M08,   NONE,       NONE ), F_0F,   0,  no_WDS, 0x94,     0x00,       P_386,       0)

#define cmov( cond, code, condlc )      \
ins (CMOV##cond, cmov##condlc,           OpCls( RGT8,     R_MS,    NONE ), F_0F,   1,  no_WDS, 0x40+code,0x00,   P_686,   0)

cmov( A,   0x7,   a )
cmov( AE,  0x3,  ae )
cmov( B,   0x2,   b )
cmov( BE,  0x6,  be )
cmov( C,   0x2,   c )
cmov( E,   0x4,   e )
cmov( G,   0xf,   g )
cmov( GE,  0xd,  ge )
cmov( L,   0xc,   l )
cmov( LE,  0xe,  le )
cmov( NA,  0x6,  na )
cmov( NAE, 0x2, nae )
cmov( NB,  0x3,  nb )
cmov( NBE, 0x7, nbe )
cmov( NC,  0x3,  nc )
cmov( NE,  0x5,  ne )
cmov( NG,  0xe,  ng )
cmov( NGE, 0xc, nge )
cmov( NL,  0xd,  nl )
cmov( NLE, 0xf, nle )
cmov( NO,  0x1,  no )
cmov( NP,  0xb,  np )
cmov( NS,  0x9,  ns )
cmov( NZ,  0x5,  nz )
cmov( O,   0x0,   o )
cmov( P,   0xa,   p )
cmov( PE,  0xa,  pe )
cmov( PO,  0xb,  po )
cmov( S,   0x8,   s )
cmov( Z,   0x4,   z )

#undef cmov

/* FPU opcodes */

ins (FCMOVB, fcmovb,            OpCls( ST,       STI,        NONE ), 0,      0,  0,      0xDA,     0xC0,       P_686,       0)
ins (FCMOVBE, fcmovbe,          OpCls( ST,       STI,        NONE ), 0,      0,  0,      0xDA,     0xD0,       P_686,       0)
ins (FCMOVE, fcmove,            OpCls( ST,       STI,        NONE ), 0,      0,  0,      0xDA,     0xC8,       P_686,       0)
ins (FCMOVNB, fcmovnb,          OpCls( ST,       STI,        NONE ), 0,      0,  0,      0xDB,     0xC0,       P_686,       0)
ins (FCMOVNBE, fcmovnbe,        OpCls( ST,       STI,        NONE ), 0,      0,  0,      0xDB,     0xD0,       P_686,       0)
ins (FCMOVNE, fcmovne,          OpCls( ST,       STI,        NONE ), 0,      0,  0,      0xDB,     0xC8,       P_686,       0)
ins (FCMOVNU, fcmovnu,          OpCls( ST,       STI,        NONE ), 0,      0,  0,      0xDB,     0xD8,       P_686,       0)
ins (FCMOVU, fcmovu,            OpCls( ST,       STI,        NONE ), 0,      0,  0,      0xDA,     0xD8,       P_686,       0)

ins (FCOM, fcom,                OpCls( STI,      NONE,       NONE ), 0,      0,  0,      0xD8,     0xD0,       P_87,        0)
insn(FCOM, 1,                   OpCls( M32,      NONE,       NONE ), 0,      0,  0,      0xD8,     0x10,       P_87,        0)
insn(FCOM, 2,                   OpCls( M64,      NONE,       NONE ), 0,      0,  0,      0xDC,     0x10,       P_87,        0)
insn(FCOM, 3,                   OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xD8,     0xD1,       P_87,        0)
ins (FCOMP, fcomp,              OpCls( STI,      NONE,       NONE ), 0,      0,  0,      0xD8,     0xD8,       P_87,        0)
insn(FCOMP, 1,                  OpCls( M32,      NONE,       NONE ), 0,      0,  0,      0xD8,     0x18,       P_87,        0)
insn(FCOMP, 2,                  OpCls( M64,      NONE,       NONE ), 0,      0,  0,      0xDC,     0x18,       P_87,        0)
insn(FCOMP, 3,                  OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xD8,     0xD9,       P_87,        0)
ins (FCOMPP, fcompp,            OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xDE,     0xD9,       P_87,        0)

ins (FUCOM, fucom,              OpCls( STI,      NONE,       NONE ), 0,      0,  0,      0xDD,     0xE0,       P_387,       0)
insn(FUCOM, 1,                  OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xDD,     0xE1,       P_387,       0)
ins (FUCOMP, fucomp,            OpCls( STI,      NONE,       NONE ), 0,      0,  0,      0xDD,     0xE8,       P_387,       0)
insn(FUCOMP, 1,                 OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xDD,     0xE9,       P_387,       0)
ins (FUCOMPP, fucompp,          OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xDA,     0xE9,       P_387,       0)
ins (FCOMI, fcomi,              OpCls( ST,       STI,        NONE ), 0,      0,  0,      0xDB,     0xF0,       P_686,       0)
ins (FCOMIP, fcomip,            OpCls( ST,       STI,        NONE ), 0,      0,  0,      0xDF,     0xF0,       P_686,       0)
ins (FUCOMI, fucomi,            OpCls( ST,       STI,        NONE ), 0,      0,  0,      0xDB,     0xE8,       P_686,       0)
ins (FUCOMIP, fucomip,          OpCls( ST,       STI,        NONE ), 0,      0,  0,      0xDF,     0xE8,       P_686,       0)

/* v2.11: first 2 variants of FADD, FMUL, FDIV, FDIVP, FSUP and FSUBR exchanged */
ins (FADD, fadd,                OpCls( ST,       STI,        NONE ), 0,      0,  0,      0xD8,     0xC0,       P_87,        0)
insn(FADD, 1,                   OpCls( STI,      ST,         NONE ), 0,      0,  0,      0xDC,     0xC0,       P_87,        0)
insn(FADD, 2,                   OpCls( M32,      NONE,       NONE ), 0,      0,  0,      0xD8,     0x00,       P_87,        0)
insn(FADD, 3,                   OpCls( M64,      NONE,       NONE ), 0,      0,  0,      0xDC,     0x00,       P_87,        0)
insn(FADD, 4,                   OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xDE,     0xC1,       P_87,        0)
ins (FADDP, faddp,              OpCls( STI,      ST,         NONE ), 0,      0,  0,      0xDE,     0xC0,       P_87,        0)
insn(FADDP, 1,                  OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xDE,     0xC1,       P_87,        0)
ins (FMUL, fmul,                OpCls( ST,       STI,        NONE ), 0,      0,  0,      0xD8,     0xC8,       P_87,        0)
insn(FMUL, 1,                   OpCls( STI,      ST,         NONE ), 0,      0,  0,      0xDC,     0xC8,       P_87,        0)
insn(FMUL, 2,                   OpCls( M32,      NONE,       NONE ), 0,      0,  0,      0xD8,     0x08,       P_87,        0)
insn(FMUL, 3,                   OpCls( M64,      NONE,       NONE ), 0,      0,  0,      0xDC,     0x08,       P_87,        0)
insn(FMUL, 4,                   OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xDE,     0xC9,       P_87,        0)
ins (FMULP, fmulp,              OpCls( STI,      ST,         NONE ), 0,      0,  0,      0xDE,     0xC8,       P_87,        0)
insn(FMULP, 1,                  OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xDE,     0xC9,       P_87,        0)

ins (FDIV, fdiv,                OpCls( ST,       STI,        NONE ), 0,      0,  0,      0xD8,     0xF0,       P_87,        0)
insn(FDIV, 1,                   OpCls( STI,      ST,         NONE ), 0,      0,  0,      0xDC,     0xF8,       P_87,        0)
insn(FDIV, 2,                   OpCls( M32,      NONE,       NONE ), 0,      0,  0,      0xD8,     0x30,       P_87,        0)
insn(FDIV, 3,                   OpCls( M64,      NONE,       NONE ), 0,      0,  0,      0xDC,     0x30,       P_87,        0)
insn(FDIV, 4,                   OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xDE,     0xF9,       P_87,        0)
ins (FDIVP, fdivp,              OpCls( STI,      ST,         NONE ), 0,      0,  0,      0xDE,     0xF8,       P_87,        0)
insn(FDIVP, 1,                  OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xDE,     0xF9,       P_87,        0)
ins (FDIVR, fdivr,              OpCls( ST,       STI,        NONE ), 0,      0,  0,      0xD8,     0xF8,       P_87,        0)
insn(FDIVR, 1,                  OpCls( STI,      ST,         NONE ), 0,      0,  0,      0xDC,     0xF0,       P_87,        0)
insn(FDIVR, 2,                  OpCls( M32,      NONE,       NONE ), 0,      0,  0,      0xD8,     0x38,       P_87,        0)
insn(FDIVR, 3,                  OpCls( M64,      NONE,       NONE ), 0,      0,  0,      0xDC,     0x38,       P_87,        0)
insn(FDIVR, 4,                  OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xDE,     0xF1,       P_87,        0)
ins (FDIVRP, fdivrp,            OpCls( STI,      ST,         NONE ), 0,      0,  0,      0xDE,     0xF0,       P_87,        0)
insn(FDIVRP, 1,                 OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xDE,     0xF1,       P_87,        0)
ins (FSUB, fsub,                OpCls( ST,       STI,        NONE ), 0,      0,  0,      0xD8,     0xE0,       P_87,        0)
insn(FSUB, 1,                   OpCls( STI,      ST,         NONE ), 0,      0,  0,      0xDC,     0xE8,       P_87,        0)
insn(FSUB, 2,                   OpCls( M32,      NONE,       NONE ), 0,      0,  0,      0xD8,     0x20,       P_87,        0)
insn(FSUB, 3,                   OpCls( M64,      NONE,       NONE ), 0,      0,  0,      0xDC,     0x20,       P_87,        0)
insn(FSUB, 4,                   OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xDE,     0xE9,       P_87,        0)
ins (FSUBP, fsubp,              OpCls( STI,      ST,         NONE ), 0,      0,  0,      0xDE,     0xE8,       P_87,        0)
insn(FSUBP, 1,                  OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xDE,     0xE9,       P_87,        0)
ins (FSUBR, fsubr,              OpCls( ST,       STI,        NONE ), 0,      0,  0,      0xD8,     0xE8,       P_87,        0)
insn(FSUBR, 1,                  OpCls( STI,      ST,         NONE ), 0,      0,  0,      0xDC,     0xE0,       P_87,        0)
insn(FSUBR, 2,                  OpCls( M32,      NONE,       NONE ), 0,      0,  0,      0xD8,     0x28,       P_87,        0)
insn(FSUBR, 3,                  OpCls( M64,      NONE,       NONE ), 0,      0,  0,      0xDC,     0x28,       P_87,        0)
insn(FSUBR, 4,                  OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xDE,     0xE1,       P_87,        0)
ins (FSUBRP, fsubrp,            OpCls( STI,      ST,         NONE ), 0,      0,  0,      0xDE,     0xE0,       P_87,        0)
insn(FSUBRP, 1,                 OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xDE,     0xE1,       P_87,        0)

ins (FIADD, fiadd,              OpCls( M32,      NONE,       NONE ), 0,      0,  0,      0xDA,     0x00,       P_87,        0)
insn(FIADD, 1,                  OpCls( M16,      NONE,       NONE ), 0,      0,  0,      0xDE,     0x00,       P_87,        0)
ins (FICOM, ficom,              OpCls( M32,      NONE,       NONE ), 0,      0,  0,      0xDA,     0x10,       P_87,        0)
insn(FICOM, 1,                  OpCls( M16,      NONE,       NONE ), 0,      0,  0,      0xDE,     0x10,       P_87,        0)
ins (FICOMP, ficomp,            OpCls( M32,      NONE,       NONE ), 0,      0,  0,      0xDA,     0x18,       P_87,        0)
insn(FICOMP, 1,                 OpCls( M16,      NONE,       NONE ), 0,      0,  0,      0xDE,     0x18,       P_87,        0)
ins (FIDIV, fidiv,              OpCls( M32,      NONE,       NONE ), 0,      0,  0,      0xDA,     0x30,       P_87,        0)
insn(FIDIV, 1,                  OpCls( M16,      NONE,       NONE ), 0,      0,  0,      0xDE,     0x30,       P_87,        0)
ins (FIDIVR, fidivr,            OpCls( M32,      NONE,       NONE ), 0,      0,  0,      0xDA,     0x38,       P_87,        0)
insn(FIDIVR, 1,                 OpCls( M16,      NONE,       NONE ), 0,      0,  0,      0xDE,     0x38,       P_87,        0)
ins (FIMUL, fimul,              OpCls( M32,      NONE,       NONE ), 0,      0,  0,      0xDA,     0x08,       P_87,        0)
insn(FIMUL, 1,                  OpCls( M16,      NONE,       NONE ), 0,      0,  0,      0xDE,     0x08,       P_87,        0)
ins (FISUB, fisub,              OpCls( M32,      NONE,       NONE ), 0,      0,  0,      0xDA,     0x20,       P_87,        0)
insn(FISUB, 1,                  OpCls( M16,      NONE,       NONE ), 0,      0,  0,      0xDE,     0x20,       P_87,        0)
ins (FISUBR, fisubr,            OpCls( M32,      NONE,       NONE ), 0,      0,  0,      0xDA,     0x28,       P_87,        0)
insn(FISUBR, 1,                 OpCls( M16,      NONE,       NONE ), 0,      0,  0,      0xDE,     0x28,       P_87,        0)

ins (FILD, fild,                OpCls( M32,      NONE,       NONE ), 0,      0,  0,      0xDB,     0x00,       P_87,        0)
insn(FILD, 1,                   OpCls( M64,      NONE,       NONE ), 0,      0,  0,      0xDF,     0x28,       P_87,        0)
insn(FILD, 2,                   OpCls( M16,      NONE,       NONE ), 0,      0,  0,      0xDF,     0x00,       P_87,        0)
ins (FISTP, fistp,              OpCls( M32,      NONE,       NONE ), 0,      0,  0,      0xDB,     0x18,       P_87,        0)
insn(FISTP, 1,                  OpCls( M64,      NONE,       NONE ), 0,      0,  0,      0xDF,     0x38,       P_87,        0)
insn(FISTP, 2,                  OpCls( M16,      NONE,       NONE ), 0,      0,  0,      0xDF,     0x18,       P_87,        0)
ins (FIST, fist,                OpCls( M32,      NONE,       NONE ), 0,      0,  0,      0xDB,     0x10,       P_87,        0)
insn(FIST, 1,                   OpCls( M16,      NONE,       NONE ), 0,      0,  0,      0xDF,     0x10,       P_87,        0)

ins (FLD, fld,                  OpCls( STI,      NONE,       NONE ), 0,      0,  0,      0xD9,     0xC0,       P_87,        0)
insn(FLD, 1,                    OpCls( M32,      NONE,       NONE ), 0,      0,  0,      0xD9,     0x00,       P_87,        0)
insn(FLD, 2,                    OpCls( M64,      NONE,       NONE ), 0,      0,  0,      0xDD,     0x00,       P_87,        0)
insn(FLD, 3,                    OpCls( M80,      NONE,       NONE ), 0,      0,  0,      0xDB,     0x28,       P_87,        0)
ins (FSTP, fstp,                OpCls( STI,      NONE,       NONE ), 0,      0,  0,      0xDD,     0xD8,       P_87,        0)
insn(FSTP, 1,                   OpCls( M32,      NONE,       NONE ), 0,      0,  0,      0xD9,     0x18,       P_87,        0)
insn(FSTP, 2,                   OpCls( M64,      NONE,       NONE ), 0,      0,  0,      0xDD,     0x18,       P_87,        0)
insn(FSTP, 3,                   OpCls( M80,      NONE,       NONE ), 0,      0,  0,      0xDB,     0x38,       P_87,        0)
ins (FST, fst,                  OpCls( STI,      NONE,       NONE ), 0,      0,  0,      0xDD,     0xD0,       P_87,        0)
insn(FST, 1,                    OpCls( M32,      NONE,       NONE ), 0,      0,  0,      0xD9,     0x10,       P_87,        0)
insn(FST, 2,                    OpCls( M64,      NONE,       NONE ), 0,      0,  0,      0xDD,     0x10,       P_87,        0)

ins (FLDENV, fldenv,            OpCls( M_ANY,    NONE,       NONE ), 0,      0,  0,      0xD9,     0x20,       P_87,        0)
ins (FLDENVD, fldenvd,          OpCls( M_ANY,    NONE,       NONE ), F_32,   0,  0,      0xD9,     0x20,       P_387,       0)
ins (FLDENVW, fldenvw,          OpCls( M_ANY,    NONE,       NONE ), F_16,   0,  0,      0xD9,     0x20,       P_87,        0)
ins (FNSAVE, fnsave,            OpCls( M_ANY,    NONE,       NONE ), 0,      0,  0,      0xDD,     0x30,       P_87,        AP_NO_FWAIT)
ins (FNSAVED, fnsaved,          OpCls( M_ANY,    NONE,       NONE ), F_32,   0,  0,      0xDD,     0x30,       P_387,       AP_NO_FWAIT)
ins (FNSAVEW, fnsavew,          OpCls( M_ANY,    NONE,       NONE ), F_16,   0,  0,      0xDD,     0x30,       P_87,        AP_NO_FWAIT)
ins (FNSTENV, fnstenv,          OpCls( M_ANY,    NONE,       NONE ), 0,      0,  0,      0xD9,     0x30,       P_87,        AP_NO_FWAIT)
ins (FNSTENVD, fnstenvd,        OpCls( M_ANY,    NONE,       NONE ), F_32,   0,  0,      0xD9,     0x30,       P_387,       AP_NO_FWAIT)
ins (FNSTENVW, fnstenvw,        OpCls( M_ANY,    NONE,       NONE ), F_16,   0,  0,      0xD9,     0x30,       P_87,        AP_NO_FWAIT)
ins (FRSTOR, frstor,            OpCls( M_ANY,    NONE,       NONE ), 0,      0,  0,      0xDD,     0x20,       P_87,        0)
ins (FRSTORD, frstord,          OpCls( M_ANY,    NONE,       NONE ), F_32,   0,  0,      0xDD,     0x20,       P_387,       0)
ins (FRSTORW, frstorw,          OpCls( M_ANY,    NONE,       NONE ), F_16,   0,  0,      0xDD,     0x20,       P_87,        0)
ins (FSAVE, fsave,              OpCls( M_ANY,    NONE,       NONE ), 0,      0,  0,      0xDD,     0x30,       P_87,        AP_FWAIT)
ins (FSAVED, fsaved,            OpCls( M_ANY,    NONE,       NONE ), F_32,   0,  0,      0xDD,     0x30,       P_387,       AP_FWAIT)
ins (FSAVEW, fsavew,            OpCls( M_ANY,    NONE,       NONE ), F_16,   0,  0,      0xDD,     0x30,       P_87,        AP_FWAIT)
ins (FSTENV, fstenv,            OpCls( M_ANY,    NONE,       NONE ), 0,      0,  0,      0xD9,     0x30,       P_87,        AP_FWAIT)
ins (FSTENVD, fstenvd,          OpCls( M_ANY,    NONE,       NONE ), F_32,   0,  0,      0xD9,     0x30,       P_387,       AP_FWAIT)
ins (FSTENVW, fstenvw,          OpCls( M_ANY,    NONE,       NONE ), F_16,   0,  0,      0xD9,     0x30,       P_87,        AP_FWAIT)

ins (FLDCW, fldcw,              OpCls( M16,      NONE,       NONE ), 0,      0,  0,      0xD9,     0x28,       P_87,        0)
ins (FNSTCW, fnstcw,            OpCls( M16,      NONE,       NONE ), 0,      0,  0,      0xD9,     0x38,       P_87,        AP_NO_FWAIT)
ins (FNSTSW, fnstsw,            OpCls( AX,       NONE,       NONE ), 0,      0,  no_WDS, 0xDF,     0xE0,       P_287,       AP_NO_FWAIT)
insn(FNSTSW, 1,                 OpCls( M16,      NONE,       NONE ), 0,      0,  0,      0xDD,     0x38,       P_87,        AP_NO_FWAIT)
ins (FSTCW, fstcw,              OpCls( M16,      NONE,       NONE ), 0,      0,  0,      0xD9,     0x38,       P_87,        AP_FWAIT)
ins (FSTSW, fstsw,              OpCls( AX,       NONE,       NONE ), 0,      0,  no_WDS, 0xDF,     0xE0,       P_287,       AP_FWAIT)
insn(FSTSW, 1,                  OpCls( M16,      NONE,       NONE ), 0,      0,  0,      0xDD,     0x38,       P_87,        AP_FWAIT)

ins (FCOS, fcos,                OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xD9,     0xFF,       P_387,       0)
ins (FPATAN, fpatan,            OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xD9,     0xF3,       P_87,        0)
ins (FPTAN, fptan,              OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xD9,     0xF2,       P_87,        0)
ins (FSIN, fsin,                OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xD9,     0xFE,       P_387,       0)
ins (FSINCOS, fsincos,          OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xD9,     0xFB,       P_387,       0)

ins (FINIT, finit,              OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xDB,     0xE3,       P_87,        AP_FWAIT)
ins (FNINIT, fninit,            OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xDB,     0xE3,       P_87,        AP_NO_FWAIT)
ins (FDISI, fdisi,              OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xDB,     0xE1,       P_87,        AP_FWAIT)
ins (FNDISI, fndisi,            OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xDB,     0xE1,       P_87,        AP_NO_FWAIT)
ins (FENI, feni,                OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xDB,     0xE0,       P_87,        AP_FWAIT)
ins (FNENI, fneni,              OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xDB,     0xE0,       P_87,        AP_NO_FWAIT)
ins (FCLEX, fclex,              OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xDB,     0xE2,       P_87,        AP_FWAIT)
ins (FNCLEX, fnclex,            OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xDB,     0xE2,       P_87,        AP_NO_FWAIT)

ins (F2XM1, f2xm1,              OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xD9,     0xF0,       P_87,        0)
ins (FABS, fabs,                OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xD9,     0xE1,       P_87,        0)
ins (FBLD, fbld,                OpCls( M80,      NONE,       NONE ), 0,      0,  0,      0xDF,     0x20,       P_87,        0)
ins (FBSTP, fbstp,              OpCls( M80,      NONE,       NONE ), 0,      0,  0,      0xDF,     0x30,       P_87,        0)
ins (FCHS, fchs,                OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xD9,     0xE0,       P_87,        0)
ins (FLD1, fld1,                OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xD9,     0xE8,       P_87,        0)
ins (FLDL2E, fldl2e,            OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xD9,     0xEA,       P_87,        0)
ins (FLDL2T, fldl2t,            OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xD9,     0xE9,       P_87,        0)
ins (FLDLG2, fldlg2,            OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xD9,     0xEC,       P_87,        0)
ins (FLDLN2, fldln2,            OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xD9,     0xED,       P_87,        0)
ins (FLDPI, fldpi,              OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xD9,     0xEB,       P_87,        0)
ins (FLDZ, fldz,                OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xD9,     0xEE,       P_87,        0)
ins (FDECSTP, fdecstp,          OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xD9,     0xF6,       P_87,        0)
ins (FINCSTP, fincstp,          OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xD9,     0xF7,       P_87,        0)
ins (FFREE, ffree,              OpCls( STI,      NONE,       NONE ), 0,      0,  0,      0xDD,     0xC0,       P_87,        0)
/* FFREEP is undocumented (same as FFREE + POP) */
ins (FFREEP, ffreep,            OpCls( STI,      NONE,       NONE ), 0,      0,  0,      0xDF,     0xC0,       P_87,        0)
ins (FNOP, fnop,                OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xD9,     0xD0,       P_87,        0)
ins (FPREM, fprem,              OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xD9,     0xF8,       P_87,        0)
ins (FPREM1, fprem1,            OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xD9,     0xF5,       P_387,       0)
ins (FRNDINT, frndint,          OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xD9,     0xFC,       P_87,        0)
ins (FSCALE, fscale,            OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xD9,     0xFD,       P_87,        0)
ins (FSETPM, fsetpm,            OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xDB,     0xE4,       P_287,       0)
ins (FSQRT, fsqrt,              OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xD9,     0xFA,       P_87,        0)
ins (FTST, ftst,                OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xD9,     0xE4,       P_87,        0)
ins (FWAIT, fwait,              OpCls( NONE,     NONE,       NONE ), 0,      0,  no_RM,  0x9B,     0x00,       P_87,        0)
ins (FXAM, fxam,                OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xD9,     0xE5,       P_87,        0)
ins (FXCH, fxch,                OpCls( STI,      NONE,       NONE ), 0,      0,  0,      0xD9,     0xC8,       P_87,        0)
insn(FXCH, 1,                   OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xD9,     0xC9,       P_87,        0)
ins (FXRSTOR, fxrstor,          OpCls( M_ANY,    NONE,       NONE ), F_0F,   0,  no_WDS, 0xAE,     0x08,       P_686|P_SSE1,0)
ins (FXSAVE, fxsave,            OpCls( M_ANY,    NONE,       NONE ), F_0F,   0,  no_WDS, 0xAE,     0x00,       P_686|P_SSE1,0)
ins (FXTRACT, fxtract,          OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xD9,     0xF4,       P_87,        0)
ins (FYL2X, fyl2x,              OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xD9,     0xF1,       P_87,        0)
ins (FYL2XP1, fyl2xp1,          OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xD9,     0xF9,       P_87,        0)

/* MMX/SSE related opcodes (except SSE instructions CMPSD and MOVSD) */

ins (EMMS, emms,                OpCls( NONE,     NONE,       NONE ), F_0F,   0,  no_RM,  0x77,     0x00,       P_586|P_MMX, 0)
ins (CLFLUSH, clflush,          OpCls( M_ANY,    NONE,       NONE ), F_0F,   0,  no_WDS, 0xAE,     0x38,       P_686|P_SSE2,0)
ins (LDMXCSR, ldmxcsr,          OpCls( M32,      NONE,       NONE ), F_0F,   0,  no_WDS, 0xAE,     0x10,       P_686|P_SSE1,0)
ins (STMXCSR, stmxcsr,          OpCls( M32,      NONE,       NONE ), F_0F,   0,  no_WDS, 0xAE,     0x18,       P_686|P_SSE1,0)
ins (LFENCE, lfence,            OpCls( NONE,     NONE,       NONE ), F_0F,   0,  no_WDS, 0xAE,     0xE8,       P_686|P_SSE2,0)
ins (MFENCE, mfence,            OpCls( NONE,     NONE,       NONE ), F_0F,   0,  no_WDS, 0xAE,     0xF0,       P_686|P_SSE2,0)
ins (SFENCE, sfence,            OpCls( NONE,     NONE,       NONE ), F_0F,   0,  no_WDS, 0xAE,     0xF8,       P_686|P_SSE1,0)
ins (PREFETCHNTA,prefetchnta,   OpCls( M_ANY,    NONE,       NONE ), F_0F,   0,  no_WDS, 0x18,     0x00,       P_686|P_SSE1,0)
ins (PREFETCHT0, prefetcht0,    OpCls( M_ANY,    NONE,       NONE ), F_0F,   0,  no_WDS, 0x18,     0x08,       P_686|P_SSE1,0)
ins (PREFETCHT1, prefetcht1,    OpCls( M_ANY,    NONE,       NONE ), F_0F,   0,  no_WDS, 0x18,     0x10,       P_686|P_SSE1,0)
ins (PREFETCHT2, prefetcht2,    OpCls( M_ANY,    NONE,       NONE ), F_0F,   0,  no_WDS, 0x18,     0x18,       P_686|P_SSE1,0)
ins (PAUSE, pause,              OpCls( NONE,     NONE,       NONE ), F_F3,   0,  no_RM,  0x90,     0x00,       P_686|P_SSE2,0)

/* define ADDPD, ADDPS, ADDSD, ADDSS, DIVPD, DIVPS, DIVSD, DIVSS, ... */
#define arfl( prefix, prefixlc, opc )      \
ins (prefix ## PD, prefixlc ## pd,       OpCls( XMM,  XMM_M128,NONE ), F_660F, 1,  no_WDS, opc,   0x00,   P_686|P_SSE2,0) \
ins (prefix ## PS, prefixlc ## ps,       OpCls( XMM,  XMM_M128,NONE ), F_0F,   1,  no_WDS, opc,   0x00,   P_686|P_SSE1,0) \
ins (prefix ## SD, prefixlc ## sd,       OpCls( XMM,  XMM_M64, NONE ), F_F20F, 1,  no_WDS, opc,   0x00,   P_686|P_SSE2,0) \
ins (prefix ## SS, prefixlc ## ss,       OpCls( XMM,  XMM_M32, NONE ), F_F30F, 1,  no_WDS, opc,   0x00,   P_686|P_SSE1,0)

arfl( ADD,  add,  0x58 )
arfl( DIV,  div,  0x5E )
arfl( MAX,  max,  0x5F )
arfl( MIN,  min,  0x5D )
arfl( MUL,  mul,  0x59 )
arfl( SQRT, sqrt, 0x51 )
arfl( SUB,  sub,  0x5C )

/* CMP can't be added because CMPSD is special */
ins (CMPPD, cmppd,              OpCls( XMM,      XMM_M128, I8_U ), F_660F, 1,  no_WDS, 0xC2,     0x00,       P_686|P_SSE2,0)
ins (CMPPS, cmpps,              OpCls( XMM,      XMM_M128, I8_U ), F_0F,   1,  no_WDS, 0xC2,     0x00,       P_686|P_SSE1,0)
//ins (CMPSD, cmpsd,              OpCls( XMM,      XMM_M64, I8_U ), F_F20F, 1,  no_WDS, 0xC2,     0x00,       P_686|P_SSE2,0)
ins (CMPSS, cmpss,              OpCls( XMM,      XMM_M32,  I8_U ), F_F30F, 1,  no_WDS, 0xC2,     0x00,       P_686|P_SSE1,0)

#undef arfl

#define cmpxx( suffix, suffixlc, byte1, memop, ssever )      \
ins (CMP ## EQ    ## suffix, cmp ## eq    ## suffixlc,    OpCls( XMM, XMM_ ## memop, HID ),byte1, 1, no_WDS, 0xC2, 0x00, P_686|ssever, 0 ) \
ins (CMP ## LT    ## suffix, cmp ## lt    ## suffixlc,    OpCls( XMM, XMM_ ## memop, HID ),byte1, 1, no_WDS, 0xC2, 0x00, P_686|ssever, 0 ) \
ins (CMP ## LE    ## suffix, cmp ## le    ## suffixlc,    OpCls( XMM, XMM_ ## memop, HID ),byte1, 1, no_WDS, 0xC2, 0x00, P_686|ssever, 0 ) \
ins (CMP ## UNORD ## suffix, cmp ## unord ## suffixlc,    OpCls( XMM, XMM_ ## memop, HID ),byte1, 1, no_WDS, 0xC2, 0x00, P_686|ssever, 0 ) \
ins (CMP ## NEQ   ## suffix, cmp ## neq   ## suffixlc,    OpCls( XMM, XMM_ ## memop, HID ),byte1, 1, no_WDS, 0xC2, 0x00, P_686|ssever, 0 ) \
ins (CMP ## NLT   ## suffix, cmp ## nlt   ## suffixlc,    OpCls( XMM, XMM_ ## memop, HID ),byte1, 1, no_WDS, 0xC2, 0x00, P_686|ssever, 0 ) \
ins (CMP ## NLE   ## suffix, cmp ## nle   ## suffixlc,    OpCls( XMM, XMM_ ## memop, HID ),byte1, 1, no_WDS, 0xC2, 0x00, P_686|ssever, 0 ) \
ins (CMP ## ORD   ## suffix, cmp ## ord   ## suffixlc,    OpCls( XMM, XMM_ ## memop, HID ),byte1, 1, no_WDS, 0xC2, 0x00, P_686|ssever, 0 )

cmpxx( PD, pd, F_660F, M128, P_SSE2 )
cmpxx( PS, ps, F_0F,   M128, P_SSE1 )
cmpxx( SD, sd, F_F20F, M64,  P_SSE2 )
cmpxx( SS, ss, F_F30F, M32,  P_SSE1 )

#undef cmpxx

ins (ANDNPD, andnpd,            OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0x55,     0x00,       P_686|P_SSE2,0)
ins (ANDNPS, andnps,            OpCls( XMM,      XMM_M128, NONE ), F_0F,   1,  no_WDS, 0x55,     0x00,       P_686|P_SSE1,0)
ins (ANDPD, andpd,              OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0x54,     0x00,       P_686|P_SSE2,0)
ins (ANDPS, andps,              OpCls( XMM,      XMM_M128, NONE ), F_0F,   1,  no_WDS, 0x54,     0x00,       P_686|P_SSE1,0)
ins (ORPD, orpd,                OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0x56,     0x00,       P_686|P_SSE2,0)
ins (ORPS, orps,                OpCls( XMM,      XMM_M128, NONE ), F_0F,   1,  no_WDS, 0x56,     0x00,       P_686|P_SSE1,0)
ins (COMISD, comisd,            OpCls( XMM,      XMM_M64,  NONE ), F_660F, 1,  no_WDS, 0x2F,     0x00,       P_686|P_SSE2,0)
ins (COMISS, comiss,            OpCls( XMM,      XMM_M32,  NONE ), F_0F,   1,  no_WDS, 0x2F,     0x00,       P_686|P_SSE1,0)
ins (XORPD, xorpd,              OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0x57,     0x00,       P_686|P_SSE2,0)
ins (XORPS, xorps,              OpCls( XMM,      XMM_M128, NONE ), F_0F,   1,  no_WDS, 0x57,     0x00,       P_686|P_SSE1,0)

ins (CVTPD2PI, cvtpd2pi,        OpCls( MMX,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0x2D,     0x00,       P_686|P_SSE2,0)
ins (CVTPS2PI, cvtps2pi,        OpCls( MMX,      XMM_M64,  NONE ), F_0F,   1,  no_WDS, 0x2D,     0x00,       P_686|P_SSE1,0)
ins (CVTSD2SI, cvtsd2si,        OpCls( RGT16,    XMM_M64,  NONE ), F_F20F, 1,  no_WDS, 0x2D,     0x00,       P_686|P_SSE2,0)
ins (CVTSS2SI, cvtss2si,        OpCls( RGT16,    XMM_M32,  NONE ), F_F30F, 1,  no_WDS, 0x2D,     0x00,       P_686|P_SSE1,0)
ins (CVTPI2PD, cvtpi2pd,        OpCls( XMM,      MMX_M64,  NONE ), F_660F, 1,  no_WDS, 0x2A,     0x00,       P_686|P_SSE2,0)
ins (CVTPI2PS, cvtpi2ps,        OpCls( XMM,      MMX_M64,  NONE ), F_0F,   1,  no_WDS, 0x2A,     0x00,       P_686|P_SSE1,0)
ins (CVTSI2SD, cvtsi2sd,        OpCls( XMM,      RMGT16,   NONE ), F_F20F, 1,  no_WDS, 0x2A,     0x00,       P_686|P_SSE2,0)
ins (CVTSI2SS, cvtsi2ss,        OpCls( XMM,      RMGT16,   NONE ), F_F30F, 1,  no_WDS, 0x2A,     0x00,       P_686|P_SSE1,0)
ins (CVTTPD2PI, cvttpd2pi,      OpCls( MMX,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0x2C,     0x00,       P_686|P_SSE2,0)
ins (CVTTPS2PI, cvttps2pi,      OpCls( MMX,      XMM_M64,  NONE ), F_0F,   1,  no_WDS, 0x2C,     0x00,       P_686|P_SSE1,0)
ins (CVTTSD2SI, cvttsd2si,      OpCls( RGT16,    XMM_M64,  NONE ), F_F20F, 1,  no_WDS, 0x2C,     0x00,       P_686|P_SSE2,0)
ins (CVTTSS2SI, cvttss2si,      OpCls( RGT16,    XMM_M32,  NONE ), F_F30F, 1,  no_WDS, 0x2C,     0x00,       P_686|P_SSE1,0)

ins (CVTDQ2PS, cvtdq2ps,        OpCls( XMM,      XMM_M128, NONE ), F_0F,   1,  no_WDS, 0x5B,     0x00,       P_686|P_SSE2,0)
ins (CVTPS2DQ, cvtps2dq,        OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0x5B,     0x00,       P_686|P_SSE2,0)
ins (CVTTPS2DQ, cvttps2dq,      OpCls( XMM,      XMM_M128, NONE ), F_F30F, 1,  no_WDS, 0x5B,     0x00,       P_686|P_SSE2,0)

ins (CVTPD2DQ, cvtpd2dq,        OpCls( XMM,      XMM_M128, NONE ), F_F20F, 1,  no_WDS, 0xE6,     0x00,       P_686|P_SSE2,0)
ins (CVTDQ2PD, cvtdq2pd,        OpCls( XMM,      XMM_M64,  NONE ), F_F30F, 1,  no_WDS, 0xE6,     0x00,       P_686|P_SSE2,0)
ins (CVTTPD2DQ, cvttpd2dq,      OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0xE6,     0x00,       P_686|P_SSE2,0)

ins (CVTPD2PS, cvtpd2ps,        OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0x5A,     0x00,       P_686|P_SSE2,0)
ins (CVTPS2PD, cvtps2pd,        OpCls( XMM,      XMM_M64,  NONE ), F_0F,   1,  no_WDS, 0x5A,     0x00,       P_686|P_SSE2,0)
ins (CVTSD2SS, cvtsd2ss,        OpCls( XMM,      XMM_M64,  NONE ), F_F20F, 1,  no_WDS, 0x5A,     0x00,       P_686|P_SSE2,0)
ins (CVTSS2SD, cvtss2sd,        OpCls( XMM,      XMM_M32,  NONE ), F_F30F, 1,  no_WDS, 0x5A,     0x00,       P_686|P_SSE2,0)

ins (MASKMOVDQU, maskmovdqu,    OpCls( XMM,      XMM,      NONE ), F_660F, 1,  no_WDS, 0xF7,     0x00,       P_686|P_SSE2,0)
ins (MASKMOVQ, maskmovq,        OpCls( MMX,      MMX,      NONE ), F_0F,   1,  no_WDS, 0xF7,     0x00,       P_686|P_SSE1,0)

/* Masm (ML64) uses MOVD if a 64-bit register is src/dst. Intel docs prefer MOVQ */
ins (MOVD, movd,                OpCls( MMX,      RMGT16,   NONE ), F_0F,   1,  no_WDS, 0x6E,     0x00,       P_586|P_MMX, 0)
insn(MOVD, 1,                   OpCls( XMM,      RMGT16,   NONE ), F_660F, 1,  no_WDS, 0x6E,     0x00,       P_686|P_SSE2,0)
#if INTELMOVQ
insn(MOVD, 2,                   OpCls( R32_M32,  MMX,      NONE ), F_0F,   0,  no_WDS, 0x7E,     0x00,       P_586|P_MMX, 0)
insn(MOVD, 3,                   OpCls( R32_M32,  XMM,      NONE ), F_660F, 0,  no_WDS, 0x7E,     0x00,       P_686|P_SSE2,0)
#else
insn(MOVD, 2,                   OpCls( RMGT16,   MMX,      NONE ), F_0F,   0,  no_WDS, 0x7E,     0x00,       P_586|P_MMX, 0)
insn(MOVD, 3,                   OpCls( RMGT16,   XMM,      NONE ), F_660F, 0,  no_WDS, 0x7E,     0x00,       P_686|P_SSE2,0)
#endif
ins (MOVQ, movq,                OpCls( MMX,      MMX_M64,  NONE ), F_0F,   1,  no_WDS, 0x6F,     0x00,       P_586|P_MMX, 0)
insn(MOVQ, 1,                   OpCls( XMM,      XMM_M64,  NONE ), F_F30F, 1,  no_WDS, 0x7E,     0x00,       P_686|P_SSE2,0)
#if INTELMOVQ
insn(MOVQ, 2,                   OpCls( R64_M64,  MMX,      NONE ), F_0F,   0,  no_WDS, 0x7F,     0x00,       P_586|P_MMX, 0)
insn(MOVQ, 3,                   OpCls( R64_M64,  XMM,      NONE ), F_660F, 0,  no_WDS, 0xD6,     0x00,       P_686|P_SSE2,0)
#else
insn(MOVQ, 2,                   OpCls( M64,      MMX,      NONE ), F_0F,   0,  no_WDS, 0x7F,     0x00,       P_586|P_MMX, 0)
insn(MOVQ, 3,                   OpCls( M64,      XMM,      NONE ), F_660F, 0,  no_WDS, 0xD6,     0x00,       P_686|P_SSE2,0)
#endif

ins (MOVAPD, movapd,            OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0x28,     0x00,       P_686|P_SSE2,0)
insn(MOVAPD, 1,                 OpCls( M128,     XMM,      NONE ), F_660F, 0,  no_WDS, 0x29,     0x00,       P_686|P_SSE2,0)
ins (MOVAPS, movaps,            OpCls( XMM,      XMM_M128, NONE ), F_0F,   1,  no_WDS, 0x28,     0x00,       P_686|P_SSE1,0)
insn(MOVAPS, 1,                 OpCls( M128,     XMM,      NONE ), F_0F,   0,  no_WDS, 0x29,     0x00,       P_686|P_SSE1,0)
ins (MOVDQA, movdqa,            OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0x6F,     0x00,       P_686|P_SSE2,0)
insn(MOVDQA, 1,                 OpCls( M128,     XMM,      NONE ), F_660F, 0,  no_WDS, 0x7F,     0x00,       P_686|P_SSE2,0)
ins (MOVDQU, movdqu,            OpCls( XMM,      XMM_M128, NONE ), F_F30F, 1,  no_WDS, 0x6F,     0x00,       P_686|P_SSE2,0)
insn(MOVDQU, 1,                 OpCls( M128,     XMM,      NONE ), F_F30F, 0,  no_WDS, 0x7F,     0x00,       P_686|P_SSE2,0)
ins (MOVUPD, movupd,            OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0x10,     0x00,       P_686|P_SSE2,0)
insn(MOVUPD, 1,                 OpCls( M128,     XMM,      NONE ), F_660F, 0,  no_WDS, 0x11,     0x00,       P_686|P_SSE2,0)
ins (MOVUPS, movups,            OpCls( XMM,      XMM_M128, NONE ), F_0F,   1,  no_WDS, 0x10,     0x00,       P_686|P_SSE1,0)
insn(MOVUPS, 1,                 OpCls( M128,     XMM,      NONE ), F_0F,   0,  no_WDS, 0x11,     0x00,       P_686|P_SSE1,0)

ins (MOVHPD, movhpd,            OpCls( XMM,      M64,      NONE ), F_660F, 1,  no_WDS, 0x16,     0x00,       P_686|P_SSE2,0)
insn(MOVHPD, 1,                 OpCls( M64,      XMM,      NONE ), F_660F, 0,  no_WDS, 0x17,     0x00,       P_686|P_SSE2,0)
ins (MOVHPS, movhps,            OpCls( XMM,      M64,      NONE ), F_0F,   1,  no_WDS, 0x16,     0x00,       P_686|P_SSE1,0)
insn(MOVHPS, 1,                 OpCls( M64,      XMM,      NONE ), F_0F,   0,  no_WDS, 0x17,     0x00,       P_686|P_SSE1,0)
ins (MOVLPD, movlpd,            OpCls( XMM,      M64,      NONE ), F_660F, 1,  no_WDS, 0x12,     0x00,       P_686|P_SSE2,0)
insn(MOVLPD, 1,                 OpCls( M64,      XMM,      NONE ), F_660F, 0,  no_WDS, 0x13,     0x00,       P_686|P_SSE2,0)
ins (MOVLPS, movlps,            OpCls( XMM,      M64,      NONE ), F_0F,   1,  no_WDS, 0x12,     0x00,       P_686|P_SSE1,0)
insn(MOVLPS, 1,                 OpCls( M64,      XMM,      NONE ), F_0F,   0,  no_WDS, 0x13,     0x00,       P_686|P_SSE1,0)

ins (MOVHLPS, movhlps,          OpCls( XMM,      XMM,      NONE ), F_0F,   1,  no_WDS, 0x12,     0x00,       P_686|P_SSE1,0)
ins (MOVLHPS, movlhps,          OpCls( XMM,      XMM,      NONE ), F_0F,   1,  no_WDS, 0x16,     0x00,       P_686|P_SSE1,0)
ins (MOVDQ2Q, movdq2q,          OpCls( MMX,      XMM,      NONE ), F_F20F, 1,  no_WDS, 0xD6,     0x00,       P_686|P_SSE2,0)
ins (MOVQ2DQ, movq2dq,          OpCls( XMM,      MMX,      NONE ), F_F30F, 1,  no_WDS, 0xD6,     0x00,       P_686|P_SSE2,0)

ins (MOVMSKPD, movmskpd,        OpCls( RGT16,    XMM,      NONE ), F_660F, 1,  no_WDS, 0x50,     0x00,       P_686|P_SSE2,0)
ins (MOVMSKPS, movmskps,        OpCls( RGT16,    XMM,      NONE ), F_0F,   1,  no_WDS, 0x50,     0x00,       P_686|P_SSE1,0)
ins (MOVNTDQ, movntdq,          OpCls( M128,     XMM,      NONE ), F_660F, 0,  no_WDS, 0xE7,     0x00,       P_686|P_SSE2,0)
ins (MOVNTI, movnti,            OpCls( MGT16,    RGT16,    NONE ), F_0F,   0,  no_WDS, 0xC3,     0x00,       P_686|P_SSE2,0)
ins (MOVNTPD, movntpd,          OpCls( M128,     XMM,      NONE ), F_660F, 0,  no_WDS, 0x2B,     0x00,       P_686|P_SSE2,0)
ins (MOVNTPS, movntps,          OpCls( M128,     XMM,      NONE ), F_0F,   0,  no_WDS, 0x2B,     0x00,       P_686|P_SSE1,0)
ins (MOVNTQ, movntq,            OpCls( M64,      MMX,      NONE ), F_0F,   0,  no_WDS, 0xE7,     0x00,       P_686|P_SSE1,0)
//ins (MOVSD, movsd,              OpCls( XMM,      XMM_M64,  NONE ), F_F20F, 1,  no_WDS, 0x10,     0x00,       P_686|P_SSE2,0)
//insn(MOVSD, 1                   OpCls( M64,      XMM,      NONE ), F_F20F, 0,  no_WDS, 0x11,     0x00,       P_686|P_SSE2,0)
ins (MOVSS, movss,              OpCls( XMM,      XMM_M32,  NONE ), F_F30F, 1,  no_WDS, 0x10,     0x00,       P_686|P_SSE1,0)
insn(MOVSS, 1,                  OpCls( M32,      XMM,      NONE ), F_F30F, 0,  no_WDS, 0x11,     0x00,       P_686|P_SSE1,0)

ins (PACKSSDW, packssdw,        OpCls( MMX,      MMX_M64,  NONE ), F_0F,   1,  no_WDS, 0x6B,     0x00,       P_586|P_MMX, 0)
insn(PACKSSDW, 1,               OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0x6B,     0x00,       P_686|P_SSE2,0)
ins (PACKSSWB, packsswb,        OpCls( MMX,      MMX_M64,  NONE ), F_0F,   1,  no_WDS, 0x63,     0x00,       P_586|P_MMX, 0)
insn(PACKSSWB, 1,               OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0x63,     0x00,       P_686|P_SSE2,0)
ins (PACKUSWB, packuswb,        OpCls( MMX,      MMX_M64,  NONE ), F_0F,   1,  no_WDS, 0x67,     0x00,       P_586|P_MMX, 0)
insn(PACKUSWB, 1,               OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0x67,     0x00,       P_686|P_SSE2,0)
ins (PADDB, paddb,              OpCls( MMX,    MMX_M64_08, NONE ), F_0F,   1,  no_WDS, 0xFC,     0x00,       P_586|P_MMX, 0)
insn(PADDB, 1,                  OpCls( XMM,    XMM_M128_08,NONE ), F_660F, 1,  no_WDS, 0xFC,     0x00,       P_686|P_SSE2,0)
ins (PADDW, paddw,              OpCls( MMX,    MMX_M64_16, NONE ), F_0F,   1,  no_WDS, 0xFD,     0x00,       P_586|P_MMX, 0)
insn(PADDW, 1,                  OpCls( XMM,    XMM_M128_16,NONE ), F_660F, 1,  no_WDS, 0xFD,     0x00,       P_686|P_SSE2,0)
ins (PADDD, paddd,              OpCls( MMX,    MMX_M64_32, NONE ), F_0F,   1,  no_WDS, 0xFE,     0x00,       P_586|P_MMX, 0)
insn(PADDD, 1,                  OpCls( XMM,    XMM_M128_32,NONE ), F_660F, 1,  no_WDS, 0xFE,     0x00,       P_686|P_SSE2,0)
ins (PADDQ, paddq,              OpCls( MMX,      MMX_M64,  NONE ), F_0F,   1,  no_WDS, 0xD4,     0x00,       P_686|P_SSE2,0)
insn(PADDQ, 1,                  OpCls( XMM,    XMM_M128_64,NONE ), F_660F, 1,  no_WDS, 0xD4,     0x00,       P_686|P_SSE2,0)
ins (PADDSB, paddsb,            OpCls( MMX,    MMX_M64_08, NONE ), F_0F,   1,  no_WDS, 0xEC,     0x00,       P_586|P_MMX, 0)
insn(PADDSB, 1,                 OpCls( XMM,    XMM_M128_08,NONE ), F_660F, 1,  no_WDS, 0xEC,     0x00,       P_686|P_SSE2,0)
ins (PADDSW, paddsw,            OpCls( MMX,    MMX_M64_16, NONE ), F_0F,   1,  no_WDS, 0xED,     0x00,       P_586|P_MMX, 0)
insn(PADDSW, 1,                 OpCls( XMM,    XMM_M128_16,NONE ), F_660F, 1,  no_WDS, 0xED,     0x00,       P_686|P_SSE2,0)
ins (PADDUSB, paddusb,          OpCls( MMX,    MMX_M64_08, NONE ), F_0F,   1,  no_WDS, 0xDC,     0x00,       P_586|P_MMX, 0)
insn(PADDUSB, 1,                OpCls( XMM,    XMM_M128_08,NONE ), F_660F, 1,  no_WDS, 0xDC,     0x00,       P_686|P_SSE2,0)
ins (PADDUSW, paddusw,          OpCls( MMX,    MMX_M64_16, NONE ), F_0F,   1,  no_WDS, 0xDD,     0x00,       P_586|P_MMX, 0)
insn(PADDUSW, 1,                OpCls( XMM,    XMM_M128_16,NONE ), F_660F, 1,  no_WDS, 0xDD,     0x00,       P_686|P_SSE2,0)
ins (PAND, pand,                OpCls( MMX,      MMX_M64,  NONE ), F_0F,   1,  no_WDS, 0xDB,     0x00,       P_586|P_MMX, 0)
insn(PAND, 1,                   OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0xDB,     0x00,       P_686|P_SSE2,0)
ins (PANDN, pandn,              OpCls( MMX,      MMX_M64,  NONE ), F_0F,   1,  no_WDS, 0xDF,     0x00,       P_586|P_MMX, 0)
insn(PANDN, 1,                  OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0xDF,     0x00,       P_686|P_SSE2,0)
ins (PAVGB, pavgb,              OpCls( MMX,      MMX_M64,  NONE ), F_0F,   1,  no_WDS, 0xE0,     0x00,       P_686|P_SSE1,0)
insn(PAVGB, 1,                  OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0xE0,     0x00,       P_686|P_SSE2,0)
ins (PAVGW, pavgw,              OpCls( MMX,      MMX_M64,  NONE ), F_0F,   1,  no_WDS, 0xE3,     0x00,       P_686|P_SSE1,0)
insn(PAVGW, 1,                  OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0xE3,     0x00,       P_686|P_SSE2,0)
ins (PCMPEQB, pcmpeqb,          OpCls( MMX,      MMX_M64,  NONE ), F_0F,   1,  no_WDS, 0x74,     0x00,       P_586|P_MMX, 0)
insn(PCMPEQB, 1,                OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0x74,     0x00,       P_686|P_SSE2,0)
ins (PCMPEQW, pcmpeqw,          OpCls( MMX,      MMX_M64,  NONE ), F_0F,   1,  no_WDS, 0x75,     0x00,       P_586|P_MMX, 0)
insn(PCMPEQW, 1,                OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0x75,     0x00,       P_686|P_SSE2,0)
ins (PCMPEQD, pcmpeqd,          OpCls( MMX,      MMX_M64,  NONE ), F_0F,   1,  no_WDS, 0x76,     0x00,       P_586|P_MMX, 0)
insn(PCMPEQD, 1,                OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0x76,     0x00,       P_686|P_SSE2,0)
ins (PCMPGTB, pcmpgtb,          OpCls( MMX,      MMX_M64,  NONE ), F_0F,   1,  no_WDS, 0x64,     0x00,       P_586|P_MMX, 0)
insn(PCMPGTB, 1,                OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0x64,     0x00,       P_686|P_SSE2,0)
ins (PCMPGTW, pcmpgtw,          OpCls( MMX,      MMX_M64,  NONE ), F_0F,   1,  no_WDS, 0x65,     0x00,       P_586|P_MMX, 0)
insn(PCMPGTW, 1,                OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0x65,     0x00,       P_686|P_SSE2,0)
ins (PCMPGTD, pcmpgtd,          OpCls( MMX,      MMX_M64,  NONE ), F_0F,   1,  no_WDS, 0x66,     0x00,       P_586|P_MMX, 0)
insn(PCMPGTD, 1,                OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0x66,     0x00,       P_686|P_SSE2,0)
ins (PEXTRW, pextrw,            OpCls( RGT16,    MMX,      I8_U ), F_0F,   1,  no_WDS, 0xC5,     0x00,       P_686|P_SSE1,0)
insn(PEXTRW, 1,                 OpCls( RGT16,    XMM,      I8_U ), F_660F, 1,  no_WDS, 0xC5,     0x00,       P_686|P_SSE1,0)
#if SSE4SUPP /* SSE 4.1 */
insn(PEXTRW, 2,                 OpCls( M16,      XMM,      I8_U ), F_660F3A, 0,no_WDS, 0x15,     0x00,       P_686|P_SSE4,0)
#endif
/* v2.06: define it like PINSRB/PINSRD */
//ins (PINSRW, pinsrw,            OpCls( MMX,      R32,      I8_U ), F_0F,   1,  no_WDS, 0xC4,     0x00,       P_686|P_SSE1,0)
//insn(PINSRW, 1,                 OpCls( MMX,      M16,      I8_U ), F_0F,   1,  no_WDS, 0xC4,     0x00,       P_686|P_SSE1,0)
//insn(PINSRW, 2,                 OpCls( XMM,      R32,      I8_U ), F_660F, 1,  no_WDS, 0xC4,     0x00,       P_686|P_SSE1,0)
//insn(PINSRW, 3,                 OpCls( XMM,      M16,      I8_U ), F_660F, 1,  no_WDS, 0xC4,     0x00,       P_686|P_SSE1,0)
ins (PINSRW, pinsrw,            OpCls( MMX,      R32_M16,  I8_U ), F_0F,   1,  no_WDS, 0xC4,     0x00,       P_686|P_SSE1,0)
insn(PINSRW, 1,                 OpCls( XMM,      R32_M16,  I8_U ), F_660F, 1,  no_WDS, 0xC4,     0x00,       P_686|P_SSE1,0)
ins (PMADDWD, pmaddwd,          OpCls( MMX,      MMX_M64,  NONE ), F_0F,   1,  no_WDS, 0xF5,     0x00,       P_586|P_MMX, 0)
insn(PMADDWD, 1,                OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0xF5,     0x00,       P_686|P_SSE2,0)
ins (PMAXSW, pmaxsw,            OpCls( MMX,      MMX_M64,  NONE ), F_0F,   1,  no_WDS, 0xEE,     0x00,       P_686|P_SSE1,0)
insn(PMAXSW, 1,                 OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0xEE,     0x00,       P_686|P_SSE2,0)
ins (PMAXUB, pmaxub,            OpCls( MMX,      MMX_M64,  NONE ), F_0F,   1,  no_WDS, 0xDE,     0x00,       P_686|P_SSE1,0)
insn(PMAXUB, 1,                 OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0xDE,     0x00,       P_686|P_SSE2,0)
ins (PMINSW, pminsw,            OpCls( MMX,      MMX_M64,  NONE ), F_0F,   1,  no_WDS, 0xEA,     0x00,       P_686|P_SSE1,0)
insn(PMINSW, 1,                 OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0xEA,     0x00,       P_686|P_SSE2,0)
ins (PMINUB, pminub,            OpCls( MMX,      MMX_M64,  NONE ), F_0F,   1,  no_WDS, 0xDA,     0x00,       P_686|P_SSE1,0)
insn(PMINUB, 1,                 OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0xDA,     0x00,       P_686|P_SSE2,0)
ins (PMOVMSKB, pmovmskb,        OpCls( RGT16,    MMX,      NONE ), F_0F,   1,  no_WDS, 0xD7,     0x00,       P_686|P_SSE1,0)
insn(PMOVMSKB, 1,               OpCls( RGT16,    XMM,      NONE ), F_660F, 1,  no_WDS, 0xD7,     0x00,       P_686|P_SSE2,0)
ins (PMULHUW, pmulhuw,          OpCls( MMX,      MMX_M64,  NONE ), F_0F,   1,  no_WDS, 0xE4,     0x00,       P_586|P_SSE1,0)
insn(PMULHUW, 1,                OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0xE4,     0x00,       P_686|P_SSE2,0)
ins (PMULHW, pmulhw,            OpCls( MMX,      MMX_M64,  NONE ), F_0F,   1,  no_WDS, 0xE5,     0x00,       P_586|P_MMX, 0)
insn(PMULHW, 1,                 OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0xE5,     0x00,       P_686|P_SSE2,0)
ins (PMULLW, pmullw,            OpCls( MMX,      MMX_M64,  NONE ), F_0F,   1,  no_WDS, 0xD5,     0x00,       P_586|P_MMX, 0)
insn(PMULLW, 1,                 OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0xD5,     0x00,       P_686|P_SSE2,0)
ins (PMULUDQ, pmuludq,          OpCls( MMX,      MMX_M64,  NONE ), F_0F,   1,  no_WDS, 0xF4,     0x00,       P_686|P_SSE2,0)
insn(PMULUDQ, 1,                OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0xF4,     0x00,       P_686|P_SSE2,0)
ins (POR, por,                  OpCls( MMX,      MMX_M64,  NONE ), F_0F,   1,  no_WDS, 0xEB,     0x00,       P_586|P_MMX, 0)
insn(POR,  1,                   OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0xEB,     0x00,       P_686|P_SSE2,0)
ins (PSADBW, psadbw,            OpCls( MMX,      MMX_M64,  NONE ), F_0F,   1,  no_WDS, 0xF6,     0x00,       P_686|P_SSE1,0)
insn(PSADBW, 1,                 OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0xF6,     0x00,       P_686|P_SSE2,0)
ins (PSHUFD, pshufd,            OpCls( XMM,      XMM_M128, I8_U ), F_660F, 1,  no_WDS, 0x70,     0x00,       P_686|P_SSE2,0)
ins (PSHUFW, pshufw,            OpCls( MMX,      MMX_M64,  I8_U ), F_0F,   1,  no_WDS, 0x70,     0x00,       P_686|P_SSE1,0)
ins (PSHUFHW, pshufhw,          OpCls( XMM,      XMM_M128, I8_U ), F_F30F, 1,  no_WDS, 0x70,     0x00,       P_686|P_SSE2,0)
ins (PSHUFLW, pshuflw,          OpCls( XMM,      XMM_M128, I8_U ), F_F20F, 1,  no_WDS, 0x70,     0x00,       P_686|P_SSE2,0)

ins (PSLLW, psllw,              OpCls( MMX,      MMX_M64,  NONE ), F_0F,   1,  no_WDS, 0xF1,     0x00,       P_586|P_MMX, 0)
insn(PSLLW, 1,                  OpCls( MMX,      I8_U,     NONE ), F_0F,   0,  no_WDS, 0x71,     0x30,       P_586|P_MMX, 0)
insn(PSLLW, 2,                  OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0xF1,     0x00,       P_686|P_SSE2,0)
insn(PSLLW, 3,                  OpCls( XMM,      I8_U,     NONE ), F_660F, 0,  no_WDS, 0x71,     0x30,       P_686|P_SSE2,0)
ins (PSLLD, pslld,              OpCls( MMX,      MMX_M64,  NONE ), F_0F,   1,  no_WDS, 0xF2,     0x00,       P_586|P_MMX, 0)
insn(PSLLD, 1,                  OpCls( MMX,      I8_U,     NONE ), F_0F,   0,  no_WDS, 0x72,     0x30,       P_586|P_MMX, 0)
insn(PSLLD, 2,                  OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0xF2,     0x00,       P_686|P_SSE2,0)
insn(PSLLD, 3,                  OpCls( XMM,      I8_U,     NONE ), F_660F, 0,  no_WDS, 0x72,     0x30,       P_686|P_SSE2,0)
ins (PSLLQ, psllq,              OpCls( MMX,      MMX_M64,  NONE ), F_0F,   1,  no_WDS, 0xF3,     0x00,       P_586|P_MMX, 0)
insn(PSLLQ, 1,                  OpCls( MMX,      I8_U,     NONE ), F_0F,   0,  no_WDS, 0x73,     0x30,       P_586|P_MMX, 0)
insn(PSLLQ, 2,                  OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0xF3,     0x00,       P_686|P_SSE2,0)
insn(PSLLQ, 3,                  OpCls( XMM,      I8_U,     NONE ), F_660F, 0,  no_WDS, 0x73,     0x30,       P_686|P_SSE2,0)
ins (PSRAW, psraw,              OpCls( MMX,      MMX_M64,  NONE ), F_0F,   1,  no_WDS, 0xE1,     0x00,       P_586|P_MMX, 0)
insn(PSRAW, 1,                  OpCls( MMX,      I8_U,     NONE ), F_0F,   0,  no_WDS, 0x71,     0x20,       P_586|P_MMX, 0)
insn(PSRAW, 2,                  OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0xE1,     0x00,       P_586|P_SSE2,0)
insn(PSRAW, 3,                  OpCls( XMM,      I8_U,     NONE ), F_660F, 0,  no_WDS, 0x71,     0x20,       P_686|P_SSE2,0)
ins (PSRAD, psrad,              OpCls( MMX,      MMX_M64,  NONE ), F_0F,   1,  no_WDS, 0xE2,     0x00,       P_586|P_MMX, 0)
insn(PSRAD, 1,                  OpCls( MMX,      I8_U,     NONE ), F_0F,   0,  no_WDS, 0x72,     0x20,       P_586|P_MMX, 0)
insn(PSRAD, 2,                  OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0xE2,     0x00,       P_686|P_SSE2,0)
insn(PSRAD, 3,                  OpCls( XMM,      I8_U,     NONE ), F_660F, 0,  no_WDS, 0x72,     0x20,       P_686|P_SSE2,0)
ins (PSRLW, psrlw,              OpCls( MMX,      MMX_M64,  NONE ), F_0F,   1,  no_WDS, 0xD1,     0x00,       P_586|P_MMX, 0)
insn(PSRLW, 1,                  OpCls( MMX,      I8_U,     NONE ), F_0F,   0,  no_WDS, 0x71,     0x10,       P_586|P_MMX, 0)
insn(PSRLW, 2,                  OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0xD1,     0x00,       P_686|P_SSE2,0)
insn(PSRLW, 3,                  OpCls( XMM,      I8_U,     NONE ), F_660F, 0,  no_WDS, 0x71,     0x10,       P_686|P_SSE2,0)
ins (PSRLD, psrld,              OpCls( MMX,      MMX_M64,  NONE ), F_0F,   1,  no_WDS, 0xD2,     0x00,       P_586|P_MMX, 0)
insn(PSRLD, 1,                  OpCls( MMX,      I8_U,     NONE ), F_0F,   0,  no_WDS, 0x72,     0x10,       P_586|P_MMX, 0)
insn(PSRLD, 2,                  OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0xD2,     0x00,       P_686|P_SSE2,0)
insn(PSRLD, 3,                  OpCls( XMM,      I8_U,     NONE ), F_660F, 0,  no_WDS, 0x72,     0x10,       P_686|P_SSE2,0)
ins (PSRLQ, psrlq,              OpCls( MMX,      MMX_M64,  NONE ), F_0F,   1,  no_WDS, 0xD3,     0x00,       P_586|P_MMX, 0)
insn(PSRLQ, 1,                  OpCls( MMX,      I8_U,     NONE ), F_0F,   0,  no_WDS, 0x73,     0x10,       P_586|P_MMX, 0)
insn(PSRLQ, 2,                  OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0xD3,     0x00,       P_686|P_SSE2,0)
insn(PSRLQ, 3,                  OpCls( XMM,      I8_U,     NONE ), F_660F, 0,  no_WDS, 0x73,     0x10,       P_686|P_SSE2,0)

ins (PSLLDQ, pslldq,            OpCls( XMM,      I8_U,     NONE ), F_660F, 0,  no_WDS, 0x73,     0x38,       P_686|P_SSE2,0)
ins (PSRLDQ, psrldq,            OpCls( XMM,      I8_U,     NONE ), F_660F, 0,  no_WDS, 0x73,     0x18,       P_686|P_SSE2,0)

ins (PSUBB, psubb,              OpCls( MMX,      MMX_M64,  NONE ), F_0F,   1,  no_WDS, 0xF8,     0x00,       P_586|P_MMX, 0)
insn(PSUBB, 1,                  OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0xF8,     0x00,       P_686|P_SSE2,0)
ins (PSUBW, psubw,              OpCls( MMX,      MMX_M64,  NONE ), F_0F,   1,  no_WDS, 0xF9,     0x00,       P_586|P_MMX, 0)
insn(PSUBW, 1,                  OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0xF9,     0x00,       P_686|P_SSE2,0)
ins (PSUBD, psubd,              OpCls( MMX,      MMX_M64,  NONE ), F_0F,   1,  no_WDS, 0xFA,     0x00,       P_586|P_MMX, 0)
insn(PSUBD, 1,                  OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0xFA,     0x00,       P_686|P_SSE2,0)
ins (PSUBQ, psubq,              OpCls( MMX,      MMX_M64,  NONE ), F_0F,   1,  no_WDS, 0xFB,     0x00,       P_686|P_SSE2,0)
insn(PSUBQ, 1,                  OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0xFB,     0x00,       P_686|P_SSE2,0)
ins (PSUBSB, psubsb,            OpCls( MMX,      MMX_M64,  NONE ), F_0F,   1,  no_WDS, 0xE8,     0x00,       P_586|P_MMX, 0)
insn(PSUBSB, 1,                 OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0xE8,     0x00,       P_686|P_SSE2,0)
ins (PSUBSW, psubsw,            OpCls( MMX,      MMX_M64,  NONE ), F_0F,   1,  no_WDS, 0xE9,     0x00,       P_586|P_MMX, 0)
insn(PSUBSW, 1,                 OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0xE9,     0x00,       P_686|P_SSE2,0)
ins (PSUBUSB, psubusb,          OpCls( MMX,      MMX_M64,  NONE ), F_0F,   1,  no_WDS, 0xD8,     0x00,       P_586|P_MMX, 0)
insn(PSUBUSB, 1,                OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0xD8,     0x00,       P_686|P_SSE2,0)
ins (PSUBUSW, psubusw,          OpCls( MMX,      MMX_M64,  NONE ), F_0F,   1,  no_WDS, 0xD9,     0x00,       P_586|P_MMX, 0)
insn(PSUBUSW, 1,                OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0xD9,     0x00,       P_686|P_SSE2,0)
ins (PXOR, pxor,                OpCls( MMX,      MMX_M64,  NONE ), F_0F,   1,  no_WDS, 0xEF,     0x00,       P_586|P_MMX, 0)
insn(PXOR, 1,                   OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0xEF,     0x00,       P_686|P_SSE2,0)
ins (PUNPCKHBW, punpckhbw,      OpCls( MMX,      MMX_M64,  NONE ), F_0F,   1,  no_WDS, 0x68,     0x00,       P_586|P_MMX, 0)
insn(PUNPCKHBW, 1,              OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0x68,     0x00,       P_686|P_SSE2,0)
ins (PUNPCKHWD, punpckhwd,      OpCls( MMX,      MMX_M64,  NONE ), F_0F,   1,  no_WDS, 0x69,     0x00,       P_586|P_MMX, 0)
insn(PUNPCKHWD, 1,              OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0x69,     0x00,       P_686|P_SSE2,0)
ins (PUNPCKHDQ, punpckhdq,      OpCls( MMX,      MMX_M64,  NONE ), F_0F,   1,  no_WDS, 0x6A,     0x00,       P_586|P_MMX, 0)
insn(PUNPCKHDQ, 1,              OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0x6A,     0x00,       P_686|P_SSE2,0)
ins (PUNPCKLBW, punpcklbw,      OpCls( MMX,      MMX_M64,  NONE ), F_0F,   1,  no_WDS, 0x60,     0x00,       P_586|P_MMX, 0)
insn(PUNPCKLBW, 1,              OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0x60,     0x00,       P_686|P_SSE2,0)
ins (PUNPCKLWD, punpcklwd,      OpCls( MMX,      MMX_M64,  NONE ), F_0F,   1,  no_WDS, 0x61,     0x00,       P_586|P_MMX, 0)
insn(PUNPCKLWD, 1,              OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0x61,     0x00,       P_686|P_SSE2,0)
ins (PUNPCKLDQ, punpckldq,      OpCls( MMX,      MMX_M64,  NONE ), F_0F,   1,  no_WDS, 0x62,     0x00,       P_586|P_MMX, 0)
insn(PUNPCKLDQ, 1,              OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0x62,     0x00,       P_686|P_SSE2,0)
ins (PUNPCKHQDQ, punpckhqdq,    OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0x6D,     0x00,       P_686|P_SSE2,0)
ins (PUNPCKLQDQ, punpcklqdq,    OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0x6C,     0x00,       P_686|P_SSE2,0)

ins (RCPPS, rcpps,              OpCls( XMM,      XMM_M128, NONE ), F_0F,   1,  no_WDS, 0x53,     0x00,       P_686|P_SSE1,0)
ins (RCPSS, rcpss,              OpCls( XMM,      XMM_M32,  NONE ), F_F30F, 1,  no_WDS, 0x53,     0x00,       P_686|P_SSE1,0)
ins (RSQRTPS, rsqrtps,          OpCls( XMM,      XMM_M128, NONE ), F_0F,   1,  no_WDS, 0x52,     0x00,       P_686|P_SSE1,0)
ins (RSQRTSS, rsqrtss,          OpCls( XMM,      XMM_M32,  NONE ), F_F30F, 1,  no_WDS, 0x52,     0x00,       P_686|P_SSE1,0)
ins (SHUFPD, shufpd,            OpCls( XMM,      XMM_M128, I8_U ), F_660F, 1,  no_WDS, 0xC6,     0x00,       P_686|P_SSE2,0)
ins (SHUFPS, shufps,            OpCls( XMM,      XMM_M128, I8_U ), F_0F,   1,  no_WDS, 0xC6,     0x00,       P_686|P_SSE1,0)
ins (UCOMISD, ucomisd,          OpCls( XMM,      XMM_M64,  NONE ), F_660F, 1,  no_WDS, 0x2E,     0x00,       P_686|P_SSE2,0)
ins (UCOMISS, ucomiss,          OpCls( XMM,      XMM_M32,  NONE ), F_0F,   1,  no_WDS, 0x2E,     0x00,       P_686|P_SSE1,0)
ins (UNPCKHPD, unpckhpd,        OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0x15,     0x00,       P_686|P_SSE2,0)
ins (UNPCKHPS, unpckhps,        OpCls( XMM,      XMM_M128, NONE ), F_0F,   1,  no_WDS, 0x15,     0x00,       P_686|P_SSE1,0)
ins (UNPCKLPD, unpcklpd,        OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0x14,     0x00,       P_686|P_SSE2,0)
ins (UNPCKLPS, unpcklps,        OpCls( XMM,      XMM_M128, NONE ), F_0F,   1,  no_WDS, 0x14,     0x00,       P_686|P_SSE1,0)

/* K3D instructions */
#if K3DSUPP
ins (FEMMS, femms,              OpCls( NONE,     NONE,     NONE ), F_0F,   0,  no_RM,  0x0E,     0x00,       P_586|P_K3D, 0)
ins (PREFETCH, prefetch,        OpCls( M_ANY,    NONE,     NONE ), F_0F,   0,  no_WDS, 0x0D,     0x00,       P_586|P_K3D, 0)
ins (PREFETCHW, prefetchw,      OpCls( M_ANY,    NONE,     NONE ), F_0F,   0,  no_WDS, 0x0D,     0x08,       P_586|P_K3D, 0)
ins (PAVGUSB, pavgusb,          OpCls( MMX,      MMX_M64,  NONE ), F_0F0F, 1,  no_WDS, 0xBF,     0x00,       P_586|P_K3D, 0)
ins (PF2ID, pf2id,              OpCls( MMX,      MMX_M64,  NONE ), F_0F0F, 1,  no_WDS, 0x1D,     0x00,       P_586|P_K3D, 0)
ins (PF2IW, pf2iw,              OpCls( MMX,      MMX_M64,  NONE ), F_0F0F, 1,  no_WDS, 0x1C,     0x00,       P_586|P_K3D, 0)
ins (PFACC, pfacc,              OpCls( MMX,      MMX_M64,  NONE ), F_0F0F, 1,  no_WDS, 0xAE,     0x00,       P_586|P_K3D, 0)
ins (PFADD, pfadd,              OpCls( MMX,      MMX_M64,  NONE ), F_0F0F, 1,  no_WDS, 0x9E,     0x00,       P_586|P_K3D, 0)
ins (PFCMPEQ, pfcmpeq,          OpCls( MMX,      MMX_M64,  NONE ), F_0F0F, 1,  no_WDS, 0xB0,     0x00,       P_586|P_K3D, 0)
ins (PFCMPGE, pfcmpge,          OpCls( MMX,      MMX_M64,  NONE ), F_0F0F, 1,  no_WDS, 0x90,     0x00,       P_586|P_K3D, 0)
ins (PFCMPGT, pfcmpgt,          OpCls( MMX,      MMX_M64,  NONE ), F_0F0F, 1,  no_WDS, 0xA0,     0x00,       P_586|P_K3D, 0)
ins (PFMAX, pfmax,              OpCls( MMX,      MMX_M64,  NONE ), F_0F0F, 1,  no_WDS, 0xA4,     0x00,       P_586|P_K3D, 0)
ins (PFMIN, pfmin,              OpCls( MMX,      MMX_M64,  NONE ), F_0F0F, 1,  no_WDS, 0x94,     0x00,       P_586|P_K3D, 0)
ins (PFMUL, pfmul,              OpCls( MMX,      MMX_M64,  NONE ), F_0F0F, 1,  no_WDS, 0xB4,     0x00,       P_586|P_K3D, 0)
ins (PFNACC, pfnacc,            OpCls( MMX,      MMX_M64,  NONE ), F_0F0F, 1,  no_WDS, 0x8A,     0x00,       P_586|P_K3D, 0)
ins (PFPNACC, pfpnacc,          OpCls( MMX,      MMX_M64,  NONE ), F_0F0F, 1,  no_WDS, 0x8E,     0x00,       P_586|P_K3D, 0)
ins (PFRCP, pfrcp,              OpCls( MMX,      MMX_M64,  NONE ), F_0F0F, 1,  no_WDS, 0x96,     0x00,       P_586|P_K3D, 0)
ins (PFRCPIT1, pfrcpit1,        OpCls( MMX,      MMX_M64,  NONE ), F_0F0F, 1,  no_WDS, 0xA6,     0x00,       P_586|P_K3D, 0)
ins (PFRCPIT2, pfrcpit2,        OpCls( MMX,      MMX_M64,  NONE ), F_0F0F, 1,  no_WDS, 0xB6,     0x00,       P_586|P_K3D, 0)
ins (PFRSQIT1, pfrsqit1,        OpCls( MMX,      MMX_M64,  NONE ), F_0F0F, 1,  no_WDS, 0xA7,     0x00,       P_586|P_K3D, 0)
ins (PFRSQRT, pfrsqrt,          OpCls( MMX,      MMX_M64,  NONE ), F_0F0F, 1,  no_WDS, 0x97,     0x00,       P_586|P_K3D, 0)
ins (PFSUB, pfsub,              OpCls( MMX,      MMX_M64,  NONE ), F_0F0F, 1,  no_WDS, 0x9A,     0x00,       P_586|P_K3D, 0)
ins (PFSUBR, pfsubr,            OpCls( MMX,      MMX_M64,  NONE ), F_0F0F, 1,  no_WDS, 0xAA,     0x00,       P_586|P_K3D, 0)
ins (PI2FD, pi2fd,              OpCls( MMX,      MMX_M64,  NONE ), F_0F0F, 1,  no_WDS, 0x0D,     0x00,       P_586|P_K3D, 0)
ins (PI2FW, pi2fw,              OpCls( MMX,      MMX_M64,  NONE ), F_0F0F, 1,  no_WDS, 0x0C,     0x00,       P_586|P_K3D, 0)
ins (PMULHRW, pmulhrw,          OpCls( MMX,      MMX_M64,  NONE ), F_0F0F, 1,  no_WDS, 0xB7,     0x00,       P_586|P_K3D, 0)
ins (PSWAPD, pswapd,            OpCls( MMX,      MMX_M64,  NONE ), F_0F0F, 1,  no_WDS, 0xBB,     0x00,       P_586|P_K3D, 0)
#endif

#if SSE3SUPP
ins (ADDSUBPD, addsubpd,        OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0xD0,     0x00,       P_686|P_SSE3,0)
ins (ADDSUBPS, addsubps,        OpCls( XMM,      XMM_M128, NONE ), F_F20F, 1,  no_WDS, 0xD0,     0x00,       P_686|P_SSE3,0)
ins (FISTTP, fisttp,            OpCls( M32,      NONE,     NONE ), 0,      0,  no_WDS, 0xDB,     0x08,       P_686|P_SSE3,0)
insn(FISTTP, 1,                 OpCls( M64,      NONE,     NONE ), 0,      0,  no_WDS, 0xDD,     0x08,       P_686|P_SSE3,0)
insn(FISTTP, 2,                 OpCls( M16,      NONE,     NONE ), 0,      0,  no_WDS, 0xDF,     0x08,       P_686|P_SSE3,0)
ins (HADDPD, haddpd,            OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0x7C,     0x00,       P_686|P_SSE3,0)
ins (HADDPS, haddps,            OpCls( XMM,      XMM_M128, NONE ), F_F20F, 1,  no_WDS, 0x7C,     0x00,       P_686|P_SSE3,0)
ins (HSUBPD, hsubpd,            OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0x7D,     0x00,       P_686|P_SSE3,0)
ins (HSUBPS, hsubps,            OpCls( XMM,      XMM_M128, NONE ), F_F20F, 1,  no_WDS, 0x7D,     0x00,       P_686|P_SSE3,0)
ins (LDDQU, lddqu,              OpCls( XMM,      M128,     NONE ), F_F20F, 1,  no_WDS, 0xF0,     0x00,       P_686|P_SSE3,0)
ins (MONITOR, monitor,          OpCls( NONE,     NONE,     NONE ), F_0F,   0,  0,      0x01,     0xC8,       P_686|P_SSE3,0)
ins (MOVDDUP, movddup,          OpCls( XMM,      XMM_M64,  NONE ), F_F20F, 1,  no_WDS, 0x12,     0x00,       P_686|P_SSE3,0)
ins (MOVSHDUP, movshdup,        OpCls( XMM,      XMM_M128, NONE ), F_F30F, 1,  no_WDS, 0x16,     0x00,       P_686|P_SSE3,0)
ins (MOVSLDUP, movsldup,        OpCls( XMM,      XMM_M128, NONE ), F_F30F, 1,  no_WDS, 0x12,     0x00,       P_686|P_SSE3,0)
ins (MWAIT, mwait,              OpCls( NONE,     NONE,     NONE ), F_0F,   0,  0,      0x01,     0xC9,       P_686|P_SSE3,0)
#endif

#if SSSE3SUPP
ins (PABSB, pabsb,              OpCls( MMX,      MMX_M64,  NONE ), F_0F38,  1,  no_WDS, 0x1C,     0x00,       P_686|P_SSSE3, 0)
insn(PABSB, 1,                  OpCls( XMM,      XMM_M128, NONE ), F_660F38,1,  no_WDS, 0x1C,     0x00,       P_686|P_SSSE3, 0)
ins (PABSD, pabsd,              OpCls( MMX,      MMX_M64,  NONE ), F_0F38,  1,  no_WDS, 0x1E,     0x00,       P_686|P_SSSE3, 0)
insn(PABSD, 1,                  OpCls( XMM,      XMM_M128, NONE ), F_660F38,1,  no_WDS, 0x1E,     0x00,       P_686|P_SSSE3, 0)
ins (PABSW, pabsw,              OpCls( MMX,      MMX_M64,  NONE ), F_0F38,  1,  no_WDS, 0x1D,     0x00,       P_686|P_SSSE3, 0)
insn(PABSW, 1,                  OpCls( XMM,      XMM_M128, NONE ), F_660F38,1,  no_WDS, 0x1D,     0x00,       P_686|P_SSSE3, 0)
ins (PALIGNR, palignr,          OpCls( MMX,      MMX_M64,  I8_U ), F_0F3A,  1,  no_WDS, 0x0F,     0x00,       P_686|P_SSSE3, 0)
insn(PALIGNR, 1,                OpCls( XMM,      XMM_M128, I8_U ), F_660F3A,1,  no_WDS, 0x0F,     0x00,       P_686|P_SSSE3, 0)
ins (PHADDD, phaddd,            OpCls( MMX,      MMX_M64,  NONE ), F_0F38,  1,  no_WDS, 0x02,     0x00,       P_686|P_SSSE3, 0)
insn(PHADDD, 1,                 OpCls( XMM,      XMM_M128, NONE ), F_660F38,1,  no_WDS, 0x02,     0x00,       P_686|P_SSSE3, 0)
ins (PHADDSW, phaddsw,          OpCls( MMX,      MMX_M64,  NONE ), F_0F38,  1,  no_WDS, 0x03,     0x00,       P_686|P_SSSE3, 0)
insn(PHADDSW, 1,                OpCls( XMM,      XMM_M128, NONE ), F_660F38,1,  no_WDS, 0x03,     0x00,       P_686|P_SSSE3, 0)
ins (PHADDW, phaddw,            OpCls( MMX,      MMX_M64,  NONE ), F_0F38,  1,  no_WDS, 0x01,     0x00,       P_686|P_SSSE3, 0)
insn(PHADDW, 1,                 OpCls( XMM,      XMM_M128, NONE ), F_660F38,1,  no_WDS, 0x01,     0x00,       P_686|P_SSSE3, 0)
ins (PHSUBD, phsubd,            OpCls( MMX,      MMX_M64,  NONE ), F_0F38,  1,  no_WDS, 0x06,     0x00,       P_686|P_SSSE3, 0)
insn(PHSUBD, 1,                 OpCls( XMM,      XMM_M128, NONE ), F_660F38,1,  no_WDS, 0x06,     0x00,       P_686|P_SSSE3, 0)
ins (PHSUBSW, phsubsw,          OpCls( MMX,      MMX_M64,  NONE ), F_0F38,  1,  no_WDS, 0x07,     0x00,       P_686|P_SSSE3, 0)
insn(PHSUBSW, 1,                OpCls( XMM,      XMM_M128, NONE ), F_660F38,1,  no_WDS, 0x07,     0x00,       P_686|P_SSSE3, 0)
ins (PHSUBW, phsubw,            OpCls( MMX,      MMX_M64,  NONE ), F_0F38,  1,  no_WDS, 0x05,     0x00,       P_686|P_SSSE3, 0)
insn(PHSUBW, 1,                 OpCls( XMM,      XMM_M128, NONE ), F_660F38,1,  no_WDS, 0x05,     0x00,       P_686|P_SSSE3, 0)
ins (PMADDUBSW, pmaddubsw,      OpCls( MMX,      MMX_M64,  NONE ), F_0F38,  1,  no_WDS, 0x04,     0x00,       P_686|P_SSSE3, 0)
insn(PMADDUBSW, 1,              OpCls( XMM,      XMM_M128, NONE ), F_660F38,1,  no_WDS, 0x04,     0x00,       P_686|P_SSSE3, 0)
ins (PMULHRSW, pmulhrsw,        OpCls( MMX,      MMX_M64,  NONE ), F_0F38,  1,  no_WDS, 0x0B,     0x00,       P_686|P_SSSE3, 0)
insn(PMULHRSW, 1,               OpCls( XMM,      XMM_M128, NONE ), F_660F38,1,  no_WDS, 0x0B,     0x00,       P_686|P_SSSE3, 0)
ins (PSHUFB, pshufb,            OpCls( MMX,      MMX_M64,  NONE ), F_0F38,  1,  no_WDS, 0x00,     0x00,       P_686|P_SSSE3, 0)
insn(PSHUFB, 1,                 OpCls( XMM,      XMM_M128, NONE ), F_660F38,1,  no_WDS, 0x00,     0x00,       P_686|P_SSSE3, 0)
ins (PSIGNB, psignb,            OpCls( MMX,      MMX_M64,  NONE ), F_0F38,  1,  no_WDS, 0x08,     0x00,       P_686|P_SSSE3, 0)
insn(PSIGNB, 1,                 OpCls( XMM,      XMM_M128, NONE ), F_660F38,1,  no_WDS, 0x08,     0x00,       P_686|P_SSSE3, 0)
ins (PSIGND, psignd,            OpCls( MMX,      MMX_M64,  NONE ), F_0F38,  1,  no_WDS, 0x0A,     0x00,       P_686|P_SSSE3, 0)
insn(PSIGND, 1,                 OpCls( XMM,      XMM_M128, NONE ), F_660F38,1,  no_WDS, 0x0A,     0x00,       P_686|P_SSSE3, 0)
ins (PSIGNW, psignw,            OpCls( MMX,      MMX_M64,  NONE ), F_0F38,  1,  no_WDS, 0x09,     0x00,       P_686|P_SSSE3, 0)
insn(PSIGNW, 1,                 OpCls( XMM,      XMM_M128, NONE ), F_660F38,1,  no_WDS, 0x09,     0x00,       P_686|P_SSSE3, 0)
#endif
#if AMD64_SUPPORT
/* CDQE must be first in this group, see reswords.c */
insx(CDQE, cdqe,                OpCls( NONE,     NONE,       NONE ), F_48,   0,  no_RM,  0x98,     0x00,       P_64,       0,        RWF_X64)
insx(CQO, cqo,                  OpCls( NONE,     NONE,       NONE ), F_48,   0,  no_RM,  0x99,     0x00,       P_64,       0,        RWF_X64)
insx(PUSHFQ,pushfq,             OpCls( NONE,     NONE,       NONE ), 0,      0,  no_RM,  0x9C,     0x00,       P_64,       0,        RWF_X64)
insx(POPFQ, popfq,              OpCls( NONE,     NONE,       NONE ), 0,      0,  no_RM,  0x9D,     0x00,       P_64,       0,        RWF_X64)
insx(IRETQ, iretq,              OpCls( NONE,     NONE,       NONE ), F_48,   0,  no_RM,  0xCF,     0x00,       P_64,       0,        RWF_X64)
insx(CMPXCHG16B, cmpxchg16b,    OpCls( M128,     NONE,       NONE ), F_480F, 0,  0,      0xC7,     0x08,       P_64,       AP_LOCK,  RWF_X64)
insx(MOVSXD,movsxd,             OpCls( R64,      R32_M32,    NONE ), 0,      1,  0,      0x63,     0x00,       P_64,       0,        RWF_X64)

insx(CMPSQ, cmpsq,              OpCls( NONE,     NONE,       NONE ), F_48,   0,  no_RM,  0xA7,     0x00,       P_64,       AP_REPxx, RWF_X64)
insn(CMPSQ, 1,                  OpCls( M64,      M64,        NONE ), F_48,   0,  no_RM,  0xA7,     0x00,       P_64,       AP_REPxx)
insx(LODSQ, lodsq,              OpCls( NONE,     NONE,       NONE ), F_48,   0,  no_RM,  0xAD,     0x00,       P_64,       AP_REP,   RWF_X64)
insn(LODSQ, 1,                  OpCls( M64,      NONE,       NONE ), F_48,   0,  no_RM,  0xAD,     0x00,       P_64,       AP_REP  )
insx(MOVSQ, movsq,              OpCls( NONE,     NONE,       NONE ), F_48,   0,  no_RM,  0xA5,     0x00,       P_64,       AP_REP,   RWF_X64)
insn(MOVSQ, 1,                  OpCls( M64,      M64,        NONE ), F_48,   0,  no_RM,  0xA5,     0x00,       P_64,       AP_REP  )
insx(SCASQ, scasq,              OpCls( NONE,     NONE,       NONE ), F_48,   0,  no_RM,  0xAF,     0x00,       P_64,       AP_REPxx, RWF_X64)
insn(SCASQ, 1,                  OpCls( M64,      NONE,       NONE ), F_48,   0,  no_RM,  0xAF,     0x00,       P_64,       AP_REPxx)
insx(STOSQ, stosq,              OpCls( NONE,     NONE,       NONE ), F_48,   0,  no_RM,  0xAB,     0x00,       P_64,       AP_REP,   RWF_X64)
insn(STOSQ, 1,                  OpCls( M64,      NONE,       NONE ), F_48,   0,  no_RM,  0xAB,     0x00,       P_64,       AP_REP  )
#if SSE4SUPP
/* PEXTRQ/PINSRQ need a REX.W prefix if M64 is dst/src! */
insx(PEXTRQ, pextrq,            OpCls( R64_M64,  XMM,        I8_U ), F_660F3A,0, no_WDS, 0x16,     0x00,       P_64|P_SSE4,0,        RWF_X64)
insx(PINSRQ, pinsrq,            OpCls( XMM,      R64_M64,    I8_U ), F_660F3A,1, no_WDS, 0x22,     0x00,       P_64|P_SSE4,0,        RWF_X64)
#endif
insx(SWAPGS, swapgs,            OpCls( NONE,     NONE,       NONE ), F_0F,   0,  0,      0x01,     0xF8,       P_64,       0,        RWF_X64)
insx(SYSCALL_, syscall,         OpCls( NONE,     NONE,       NONE ), F_0F,   0,  no_RM,  0x05,     0x00,       P_64,       0,        RWF_X64)
insx(SYSRET, sysret,            OpCls( NONE,     NONE,       NONE ), F_0F,   0,  no_RM,  0x07,     0x00,       P_64,       0,        RWF_X64)
#if 0 /* v2.09: added, inactive ( not supported by ML64 v8,9,10 ) */
insx(FXRSTOR64, fxrstor64,      OpCls( M_ANY,    NONE,       NONE ), F_480F, 0,  no_WDS, 0xAE,     0x08,       P_64,       0,        RWF_X64)
insx(FXSAVE64, fxsave64,        OpCls( M_ANY,    NONE,       NONE ), F_480F, 0,  no_WDS, 0xAE,     0x00,       P_64,       0,        RWF_X64)
#if SSE4SUPP
insx(XRSTOR64, xrstor64,        OpCls( M_ANY,    NONE,       NONE ), F_480F, 0,  no_WDS, 0xAE,     0x28,       P_64|P_SSE4,0,        RWF_X64)
insx(XSAVE64, xsave64,          OpCls( M_ANY,    NONE,       NONE ), F_480F, 0,  no_WDS, 0xAE,     0x20,       P_64|P_SSE4,0,        RWF_X64)
insx(XSAVEOPT64, xsaveopt64,    OpCls( M_ANY,    NONE,       NONE ), F_480F, 0,  no_WDS, 0xAE,     0x30,       P_64|P_SSE4,0,        RWF_X64)
#endif
#endif
#endif

#if SSE4SUPP
/* SSE4.1 */
ins (BLENDPD, blendpd,          OpCls( XMM,      XMM_M128, I8_U ), F_660F3A, 1,  no_WDS, 0x0D,     0x00,       P_686|P_SSE4, 0)
ins (BLENDPS, blendps,          OpCls( XMM,      XMM_M128, I8_U ), F_660F3A, 1,  no_WDS, 0x0C,     0x00,       P_686|P_SSE4, 0)
ins (BLENDVPD, blendvpd,        OpCls( XMM,      XMM_M128, XMM0 ), F_660F38, 1,  no_WDS, 0x15,     0x00,       P_686|P_SSE4, 0)
ins (BLENDVPS, blendvps,        OpCls( XMM,      XMM_M128, XMM0 ), F_660F38, 1,  no_WDS, 0x14,     0x00,       P_686|P_SSE4, 0)
ins (DPPD, dppd,                OpCls( XMM,      XMM_M128, I8_U ), F_660F3A, 1,  no_WDS, 0x41,     0x00,       P_686|P_SSE4, 0)
ins (DPPS, dpps,                OpCls( XMM,      XMM_M128, I8_U ), F_660F3A, 1,  no_WDS, 0x40,     0x00,       P_686|P_SSE4, 0)
ins (EXTRACTPS, extractps,      OpCls( RGT16,    XMM,      I8_U ), F_660F3A, 0,  no_WDS, 0x17,     0x00,       P_686|P_SSE4, 0)
insn(EXTRACTPS, 1,              OpCls( M32,      XMM,      I8_U ), F_660F3A, 0,  no_WDS, 0x17,     0x00,       P_686|P_SSE4, 0)
ins (INSERTPS, insertps,        OpCls( XMM,      XMM_M32,  I8_U ), F_660F3A, 1,  no_WDS, 0x21,     0x00,       P_686|P_SSE4, 0)
ins (MOVNTDQA, movntdqa,        OpCls( XMM,      M128,     NONE ), F_660F38, 1,  no_WDS, 0x2A,     0x00,       P_686|P_SSE4, 0)
ins (MPSADBW, mpsadbw,          OpCls( XMM,      XMM_M128, I8_U ), F_660F3A, 1,  no_WDS, 0x42,     0x00,       P_686|P_SSE4, 0)
ins (PACKUSDW, packusdw,        OpCls( XMM,      XMM_M128, NONE ), F_660F38, 1,  no_WDS, 0x2B,     0x00,       P_686|P_SSE4, 0)
ins (PBLENDVB, pblendvb,        OpCls( XMM,      XMM_M128, XMM0 ), F_660F38, 1,  no_WDS, 0x10,     0x00,       P_686|P_SSE4, 0)
ins (PBLENDW, pblendw,          OpCls( XMM,      XMM_M128, I8_U ), F_660F3A, 1,  no_WDS, 0x0E,     0x00,       P_686|P_SSE4, 0)
ins (PCMPEQQ, pcmpeqq,          OpCls( XMM,      XMM_M128, NONE ), F_660F38, 1,  no_WDS, 0x29,     0x00,       P_686|P_SSE4, 0)
ins (PEXTRB, pextrb,            OpCls( RGT16_M08,XMM,      I8_U ), F_660F3A, 0,  no_WDS, 0x14,     0x00,       P_686|P_SSE4, 0)
ins (PEXTRD, pextrd,            OpCls( R32_M32,  XMM,      I8_U ), F_660F3A, 0,  no_WDS, 0x16,     0x00,       P_686|P_SSE4, 0)
ins (PHMINPOSUW, phminposuw,    OpCls( XMM,      XMM_M128, NONE ), F_660F38, 1,  no_WDS, 0x41,     0x00,       P_686|P_SSE4, 0)
ins (PINSRB, pinsrb,            OpCls( XMM,      R32_M08,  I8_U ), F_660F3A, 1,  no_WDS, 0x20,     0x00,       P_686|P_SSE4, 0)
ins (PINSRD, pinsrd,            OpCls( XMM,      R32_M32,  I8_U ), F_660F3A, 1,  no_WDS, 0x22,     0x00,       P_686|P_SSE4, 0)
ins (PMAXSB, pmaxsb,            OpCls( XMM,      XMM_M128, NONE ), F_660F38, 1,  no_WDS, 0x3C,     0x00,       P_686|P_SSE4, 0)
ins (PMAXSD, pmaxsd,            OpCls( XMM,      XMM_M128, NONE ), F_660F38, 1,  no_WDS, 0x3D,     0x00,       P_686|P_SSE4, 0)
ins (PMAXUW, pmaxuw,            OpCls( XMM,      XMM_M128, NONE ), F_660F38, 1,  no_WDS, 0x3E,     0x00,       P_686|P_SSE4, 0)
ins (PMAXUD, pmaxud,            OpCls( XMM,      XMM_M128, NONE ), F_660F38, 1,  no_WDS, 0x3F,     0x00,       P_686|P_SSE4, 0)
ins (PMINSB, pminsb,            OpCls( XMM,      XMM_M128, NONE ), F_660F38, 1,  no_WDS, 0x38,     0x00,       P_686|P_SSE4, 0)
ins (PMINSD, pminsd,            OpCls( XMM,      XMM_M128, NONE ), F_660F38, 1,  no_WDS, 0x39,     0x00,       P_686|P_SSE4, 0)
ins (PMINUW, pminuw,            OpCls( XMM,      XMM_M128, NONE ), F_660F38, 1,  no_WDS, 0x3A,     0x00,       P_686|P_SSE4, 0)
ins (PMINUD, pminud,            OpCls( XMM,      XMM_M128, NONE ), F_660F38, 1,  no_WDS, 0x3B,     0x00,       P_686|P_SSE4, 0)
ins (PMOVSXBW, pmovsxbw,        OpCls( XMM,      XMM_M64,  NONE ), F_660F38, 1,  no_WDS, 0x20,     0x00,       P_686|P_SSE4, 0)
ins (PMOVSXBD, pmovsxbd,        OpCls( XMM,      XMM_M32,  NONE ), F_660F38, 1,  no_WDS, 0x21,     0x00,       P_686|P_SSE4, 0)
ins (PMOVSXBQ, pmovsxbq,        OpCls( XMM,      XMM_M16,  NONE ), F_660F38, 1,  no_WDS, 0x22,     0x00,       P_686|P_SSE4, 0)
ins (PMOVSXWD, pmovsxwd,        OpCls( XMM,      XMM_M64,  NONE ), F_660F38, 1,  no_WDS, 0x23,     0x00,       P_686|P_SSE4, 0)
ins (PMOVSXWQ, pmovsxwq,        OpCls( XMM,      XMM_M32,  NONE ), F_660F38, 1,  no_WDS, 0x24,     0x00,       P_686|P_SSE4, 0)
ins (PMOVSXDQ, pmovsxdq,        OpCls( XMM,      XMM_M64,  NONE ), F_660F38, 1,  no_WDS, 0x25,     0x00,       P_686|P_SSE4, 0)
ins (PMOVZXBW, pmovzxbw,        OpCls( XMM,      XMM_M64,  NONE ), F_660F38, 1,  no_WDS, 0x30,     0x00,       P_686|P_SSE4, 0)
ins (PMOVZXBD, pmovzxbd,        OpCls( XMM,      XMM_M32,  NONE ), F_660F38, 1,  no_WDS, 0x31,     0x00,       P_686|P_SSE4, 0)
ins (PMOVZXBQ, pmovzxbq,        OpCls( XMM,      XMM_M16,  NONE ), F_660F38, 1,  no_WDS, 0x32,     0x00,       P_686|P_SSE4, 0)
ins (PMOVZXWD, pmovzxwd,        OpCls( XMM,      XMM_M64,  NONE ), F_660F38, 1,  no_WDS, 0x33,     0x00,       P_686|P_SSE4, 0)
ins (PMOVZXWQ, pmovzxwq,        OpCls( XMM,      XMM_M32,  NONE ), F_660F38, 1,  no_WDS, 0x34,     0x00,       P_686|P_SSE4, 0)
ins (PMOVZXDQ, pmovzxdq,        OpCls( XMM,      XMM_M64,  NONE ), F_660F38, 1,  no_WDS, 0x35,     0x00,       P_686|P_SSE4, 0)
ins (PMULDQ, pmuldq,            OpCls( XMM,      XMM_M128, NONE ), F_660F38, 1,  no_WDS, 0x28,     0x00,       P_686|P_SSE4, 0)
ins (PMULLD, pmulld,            OpCls( XMM,      XMM_M128, NONE ), F_660F38, 1,  no_WDS, 0x40,     0x00,       P_686|P_SSE4, 0)
ins (PTEST, ptest,              OpCls( XMM,      XMM_M128, NONE ), F_660F38, 1,  no_WDS, 0x17,     0x00,       P_686|P_SSE4, 0)
ins (ROUNDPS, roundps,          OpCls( XMM,      XMM_M128, I8_U ), F_660F3A, 1,  no_WDS, 0x08,     0x00,       P_686|P_SSE4, 0)
ins (ROUNDPD, roundpd,          OpCls( XMM,      XMM_M128, I8_U ), F_660F3A, 1,  no_WDS, 0x09,     0x00,       P_686|P_SSE4, 0)
ins (ROUNDSS, roundss,          OpCls( XMM,      XMM_M32 , I8_U ), F_660F3A, 1,  no_WDS, 0x0A,     0x00,       P_686|P_SSE4, 0)
ins (ROUNDSD, roundsd,          OpCls( XMM,      XMM_M64 , I8_U ), F_660F3A, 1,  no_WDS, 0x0B,     0x00,       P_686|P_SSE4, 0)
/* SSE4.2 */
ins (CRC32, crc32,              OpCls( RGT16,    R8_M08,   NONE ), F_F20F38, 1,  no_WDS, 0xF0,     0x00,       P_686|P_SSE4, 0)
insn(CRC32, 1,                  OpCls( RGT16,    RGT8_MS,  NONE ), F_F20F38, 1,  no_WDS, 0xF1,     0x00,       P_686|P_SSE4, 0)
ins (PCMPESTRM, pcmpestrm,      OpCls( XMM,      XMM_M128, I8_U ), F_660F3A, 1,  no_WDS, 0x60,     0x00,       P_686|P_SSE4, 0)
ins (PCMPESTRI, pcmpestri,      OpCls( XMM,      XMM_M128, I8_U ), F_660F3A, 1,  no_WDS, 0x61,     0x00,       P_686|P_SSE4, 0)
ins (PCMPISTRM, pcmpistrm,      OpCls( XMM,      XMM_M128, I8_U ), F_660F3A, 1,  no_WDS, 0x62,     0x00,       P_686|P_SSE4, 0)
ins (PCMPISTRI, pcmpistri,      OpCls( XMM,      XMM_M128, I8_U ), F_660F3A, 1,  no_WDS, 0x63,     0x00,       P_686|P_SSE4, 0)
ins (PCMPGTQ, pcmpgtq,          OpCls( XMM,      XMM_M128, NONE ), F_660F38, 1,  no_WDS, 0x37,     0x00,       P_686|P_SSE4, 0)
ins (POPCNT, popcnt,            OpCls( RGT8,     RGT8_MS,  NONE ), F_F30F,   1,  no_WDS ,0xB8,     0x00,       P_686|P_SSE4, 0)
#if 0
/* SSE4A (AMD only). */
/* disabled because INSERTQ needs 4 arguments, which JWasm cannot support currently */
ins (EXTRQ, extrq,              OpCls( XMM,      I8_U,     I8_U ), F_660F, 0,  no_WDS ,0x78,     0x00,       P_686|P_SSE4, 0)
ins (INSERTQ, insertq,          OpCls( XMM,      XMM,      I8_U ), F_F20F, 0,  no_WDS ,0x78,     0x00,       P_686|P_SSE4, 0)
ins (LZCNT, lzcnt,              OpCls( RGT8,     RGT8_MS,  NONE ), F_F30F, 1,  no_WDS ,0xBD,     0x00,       P_686|P_SSE4, 0)
ins (MOVNTSD, movntsd,          OpCls( M64,      XMM,      NONE ), F_F20F, 0,  no_WDS ,0x2B,     0x00,       P_686|P_SSE4, 0)
ins (MOVNTSS, movntss,          OpCls( M32,      XMM,      NONE ), F_F30F, 0,  no_WDS ,0x2B,     0x00,       P_686|P_SSE4, 0)
#endif
/* v2.06: added xrstor, xsave, xgetbv, xsetbv */
ins (XRSTOR, xrstor,            OpCls( M_ANY,    NONE,       NONE ), F_0F,   0,  no_WDS, 0xAE,     0x28,     P_686|P_SSE4,0)
ins (XSAVE, xsave,              OpCls( M_ANY,    NONE,       NONE ), F_0F,   0,  no_WDS, 0xAE,     0x20,     P_686|P_SSE4,0)
ins (XSAVEOPT, xsaveopt,        OpCls( M_ANY,    NONE,       NONE ), F_0F,   0,  no_WDS, 0xAE,     0x30,     P_686|P_SSE4,0)
ins (XGETBV, xgetbv,            OpCls( NONE,     NONE,       NONE ), F_0F,   0,  no_WDS, 0x01,     0xD0,     P_686|P_SSE4,0)
ins (XSETBV, xsetbv,            OpCls( NONE,     NONE,       NONE ), F_0F,   0,  no_WDS, 0x01,     0xD1,     P_686p|P_SSE4,0)
#endif
#if VMXSUPP
/* v2.09: added */
ins (VMCALL,  vmcall,           OpCls( NONE,     NONE,       NONE ), F_0F,   0,  0,      0x01,     0xC1,     P_686, 0)
ins (VMLAUNCH,vmlaunch,         OpCls( NONE,     NONE,       NONE ), F_0F,   0,  0,      0x01,     0xC2,     P_686p,0)
ins (VMRESUME,vmresume,         OpCls( NONE,     NONE,       NONE ), F_0F,   0,  0,      0x01,     0xC3,     P_686p,0)
ins (VMXOFF,  vmxoff,           OpCls( NONE,     NONE,       NONE ), F_0F,   0,  0,      0x01,     0xC4,     P_686p,0)
ins (VMPTRLD, vmptrld,          OpCls( M64,      NONE,       NONE ), F_0F,   0,  no_WDS, 0xC7,     0x30,     P_686p,0)
ins (VMPTRST, vmptrst,          OpCls( M64,      NONE,       NONE ), F_0F,   0,  no_WDS, 0xC7,     0x38,     P_686p,0)
ins (VMCLEAR, vmclear,          OpCls( M64,      NONE,       NONE ), F_660F, 0,  no_WDS, 0xC7,     0x30,     P_686p,0)
ins (VMXON,   vmxon,            OpCls( M64,      NONE,       NONE ), F_F30F, 0,  no_WDS, 0xC7,     0x30,     P_686p,0)
ins (VMREAD,  vmread,           OpCls( R32_M32,  R32,        NONE ), F_0F,   0,  no_WDS, 0x78,     0x00,     P_686p,0)
ins (VMWRITE, vmwrite,          OpCls( R32,      R32_M32,    NONE ), F_0F,   1,  no_WDS, 0x79,     0x00,     P_686p,0)
ins (INVEPT,  invept,           OpCls( RGT16,    M128,       NONE ), F_660F38,1, no_WDS, 0x80,     0x00,     P_686p,0)
ins (INVVPID, invvpid,          OpCls( RGT16,    M128,       NONE ), F_660F38,1, no_WDS, 0x81,     0x00,     P_686p,0)
#endif
#if SVMSUPP
/* v2.09: added, but inactive */
ins (VMRUN,   vmrun,            OpCls( A,        NONE,       NONE ), F_0F,   0,  no_WDS, 0x01,     0xD8,     P_686p,0)
ins (VMMCALL, vmmcall,          OpCls( NONE,     NONE,       NONE ), F_0F,   0,  0,      0x01,     0xD9,     P_686, 0)
ins (VMLOAD,  vmload,           OpCls( A,        NONE,       NONE ), F_0F,   0,  no_WDS, 0x01,     0xDA,     P_686p,0)
ins (VMSAVE,  vmsave,           OpCls( A,        NONE,       NONE ), F_0F,   0,  no_WDS, 0x01,     0xDB,     P_686p,0)
ins (STGI,    stgi,             OpCls( NONE,     NONE,       NONE ), F_0F,   0,  0,      0x01,     0xDC,     P_686p,0)
ins (CLGI,    clgi,             OpCls( NONE,     NONE,       NONE ), F_0F,   0,  0,      0x01,     0xDD,     P_686p,0)
ins (SKINIT,  skinit,           OpCls( A,        NONE,       NONE ), F_0F,   0,  no_WDS, 0x01,     0xDE,     P_686p,0)
ins (INVLPGA, invlpga,          OpCls( A,        R32,        NONE ), F_0F,   0,  no_WDS, 0x01,     0xDF,     P_686p,0)
#endif
#if AVXSUPP
/* VBROADCASTSS is first VEX encoded instruction (VEX_START in parser.h).
 * Important: currently vex_flags[] in reswords.c must match the order here!
 * (this is to be improved).
 * Most AVX instructions that also have a "legacy" encoding are not listed
 * here but are contained in instravx.h!. Exceptions:
 * - VBLENDVPD, VBLENDVPS, VPBLENDVB ( they use a different opcode in VEX )
 * - VCVT[T]PD* ( they expect a mix of xmm and ymm/m256 arguments )
 */
insx(VBROADCASTSS, vbroadcastss,       OpCls( XMM,      M32,        NONE ), F_660F38,1,  no_WDS, 0x18,     0x00,     P_686|P_AVX, 0, RWF_VEX )
insn(VBROADCASTSS, 1,                  OpCls( YMM,      M32,        NONE ), F_660F38,1,  no_WDS, 0x18,     0x00,     P_686|P_AVX, 0)
insx(VBROADCASTSD, vbroadcastsd,       OpCls( YMM,      M64,        NONE ), F_660F38,1,  no_WDS, 0x19,     0x00,     P_686|P_AVX, 0, RWF_VEX )
insx(VBROADCASTF128, vbroadcastf128,   OpCls( YMM,      M128,       NONE ), F_660F38,1,  no_WDS, 0x1A,     0x00,     P_686|P_AVX, 0, RWF_VEX )
insx(VBLENDVPD, vblendvpd,             OpCls( XMM,      XMM_M128,   XMM  ), F_660F3A,1,  no_WDS, 0x4B,     0x00,     P_686|P_AVX, 0, RWF_VEX )
insx(VBLENDVPS, vblendvps,             OpCls( XMM,      XMM_M128,   XMM  ), F_660F3A,1,  no_WDS, 0x4A,     0x00,     P_686|P_AVX, 0, RWF_VEX )
insx(VINSERTF128, vinsertf128,         OpCls( YMM,      XMM_M128,   I8_U ), F_660F3A,1,  no_WDS, 0x18,     0x00,     P_686|P_AVX, 0, RWF_VEX )
insx(VEXTRACTF128, vextractf128,       OpCls( XMM,      YMM,        I8_U ), F_660F3A,0,  no_WDS, 0x19,     0x00,     P_686|P_AVX, 0, RWF_VEX )
insn(VEXTRACTF128, 1,                  OpCls( M128,     YMM,        I8_U ), F_660F3A,0,  no_WDS, 0x19,     0x00,     P_686|P_AVX, 0)
insx(VMASKMOVPS, vmaskmovps,           OpCls( XMM,      XMM_M128,   NONE ), F_660F38,1,  no_WDS, 0x2C,     0x00,     P_686|P_AVX, 0, RWF_VEX )
insn(VMASKMOVPS, 1,                    OpCls( M128,     XMM,        NONE ), F_660F38,0,  no_WDS, 0x2E,     0x00,     P_686|P_AVX, 0)
insx(VMASKMOVPD, vmaskmovpd,           OpCls( XMM,      XMM_M128,   NONE ), F_660F38,1,  no_WDS, 0x2D,     0x00,     P_686|P_AVX, 0, RWF_VEX )
insn(VMASKMOVPD, 1,                    OpCls( M128,     XMM,        NONE ), F_660F38,0,  no_WDS, 0x2F,     0x00,     P_686|P_AVX, 0)
insx(VPBLENDVB, vpblendvb,             OpCls( XMM,      XMM_M128,   XMM  ), F_660F3A,1,  no_WDS, 0x4C,     0x00,     P_686|P_AVX, 0, RWF_VEX )
insx(VPERMILPD, vpermilpd,             OpCls( XMM,      XMM_M128,   NONE ), F_660F38,1,  no_WDS, 0x0D,     0x00,     P_686|P_AVX, 0, RWF_VEX )
insn(VPERMILPD, 1,                     OpCls( XMM,      XMM_M128,   I8_U ), F_660F3A,1,  no_WDS, 0x0D,     0x00,     P_686|P_AVX, 0)
insx(VPERMILPS, vpermilps,             OpCls( XMM,      XMM_M128,   NONE ), F_660F38,1,  no_WDS, 0x0C,     0x00,     P_686|P_AVX, 0, RWF_VEX )
insn(VPERMILPS, 1,                     OpCls( XMM,      XMM_M128,   I8_U ), F_660F3A,1,  no_WDS, 0x0C,     0x00,     P_686|P_AVX, 0)
/* the VPERMIL2xx instructions were dropped */
//insx(VPERMIL2PD, vpermil2pd,           OpCls( XMM,      XMM_M128,   XMM  ), F_660F3A,1,  no_WDS, 0x49,     0x00,     P_686|P_AVX, 0, RWF_VEX )
//insx(VPERMIL2PS, vpermil2ps,           OpCls( XMM,      XMM_M128,   XMM  ), F_660F3A,1,  no_WDS, 0x48,     0x00,     P_686|P_AVX, 0, RWF_VEX )
insx(VPERM2F128, vperm2f128,           OpCls( YMM,      YMM_M256,   I8_U ), F_660F3A,1,  no_WDS, 0x06,     0x00,     P_686|P_AVX, 0, RWF_VEX )
insx(VTESTPS, vtestps,                 OpCls( XMM,      XMM_M128,   NONE ), F_660F38,1,  no_WDS, 0x0E,     0x00,     P_686|P_AVX, 0, RWF_VEX )
insx(VTESTPD, vtestpd,                 OpCls( XMM,      XMM_M128,   NONE ), F_660F38,1,  no_WDS, 0x0F,     0x00,     P_686|P_AVX, 0, RWF_VEX )
insx(VZEROALL, vzeroall,               OpCls( NONE,     NONE,       NONE ), F_0F,    0,  no_RM,  0x77,     0x00,     P_686|P_AVX, 0, RWF_VEX )
insx(VZEROUPPER, vzeroupper,           OpCls( NONE,     NONE,       NONE ), F_0F,    0,  no_RM,  0x77,     0x00,     P_686|P_AVX, 0, RWF_VEX )
insx(VCVTPD2DQ, vcvtpd2dq,             OpCls( XMM,      XMM_M128,   NONE ), F_F20F,  1,  no_WDS, 0xE6,     0x00,     P_686|P_AVX, 0, RWF_VEX )
insn(VCVTPD2DQ, 1,                     OpCls( XMM,      YMM_M256,   NONE ), F_F20F,  1,  no_WDS, 0xE6,     0x00,     P_686|P_AVX, 0)
insx(VCVTTPD2DQ, vcvttpd2dq,           OpCls( XMM,      XMM_M128,   NONE ), F_660F,  1,  no_WDS, 0xE6,     0x00,     P_686|P_AVX, 0, RWF_VEX )
insn(VCVTTPD2DQ, 1,                    OpCls( XMM,      YMM_M256,   NONE ), F_660F,  1,  no_WDS, 0xE6,     0x00,     P_686|P_AVX, 0)
insx(VCVTPD2PS, vcvtpd2ps,             OpCls( XMM,      XMM_M128,   NONE ), F_660F,  1,  no_WDS, 0x5A,     0x00,     P_686|P_AVX, 0, RWF_VEX )
insn(VCVTPD2PS, 1,                     OpCls( XMM,      YMM_M256,   NONE ), F_660F,  1,  no_WDS, 0x5A,     0x00,     P_686|P_AVX, 0)
insx(VMOVDDUP, vmovddup,               OpCls( XMM,      XMM_M64,    NONE ), F_F20F,  1,  no_WDS, 0x12,     0x00,     P_686|P_AVX, 0, RWF_VEX )
insn(VMOVDDUP, 1,                      OpCls( YMM,      YMM_M256,   NONE ), F_F20F,  1,  no_WDS, 0x12,     0x00,     P_686|P_AVX, 0)
/* v2.11: added here, removed in instravx.h */
insx(VMOVMSKPD, vmovmskpd,             OpCls( RGT16,    XMM,        NONE ), F_660F,  1,  no_WDS, 0x50,     0x00,     P_686|P_AVX, 0, RWF_VEX )
insn(VMOVMSKPD, 1,                     OpCls( RGT16,    YMM,        NONE ), F_660F,  1,  no_WDS, 0x50,     0x00,     P_686|P_AVX, 0)
insx(VMOVMSKPS, vmovmskps,             OpCls( RGT16,    XMM,        NONE ), F_0F,    1,  no_WDS, 0x50,     0x00,     P_686|P_AVX, 0, RWF_VEX )
insn(VMOVMSKPS, 1,                     OpCls( RGT16,    YMM,        NONE ), F_0F,    1,  no_WDS, 0x50,     0x00,     P_686|P_AVX, 0)
#endif
