
%if 0

lDebug string keyword comparison

Copyright (C) 1995-2003 Paul Vojta
Copyright (C) 2008-2023 C. Masloch

Usage of the works is permitted provided that this
instrument is retained with the works, so that any entity
that uses the works is notified of this instrument.

DISCLAIMER: THE WORKS ARE WITHOUT WARRANTY.

%endif


		; Check for given string (cap-insensitive)
		;
		; INP:	ds:si -> input string to check (either cap),
		;	 terminated by CR (13), NUL, semicolon, space,
		;	 tab, dot, comma, equals, colon, [, ], (, or )
		;	es:dx -> ASCIZ string to check (all-caps)
		; OUT:	Iff string matches,
		;	 ZR
		;	 si -> at separator that terminates the keyword
		;	else,
		;	 NZ
		;	 si = input si
		; STT:	ds = es = ss
		; CHG:	dx, al
%[PREFIX]isstring?:
	push si
	xchg dx, di
.loop:
	lodsb
	call %[PREFIX]uppercase
	scasb
	jne .mismatch
	test al, al
	jne .loop
	jmp .matched_zr

.mismatch:
	call %[PREFIX]iseol?
	je .checkend
	cmp al, 32
	je .checkend
	cmp al, 9
	je .checkend
	cmp al, '.'
	je .checkend
	cmp al, ','
	je .checkend
	cmp al, '='
	je .checkend
	cmp al, ':'
	je .checkend
	cmp al, '['
	je .checkend
	cmp al, ']'
	je .checkend
	cmp al, '('
	je .checkend
	cmp al, ')'
	je .checkend
%ifidni PREFIX, init_
	cmp al, byte [ss:swch1]
	je .checkend
%endif
.ret_nz:
		; NZ
	pop si
.ret:
	xchg dx, di
	retn

.checkend:
	cmp byte [es:di - 1], 0
	jne .ret_nz
.matched_zr:	; ZR
	pop di			; (discard)
	lea si, [si - 1]	; -> separator (preserve ZR)
	jmp .ret


%[PREFIX]uppercase: section_of_function
	cmp al, 'a'
	jb .ret
	cmp al, 'z'
	ja .ret
	and al, TOUPPER
.ret:
	retn

%ifempty PREFIX
iseol?_or_then:
 %if _INPUT_FILE_HANDLES || _INPUT_FILE_BOOT
	testopt [internalflags3], dif3_in_if
	jz iseol?
	mov dx, msg.then
	dec si
	call isstring?
	je iseol?.ret
	lodsb
 %endif
%endif

%[PREFIX]iseol?:
	cmp al, ';'
	je .ret
.notsemicolon:
	cmp al, 13		; this *IS* iseol?
	je .ret
	cmp al, 0
.ret:
	retn
