#include "x64Instructions.h"

const char * const opcodeTable[626] = {
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"aaa",
	"aad",
	"aam",
	"aas",
	"adc",
	"add",
	"and",
	"arpl",
	"bound",
	"bsf",
	"bsr",
	"bswap",
	"bt",
	"btc",
	"btr",
	"bts",
	"call",
	"cbw",
	"cdq",
	"cdqe",
	"clc",
	"cld",
	"cli",
	"clts",
	"cmc",
	"cmova",
	"cmovae",
	"cmovb",
	"cmovbe",
	"cmovc",
	"cmove",
	"cmovg",
	"cmovge",
	"cmovl",
	"cmovle",
	"cmovna",
	"cmovnae",
	"cmovnb",
	"cmovnbe",
	"cmovnc",
	"cmovne",
	"cmovng",
	"cmovnge",
	"cmovnl",
	"cmovnle",
	"cmovno",
	"cmovnp",
	"cmovns",
	"cmovnz",
	"cmovo",
	"cmovp",
	"cmovpe",
	"cmovpo",
	"cmovs",
	"cmovz",
	"cmp",
	"cmps",
	"cmpsb",
	"cmpsw",
	"cmpsd",
	"cmpsq",
	"cmpxchg",
	"cmpxchg8b",
	"cmpxchg16b",
	"cpuid",
	"cqo",
	"cwd",
	"cwde",
	"daa",
	"das",
	"dec",
	"div",
	"enter",
	"esc",
	"f2xm1",
	"fabs",
	"fadd",
	"faddp",
	"fbld",
	"fbstp",
	"fchs",
	"fclex",
	"fnclex",
	"fcmovb",
	"fcmovbe",
	"fcmove",
	"fcmovnb",
	"fcmovnbe",
	"fcmovne",
	"fcmovnu",
	"fcmovu",
	"fcom",
	"fcomi",
	"fcomip",
	"fcomp",
	"fcompp",
	"fcos",
	"fdecstp",
	"fdisi",
	"fdiv",
	"fdivp",
	"fdivr",
	"fdivrp",
	"feni",
	"ffree",
	"ffreep",
	"fiadd",
	"ficom",
	"ficomp",
	"fidiv",
	"fidivr",
	"fild",
	"fimul",
	"fincstp",
	"finit",
	"fninit",
	"fist",
	"fistp",
	"fisub",
	"fisubr",
	"fld",
	"fld1",
	"fldcw",
	"fldenv",
	"fldl2e",
	"fldl2t",
	"fldlg2",
	"fldln2",
	"fldpi",
	"fldz",
	"fmul",
	"fmulp",
	"fnop",
	"fnsave",
	"fpatan",
	"fprem",
	"fprem1",
	"fptan",
	"frndint",
	"frstor",
	"fsave",
	"fscale",
	"fsetpm",
	"fsin",
	"fsincos",
	"fsqrt",
	"fst",
	"fstcw",
	"fnstcw",
	"fstenv",
	"fnstenv",
	"fstp",
	"fstsw",
	"fnstsw",
	"fsub",
	"fsubp",
	"fsubr",
	"fsubrp",
	"ftst",
	"fucom",
	"fucomi",
	"fucomip",
	"fucomp",
	"fucompp",
	"fwait",
	"fxam",
	"fxch",
	"fxch4",
	"fxch7",
	"fxrstor",
	"fxsave",
	"fxtract",
	"fyl2x",
	"fyl2xp1",
	"hlt",
	"icebp",
	"idiv",
	"imul",
	"in",
	"ins",
	"insb",
	"insw",
	"insd",
	"inc",
	"int",
	"int1",
	"int3",
	"into",
	"invd",
	"invlpg",
	"iret",
	"iretw",
	"iretd",
	"iretq",
	"ja",
	"jae",
	"jb",
	"jbe",
	"jc",
	"jcxz",
	"jecxz",
	"je",
	"jg",
	"jge",
	"jl",
	"jle",
	"jmp",
	"jna",
	"jnae",
	"jnb",
	"jnbe",
	"jnc",
	"jne",
	"jng",
	"jnge",
	"jnl",
	"jnle",
	"jno",
	"jnp",
	"jns",
	"jnz",
	"jo",
	"jp",
	"jpe",
	"jpo",
	"js",
	"jz",
	"lahf",
	"lar",
	"lds",
	"lea",
	"leave",
	"les",
	"lfence",
	"lfs",
	"lgdt",
	"lgs",
	"lidt",
	"lldt",
	"lmsw",
	"lods",
	"lodsb",
	"lodsw",
	"lodsd",
	"lodsq",
	"loop",
	"loope",
	"loopne",
	"loopnz",
	"loopz",
	"lsl",
	"lss",
	"ltr",
	"mov",
	"movs",
	"movbe",
	"movsb",
	"movsw",
	"movsd",
	"movsq",
	"movsx",
	"movzx",
	"movsxd",
	"mul",
	"neg",
	"nop",
	"not",
	"or",
	"out",
	"outs",
	"outsb",
	"outsw",
	"outsd",
	"pop",
	"popa",
	"popaw",
	"popad",
	"popcnt",
	"popf",
	"popfw",
	"popfd",
	"popfq",
	"prefetchnta",
	"prefetcht0",
	"prefetcht1",
	"prefetcht2",
	"push",
	"pusha",
	"pushaw",
	"pushad",
	"pushf",
	"pushfw",
	"pushfd",
	"pushfq",
	"rcl",
	"rcr",
	"rdmsr",
	"rdpmc",
	"rdtsc",
	"ret",
	"retf",
	"rol",
	"ror",
	"rsm",
	"sahf",
	"sal",
	"sar",
	"sbb",
	"scas",
	"scasb",
	"scasw",
	"scasd",
	"scasq",
	"seta",
	"setae",
	"setb",
	"setbe",
	"setc",
	"sete",
	"setg",
	"setge",
	"setl",
	"setle",
	"setna",
	"setnae",
	"setnb",
	"setnbe",
	"setnc",
	"setne",
	"setng",
	"setnge",
	"setnl",
	"setnle",
	"setno",
	"setnp",
	"setns",
	"setnz",
	"seto",
	"setp",
	"setpe",
	"setpo",
	"sets",
	"setz",
	"sfence",
	"sgdt",
	"shl",
	"shld",
	"shr",
	"shrd",
	"sidt",
	"sldt",
	"smsw",
	"stc",
	"std",
	"sti",
	"stos",
	"stosb",
	"stosw",
	"stosd",
	"stosq",
	"str",
	"sub",
	"syscall",
	"sysenter",
	"sysexit",
	"sysret",
	"test",
	"ud2",
	"verr",
	"verw",
	"wait",
	"wbinvd",
	"wrmsr",
	"xadd",
	"xchg",
	"xlat",
	"xlatb",
	"xor",
	"xrstor",
	"xrstor64",
	"xsave",
	"xsave64",
	"xsetbv",
	"addpd",
	"addps",
	"addsd",
	"addss",
	"addsubpd",
	"addsubps",
	"andnpd",
	"andnps",
	"andpd",
	"andps",
	"blendpd",
	"blendps",
	"cmppd",
	"cmpps",
	"cvtdq2pd",
	"cvtdq2ps",
	"cvtpd2dq",
	"cvtpd2pi",
	"cvtpd2ps",
	"cvtpi2pd",
	"cvtpi2ps",
	"cvtps2dq",
	"cvtps2pd",
	"cvtps2pi",
	"cvtsd2si",
	"cvtsd2ss",
	"cvtsi2sd",
	"cvtsi2ss",
	"cvtss2sd",
	"cvtss2si",
	"cvttpd2dq",
	"cvttpd2pi",
	"cvttps2dq",
	"cvttps2pi",
	"cvttsd2si",
	"cvttss2si",
	"divpd",
	"divps",
	"divsd",
	"divss",
	"dppd",
	"dpps",
	"hsubpd",
	"hsubps",
	"insertps",
	"lddqu",
	"maskmovdqu",
	"maskmovq",
	"maxpd",
	"maxps",
	"maxsd",
	"maxss",
	"mfence",
	"minpd",
	"minps",
	"minsd",
	"minss",
	"monitor",
	"movapd",
	"movaps",
	"movd",
	"movq",
	"movddup",
	"movdq2q",
	"movdqa",
	"movdqu",
	"movhlps",
	"movhpd",
	"movhps",
	"movlhps",
	"movlpd",
	"movlps",
	"movmskpd",
	"movmskps",
	"movntdq",
	"movnti",
	"movntpd",
	"movntd",
	"movntq",
	"movq2dq",
	"movshdup",
	"movsldup",
	"movss",
	"movupd",
	"movups",
	"mpsadbw",
	"mulpd",
	"mulps",
	"mulsd",
	"mulss",
	"orpd",
	"orps",
	"packssdw",
	"packsswb",
	"packusdw",
	"paddb",
	"paddd",
	"paddq",
	"paddsw",
	"paddusb",
	"paddusw",
	"paddw",
	"palignr",
	"pand",
	"pandn",
	"pavgb",
	"pavgw",
	"pblendw",
	"pcmpeqb",
	"pcmpeqd",
	"pcmpeqw",
	"pcmpestri",
	"pcmpestrm",
	"pcmpgtb",
	"pcmpgtd",
	"pcmpgtw",
	"pextrb",
	"pextrd",
	"pextrq",
	"pextrw",
	"pinsrb",
	"pinsrd",
	"pinsrq",
	"pinsrw",
	"pmaddwd",
	"pmaxsw",
	"pmaxub",
	"pminsw",
	"pminub",
	"pmovmskb",
	"pmulhuw",
	"pmulhw",
	"pmullw",
	"pmuludq",
	"psadbw",
	"pshufd",
	"pshufhw",
	"pshuflw",
	"pshufw",
	"pslld",
	"pslldq",
	"psllq",
	"psllw",
	"psrad",
	"psraw",
	"psrld",
	"psrldq",
	"psrlq",
	"psrlw",
	"psubb",
	"psubd",
	"psubq",
	"psubsb",
	"psubsw",
	"psubusb",
	"psubusw",
	"punpckhbw",
	"punpckhdq",
	"punpckhqdq",
	"punpckhwd",
	"punpcklbw",
	"punpckldq",
	"punpcklqdq",
	"punpcklwd",
	"pxor",
	"rcpps",
	"rcpss",
	"roundpd",
	"roundps",
	"roundsd",
	"roundss",
	"rsqrtps",
	"rsqrtss",
	"shufpd",
	"shufps",
	"sqrtpd",
	"sqrtps",
	"sqrtsd",
	"sqrtss",
	"subpd",
	"subps",
	"subsd",
	"subss",
	"unpckhpd",
	"unpckhps",
	"unpcklpd",
	"unpcklps",
	"xorpd",
	"xorps",
	"invept",
	"invvpid",
	"vmcall",
	"vmclear",
	"vmlaunch",
	"vmptrld",
	"vmptrst",
	"vmread",
	"vmresume",
	"vmwrite",
	"vmxoff",
	"vmxon",
	"a16",
	"a32",
	"lock",
	"o16",
	"o32",
	"rep",
	"repe",
	"repne",
	"repnz",
	"repz",
};

std::map<enum e_tk, const char *> tokenNames = {
	{ tk_star, "*" },
	{ tk_plus, "+" },
	{ tk_comma, "," },
	{ tk_colon, ":" },
	{ tk_openbr, "[" },
	{ tk_closebr, "]" },
	{ tk_byte, "byte" },
	{ tk_dword, "dword" },
	{ tk_far, "far" },
	{ tk_near, "near" },
	{ tk_qword, "qword" },
	{ tk_short, "short" },
	{ tk_tword, "tword" },
	{ tk_word, "word" },
	{ tk_al, "al" },
	{ tk_ah, "ah" },
	{ tk_ax, "ax" },
	{ tk_eax, "eax" },
	{ tk_rax, "rax" },
	{ tk_r8b, "r8b" },
	{ tk_r8w, "r8w" },
	{ tk_r8d, "r8d" },
	{ tk_r8, "r8" },
	{ tk_cl, "cl" },
	{ tk_ch, "ch" },
	{ tk_cx, "cx" },
	{ tk_ecx, "ecx" },
	{ tk_rcx, "rcx" },
	{ tk_r9b, "r9b" },
	{ tk_r9w, "r9w" },
	{ tk_r9d, "r9d" },
	{ tk_r9, "r9" },
	{ tk_dl, "dl" },
	{ tk_dh, "dh" },
	{ tk_dx, "dx" },
	{ tk_edx, "edx" },
	{ tk_rdx, "rdx" },
	{ tk_r10b, "r10b" },
	{ tk_r10w, "r10w" },
	{ tk_r10d, "r10d" },
	{ tk_r10, "r10" },
	{ tk_bl, "bl" },
	{ tk_bh, "bh" },
	{ tk_bx, "bx" },
	{ tk_ebx, "ebx" },
	{ tk_rbx, "rbx" },
	{ tk_r11b, "r11b" },
	{ tk_r11w, "r11w" },
	{ tk_r11d, "r11d" },
	{ tk_r11, "r11" },
	{ tk_spl, "spl" },
	{ tk_sp, "sp" },
	{ tk_esp, "esp" },
	{ tk_rsp, "rsp" },
	{ tk_r12b, "r12b" },
	{ tk_r12w, "r12w" },
	{ tk_r12d, "r12d" },
	{ tk_r12, "r12" },
	{ tk_bpl, "bpl" },
	{ tk_bp, "bp" },
	{ tk_ebp, "ebp" },
	{ tk_rbp, "rbp" },
	{ tk_r13b, "r13b" },
	{ tk_r13w, "r13w" },
	{ tk_r13d, "r13d" },
	{ tk_r13, "r13" },
	{ tk_sil, "sil" },
	{ tk_si, "si" },
	{ tk_esi, "esi" },
	{ tk_rsi, "rsi" },
	{ tk_r14b, "r14b" },
	{ tk_r14w, "r14w" },
	{ tk_r14d, "r14d" },
	{ tk_r14, "r14" },
	{ tk_dil, "dil" },
	{ tk_di, "di" },
	{ tk_edi, "edi" },
	{ tk_rdi, "rdi" },
	{ tk_r15b, "r15b" },
	{ tk_r15w, "r15w" },
	{ tk_r15d, "r15d" },
	{ tk_r15, "r15" },
	{ tk_rip, "rip" },
	{ tk_mm0, "mm0" },
	{ tk_xmm0, "xmm0" },
	{ tk_xmm8, "xmm8" },
	{ tk_mm1, "mm1" },
	{ tk_xmm1, "xmm1" },
	{ tk_xmm9, "xmm9" },
	{ tk_mm2, "mm2" },
	{ tk_xmm2, "xmm2" },
	{ tk_xmm10, "xmm10" },
	{ tk_mm3, "mm3" },
	{ tk_xmm3, "xmm3" },
	{ tk_xmm11, "xmm11" },
	{ tk_mm4, "mm4" },
	{ tk_xmm4, "xmm4" },
	{ tk_xmm12, "xmm12" },
	{ tk_mm5, "mm5" },
	{ tk_xmm5, "xmm5" },
	{ tk_xmm13, "xmm13" },
	{ tk_mm6, "mm6" },
	{ tk_xmm6, "xmm6" },
	{ tk_xmm14, "xmm14" },
	{ tk_mm7, "mm7" },
	{ tk_xmm7, "xmm7" },
	{ tk_xmm15, "xmm15" },
	{ tk_es, "es" },
	{ tk_cs, "cs" },
	{ tk_ss, "ss" },
	{ tk_ds, "ds" },
	{ tk_fs, "fs" },
	{ tk_gs, "gs" },
	{ tk_st0, "st0" },
	{ tk_st1, "st1" },
	{ tk_st2, "st2" },
	{ tk_st3, "st3" },
	{ tk_st4, "st4" },
	{ tk_st5, "st5" },
	{ tk_st6, "st6" },
	{ tk_st7, "st7" },
	{ tk_cr0, "cr0" },
	{ tk_cr1, "cr1" },
	{ tk_cr2, "cr2" },
	{ tk_cr3, "cr3" },
	{ tk_cr4, "cr4" },
	{ tk_cr5, "cr5" },
	{ tk_cr6, "cr6" },
	{ tk_cr7, "cr7" },
	{ tk_dr0, "dr0" },
	{ tk_dr1, "dr1" },
	{ tk_dr2, "dr2" },
	{ tk_dr3, "dr3" },
	{ tk_dr4, "dr4" },
	{ tk_dr5, "dr5" },
	{ tk_dr6, "dr6" },
	{ tk_dr7, "dr7" },
	{ tk_tr0, "tr0" },
	{ tk_tr1, "tr1" },
	{ tk_tr2, "tr2" },
	{ tk_tr3, "tr3" },
	{ tk_tr4, "tr4" },
	{ tk_tr5, "tr5" },
	{ tk_tr6, "tr6" },
	{ tk_tr7, "tr7" },
};

InputToken Tokenstar{ InputToken::TOKEN, new AsmExprNode(tk_star) };
InputToken Tokenplus{ InputToken::TOKEN, new AsmExprNode(tk_plus) };
InputToken Tokencomma{ InputToken::TOKEN, new AsmExprNode(tk_comma) };
InputToken Tokencolon{ InputToken::TOKEN, new AsmExprNode(tk_colon) };
InputToken Tokenopenbr{ InputToken::TOKEN, new AsmExprNode(tk_openbr) };
InputToken Tokenclosebr{ InputToken::TOKEN, new AsmExprNode(tk_closebr) };
InputToken Tokenbyte{ InputToken::TOKEN, new AsmExprNode(tk_byte) };
InputToken Tokendword{ InputToken::TOKEN, new AsmExprNode(tk_dword) };
InputToken Tokenfar{ InputToken::TOKEN, new AsmExprNode(tk_far) };
InputToken Tokennear{ InputToken::TOKEN, new AsmExprNode(tk_near) };
InputToken Tokenqword{ InputToken::TOKEN, new AsmExprNode(tk_qword) };
InputToken Tokenshort{ InputToken::TOKEN, new AsmExprNode(tk_short) };
InputToken Tokentword{ InputToken::TOKEN, new AsmExprNode(tk_tword) };
InputToken Tokenword{ InputToken::TOKEN, new AsmExprNode(tk_word) };
InputToken Tokenal{ InputToken::REGISTER, new AsmExprNode(tk_al) };
InputToken Tokenah{ InputToken::REGISTER, new AsmExprNode(tk_ah) };
InputToken Tokenax{ InputToken::REGISTER, new AsmExprNode(tk_ax) };
InputToken Tokeneax{ InputToken::REGISTER, new AsmExprNode(tk_eax) };
InputToken Tokenrax{ InputToken::REGISTER, new AsmExprNode(tk_rax) };
InputToken Tokenr8b{ InputToken::REGISTER, new AsmExprNode(tk_r8b) };
InputToken Tokenr8w{ InputToken::REGISTER, new AsmExprNode(tk_r8w) };
InputToken Tokenr8d{ InputToken::REGISTER, new AsmExprNode(tk_r8d) };
InputToken Tokenr8{ InputToken::REGISTER, new AsmExprNode(tk_r8) };
InputToken Tokencl{ InputToken::REGISTER, new AsmExprNode(tk_cl) };
InputToken Tokench{ InputToken::REGISTER, new AsmExprNode(tk_ch) };
InputToken Tokencx{ InputToken::REGISTER, new AsmExprNode(tk_cx) };
InputToken Tokenecx{ InputToken::REGISTER, new AsmExprNode(tk_ecx) };
InputToken Tokenrcx{ InputToken::REGISTER, new AsmExprNode(tk_rcx) };
InputToken Tokenr9b{ InputToken::REGISTER, new AsmExprNode(tk_r9b) };
InputToken Tokenr9w{ InputToken::REGISTER, new AsmExprNode(tk_r9w) };
InputToken Tokenr9d{ InputToken::REGISTER, new AsmExprNode(tk_r9d) };
InputToken Tokenr9{ InputToken::REGISTER, new AsmExprNode(tk_r9) };
InputToken Tokendl{ InputToken::REGISTER, new AsmExprNode(tk_dl) };
InputToken Tokendh{ InputToken::REGISTER, new AsmExprNode(tk_dh) };
InputToken Tokendx{ InputToken::REGISTER, new AsmExprNode(tk_dx) };
InputToken Tokenedx{ InputToken::REGISTER, new AsmExprNode(tk_edx) };
InputToken Tokenrdx{ InputToken::REGISTER, new AsmExprNode(tk_rdx) };
InputToken Tokenr10b{ InputToken::REGISTER, new AsmExprNode(tk_r10b) };
InputToken Tokenr10w{ InputToken::REGISTER, new AsmExprNode(tk_r10w) };
InputToken Tokenr10d{ InputToken::REGISTER, new AsmExprNode(tk_r10d) };
InputToken Tokenr10{ InputToken::REGISTER, new AsmExprNode(tk_r10) };
InputToken Tokenbl{ InputToken::REGISTER, new AsmExprNode(tk_bl) };
InputToken Tokenbh{ InputToken::REGISTER, new AsmExprNode(tk_bh) };
InputToken Tokenbx{ InputToken::REGISTER, new AsmExprNode(tk_bx) };
InputToken Tokenebx{ InputToken::REGISTER, new AsmExprNode(tk_ebx) };
InputToken Tokenrbx{ InputToken::REGISTER, new AsmExprNode(tk_rbx) };
InputToken Tokenr11b{ InputToken::REGISTER, new AsmExprNode(tk_r11b) };
InputToken Tokenr11w{ InputToken::REGISTER, new AsmExprNode(tk_r11w) };
InputToken Tokenr11d{ InputToken::REGISTER, new AsmExprNode(tk_r11d) };
InputToken Tokenr11{ InputToken::REGISTER, new AsmExprNode(tk_r11) };
InputToken Tokenspl{ InputToken::REGISTER, new AsmExprNode(tk_spl) };
InputToken Tokensp{ InputToken::REGISTER, new AsmExprNode(tk_sp) };
InputToken Tokenesp{ InputToken::REGISTER, new AsmExprNode(tk_esp) };
InputToken Tokenrsp{ InputToken::REGISTER, new AsmExprNode(tk_rsp) };
InputToken Tokenr12b{ InputToken::REGISTER, new AsmExprNode(tk_r12b) };
InputToken Tokenr12w{ InputToken::REGISTER, new AsmExprNode(tk_r12w) };
InputToken Tokenr12d{ InputToken::REGISTER, new AsmExprNode(tk_r12d) };
InputToken Tokenr12{ InputToken::REGISTER, new AsmExprNode(tk_r12) };
InputToken Tokenbpl{ InputToken::REGISTER, new AsmExprNode(tk_bpl) };
InputToken Tokenbp{ InputToken::REGISTER, new AsmExprNode(tk_bp) };
InputToken Tokenebp{ InputToken::REGISTER, new AsmExprNode(tk_ebp) };
InputToken Tokenrbp{ InputToken::REGISTER, new AsmExprNode(tk_rbp) };
InputToken Tokenr13b{ InputToken::REGISTER, new AsmExprNode(tk_r13b) };
InputToken Tokenr13w{ InputToken::REGISTER, new AsmExprNode(tk_r13w) };
InputToken Tokenr13d{ InputToken::REGISTER, new AsmExprNode(tk_r13d) };
InputToken Tokenr13{ InputToken::REGISTER, new AsmExprNode(tk_r13) };
InputToken Tokensil{ InputToken::REGISTER, new AsmExprNode(tk_sil) };
InputToken Tokensi{ InputToken::REGISTER, new AsmExprNode(tk_si) };
InputToken Tokenesi{ InputToken::REGISTER, new AsmExprNode(tk_esi) };
InputToken Tokenrsi{ InputToken::REGISTER, new AsmExprNode(tk_rsi) };
InputToken Tokenr14b{ InputToken::REGISTER, new AsmExprNode(tk_r14b) };
InputToken Tokenr14w{ InputToken::REGISTER, new AsmExprNode(tk_r14w) };
InputToken Tokenr14d{ InputToken::REGISTER, new AsmExprNode(tk_r14d) };
InputToken Tokenr14{ InputToken::REGISTER, new AsmExprNode(tk_r14) };
InputToken Tokendil{ InputToken::REGISTER, new AsmExprNode(tk_dil) };
InputToken Tokendi{ InputToken::REGISTER, new AsmExprNode(tk_di) };
InputToken Tokenedi{ InputToken::REGISTER, new AsmExprNode(tk_edi) };
InputToken Tokenrdi{ InputToken::REGISTER, new AsmExprNode(tk_rdi) };
InputToken Tokenr15b{ InputToken::REGISTER, new AsmExprNode(tk_r15b) };
InputToken Tokenr15w{ InputToken::REGISTER, new AsmExprNode(tk_r15w) };
InputToken Tokenr15d{ InputToken::REGISTER, new AsmExprNode(tk_r15d) };
InputToken Tokenr15{ InputToken::REGISTER, new AsmExprNode(tk_r15) };
InputToken Tokenrip{ InputToken::REGISTER, new AsmExprNode(tk_rip) };
InputToken Tokenmm0{ InputToken::REGISTER, new AsmExprNode(tk_mm0) };
InputToken Tokenxmm0{ InputToken::REGISTER, new AsmExprNode(tk_xmm0) };
InputToken Tokenxmm8{ InputToken::REGISTER, new AsmExprNode(tk_xmm8) };
InputToken Tokenmm1{ InputToken::REGISTER, new AsmExprNode(tk_mm1) };
InputToken Tokenxmm1{ InputToken::REGISTER, new AsmExprNode(tk_xmm1) };
InputToken Tokenxmm9{ InputToken::REGISTER, new AsmExprNode(tk_xmm9) };
InputToken Tokenmm2{ InputToken::REGISTER, new AsmExprNode(tk_mm2) };
InputToken Tokenxmm2{ InputToken::REGISTER, new AsmExprNode(tk_xmm2) };
InputToken Tokenxmm10{ InputToken::REGISTER, new AsmExprNode(tk_xmm10) };
InputToken Tokenmm3{ InputToken::REGISTER, new AsmExprNode(tk_mm3) };
InputToken Tokenxmm3{ InputToken::REGISTER, new AsmExprNode(tk_xmm3) };
InputToken Tokenxmm11{ InputToken::REGISTER, new AsmExprNode(tk_xmm11) };
InputToken Tokenmm4{ InputToken::REGISTER, new AsmExprNode(tk_mm4) };
InputToken Tokenxmm4{ InputToken::REGISTER, new AsmExprNode(tk_xmm4) };
InputToken Tokenxmm12{ InputToken::REGISTER, new AsmExprNode(tk_xmm12) };
InputToken Tokenmm5{ InputToken::REGISTER, new AsmExprNode(tk_mm5) };
InputToken Tokenxmm5{ InputToken::REGISTER, new AsmExprNode(tk_xmm5) };
InputToken Tokenxmm13{ InputToken::REGISTER, new AsmExprNode(tk_xmm13) };
InputToken Tokenmm6{ InputToken::REGISTER, new AsmExprNode(tk_mm6) };
InputToken Tokenxmm6{ InputToken::REGISTER, new AsmExprNode(tk_xmm6) };
InputToken Tokenxmm14{ InputToken::REGISTER, new AsmExprNode(tk_xmm14) };
InputToken Tokenmm7{ InputToken::REGISTER, new AsmExprNode(tk_mm7) };
InputToken Tokenxmm7{ InputToken::REGISTER, new AsmExprNode(tk_xmm7) };
InputToken Tokenxmm15{ InputToken::REGISTER, new AsmExprNode(tk_xmm15) };
InputToken Tokenes{ InputToken::REGISTER, new AsmExprNode(tk_es) };
InputToken Tokencs{ InputToken::REGISTER, new AsmExprNode(tk_cs) };
InputToken Tokenss{ InputToken::REGISTER, new AsmExprNode(tk_ss) };
InputToken Tokends{ InputToken::REGISTER, new AsmExprNode(tk_ds) };
InputToken Tokenfs{ InputToken::REGISTER, new AsmExprNode(tk_fs) };
InputToken Tokengs{ InputToken::REGISTER, new AsmExprNode(tk_gs) };
InputToken Tokenst0{ InputToken::REGISTER, new AsmExprNode(tk_st0) };
InputToken Tokenst1{ InputToken::REGISTER, new AsmExprNode(tk_st1) };
InputToken Tokenst2{ InputToken::REGISTER, new AsmExprNode(tk_st2) };
InputToken Tokenst3{ InputToken::REGISTER, new AsmExprNode(tk_st3) };
InputToken Tokenst4{ InputToken::REGISTER, new AsmExprNode(tk_st4) };
InputToken Tokenst5{ InputToken::REGISTER, new AsmExprNode(tk_st5) };
InputToken Tokenst6{ InputToken::REGISTER, new AsmExprNode(tk_st6) };
InputToken Tokenst7{ InputToken::REGISTER, new AsmExprNode(tk_st7) };
InputToken Tokencr0{ InputToken::REGISTER, new AsmExprNode(tk_cr0) };
InputToken Tokencr1{ InputToken::REGISTER, new AsmExprNode(tk_cr1) };
InputToken Tokencr2{ InputToken::REGISTER, new AsmExprNode(tk_cr2) };
InputToken Tokencr3{ InputToken::REGISTER, new AsmExprNode(tk_cr3) };
InputToken Tokencr4{ InputToken::REGISTER, new AsmExprNode(tk_cr4) };
InputToken Tokencr5{ InputToken::REGISTER, new AsmExprNode(tk_cr5) };
InputToken Tokencr6{ InputToken::REGISTER, new AsmExprNode(tk_cr6) };
InputToken Tokencr7{ InputToken::REGISTER, new AsmExprNode(tk_cr7) };
InputToken Tokendr0{ InputToken::REGISTER, new AsmExprNode(tk_dr0) };
InputToken Tokendr1{ InputToken::REGISTER, new AsmExprNode(tk_dr1) };
InputToken Tokendr2{ InputToken::REGISTER, new AsmExprNode(tk_dr2) };
InputToken Tokendr3{ InputToken::REGISTER, new AsmExprNode(tk_dr3) };
InputToken Tokendr4{ InputToken::REGISTER, new AsmExprNode(tk_dr4) };
InputToken Tokendr5{ InputToken::REGISTER, new AsmExprNode(tk_dr5) };
InputToken Tokendr6{ InputToken::REGISTER, new AsmExprNode(tk_dr6) };
InputToken Tokendr7{ InputToken::REGISTER, new AsmExprNode(tk_dr7) };
InputToken Tokentr0{ InputToken::REGISTER, new AsmExprNode(tk_tr0) };
InputToken Tokentr1{ InputToken::REGISTER, new AsmExprNode(tk_tr1) };
InputToken Tokentr2{ InputToken::REGISTER, new AsmExprNode(tk_tr2) };
InputToken Tokentr3{ InputToken::REGISTER, new AsmExprNode(tk_tr3) };
InputToken Tokentr4{ InputToken::REGISTER, new AsmExprNode(tk_tr4) };
InputToken Tokentr5{ InputToken::REGISTER, new AsmExprNode(tk_tr5) };
InputToken Tokentr6{ InputToken::REGISTER, new AsmExprNode(tk_tr6) };
InputToken Tokentr7{ InputToken::REGISTER, new AsmExprNode(tk_tr7) };
