#ifndef _WINERROR_H
#define _WINERROR_H
#if __GNUC__ >= 3
#    pragma GCC system_header
#endif

#define _HRESULT_TYPEDEF_(_sc) ((HRESULT)_sc)

#include <win32/errors.h>

#define ERROR_CTX_WINSTATION_NAME_INVALID 7001L
#define ERROR_CTX_INVALID_PD 7002L
#define ERROR_CTX_PD_NOT_FOUND 7003L
#define ERROR_CTX_WD_NOT_FOUND 7004L
#define ERROR_CTX_CANNOT_MAKE_EVENTLOG_ENTRY 7005L
#define ERROR_CTX_SERVICE_NAME_COLLISION 7006L
#define ERROR_CTX_CLOSE_PENDING 7007L
#define ERROR_CTX_NO_OUTBUF 7008L
#define ERROR_CTX_MODEM_INF_NOT_FOUND 7009L
#define ERROR_CTX_INVALID_MODEMNAME 7010L
#define ERROR_CTX_MODEM_RESPONSE_ERROR 7011L
#define ERROR_CTX_MODEM_RESPONSE_TIMEOUT 7012L
#define ERROR_CTX_MODEM_RESPONSE_NO_CARRIER 7013L
#define ERROR_CTX_MODEM_RESPONSE_NO_DIALTONE 7014L
#define ERROR_CTX_MODEM_RESPONSE_BUSY 7015L
#define ERROR_CTX_MODEM_RESPONSE_VOICE 7016L
#define ERROR_CTX_TD_ERROR 7017L
#define ERROR_CTX_WINSTATION_NOT_FOUND 7022L
#define ERROR_CTX_WINSTATION_ALREADY_EXISTS 7023L
#define ERROR_CTX_WINSTATION_BUSY 7024L
#define ERROR_CTX_BAD_VIDEO_MODE 7025L
#define ERROR_CTX_GRAPHICS_INVALID 7035L
#define ERROR_CTX_LOGON_DISABLED 7037L
#define ERROR_CTX_NOT_CONSOLE 7038L
#define ERROR_CTX_CLIENT_QUERY_TIMEOUT 7040L
#define ERROR_CTX_CONSOLE_DISCONNECT 7041L
#define ERROR_CTX_CONSOLE_CONNECT 7042L
#define ERROR_CTX_SHADOW_DENIED 7044L
#define ERROR_CTX_WINSTATION_ACCESS_DENIED 7045L
#define ERROR_CTX_INVALID_WD 7049L
#define ERROR_CTX_SHADOW_INVALID 7050L
#define ERROR_CTX_SHADOW_DISABLED 7051L
#define ERROR_CTX_CLIENT_LICENSE_IN_USE 7052L
#define ERROR_CTX_CLIENT_LICENSE_NOT_SET 7053L
#define ERROR_CTX_LICENSE_NOT_AVAILABLE 7054L
#define ERROR_CTX_LICENSE_CLIENT_INVALID 7055L
#define ERROR_CTX_LICENSE_EXPIRED 7056L
#define ERROR_CTX_SHADOW_NOT_RUNNING 7057L
#define ERROR_CTX_SHADOW_ENDED_BY_MODE_CHANGE 7058L
#define ERROR_ACTIVATION_COUNT_EXCEEDED 7059L

#define FRS_ERR_INVALID_API_SEQUENCE 8001L
#define FRS_ERR_STARTING_SERVICE 8002L
#define FRS_ERR_STOPPING_SERVICE 8003L
#define FRS_ERR_INTERNAL_API 8004L
#define FRS_ERR_INTERNAL 8005L
#define FRS_ERR_SERVICE_COMM 8006L
#define FRS_ERR_INSUFFICIENT_PRIV 8007L
#define FRS_ERR_AUTHENTICATION 8008L
#define FRS_ERR_PARENT_INSUFFICIENT_PRIV 8009L
#define FRS_ERR_PARENT_AUTHENTICATION 8010L
#define FRS_ERR_CHILD_TO_PARENT_COMM 8011L
#define FRS_ERR_PARENT_TO_CHILD_COMM 8012L
#define FRS_ERR_SYSVOL_POPULATE 8013L
#define FRS_ERR_SYSVOL_POPULATE_TIMEOUT 8014L
#define FRS_ERR_SYSVOL_IS_BUSY 8015L
#define FRS_ERR_SYSVOL_DEMOTE 8016L
#define FRS_ERR_INVALID_SERVICE_PARAMETER 8017L
#define ERROR_DS_NOT_INSTALLED 8200L
#define ERROR_DS_MEMBERSHIP_EVALUATED_LOCALLY 8201L
#define ERROR_DS_NO_ATTRIBUTE_OR_VALUE 8202L
#define ERROR_DS_INVALID_ATTRIBUTE_SYNTAX 8203L
#define ERROR_DS_ATTRIBUTE_TYPE_UNDEFINED 8204L
#define ERROR_DS_ATTRIBUTE_OR_VALUE_EXISTS 8205L
#define ERROR_DS_BUSY 8206L
#define ERROR_DS_UNAVAILABLE 8207L
#define ERROR_DS_NO_RIDS_ALLOCATED 8208L
#define ERROR_DS_NO_MORE_RIDS 8209L
#define ERROR_DS_INCORRECT_ROLE_OWNER 8210L
#define ERROR_DS_RIDMGR_INIT_ERROR 8211L
#define ERROR_DS_OBJ_CLASS_VIOLATION 8212L
#define ERROR_DS_CANT_ON_NON_LEAF 8213L
#define ERROR_DS_CANT_ON_RDN 8214L
#define ERROR_DS_CANT_MOD_OBJ_CLASS 8215L
#define ERROR_DS_CROSS_DOM_MOVE_ERROR 8216L
#define ERROR_DS_GC_NOT_AVAILABLE 8217L
#define ERROR_SHARED_POLICY 8218L
#define ERROR_POLICY_OBJECT_NOT_FOUND 8219L
#define ERROR_POLICY_ONLY_IN_DS 8220L
#define ERROR_PROMOTION_ACTIVE 8221L
#define ERROR_NO_PROMOTION_ACTIVE 8222L
#define ERROR_DS_OPERATIONS_ERROR 8224L
#define ERROR_DS_PROTOCOL_ERROR 8225L
#define ERROR_DS_TIMELIMIT_EXCEEDED 8226L
#define ERROR_DS_SIZELIMIT_EXCEEDED 8227L
#define ERROR_DS_ADMIN_LIMIT_EXCEEDED 8228L
#define ERROR_DS_COMPARE_FALSE 8229L
#define ERROR_DS_COMPARE_TRUE 8230L
#define ERROR_DS_AUTH_METHOD_NOT_SUPPORTED 8231L
#define ERROR_DS_STRONG_AUTH_REQUIRED 8232L
#define ERROR_DS_INAPPROPRIATE_AUTH 8233L
#define ERROR_DS_AUTH_UNKNOWN 8234L
#define ERROR_DS_REFERRAL 8235L
#define ERROR_DS_UNAVAILABLE_CRIT_EXTENSION 8236L
#define ERROR_DS_CONFIDENTIALITY_REQUIRED 8237L
#define ERROR_DS_INAPPROPRIATE_MATCHING 8238L
#define ERROR_DS_CONSTRAINT_VIOLATION 8239L
#define ERROR_DS_NO_SUCH_OBJECT 8240L
#define ERROR_DS_ALIAS_PROBLEM 8241L
#define ERROR_DS_INVALID_DN_SYNTAX 8242L
#define ERROR_DS_IS_LEAF 8243L
#define ERROR_DS_ALIAS_DEREF_PROBLEM 8244L
#define ERROR_DS_UNWILLING_TO_PERFORM 8245L
#define ERROR_DS_LOOP_DETECT 8246L
#define ERROR_DS_NAMING_VIOLATION 8247L
#define ERROR_DS_OBJECT_RESULTS_TOO_LARGE 8248L
#define ERROR_DS_AFFECTS_MULTIPLE_DSAS 8249L
#define ERROR_DS_SERVER_DOWN 8250L
#define ERROR_DS_LOCAL_ERROR 8251L
#define ERROR_DS_ENCODING_ERROR 8252L
#define ERROR_DS_DECODING_ERROR 8253L
#define ERROR_DS_FILTER_UNKNOWN 8254L
#define ERROR_DS_PARAM_ERROR 8255L
#define ERROR_DS_NOT_SUPPORTED 8256L
#define ERROR_DS_NO_RESULTS_RETURNED 8257L
#define ERROR_DS_CONTROL_NOT_FOUND 8258L
#define ERROR_DS_CLIENT_LOOP 8259L
#define ERROR_DS_REFERRAL_LIMIT_EXCEEDED 8260L
#define ERROR_DS_SORT_CONTROL_MISSING 8261L
#define ERROR_DS_OFFSET_RANGE_ERROR 8262L
#define ERROR_DS_ROOT_MUST_BE_NC 8301L
#define ERROR_DS_ADD_REPLICA_INHIBITED 8302L
#define ERROR_DS_ATT_NOT_DEF_IN_SCHEMA 8303L
#define ERROR_DS_MAX_OBJ_SIZE_EXCEEDED 8304L
#define ERROR_DS_OBJ_STRING_NAME_EXISTS 8305L
#define ERROR_DS_NO_RDN_DEFINED_IN_SCHEMA 8306L
#define ERROR_DS_RDN_DOESNT_MATCH_SCHEMA 8307L
#define ERROR_DS_NO_REQUESTED_ATTS_FOUND 8308L
#define ERROR_DS_USER_BUFFER_TO_SMALL 8309L
#define ERROR_DS_ATT_IS_NOT_ON_OBJ 8310L
#define ERROR_DS_ILLEGAL_MOD_OPERATION 8311L
#define ERROR_DS_OBJ_TOO_LARGE 8312L
#define ERROR_DS_BAD_INSTANCE_TYPE 8313L
#define ERROR_DS_MASTERDSA_REQUIRED 8314L
#define ERROR_DS_OBJECT_CLASS_REQUIRED 8315L
#define ERROR_DS_MISSING_REQUIRED_ATT 8316L
#define ERROR_DS_ATT_NOT_DEF_FOR_CLASS 8317L
#define ERROR_DS_ATT_ALREADY_EXISTS 8318L
#define ERROR_DS_CANT_ADD_ATT_VALUES 8320L
#define ERROR_DS_SINGLE_VALUE_CONSTRAINT 8321L
#define ERROR_DS_RANGE_CONSTRAINT 8322L
#define ERROR_DS_ATT_VAL_ALREADY_EXISTS 8323L
#define ERROR_DS_CANT_REM_MISSING_ATT 8324L
#define ERROR_DS_CANT_REM_MISSING_ATT_VAL 8325L
#define ERROR_DS_ROOT_CANT_BE_SUBREF 8326L
#define ERROR_DS_NO_CHAINING 8327L
#define ERROR_DS_NO_CHAINED_EVAL 8328L
#define ERROR_DS_NO_PARENT_OBJECT 8329L
#define ERROR_DS_PARENT_IS_AN_ALIAS 8330L
#define ERROR_DS_CANT_MIX_MASTER_AND_REPS 8331L
#define ERROR_DS_CHILDREN_EXIST 8332L
#define ERROR_DS_OBJ_NOT_FOUND 8333L
#define ERROR_DS_ALIASED_OBJ_MISSING 8334L
#define ERROR_DS_BAD_NAME_SYNTAX 8335L
#define ERROR_DS_ALIAS_POINTS_TO_ALIAS 8336L
#define ERROR_DS_CANT_DEREF_ALIAS 8337L
#define ERROR_DS_OUT_OF_SCOPE 8338L
#define ERROR_DS_OBJECT_BEING_REMOVED 8339L
#define ERROR_DS_CANT_DELETE_DSA_OBJ 8340L
#define ERROR_DS_GENERIC_ERROR 8341L
#define ERROR_DS_DSA_MUST_BE_INT_MASTER 8342L
#define ERROR_DS_CLASS_NOT_DSA 8343L
#define ERROR_DS_INSUFF_ACCESS_RIGHTS 8344L
#define ERROR_DS_ILLEGAL_SUPERIOR 8345L
#define ERROR_DS_ATTRIBUTE_OWNED_BY_SAM 8346L
#define ERROR_DS_NAME_TOO_MANY_PARTS 8347L
#define ERROR_DS_NAME_TOO_LONG 8348L
#define ERROR_DS_NAME_VALUE_TOO_LONG 8349L
#define ERROR_DS_NAME_UNPARSEABLE 8350L
#define ERROR_DS_NAME_TYPE_UNKNOWN 8351L
#define ERROR_DS_NOT_AN_OBJECT 8352L
#define ERROR_DS_SEC_DESC_TOO_SHORT 8353L
#define ERROR_DS_SEC_DESC_INVALID 8354L
#define ERROR_DS_NO_DELETED_NAME 8355L
#define ERROR_DS_SUBREF_MUST_HAVE_PARENT 8356L
#define ERROR_DS_NCNAME_MUST_BE_NC 8357L
#define ERROR_DS_CANT_ADD_SYSTEM_ONLY 8358L
#define ERROR_DS_CLASS_MUST_BE_CONCRETE 8359L
#define ERROR_DS_INVALID_DMD 8360L
#define ERROR_DS_OBJ_GUID_EXISTS 8361L
#define ERROR_DS_NOT_ON_BACKLINK 8362L
#define ERROR_DS_NO_CROSSREF_FOR_NC 8363L
#define ERROR_DS_SHUTTING_DOWN 8364L
#define ERROR_DS_UNKNOWN_OPERATION 8365L
#define ERROR_DS_INVALID_ROLE_OWNER 8366L
#define ERROR_DS_COULDNT_CONTACT_FSMO 8367L
#define ERROR_DS_CROSS_NC_DN_RENAME 8368L
#define ERROR_DS_CANT_MOD_SYSTEM_ONLY 8369L
#define ERROR_DS_REPLICATOR_ONLY 8370L
#define ERROR_DS_OBJ_CLASS_NOT_DEFINED 8371L
#define ERROR_DS_OBJ_CLASS_NOT_SUBCLASS 8372L
#define ERROR_DS_NAME_REFERENCE_INVALID 8373L
#define ERROR_DS_CROSS_REF_EXISTS 8374L
#define ERROR_DS_CANT_DEL_MASTER_CROSSREF 8375L
#define ERROR_DS_SUBTREE_NOTIFY_NOT_NC_HEAD 8376L
#define ERROR_DS_NOTIFY_FILTER_TOO_COMPLEX 8377L
#define ERROR_DS_DUP_RDN 8378L
#define ERROR_DS_DUP_OID 8379L
#define ERROR_DS_DUP_MAPI_ID 8380L
#define ERROR_DS_DUP_SCHEMA_ID_GUID 8381L
#define ERROR_DS_DUP_LDAP_DISPLAY_NAME 8382L
#define ERROR_DS_SEMANTIC_ATT_TEST 8383L
#define ERROR_DS_SYNTAX_MISMATCH 8384L
#define ERROR_DS_EXISTS_IN_MUST_HAVE 8385L
#define ERROR_DS_EXISTS_IN_MAY_HAVE 8386L
#define ERROR_DS_NONEXISTENT_MAY_HAVE 8387L
#define ERROR_DS_NONEXISTENT_MUST_HAVE 8388L
#define ERROR_DS_AUX_CLS_TEST_FAIL 8389L
#define ERROR_DS_NONEXISTENT_POSS_SUP 8390L
#define ERROR_DS_SUB_CLS_TEST_FAIL 8391L
#define ERROR_DS_BAD_RDN_ATT_ID_SYNTAX 8392L
#define ERROR_DS_EXISTS_IN_AUX_CLS 8393L
#define ERROR_DS_EXISTS_IN_SUB_CLS 8394L
#define ERROR_DS_EXISTS_IN_POSS_SUP 8395L
#define ERROR_DS_RECALCSCHEMA_FAILED 8396L
#define ERROR_DS_TREE_DELETE_NOT_FINISHED 8397L
#define ERROR_DS_CANT_DELETE 8398L
#define ERROR_DS_ATT_SCHEMA_REQ_ID 8399L
#define ERROR_DS_BAD_ATT_SCHEMA_SYNTAX 8400L
#define ERROR_DS_CANT_CACHE_ATT 8401L
#define ERROR_DS_CANT_CACHE_CLASS 8402L
#define ERROR_DS_CANT_REMOVE_ATT_CACHE 8403L
#define ERROR_DS_CANT_REMOVE_CLASS_CACHE 8404L
#define ERROR_DS_CANT_RETRIEVE_DN 8405L
#define ERROR_DS_MISSING_SUPREF 8406L
#define ERROR_DS_CANT_RETRIEVE_INSTANCE 8407L
#define ERROR_DS_CODE_INCONSISTENCY 8408L
#define ERROR_DS_DATABASE_ERROR 8409L
#define ERROR_DS_GOVERNSID_MISSING 8410L
#define ERROR_DS_MISSING_EXPECTED_ATT 8411L
#define ERROR_DS_NCNAME_MISSING_CR_REF 8412L
#define ERROR_DS_SECURITY_CHECKING_ERROR 8413L
#define ERROR_DS_SCHEMA_NOT_LOADED 8414L
#define ERROR_DS_SCHEMA_ALLOC_FAILED 8415L
#define ERROR_DS_ATT_SCHEMA_REQ_SYNTAX 8416L
#define ERROR_DS_GCVERIFY_ERROR 8417L
#define ERROR_DS_DRA_SCHEMA_MISMATCH 8418L
#define ERROR_DS_CANT_FIND_DSA_OBJ 8419L
#define ERROR_DS_CANT_FIND_EXPECTED_NC 8420L
#define ERROR_DS_CANT_FIND_NC_IN_CACHE 8421L
#define ERROR_DS_CANT_RETRIEVE_CHILD 8422L
#define ERROR_DS_SECURITY_ILLEGAL_MODIFY 8423L
#define ERROR_DS_CANT_REPLACE_HIDDEN_REC 8424L
#define ERROR_DS_BAD_HIERARCHY_FILE 8425L
#define ERROR_DS_BUILD_HIERARCHY_TABLE_FAILED 8426L
#define ERROR_DS_CONFIG_PARAM_MISSING 8427L
#define ERROR_DS_COUNTING_AB_INDICES_FAILED 8428L
#define ERROR_DS_HIERARCHY_TABLE_MALLOC_FAILED 8429L
#define ERROR_DS_INTERNAL_FAILURE 8430L
#define ERROR_DS_UNKNOWN_ERROR 8431L
#define ERROR_DS_ROOT_REQUIRES_CLASS_TOP 8432L
#define ERROR_DS_REFUSING_FSMO_ROLES 8433L
#define ERROR_DS_MISSING_FSMO_SETTINGS 8434L
#define ERROR_DS_UNABLE_TO_SURRENDER_ROLES 8435L
#define ERROR_DS_DRA_GENERIC 8436L
#define ERROR_DS_DRA_INVALID_PARAMETER 8437L
#define ERROR_DS_DRA_BUSY 8438L
#define ERROR_DS_DRA_BAD_DN 8439L
#define ERROR_DS_DRA_BAD_NC 8440L
#define ERROR_DS_DRA_DN_EXISTS 8441L
#define ERROR_DS_DRA_INTERNAL_ERROR 8442L
#define ERROR_DS_DRA_INCONSISTENT_DIT 8443L
#define ERROR_DS_DRA_CONNECTION_FAILED 8444L
#define ERROR_DS_DRA_BAD_INSTANCE_TYPE 8445L
#define ERROR_DS_DRA_OUT_OF_MEM 8446L
#define ERROR_DS_DRA_MAIL_PROBLEM 8447L
#define ERROR_DS_DRA_REF_ALREADY_EXISTS 8448L
#define ERROR_DS_DRA_REF_NOT_FOUND 8449L
#define ERROR_DS_DRA_OBJ_IS_REP_SOURCE 8450L
#define ERROR_DS_DRA_DB_ERROR 8451L
#define ERROR_DS_DRA_NO_REPLICA 8452L
#define ERROR_DS_DRA_ACCESS_DENIED 8453L
#define ERROR_DS_DRA_NOT_SUPPORTED 8454L
#define ERROR_DS_DRA_RPC_CANCELLED 8455L
#define ERROR_DS_DRA_SOURCE_DISABLED 8456L
#define ERROR_DS_DRA_SINK_DISABLED 8457L
#define ERROR_DS_DRA_NAME_COLLISION 8458L
#define ERROR_DS_DRA_SOURCE_REINSTALLED 8459L
#define ERROR_DS_DRA_MISSING_PARENT 8460L
#define ERROR_DS_DRA_PREEMPTED 8461L
#define ERROR_DS_DRA_ABANDON_SYNC 8462L
#define ERROR_DS_DRA_SHUTDOWN 8463L
#define ERROR_DS_DRA_INCOMPATIBLE_PARTIAL_SET 8464L
#define ERROR_DS_DRA_SOURCE_IS_PARTIAL_REPLICA 8465L
#define ERROR_DS_DRA_EXTN_CONNECTION_FAILED 8466L
#define ERROR_DS_INSTALL_SCHEMA_MISMATCH 8467L
#define ERROR_DS_DUP_LINK_ID 8468L
#define ERROR_DS_NAME_ERROR_RESOLVING 8469L
#define ERROR_DS_NAME_ERROR_NOT_FOUND 8470L
#define ERROR_DS_NAME_ERROR_NOT_UNIQUE 8471L
#define ERROR_DS_NAME_ERROR_NO_MAPPING 8472L
#define ERROR_DS_NAME_ERROR_DOMAIN_ONLY 8473L
#define ERROR_DS_NAME_ERROR_NO_SYNTACTICAL_MAPPING 8474L
#define ERROR_DS_CONSTRUCTED_ATT_MOD 8475L
#define ERROR_DS_WRONG_OM_OBJ_CLASS 8476L
#define ERROR_DS_DRA_REPL_PENDING 8477L
#define ERROR_DS_DS_REQUIRED 8478L
#define ERROR_DS_INVALID_LDAP_DISPLAY_NAME 8479L
#define ERROR_DS_NON_BASE_SEARCH 8480L
#define ERROR_DS_CANT_RETRIEVE_ATTS 8481L
#define ERROR_DS_BACKLINK_WITHOUT_LINK 8482L
#define ERROR_DS_EPOCH_MISMATCH 8483L
#define ERROR_DS_SRC_NAME_MISMATCH 8484L
#define ERROR_DS_SRC_AND_DST_NC_IDENTICAL 8485L
#define ERROR_DS_DST_NC_MISMATCH 8486L
#define ERROR_DS_NOT_AUTHORITIVE_FOR_DST_NC 8487L
#define ERROR_DS_SRC_GUID_MISMATCH 8488L
#define ERROR_DS_CANT_MOVE_DELETED_OBJECT 8489L
#define ERROR_DS_PDC_OPERATION_IN_PROGRESS 8490L
#define ERROR_DS_CROSS_DOMAIN_CLEANUP_REQD 8491L
#define ERROR_DS_ILLEGAL_XDOM_MOVE_OPERATION 8492L
#define ERROR_DS_CANT_WITH_ACCT_GROUP_MEMBERSHPS 8493L
#define ERROR_DS_NC_MUST_HAVE_NC_PARENT 8494L
#define ERROR_DS_CR_IMPOSSIBLE_TO_VALIDATE 8495L
#define ERROR_DS_DST_DOMAIN_NOT_NATIVE 8496L
#define ERROR_DS_MISSING_INFRASTRUCTURE_CONTAINER 8497L
#define ERROR_DS_CANT_MOVE_ACCOUNT_GROUP 8498L
#define ERROR_DS_CANT_MOVE_RESOURCE_GROUP 8499L
#define ERROR_DS_INVALID_SEARCH_FLAG 8500L
#define ERROR_DS_NO_TREE_DELETE_ABOVE_NC 8501L
#define ERROR_DS_COULDNT_LOCK_TREE_FOR_DELETE 8502L
#define ERROR_DS_COULDNT_IDENTIFY_OBJECTS_FOR_TREE_DELETE 8503L
#define ERROR_DS_SAM_INIT_FAILURE 8504L
#define ERROR_DS_SENSITIVE_GROUP_VIOLATION 8505L
#define ERROR_DS_CANT_MOD_PRIMARYGROUPID 8506L
#define ERROR_DS_ILLEGAL_BASE_SCHEMA_MOD 8507L
#define ERROR_DS_NONSAFE_SCHEMA_CHANGE 8508L
#define ERROR_DS_SCHEMA_UPDATE_DISALLOWED 8509L
#define ERROR_DS_CANT_CREATE_UNDER_SCHEMA 8510L
#define ERROR_DS_INSTALL_NO_SRC_SCH_VERSION 8511L
#define ERROR_DS_INSTALL_NO_SCH_VERSION_IN_INIFILE 8512L
#define ERROR_DS_INVALID_GROUP_TYPE 8513L
#define ERROR_DS_NO_NEST_GLOBALGROUP_IN_MIXEDDOMAIN 8514L
#define ERROR_DS_NO_NEST_LOCALGROUP_IN_MIXEDDOMAIN 8515L
#define ERROR_DS_GLOBAL_CANT_HAVE_LOCAL_MEMBER 8516L
#define ERROR_DS_GLOBAL_CANT_HAVE_UNIVERSAL_MEMBER 8517L
#define ERROR_DS_UNIVERSAL_CANT_HAVE_LOCAL_MEMBER 8518L
#define ERROR_DS_GLOBAL_CANT_HAVE_CROSSDOMAIN_MEMBER 8519L
#define ERROR_DS_LOCAL_CANT_HAVE_CROSSDOMAIN_LOCAL_MEMBER 8520L
#define ERROR_DS_HAVE_PRIMARY_MEMBERS 8521L
#define ERROR_DS_STRING_SD_CONVERSION_FAILED 8522L
#define ERROR_DS_NAMING_MASTER_GC 8523L
#define ERROR_DS_DNS_LOOKUP_FAILURE 8524L
#define ERROR_DS_COULDNT_UPDATE_SPNS 8525L
#define ERROR_DS_CANT_RETRIEVE_SD 8526L
#define ERROR_DS_KEY_NOT_UNIQUE 8527L
#define ERROR_DS_WRONG_LINKED_ATT_SYNTAX 8528L
#define ERROR_DS_SAM_NEED_BOOTKEY_PASSWORD 8529L
#define ERROR_DS_SAM_NEED_BOOTKEY_FLOPPY 8530L
#define ERROR_DS_CANT_START 8531L
#define ERROR_DS_INIT_FAILURE 8532L
#define ERROR_DS_NO_PKT_PRIVACY_ON_CONNECTION 8533L
#define ERROR_DS_SOURCE_DOMAIN_IN_FOREST 8534L
#define ERROR_DS_DESTINATION_DOMAIN_NOT_IN_FOREST 8535L
#define ERROR_DS_DESTINATION_AUDITING_NOT_ENABLED 8536L
#define ERROR_DS_CANT_FIND_DC_FOR_SRC_DOMAIN 8537L
#define ERROR_DS_SRC_OBJ_NOT_GROUP_OR_USER 8538L
#define ERROR_DS_SRC_SID_EXISTS_IN_FOREST 8539L
#define ERROR_DS_SRC_AND_DST_OBJECT_CLASS_MISMATCH 8540L
#define ERROR_SAM_INIT_FAILURE 8541L
#define ERROR_DS_DRA_SCHEMA_INFO_SHIP 8542L
#define ERROR_DS_DRA_SCHEMA_CONFLICT 8543L
#define ERROR_DS_DRA_EARLIER_SCHEMA_CONFLICT 8544L
#define ERROR_DS_DRA_OBJ_NC_MISMATCH 8545L
#define ERROR_DS_NC_STILL_HAS_DSAS 8546L
#define ERROR_DS_GC_REQUIRED 8547L
#define ERROR_DS_LOCAL_MEMBER_OF_LOCAL_ONLY 8548L
#define ERROR_DS_NO_FPO_IN_UNIVERSAL_GROUPS 8549L
#define ERROR_DS_CANT_ADD_TO_GC 8550L
#define ERROR_DS_NO_CHECKPOINT_WITH_PDC 8551L
#define ERROR_DS_SOURCE_AUDITING_NOT_ENABLED 8552L
#define ERROR_DS_CANT_CREATE_IN_NONDOMAIN_NC 8553L
#define ERROR_DS_INVALID_NAME_FOR_SPN 8554L
#define ERROR_DS_FILTER_USES_CONTRUCTED_ATTRS 8555L
#define ERROR_DS_UNICODEPWD_NOT_IN_QUOTES 8556L
#define ERROR_DS_MACHINE_ACCOUNT_QUOTA_EXCEEDED 8557L
#define ERROR_DS_MUST_BE_RUN_ON_DST_DC 8558L
#define ERROR_DS_SRC_DC_MUST_BE_SP4_OR_GREATER 8559L
#define ERROR_DS_CANT_TREE_DELETE_CRITICAL_OBJ 8560L
#define ERROR_DS_INIT_FAILURE_CONSOLE 8561L
#define ERROR_DS_SAM_INIT_FAILURE_CONSOLE 8562L
#define ERROR_DS_FOREST_VERSION_TOO_HIGH 8563L
#define ERROR_DS_DOMAIN_VERSION_TOO_HIGH 8564L
#define ERROR_DS_FOREST_VERSION_TOO_LOW 8565L
#define ERROR_DS_DOMAIN_VERSION_TOO_LOW 8566L
#define ERROR_DS_INCOMPATIBLE_VERSION 8567L
#define ERROR_DS_LOW_DSA_VERSION 8568L
#define ERROR_DS_NO_BEHAVIOR_VERSION_IN_MIXEDDOMAIN 8569L
#define ERROR_DS_NOT_SUPPORTED_SORT_ORDER 8570L
#define ERROR_DS_NAME_NOT_UNIQUE 8571L
#define ERROR_DS_MACHINE_ACCOUNT_CREATED_PRENT4 8572L
#define ERROR_DS_OUT_OF_VERSION_STORE 8573L
#define ERROR_DS_INCOMPATIBLE_CONTROLS_USED 8574L
#define ERROR_DS_NO_REF_DOMAIN 8575L
#define ERROR_DS_RESERVED_LINK_ID 8576L
#define ERROR_DS_LINK_ID_NOT_AVAILABLE 8577L
#define ERROR_DS_AG_CANT_HAVE_UNIVERSAL_MEMBER 8578L
#define ERROR_DS_MODIFYDN_DISALLOWED_BY_INSTANCE_TYPE 8579L
#define ERROR_DS_NO_OBJECT_MOVE_IN_SCHEMA_NC 8580L
#define ERROR_DS_MODIFYDN_DISALLOWED_BY_FLAG 8581L
#define ERROR_DS_MODIFYDN_WRONG_GRANDPARENT 8582L
#define ERROR_DS_NAME_ERROR_TRUST_REFERRAL 8583L
#define ERROR_NOT_SUPPORTED_ON_STANDARD_SERVER 8584L
#define ERROR_DS_CANT_ACCESS_REMOTE_PART_OF_AD 8585L
#define ERROR_DS_CR_IMPOSSIBLE_TO_VALIDATE_V2 8586L
#define ERROR_DS_THREAD_LIMIT_EXCEEDED 8587L
#define ERROR_DS_NOT_CLOSEST 8588L
#define ERROR_DS_CANT_DERIVE_SPN_WITHOUT_SERVER_REF 8589L
#define ERROR_DS_SINGLE_USER_MODE_FAILED 8590L
#define ERROR_DS_NTDSCRIPT_SYNTAX_ERROR 8591L
#define ERROR_DS_NTDSCRIPT_PROCESS_ERROR 8592L
#define ERROR_DS_DIFFERENT_REPL_EPOCHS 8593L
#define ERROR_DS_DRS_EXTENSIONS_CHANGED 8594L
#define ERROR_DS_REPLICA_SET_CHANGE_NOT_ALLOWED_ON_DISABLED_CR 8595L
#define ERROR_DS_NO_MSDS_INTID 8596L
#define ERROR_DS_DUP_MSDS_INTID 8597L
#define ERROR_DS_EXISTS_IN_RDNATTID 8598L
#define ERROR_DS_AUTHORIZATION_FAILED 8599L
#define ERROR_DS_INVALID_SCRIPT 8600L
#define ERROR_DS_REMOTE_CROSSREF_OP_FAILED 8601L
#define ERROR_DS_CROSS_REF_BUSY 8602L
#define ERROR_DS_CANT_DERIVE_SPN_FOR_DELETED_DOMAIN 8603L
#define ERROR_DS_CANT_DEMOTE_WITH_WRITEABLE_NC 8604L
#define ERROR_DS_DUPLICATE_ID_FOUND 8605L
#define ERROR_DS_INSUFFICIENT_ATTR_TO_CREATE_OBJECT 8606L
#define ERROR_DS_GROUP_CONVERSION_ERROR 8607L
#define ERROR_DS_CANT_MOVE_APP_BASIC_GROUP 8608L
#define ERROR_DS_CANT_MOVE_APP_QUERY_GROUP 8609L
#define ERROR_DS_ROLE_NOT_VERIFIED 8610L
#define ERROR_DS_WKO_CONTAINER_CANNOT_BE_SPECIAL 8611L
#define ERROR_DS_DOMAIN_RENAME_IN_PROGRESS 8612L
#define ERROR_DS_EXISTING_AD_CHILD_NC 8613L
#define DNS_ERROR_RCODE_FORMAT_ERROR 9001L
#define DNS_ERROR_RCODE_SERVER_FAILURE 9002L
#define DNS_ERROR_RCODE_NAME_ERROR 9003L
#define DNS_ERROR_RCODE_NOT_IMPLEMENTED 9004L
#define DNS_ERROR_RCODE_REFUSED 9005L
#define DNS_ERROR_RCODE_YXDOMAIN 9006L
#define DNS_ERROR_RCODE_YXRRSET 9007L
#define DNS_ERROR_RCODE_NXRRSET 9008L
#define DNS_ERROR_RCODE_NOTAUTH 9009L
#define DNS_ERROR_RCODE_NOTZONE 9010L
#define DNS_ERROR_RCODE_BADSIG 9016L
#define DNS_ERROR_RCODE_BADKEY 9017L
#define DNS_ERROR_RCODE_BADTIME 9018L
#define DNS_INFO_NO_RECORDS 9501L
#define DNS_ERROR_BAD_PACKET 9502L
#define DNS_ERROR_NO_PACKET 9503L
#define DNS_ERROR_RCODE 9504L
#define DNS_ERROR_UNSECURE_PACKET 9505L
#define DNS_ERROR_INVALID_TYPE 9551L
#define DNS_ERROR_INVALID_IP_ADDRESS 9552L
#define DNS_ERROR_INVALID_PROPERTY 9553L
#define DNS_ERROR_TRY_AGAIN_LATER 9554L
#define DNS_ERROR_NOT_UNIQUE 9555L
#define DNS_ERROR_NON_RFC_NAME 9556L
#define DNS_STATUS_FQDN 9557L
#define DNS_STATUS_DOTTED_NAME 9558L
#define DNS_STATUS_SINGLE_PART_NAME 9559L
#define DNS_ERROR_INVALID_NAME_CHAR 9560L
#define DNS_ERROR_NUMERIC_NAME 9561L
#define DNS_ERROR_NOT_ALLOWED_ON_ROOT_SERVER 9562L
#define DNS_ERROR_NOT_ALLOWED_UNDER_DELEGATION 9563L
#define DNS_ERROR_CANNOT_FIND_ROOT_HINTS 9564L
#define DNS_ERROR_INCONSISTENT_ROOT_HINTS 9565L
#define DNS_ERROR_ZONE_DOES_NOT_EXIST 9601L
#define DNS_ERROR_NO_ZONE_INFO 9602L
#define DNS_ERROR_INVALID_ZONE_OPERATION 9603L
#define DNS_ERROR_ZONE_CONFIGURATION_ERROR 9604L
#define DNS_ERROR_ZONE_HAS_NO_SOA_RECORD 9605L
#define DNS_ERROR_ZONE_HAS_NO_NS_RECORDS 9606L
#define DNS_ERROR_ZONE_LOCKED 9607L
#define DNS_ERROR_ZONE_CREATION_FAILED 9608L
#define DNS_ERROR_ZONE_ALREADY_EXISTS 9609L
#define DNS_ERROR_AUTOZONE_ALREADY_EXISTS 9610L
#define DNS_ERROR_INVALID_ZONE_TYPE 9611L
#define DNS_ERROR_SECONDARY_REQUIRES_MASTER_IP 9612L
#define DNS_ERROR_ZONE_NOT_SECONDARY 9613L
#define DNS_ERROR_NEED_SECONDARY_ADDRESSES 9614L
#define DNS_ERROR_WINS_INIT_FAILED 9615L
#define DNS_ERROR_NEED_WINS_SERVERS 9616L
#define DNS_ERROR_NBSTAT_INIT_FAILED 9617L
#define DNS_ERROR_SOA_DELETE_INVALID 9618L
#define DNS_ERROR_FORWARDER_ALREADY_EXISTS 9619L
#define DNS_ERROR_ZONE_REQUIRES_MASTER_IP 9620L
#define DNS_ERROR_ZONE_IS_SHUTDOWN 9621L
#define DNS_ERROR_PRIMARY_REQUIRES_DATAFILE 9651L
#define DNS_ERROR_INVALID_DATAFILE_NAME 9652L
#define DNS_ERROR_DATAFILE_OPEN_FAILURE 9653L
#define DNS_ERROR_FILE_WRITEBACK_FAILED 9654L
#define DNS_ERROR_DATAFILE_PARSING 9655L
#define DNS_ERROR_RECORD_DOES_NOT_EXIST 9701L
#define DNS_ERROR_RECORD_FORMAT 9702L
#define DNS_ERROR_NODE_CREATION_FAILED 9703L
#define DNS_ERROR_UNKNOWN_RECORD_TYPE 9704L
#define DNS_ERROR_RECORD_TIMED_OUT 9705L
#define DNS_ERROR_NAME_NOT_IN_ZONE 9706L
#define DNS_ERROR_CNAME_LOOP 9707L
#define DNS_ERROR_NODE_IS_CNAME 9708L
#define DNS_ERROR_CNAME_COLLISION 9709L
#define DNS_ERROR_RECORD_ONLY_AT_ZONE_ROOT 9710L
#define DNS_ERROR_RECORD_ALREADY_EXISTS 9711L
#define DNS_ERROR_SECONDARY_DATA 9712L
#define DNS_ERROR_NO_CREATE_CACHE_DATA 9713L
#define DNS_ERROR_NAME_DOES_NOT_EXIST 9714L
#define DNS_WARNING_PTR_CREATE_FAILED 9715L
#define DNS_WARNING_DOMAIN_UNDELETED 9716L
#define DNS_ERROR_DS_UNAVAILABLE 9717L
#define DNS_ERROR_DS_ZONE_ALREADY_EXISTS 9718L
#define DNS_ERROR_NO_BOOTFILE_IF_DS_ZONE 9719L
#define DNS_INFO_AXFR_COMPLETE 9751L
#define DNS_ERROR_AXFR 9752L
#define DNS_INFO_ADDED_LOCAL_WINS 9753L
#define DNS_STATUS_CONTINUE_NEEDED 9801L
#define DNS_ERROR_NO_TCPIP 9851L
#define DNS_ERROR_NO_DNS_SERVERS 9852L
#define DNS_ERROR_DP_DOES_NOT_EXIST 9901L
#define DNS_ERROR_DP_ALREADY_EXISTS 9902L
#define DNS_ERROR_DP_NOT_ENLISTED 9903L
#define DNS_ERROR_DP_ALREADY_ENLISTED 9904L
#define DNS_ERROR_DP_NOT_AVAILABLE 9905L

#ifndef WSABASEERR
#    define WSABASEERR 10000
#    define WSAEINTR 10004L
#    define WSAEBADF 10009L
#    define WSAEACCES 10013L
#    define WSAEFAULT 10014L
#    define WSAEINVAL 10022L
#    define WSAEMFILE 10024L
#    define WSAEWOULDBLOCK 10035L
#    define WSAEINPROGRESS 10036L
#    define WSAEALREADY 10037L
#    define WSAENOTSOCK 10038L
#    define WSAEDESTADDRREQ 10039L
#    define WSAEMSGSIZE 10040L
#    define WSAEPROTOTYPE 10041L
#    define WSAENOPROTOOPT 10042L
#    define WSAEPROTONOSUPPORT 10043L
#    define WSAESOCKTNOSUPPORT 10044L
#    define WSAEOPNOTSUPP 10045L
#    define WSAEPFNOSUPPORT 10046L
#    define WSAEAFNOSUPPORT 10047L
#    define WSAEADDRINUSE 10048L
#    define WSAEADDRNOTAVAIL 10049L
#    define WSAENETDOWN 10050L
#    define WSAENETUNREACH 10051L
#    define WSAENETRESET 10052L
#    define WSAECONNABORTED 10053L
#    define WSAECONNRESET 10054L
#    define WSAENOBUFS 10055L
#    define WSAEISCONN 10056L
#    define WSAENOTCONN 10057L
#    define WSAESHUTDOWN 10058L
#    define WSAETOOMANYREFS 10059L
#    define WSAETIMEDOUT 10060L
#    define WSAECONNREFUSED 10061L
#    define WSAELOOP 10062L
#    define WSAENAMETOOLONG 10063L
#    define WSAEHOSTDOWN 10064L
#    define WSAEHOSTUNREACH 10065L
#    define WSAENOTEMPTY 10066L
#    define WSAEPROCLIM 10067L
#    define WSAEUSERS 10068L
#    define WSAEDQUOT 10069L
#    define WSAESTALE 10070L
#    define WSAEREMOTE 10071L
#    define WSASYSNOTREADY 10091L
#    define WSAVERNOTSUPPORTED 10092L
#    define WSANOTINITIALISED 10093L
#    define WSAEDISCON 10101L
#    define WSAENOMORE 10102L
#    define WSAECANCELLED 10103L
#    define WSAEINVALIDPROCTABLE 10104L
#    define WSAEINVALIDPROVIDER 10105L
#    define WSAEPROVIDERFAILEDINIT 10106L
#    define WSASYSCALLFAILURE 10107L
#    define WSASERVICE_NOT_FOUND 10108L
#    define WSATYPE_NOT_FOUND 10109L
#    define WSA_E_NO_MORE 10110L
#    define WSA_E_CANCELLED 10111L
#    define WSAEREFUSED 10112L
#    define WSAHOST_NOT_FOUND 11001L
#    define WSATRY_AGAIN 11002L
#    define WSANO_RECOVERY 11003L
#    define WSANO_DATA 11004L
#    define WSA_QOS_RECEIVERS 11005L
#    define WSA_QOS_SENDERS 11006L
#    define WSA_QOS_NO_SENDERS 11007L
#    define WSA_QOS_NO_RECEIVERS 11008L
#    define WSA_QOS_REQUEST_CONFIRMED 11009L
#    define WSA_QOS_ADMISSION_FAILURE 11010L
#    define WSA_QOS_POLICY_FAILURE 11011L
#    define WSA_QOS_BAD_STYLE 11012L
#    define WSA_QOS_BAD_OBJECT 11013L
#    define WSA_QOS_TRAFFIC_CTRL_ERROR 11014L
#    define WSA_QOS_GENERIC_ERROR 11015L
#    define WSA_QOS_ESERVICETYPE 11016L
#    define WSA_QOS_EFLOWSPEC 11017L
#    define WSA_QOS_EPROVSPECBUF 11018L
#    define WSA_QOS_EFILTERSTYLE 11019L
#    define WSA_QOS_EFILTERTYPE 11020L
#    define WSA_QOS_EFILTERCOUNT 11021L
#    define WSA_QOS_EOBJLENGTH 11022L
#    define WSA_QOS_EFLOWCOUNT 11023L
#    define WSA_QOS_EUNKOWNPSOBJ 11024L
#    define WSA_QOS_EPOLICYOBJ 11025L
#    define WSA_QOS_EFLOWDESC 11026L
#    define WSA_QOS_EPSFLOWSPEC 11027L
#    define WSA_QOS_EPSFILTERSPEC 11028L
#    define WSA_QOS_ESDMODEOBJ 11029L
#    define WSA_QOS_ESHAPERATEOBJ 11030L
#    define WSA_QOS_RESERVED_PETYPE 11031L
#endif /* !WSABASEERR */

#define ERROR_IPSEC_QM_POLICY_EXISTS 13000L
#define ERROR_IPSEC_QM_POLICY_NOT_FOUND 13001L
#define ERROR_IPSEC_QM_POLICY_IN_USE 13002L
#define ERROR_IPSEC_MM_POLICY_EXISTS 13003L
#define ERROR_IPSEC_MM_POLICY_NOT_FOUND 13004L
#define ERROR_IPSEC_MM_POLICY_IN_USE 13005L
#define ERROR_IPSEC_MM_FILTER_EXISTS 13006L
#define ERROR_IPSEC_MM_FILTER_NOT_FOUND 13007L
#define ERROR_IPSEC_TRANSPORT_FILTER_EXISTS 13008L
#define ERROR_IPSEC_TRANSPORT_FILTER_NOT_FOUND 13009L
#define ERROR_IPSEC_MM_AUTH_EXISTS 13010L
#define ERROR_IPSEC_MM_AUTH_NOT_FOUND 13011L
#define ERROR_IPSEC_MM_AUTH_IN_USE 13012L
#define ERROR_IPSEC_DEFAULT_MM_POLICY_NOT_FOUND 13013L
#define ERROR_IPSEC_DEFAULT_MM_AUTH_NOT_FOUND 13014L
#define ERROR_IPSEC_DEFAULT_QM_POLICY_NOT_FOUND 13015L
#define ERROR_IPSEC_TUNNEL_FILTER_EXISTS 13016L
#define ERROR_IPSEC_TUNNEL_FILTER_NOT_FOUND 13017L
#define ERROR_IPSEC_MM_FILTER_PENDING_DELETION 13018L
#define ERROR_IPSEC_TRANSPORT_FILTER_PENDING_DELETION 13019L
#define ERROR_IPSEC_TUNNEL_FILTER_PENDING_DELETION 13020L
#define ERROR_IPSEC_MM_POLICY_PENDING_DELETION 13021L
#define ERROR_IPSEC_MM_AUTH_PENDING_DELETION 13022L
#define ERROR_IPSEC_QM_POLICY_PENDING_DELETION 13023L
#define WARNING_IPSEC_MM_POLICY_PRUNED 13024L
#define WARNING_IPSEC_QM_POLICY_PRUNED 13025L
#define ERROR_IPSEC_IKE_AUTH_FAIL 13801L
#define ERROR_IPSEC_IKE_ATTRIB_FAIL 13802L
#define ERROR_IPSEC_IKE_NEGOTIATION_PENDING 13803L
#define ERROR_IPSEC_IKE_GENERAL_PROCESSING_ERROR 13804L
#define ERROR_IPSEC_IKE_TIMED_OUT 13805L
#define ERROR_IPSEC_IKE_NO_CERT 13806L
#define ERROR_IPSEC_IKE_SA_DELETED 13807L
#define ERROR_IPSEC_IKE_SA_REAPED 13808L
#define ERROR_IPSEC_IKE_MM_ACQUIRE_DROP 13809L
#define ERROR_IPSEC_IKE_QM_ACQUIRE_DROP 13810L
#define ERROR_IPSEC_IKE_QUEUE_DROP_MM 13811L
#define ERROR_IPSEC_IKE_QUEUE_DROP_NO_MM 13812L
#define ERROR_IPSEC_IKE_DROP_NO_RESPONSE 13813L
#define ERROR_IPSEC_IKE_MM_DELAY_DROP 13814L
#define ERROR_IPSEC_IKE_QM_DELAY_DROP 13815L
#define ERROR_IPSEC_IKE_ERROR 13816L
#define ERROR_IPSEC_IKE_CRL_FAILED 13817L
#define ERROR_IPSEC_IKE_INVALID_KEY_USAGE 13818L
#define ERROR_IPSEC_IKE_INVALID_CERT_TYPE 13819L
#define ERROR_IPSEC_IKE_NO_PRIVATE_KEY 13820L
#define ERROR_IPSEC_IKE_DH_FAIL 13822L
#define ERROR_IPSEC_IKE_INVALID_HEADER 13824L
#define ERROR_IPSEC_IKE_NO_POLICY 13825L
#define ERROR_IPSEC_IKE_INVALID_SIGNATURE 13826L
#define ERROR_IPSEC_IKE_KERBEROS_ERROR 13827L
#define ERROR_IPSEC_IKE_NO_PUBLIC_KEY 13828L
#define ERROR_IPSEC_IKE_PROCESS_ERR 13829L
#define ERROR_IPSEC_IKE_PROCESS_ERR_SA 13830L
#define ERROR_IPSEC_IKE_PROCESS_ERR_PROP 13831L
#define ERROR_IPSEC_IKE_PROCESS_ERR_TRANS 13832L
#define ERROR_IPSEC_IKE_PROCESS_ERR_KE 13833L
#define ERROR_IPSEC_IKE_PROCESS_ERR_ID 13834L
#define ERROR_IPSEC_IKE_PROCESS_ERR_CERT 13835L
#define ERROR_IPSEC_IKE_PROCESS_ERR_CERT_REQ 13836L
#define ERROR_IPSEC_IKE_PROCESS_ERR_HASH 13837L
#define ERROR_IPSEC_IKE_PROCESS_ERR_SIG 13838L
#define ERROR_IPSEC_IKE_PROCESS_ERR_NONCE 13839L
#define ERROR_IPSEC_IKE_PROCESS_ERR_NOTIFY 13840L
#define ERROR_IPSEC_IKE_PROCESS_ERR_DELETE 13841L
#define ERROR_IPSEC_IKE_PROCESS_ERR_VENDOR 13842L
#define ERROR_IPSEC_IKE_INVALID_PAYLOAD 13843L
#define ERROR_IPSEC_IKE_LOAD_SOFT_SA 13844L
#define ERROR_IPSEC_IKE_SOFT_SA_TORN_DOWN 13845L
#define ERROR_IPSEC_IKE_INVALID_COOKIE 13846L
#define ERROR_IPSEC_IKE_NO_PEER_CERT 13847L
#define ERROR_IPSEC_IKE_PEER_CRL_FAILED 13848L
#define ERROR_IPSEC_IKE_POLICY_CHANGE 13849L
#define ERROR_IPSEC_IKE_NO_MM_POLICY 13850L
#define ERROR_IPSEC_IKE_NOTCBPRIV 13851L
#define ERROR_IPSEC_IKE_SECLOADFAIL 13852L
#define ERROR_IPSEC_IKE_FAILSSPINIT 13853L
#define ERROR_IPSEC_IKE_FAILQUERYSSP 13854L
#define ERROR_IPSEC_IKE_SRVACQFAIL 13855L
#define ERROR_IPSEC_IKE_SRVQUERYCRED 13856L
#define ERROR_IPSEC_IKE_GETSPIFAIL 13857L
#define ERROR_IPSEC_IKE_INVALID_FILTER 13858L
#define ERROR_IPSEC_IKE_OUT_OF_MEMORY 13859L
#define ERROR_IPSEC_IKE_ADD_UPDATE_KEY_FAILED 13860L
#define ERROR_IPSEC_IKE_INVALID_POLICY 13861L
#define ERROR_IPSEC_IKE_UNKNOWN_DOI 13862L
#define ERROR_IPSEC_IKE_INVALID_SITUATION 13863L
#define ERROR_IPSEC_IKE_DH_FAILURE 13864L
#define ERROR_IPSEC_IKE_INVALID_GROUP 13865L
#define ERROR_IPSEC_IKE_ENCRYPT 13866L
#define ERROR_IPSEC_IKE_DECRYPT 13867L
#define ERROR_IPSEC_IKE_POLICY_MATCH 13868L
#define ERROR_IPSEC_IKE_UNSUPPORTED_ID 13869L
#define ERROR_IPSEC_IKE_INVALID_HASH 13870L
#define ERROR_IPSEC_IKE_INVALID_HASH_ALG 13871L
#define ERROR_IPSEC_IKE_INVALID_HASH_SIZE 13872L
#define ERROR_IPSEC_IKE_INVALID_ENCRYPT_ALG 13873L
#define ERROR_IPSEC_IKE_INVALID_AUTH_ALG 13874L
#define ERROR_IPSEC_IKE_INVALID_SIG 13875L
#define ERROR_IPSEC_IKE_LOAD_FAILED 13876L
#define ERROR_IPSEC_IKE_RPC_DELETE 13877L
#define ERROR_IPSEC_IKE_BENIGN_REINIT 13878L
#define ERROR_IPSEC_IKE_INVALID_RESPONDER_LIFETIME_NOTIFY 13879L
#define ERROR_IPSEC_IKE_INVALID_CERT_KEYLEN 13881L
#define ERROR_IPSEC_IKE_MM_LIMIT 13882L
#define ERROR_IPSEC_IKE_NEGOTIATION_DISABLED 13883L
#define ERROR_IPSEC_IKE_NEG_STATUS_END 13884L

#define ERROR_SXS_SECTION_NOT_FOUND 14000L
#define ERROR_SXS_CANT_GEN_ACTCTX 14001L
#define ERROR_SXS_INVALID_ACTCTXDATA_FORMAT 14002L
#define ERROR_SXS_ASSEMBLY_NOT_FOUND 14003L
#define ERROR_SXS_MANIFEST_FORMAT_ERROR 14004L
#define ERROR_SXS_MANIFEST_PARSE_ERROR 14005L
#define ERROR_SXS_ACTIVATION_CONTEXT_DISABLED 14006L
#define ERROR_SXS_KEY_NOT_FOUND 14007L
#define ERROR_SXS_VERSION_CONFLICT 14008L
#define ERROR_SXS_WRONG_SECTION_TYPE 14009L
#define ERROR_SXS_THREAD_QUERIES_DISABLED 14010L
#define ERROR_SXS_PROCESS_DEFAULT_ALREADY_SET 14011L
#define ERROR_SXS_UNKNOWN_ENCODING_GROUP 14012L
#define ERROR_SXS_UNKNOWN_ENCODING 14013L
#define ERROR_SXS_INVALID_XML_NAMESPACE_URI 14014L
#define ERROR_SXS_ROOT_MANIFEST_DEPENDENCY_NOT_INSTALLED 14015L
#define ERROR_SXS_LEAF_MANIFEST_DEPENDENCY_NOT_INSTALLED 14016L
#define ERROR_SXS_INVALID_ASSEMBLY_IDENTITY_ATTRIBUTE 14017L
#define ERROR_SXS_MANIFEST_MISSING_REQUIRED_DEFAULT_NAMESPACE 14018L
#define ERROR_SXS_MANIFEST_INVALID_REQUIRED_DEFAULT_NAMESPACE 14019L
#define ERROR_SXS_PRIVATE_MANIFEST_CROSS_PATH_WITH_REPARSE_POINT 14020L
#define ERROR_SXS_DUPLICATE_DLL_NAME 14021L
#define ERROR_SXS_DUPLICATE_WINDOWCLASS_NAME 14022L
#define ERROR_SXS_DUPLICATE_CLSID 14023L
#define ERROR_SXS_DUPLICATE_IID 14024L
#define ERROR_SXS_DUPLICATE_TLBID 14025L
#define ERROR_SXS_DUPLICATE_PROGID 14026L
#define ERROR_SXS_DUPLICATE_ASSEMBLY_NAME 14027L
#define ERROR_SXS_FILE_HASH_MISMATCH 14028L
#define ERROR_SXS_POLICY_PARSE_ERROR 14029L
#define ERROR_SXS_XML_E_MISSINGQUOTE 14030L
#define ERROR_SXS_XML_E_COMMENTSYNTAX 14031L
#define ERROR_SXS_XML_E_BADSTARTNAMECHAR 14032L
#define ERROR_SXS_XML_E_BADNAMECHAR 14033L
#define ERROR_SXS_XML_E_BADCHARINSTRING 14034L
#define ERROR_SXS_XML_E_XMLDECLSYNTAX 14035L
#define ERROR_SXS_XML_E_BADCHARDATA 14036L
#define ERROR_SXS_XML_E_MISSINGWHITESPACE 14037L
#define ERROR_SXS_XML_E_EXPECTINGTAGEND 14038L
#define ERROR_SXS_XML_E_MISSINGSEMICOLON 14039L
#define ERROR_SXS_XML_E_UNBALANCEDPAREN 14040L
#define ERROR_SXS_XML_E_INTERNALERROR 14041L
#define ERROR_SXS_XML_E_UNEXPECTED_WHITESPACE 14042L
#define ERROR_SXS_XML_E_INCOMPLETE_ENCODING 14043L
#define ERROR_SXS_XML_E_MISSING_PAREN 14044L
#define ERROR_SXS_XML_E_EXPECTINGCLOSEQUOTE 14045L
#define ERROR_SXS_XML_E_MULTIPLE_COLONS 14046L
#define ERROR_SXS_XML_E_INVALID_DECIMAL 14047L
#define ERROR_SXS_XML_E_INVALID_HEXIDECIMAL 14048L
#define ERROR_SXS_XML_E_INVALID_UNICODE 14049L
#define ERROR_SXS_XML_E_WHITESPACEORQUESTIONMARK 14050L
#define ERROR_SXS_XML_E_UNEXPECTEDENDTAG 14051L
#define ERROR_SXS_XML_E_UNCLOSEDTAG 14052L
#define ERROR_SXS_XML_E_DUPLICATEATTRIBUTE 14053L
#define ERROR_SXS_XML_E_MULTIPLEROOTS 14054L
#define ERROR_SXS_XML_E_INVALIDATROOTLEVEL 14055L
#define ERROR_SXS_XML_E_BADXMLDECL 14056L
#define ERROR_SXS_XML_E_MISSINGROOT 14057L
#define ERROR_SXS_XML_E_UNEXPECTEDEOF 14058L
#define ERROR_SXS_XML_E_BADPEREFINSUBSET 14059L
#define ERROR_SXS_XML_E_UNCLOSEDSTARTTAG 14060L
#define ERROR_SXS_XML_E_UNCLOSEDENDTAG 14061L
#define ERROR_SXS_XML_E_UNCLOSEDSTRING 14062L
#define ERROR_SXS_XML_E_UNCLOSEDCOMMENT 14063L
#define ERROR_SXS_XML_E_UNCLOSEDDECL 14064L
#define ERROR_SXS_XML_E_UNCLOSEDCDATA 14065L
#define ERROR_SXS_XML_E_RESERVEDNAMESPACE 14066L
#define ERROR_SXS_XML_E_INVALIDENCODING 14067L
#define ERROR_SXS_XML_E_INVALIDSWITCH 14068L
#define ERROR_SXS_XML_E_BADXMLCASE 14069L
#define ERROR_SXS_XML_E_INVALID_STANDALONE 14070L
#define ERROR_SXS_XML_E_UNEXPECTED_STANDALONE 14071L
#define ERROR_SXS_XML_E_INVALID_VERSION 14072L
#define ERROR_SXS_XML_E_MISSINGEQUALS 14073L
#define ERROR_SXS_PROTECTION_RECOVERY_FAILED 14074L
#define ERROR_SXS_PROTECTION_PUBLIC_KEY_TOO_SHORT 14075L
#define ERROR_SXS_PROTECTION_CATALOG_NOT_VALID 14076L
#define ERROR_SXS_UNTRANSLATABLE_HRESULT 14077L
#define ERROR_SXS_PROTECTION_CATALOG_FILE_MISSING 14078L
#define ERROR_SXS_MISSING_ASSEMBLY_IDENTITY_ATTRIBUTE 14079L
#define ERROR_SXS_INVALID_ASSEMBLY_IDENTITY_ATTRIBUTE_NAME 14080L

// Crypto realted errors
#define CRYPT_E_NOT_FOUND _HRESULT_TYPEDEF_(0x80092004L)
#define CRYPT_E_EXISTS _HRESULT_TYPEDEF_(0x80092005L)
#define CRYPT_E_NO_PROVIDER _HRESULT_TYPEDEF_(0x80092006L)
#define CRYPT_E_SELF_SIGNED _HRESULT_TYPEDEF_(0x80092007L)
#define CRYPT_E_DELETED_PREV _HRESULT_TYPEDEF_(0x80092008L)
#define CRYPT_E_NO_MATCH _HRESULT_TYPEDEF_(0x80092009L)
#define CRYPT_E_UNEXPECTED_MSG_TYPE _HRESULT_TYPEDEF_(0x8009200AL)
#define CRYPT_E_NO_KEY_PROPERTY _HRESULT_TYPEDEF_(0x8009200BL)
#define CRYPT_E_NO_DECRYPT_CERT _HRESULT_TYPEDEF_(0x8009200CL)
#define CRYPT_E_BAD_MSG _HRESULT_TYPEDEF_(0x8009200DL)
#define CRYPT_E_NO_SIGNER _HRESULT_TYPEDEF_(0x8009200EL)
#define CRYPT_E_PENDING_CLOSE _HRESULT_TYPEDEF_(0x8009200FL)
#define CRYPT_E_REVOKED _HRESULT_TYPEDEF_(0x80092010L)
#define CRYPT_E_NO_REVOCATION_DLL _HRESULT_TYPEDEF_(0x80092011L)
#define CRYPT_E_NO_REVOCATION_CHECK _HRESULT_TYPEDEF_(0x80092012L)

#define CO_E_INIT_TLS ((HRESULT)0x80004006L)
#define CO_E_INIT_SHARED_ALLOCATOR ((HRESULT)0x80004007L)
#define CO_E_INIT_MEMORY_ALLOCATOR ((HRESULT)0x80004008L)
#define CO_E_INIT_CLASS_CACHE ((HRESULT)0x80004009L)
#define CO_E_INIT_RPC_CHANNEL ((HRESULT)0x8000400AL)
#define CO_E_INIT_TLS_SET_CHANNEL_CONTROL ((HRESULT)0x8000400BL)
#define CO_E_INIT_TLS_CHANNEL_CONTROL ((HRESULT)0x8000400CL)
#define CO_E_INIT_UNACCEPTED_USER_ALLOCATOR ((HRESULT)0x8000400DL)
#define CO_E_INIT_SCM_MUTEX_EXISTS ((HRESULT)0x8000400EL)
#define CO_E_INIT_SCM_FILE_MAPPING_EXISTS ((HRESULT)0x8000400FL)
#define CO_E_INIT_SCM_MAP_VIEW_OF_FILE ((HRESULT)0x80004010L)
#define CO_E_INIT_SCM_EXEC_FAILURE ((HRESULT)0x80004011L)
#define CO_E_INIT_ONLY_SINGLE_THREADED ((HRESULT)0x80004012L)
#define OLE_E_FIRST ((HRESULT)0x80040000L)
#define OLE_E_LAST ((HRESULT)0x800400FFL)
#define OLE_S_FIRST ((HRESULT)0x00040000L)
#define OLE_S_LAST ((HRESULT)0x000400FFL)
#define OLE_E_OLEVERB ((HRESULT)0x80040000L)
#define OLE_E_ADVF ((HRESULT)0x80040001L)
#define OLE_E_ENUM_NOMORE ((HRESULT)0x80040002L)
#define OLE_E_ADVISENOTSUPPORTED ((HRESULT)0x80040003L)
#define OLE_E_NOCONNECTION ((HRESULT)0x80040004L)
#define OLE_E_NOTRUNNING ((HRESULT)0x80040005L)
#define OLE_E_NOCACHE ((HRESULT)0x80040006L)
#define OLE_E_BLANK ((HRESULT)0x80040007L)
#define OLE_E_CLASSDIFF ((HRESULT)0x80040008L)
#define OLE_E_CANT_GETMONIKER ((HRESULT)0x80040009L)
#define OLE_E_CANT_BINDTOSOURCE ((HRESULT)0x8004000AL)
#define OLE_E_STATIC ((HRESULT)0x8004000BL)
#define OLE_E_PROMPTSAVECANCELLED ((HRESULT)0x8004000CL)
#define OLE_E_INVALIDRECT ((HRESULT)0x8004000DL)
#define OLE_E_WRONGCOMPOBJ ((HRESULT)0x8004000EL)
#define OLE_E_INVALIDHWND ((HRESULT)0x8004000FL)
#define OLE_E_NOT_INPLACEACTIVE ((HRESULT)0x80040010L)
#define OLE_E_CANTCONVERT ((HRESULT)0x80040011L)
#define OLE_E_NOSTORAGE ((HRESULT)0x80040012L)
#define DV_E_FORMATETC ((HRESULT)0x80040064L)
#define DV_E_DVTARGETDEVICE ((HRESULT)0x80040065L)
#define DV_E_STGMEDIUM ((HRESULT)0x80040066L)
#define DV_E_STATDATA ((HRESULT)0x80040067L)
#define DV_E_LINDEX ((HRESULT)0x80040068L)
#define DV_E_TYMED ((HRESULT)0x80040069L)
#define DV_E_CLIPFORMAT ((HRESULT)0x8004006AL)
#define DV_E_DVASPECT ((HRESULT)0x8004006BL)
#define DV_E_DVTARGETDEVICE_SIZE ((HRESULT)0x8004006CL)
#define DV_E_NOIVIEWOBJECT ((HRESULT)0x8004006DL)
#define DRAGDROP_E_FIRST ((HRESULT)0x80040100L)
#define DRAGDROP_E_LAST ((HRESULT)0x8004010FL)
#define DRAGDROP_S_FIRST ((HRESULT)0x00040100L)
#define DRAGDROP_S_LAST ((HRESULT)0x0004010FL)
#define DRAGDROP_E_NOTREGISTERED ((HRESULT)0x80040100L)
#define DRAGDROP_E_ALREADYREGISTERED ((HRESULT)0x80040101L)
#define DRAGDROP_E_INVALIDHWND ((HRESULT)0x80040102L)
#define CLASSFACTORY_E_FIRST ((HRESULT)0x80040110L)
#define CLASSFACTORY_E_LAST ((HRESULT)0x8004011FL)
#define CLASSFACTORY_S_FIRST ((HRESULT)0x00040110L)
#define CLASSFACTORY_S_LAST ((HRESULT)0x0004011FL)
#define CLASS_E_NOAGGREGATION ((HRESULT)0x80040110L)
#define CLASS_E_CLASSNOTAVAILABLE ((HRESULT)0x80040111L)
#define MARSHAL_E_FIRST ((HRESULT)0x80040120L)
#define MARSHAL_E_LAST ((HRESULT)0x8004012FL)
#define MARSHAL_S_FIRST ((HRESULT)0x00040120L)
#define MARSHAL_S_LAST ((HRESULT)0x0004012FL)
#define DATA_E_FIRST ((HRESULT)0x80040130L)
#define DATA_E_LAST ((HRESULT)0x8004013FL)
#define DATA_S_FIRST ((HRESULT)0x00040130L)
#define DATA_S_LAST ((HRESULT)0x0004013FL)
#define VIEW_E_FIRST ((HRESULT)0x80040140L)
#define VIEW_E_LAST ((HRESULT)0x8004014FL)
#define VIEW_S_FIRST ((HRESULT)0x00040140L)
#define VIEW_S_LAST ((HRESULT)0x0004014FL)
#define VIEW_E_DRAW ((HRESULT)0x80040140L)
#define REGDB_E_FIRST ((HRESULT)0x80040150L)
#define REGDB_E_LAST ((HRESULT)0x8004015FL)
#define REGDB_S_FIRST ((HRESULT)0x00040150L)
#define REGDB_S_LAST ((HRESULT)0x0004015FL)
#define REGDB_E_READREGDB ((HRESULT)0x80040150L)
#define REGDB_E_WRITEREGDB ((HRESULT)0x80040151L)
#define REGDB_E_KEYMISSING ((HRESULT)0x80040152L)
#define REGDB_E_INVALIDVALUE ((HRESULT)0x80040153L)
#define REGDB_E_CLASSNOTREG ((HRESULT)0x80040154L)
#define REGDB_E_IIDNOTREG ((HRESULT)0x80040155L)
#define CACHE_E_FIRST ((HRESULT)0x80040170L)
#define CACHE_E_LAST ((HRESULT)0x8004017FL)
#define CACHE_S_FIRST ((HRESULT)0x00040170L)
#define CACHE_S_LAST ((HRESULT)0x0004017FL)
#define CACHE_E_NOCACHE_UPDATED ((HRESULT)0x80040170L)
#define OLEOBJ_E_FIRST ((HRESULT)0x80040180L)
#define OLEOBJ_E_LAST ((HRESULT)0x8004018FL)
#define OLEOBJ_S_FIRST ((HRESULT)0x00040180L)
#define OLEOBJ_S_LAST ((HRESULT)0x0004018FL)
#define OLEOBJ_E_NOVERBS ((HRESULT)0x80040180L)
#define OLEOBJ_E_INVALIDVERB ((HRESULT)0x80040181L)
#define CLIENTSITE_E_FIRST ((HRESULT)0x80040190L)
#define CLIENTSITE_E_LAST ((HRESULT)0x8004019FL)
#define CLIENTSITE_S_FIRST ((HRESULT)0x00040190L)
#define CLIENTSITE_S_LAST ((HRESULT)0x0004019FL)
#define INPLACE_E_NOTUNDOABLE ((HRESULT)0x800401A0L)
#define INPLACE_E_NOTOOLSPACE ((HRESULT)0x800401A1L)
#define INPLACE_E_FIRST ((HRESULT)0x800401A0L)
#define INPLACE_E_LAST ((HRESULT)0x800401AFL)
#define INPLACE_S_FIRST ((HRESULT)0x000401A0L)
#define INPLACE_S_LAST ((HRESULT)0x000401AFL)
#define ENUM_E_FIRST ((HRESULT)0x800401B0L)
#define ENUM_E_LAST ((HRESULT)0x800401BFL)
#define ENUM_S_FIRST ((HRESULT)0x000401B0L)
#define ENUM_S_LAST ((HRESULT)0x000401BFL)
#define CONVERT10_E_FIRST ((HRESULT)0x800401C0L)
#define CONVERT10_E_LAST ((HRESULT)0x800401CFL)
#define CONVERT10_S_FIRST ((HRESULT)0x000401C0L)
#define CONVERT10_S_LAST ((HRESULT)0x000401CFL)
#define CONVERT10_E_OLESTREAM_GET ((HRESULT)0x800401C0L)
#define CONVERT10_E_OLESTREAM_PUT ((HRESULT)0x800401C1L)
#define CONVERT10_E_OLESTREAM_FMT ((HRESULT)0x800401C2L)
#define CONVERT10_E_OLESTREAM_BITMAP_TO_DIB ((HRESULT)0x800401C3L)
#define CONVERT10_E_STG_FMT ((HRESULT)0x800401C4L)
#define CONVERT10_E_STG_NO_STD_STREAM ((HRESULT)0x800401C5L)
#define CONVERT10_E_STG_DIB_TO_BITMAP ((HRESULT)0x800401C6L)
#define CLIPBRD_E_FIRST ((HRESULT)0x800401D0L)
#define CLIPBRD_E_LAST ((HRESULT)0x800401DFL)
#define CLIPBRD_S_FIRST ((HRESULT)0x000401D0L)
#define CLIPBRD_S_LAST ((HRESULT)0x000401DFL)
#define CLIPBRD_E_CANT_OPEN ((HRESULT)0x800401D0L)
#define CLIPBRD_E_CANT_EMPTY ((HRESULT)0x800401D1L)
#define CLIPBRD_E_CANT_SET ((HRESULT)0x800401D2L)
#define CLIPBRD_E_BAD_DATA ((HRESULT)0x800401D3L)
#define CLIPBRD_E_CANT_CLOSE ((HRESULT)0x800401D4L)
#define MK_E_FIRST ((HRESULT)0x800401E0L)
#define MK_E_LAST ((HRESULT)0x800401EFL)
#define MK_S_FIRST ((HRESULT)0x000401E0L)
#define MK_S_LAST ((HRESULT)0x000401EFL)
#define MK_E_CONNECTMANUALLY ((HRESULT)0x800401E0L)
#define MK_E_EXCEEDEDDEADLINE ((HRESULT)0x800401E1L)
#define MK_E_NEEDGENERIC ((HRESULT)0x800401E2L)
#define MK_E_UNAVAILABLE ((HRESULT)0x800401E3L)
#define MK_E_SYNTAX ((HRESULT)0x800401E4L)
#define MK_E_NOOBJECT ((HRESULT)0x800401E5L)
#define MK_E_INVALIDEXTENSION ((HRESULT)0x800401E6L)
#define MK_E_INTERMEDIATEINTERFACENOTSUPPORTED ((HRESULT)0x800401E7L)
#define MK_E_NOTBINDABLE ((HRESULT)0x800401E8L)
#define MK_E_NOTBOUND ((HRESULT)0x800401E9L)
#define MK_E_CANTOPENFILE ((HRESULT)0x800401EAL)
#define MK_E_MUSTBOTHERUSER ((HRESULT)0x800401EBL)
#define MK_E_NOINVERSE ((HRESULT)0x800401ECL)
#define MK_E_NOSTORAGE ((HRESULT)0x800401EDL)
#define MK_E_NOPREFIX ((HRESULT)0x800401EEL)
#define MK_E_ENUMERATION_FAILED ((HRESULT)0x800401EFL)
#define CO_E_FIRST ((HRESULT)0x800401F0L)
#define CO_E_LAST ((HRESULT)0x800401FFL)
#define CO_S_FIRST ((HRESULT)0x000401F0L)
#define CO_S_LAST ((HRESULT)0x000401FFL)
#define CO_E_NOTINITIALIZED ((HRESULT)0x800401F0L)
#define CO_E_ALREADYINITIALIZED ((HRESULT)0x800401F1L)
#define CO_E_CANTDETERMINECLASS ((HRESULT)0x800401F2L)
#define CO_E_CLASSSTRING ((HRESULT)0x800401F3L)
#define CO_E_IIDSTRING ((HRESULT)0x800401F4L)
#define CO_E_APPNOTFOUND ((HRESULT)0x800401F5L)
#define CO_E_APPSINGLEUSE ((HRESULT)0x800401F6L)
#define CO_E_ERRORINAPP ((HRESULT)0x800401F7L)
#define CO_E_DLLNOTFOUND ((HRESULT)0x800401F8L)
#define CO_E_ERRORINDLL ((HRESULT)0x800401F9L)
#define CO_E_WRONGOSFORAPP ((HRESULT)0x800401FAL)
#define CO_E_OBJNOTREG ((HRESULT)0x800401FBL)
#define CO_E_OBJISREG ((HRESULT)0x800401FCL)
#define CO_E_OBJNOTCONNECTED ((HRESULT)0x800401FDL)
#define CO_E_APPDIDNTREG ((HRESULT)0x800401FEL)
#define CO_E_RELEASED ((HRESULT)0x800401FFL)
#define OLE_S_USEREG ((HRESULT)0x00040000L)
#define OLE_S_STATIC ((HRESULT)0x00040001L)
#define OLE_S_MAC_CLIPFORMAT ((HRESULT)0x00040002L)
#define DRAGDROP_S_DROP ((HRESULT)0x00040100L)
#define DRAGDROP_S_CANCEL ((HRESULT)0x00040101L)
#define DRAGDROP_S_USEDEFAULTCURSORS ((HRESULT)0x00040102L)
#define DATA_S_SAMEFORMATETC ((HRESULT)0x00040130L)
#define VIEW_S_ALREADY_FROZEN ((HRESULT)0x00040140L)
#define CACHE_S_FORMATETC_NOTSUPPORTED ((HRESULT)0x00040170L)
#define CACHE_S_SAMECACHE ((HRESULT)0x00040171L)
#define CACHE_S_SOMECACHES_NOTUPDATED ((HRESULT)0x00040172L)
#define OLEOBJ_S_INVALIDVERB ((HRESULT)0x00040180L)
#define OLEOBJ_S_CANNOT_DOVERB_NOW ((HRESULT)0x00040181L)
#define OLEOBJ_S_INVALIDHWND ((HRESULT)0x00040182L)
#define INPLACE_S_TRUNCATED ((HRESULT)0x000401A0L)
#define CONVERT10_S_NO_PRESENTATION ((HRESULT)0x000401C0L)
#define MK_S_REDUCED_TO_SELF ((HRESULT)0x000401E2L)
#define MK_S_ME ((HRESULT)0x000401E4L)
#define MK_S_HIM ((HRESULT)0x000401E5L)
#define MK_S_US ((HRESULT)0x000401E6L)
#define MK_S_MONIKERALREADYREGISTERED ((HRESULT)0x000401E7L)
#define CO_E_CLASS_CREATE_FAILED ((HRESULT)0x80080001L)
#define CO_E_SCM_ERROR ((HRESULT)0x80080002L)
#define CO_E_SCM_RPC_FAILURE ((HRESULT)0x80080003L)
#define CO_E_BAD_PATH ((HRESULT)0x80080004L)
#define CO_E_SERVER_EXEC_FAILURE ((HRESULT)0x80080005L)
#define CO_E_OBJSRV_RPC_FAILURE ((HRESULT)0x80080006L)
#define MK_E_NO_NORMALIZED ((HRESULT)0x80080007L)
#define CO_E_SERVER_STOPPING ((HRESULT)0x80080008L)
#define MEM_E_INVALID_ROOT ((HRESULT)0x80080009L)
#define MEM_E_INVALID_LINK ((HRESULT)0x80080010L)
#define MEM_E_INVALID_SIZE ((HRESULT)0x80080011L)
#define CO_S_NOTALLINTERFACES ((HRESULT)0x00080012L)
#define CO_S_MACHINENAMENOTFOUND ((HRESULT)0x00080013L)
#define DISP_E_UNKNOWNINTERFACE ((HRESULT)0x80020001L)
#define DISP_E_MEMBERNOTFOUND ((HRESULT)0x80020003L)
#define DISP_E_PARAMNOTFOUND ((HRESULT)0x80020004L)
#define DISP_E_TYPEMISMATCH ((HRESULT)0x80020005L)
#define DISP_E_UNKNOWNNAME ((HRESULT)0x80020006L)
#define DISP_E_NONAMEDARGS ((HRESULT)0x80020007L)
#define DISP_E_BADVARTYPE ((HRESULT)0x80020008L)
#define DISP_E_EXCEPTION ((HRESULT)0x80020009L)
#define DISP_E_OVERFLOW ((HRESULT)0x8002000AL)
#define DISP_E_BADINDEX ((HRESULT)0x8002000BL)
#define DISP_E_UNKNOWNLCID ((HRESULT)0x8002000CL)
#define DISP_E_ARRAYISLOCKED ((HRESULT)0x8002000DL)
#define DISP_E_BADPARAMCOUNT ((HRESULT)0x8002000EL)
#define DISP_E_PARAMNOTOPTIONAL ((HRESULT)0x8002000FL)
#define DISP_E_BADCALLEE ((HRESULT)0x80020010L)
#define DISP_E_NOTACOLLECTION ((HRESULT)0x80020011L)
#define DISP_E_DIVBYZERO ((HRESULT)0x80020012L)
#define TYPE_E_BUFFERTOOSMALL ((HRESULT)0x80028016L)
#define TYPE_E_INVDATAREAD ((HRESULT)0x80028018L)
#define TYPE_E_UNSUPFORMAT ((HRESULT)0x80028019L)
#define TYPE_E_REGISTRYACCESS ((HRESULT)0x8002801CL)
#define TYPE_E_LIBNOTREGISTERED ((HRESULT)0x8002801DL)
#define TYPE_E_UNDEFINEDTYPE ((HRESULT)0x80028027L)
#define TYPE_E_QUALIFIEDNAMEDISALLOWED ((HRESULT)0x80028028L)
#define TYPE_E_INVALIDSTATE ((HRESULT)0x80028029L)
#define TYPE_E_WRONGTYPEKIND ((HRESULT)0x8002802AL)
#define TYPE_E_ELEMENTNOTFOUND ((HRESULT)0x8002802BL)
#define TYPE_E_AMBIGUOUSNAME ((HRESULT)0x8002802CL)
#define TYPE_E_NAMECONFLICT ((HRESULT)0x8002802DL)
#define TYPE_E_UNKNOWNLCID ((HRESULT)0x8002802EL)
#define TYPE_E_DLLFUNCTIONNOTFOUND ((HRESULT)0x8002802FL)
#define TYPE_E_BADMODULEKIND ((HRESULT)0x800288BDL)
#define TYPE_E_SIZETOOBIG ((HRESULT)0x800288C5L)
#define TYPE_E_DUPLICATEID ((HRESULT)0x800288C6L)
#define TYPE_E_INVALIDID ((HRESULT)0x800288CFL)
#define TYPE_E_TYPEMISMATCH ((HRESULT)0x80028CA0L)
#define TYPE_E_OUTOFBOUNDS ((HRESULT)0x80028CA1L)
#define TYPE_E_IOERROR ((HRESULT)0x80028CA2L)
#define TYPE_E_CANTCREATETMPFILE ((HRESULT)0x80028CA3L)
#define TYPE_E_CANTLOADLIBRARY ((HRESULT)0x80029C4AL)
#define TYPE_E_INCONSISTENTPROPFUNCS ((HRESULT)0x80029C83L)
#define TYPE_E_CIRCULARTYPE ((HRESULT)0x80029C84L)
#define STG_E_INVALIDFUNCTION ((HRESULT)0x80030001L)
#define STG_E_FILENOTFOUND ((HRESULT)0x80030002L)
#define STG_E_PATHNOTFOUND ((HRESULT)0x80030003L)
#define STG_E_TOOMANYOPENFILES ((HRESULT)0x80030004L)
#define STG_E_ACCESSDENIED ((HRESULT)0x80030005L)
#define STG_E_INVALIDHANDLE ((HRESULT)0x80030006L)
#define STG_E_INSUFFICIENTMEMORY ((HRESULT)0x80030008L)
#define STG_E_INVALIDPOINTER ((HRESULT)0x80030009L)
#define STG_E_NOMOREFILES ((HRESULT)0x80030012L)
#define STG_E_DISKISWRITEPROTECTED ((HRESULT)0x80030013L)
#define STG_E_SEEKERROR ((HRESULT)0x80030019L)
#define STG_E_WRITEFAULT ((HRESULT)0x8003001DL)
#define STG_E_READFAULT ((HRESULT)0x8003001EL)
#define STG_E_SHAREVIOLATION ((HRESULT)0x80030020L)
#define STG_E_LOCKVIOLATION ((HRESULT)0x80030021L)
#define STG_E_FILEALREADYEXISTS ((HRESULT)0x80030050L)
#define STG_E_INVALIDPARAMETER ((HRESULT)0x80030057L)
#define STG_E_MEDIUMFULL ((HRESULT)0x80030070L)
#define STG_E_PROPSETMISMATCHED ((HRESULT)0x800300F0L)
#define STG_E_ABNORMALAPIEXIT ((HRESULT)0x800300FAL)
#define STG_E_INVALIDHEADER ((HRESULT)0x800300FBL)
#define STG_E_INVALIDNAME ((HRESULT)0x800300FCL)
#define STG_E_UNKNOWN ((HRESULT)0x800300FDL)
#define STG_E_UNIMPLEMENTEDFUNCTION ((HRESULT)0x800300FEL)
#define STG_E_INVALIDFLAG ((HRESULT)0x800300FFL)
#define STG_E_INUSE ((HRESULT)0x80030100L)
#define STG_E_NOTCURRENT ((HRESULT)0x80030101L)
#define STG_E_REVERTED ((HRESULT)0x80030102L)
#define STG_E_CANTSAVE ((HRESULT)0x80030103L)
#define STG_E_OLDFORMAT ((HRESULT)0x80030104L)
#define STG_E_OLDDLL ((HRESULT)0x80030105L)
#define STG_E_SHAREREQUIRED ((HRESULT)0x80030106L)
#define STG_E_NOTFILEBASEDSTORAGE ((HRESULT)0x80030107L)
#define STG_E_EXTANTMARSHALLINGS ((HRESULT)0x80030108L)
#define STG_E_DOCFILECORRUPT ((HRESULT)0x80030109L)
#define STG_E_BADBASEADDRESS ((HRESULT)0x80030110L)
#define STG_E_DOCFILETOOLARGE ((HRESULT)0x80030111L)
#define STG_E_NOTSIMPLEFORMAT ((HRESULT)0x80030112L)
#define STG_E_INCOMPLETE ((HRESULT)0x80030201L)
#define STG_E_TERMINATED ((HRESULT)0x80030202L)
#define STG_S_CONVERTED ((HRESULT)0x00030200L)
#define STG_S_BLOCK ((HRESULT)0x00030201L)
#define STG_S_RETRYNOW ((HRESULT)0x00030202L)
#define STG_S_MONITORING ((HRESULT)0x00030203L)
#define STG_S_MULTIPLEOPENS ((HRESULT)0x00030204L)
#define STG_S_CONSOLIDATIONFAILED ((HRESULT)0x00030205L)
#define STG_S_CANNOTCONSOLIDATE ((HRESULT)0x00030206L)
#define RPC_E_CALL_REJECTED ((HRESULT)0x80010001L)
#define RPC_E_CALL_CANCELED ((HRESULT)0x80010002L)
#define RPC_E_CANTPOST_INSENDCALL ((HRESULT)0x80010003L)
#define RPC_E_CANTCALLOUT_INASYNCCALL ((HRESULT)0x80010004L)
#define RPC_E_CANTCALLOUT_INEXTERNALCALL ((HRESULT)0x80010005L)
#define RPC_E_CONNECTION_TERMINATED ((HRESULT)0x80010006L)
#define RPC_E_SERVER_DIED ((HRESULT)0x80010007L)
#define RPC_E_CLIENT_DIED ((HRESULT)0x80010008L)
#define RPC_E_INVALID_DATAPACKET ((HRESULT)0x80010009L)
#define RPC_E_CANTTRANSMIT_CALL ((HRESULT)0x8001000AL)
#define RPC_E_CLIENT_CANTMARSHAL_DATA ((HRESULT)0x8001000BL)
#define RPC_E_CLIENT_CANTUNMARSHAL_DATA ((HRESULT)0x8001000CL)
#define RPC_E_SERVER_CANTMARSHAL_DATA ((HRESULT)0x8001000DL)
#define RPC_E_SERVER_CANTUNMARSHAL_DATA ((HRESULT)0x8001000EL)
#define RPC_E_INVALID_DATA ((HRESULT)0x8001000FL)
#define RPC_E_INVALID_PARAMETER ((HRESULT)0x80010010L)
#define RPC_E_CANTCALLOUT_AGAIN ((HRESULT)0x80010011L)
#define RPC_E_SERVER_DIED_DNE ((HRESULT)0x80010012L)
#define RPC_E_SYS_CALL_FAILED ((HRESULT)0x80010100L)
#define RPC_E_OUT_OF_RESOURCES ((HRESULT)0x80010101L)
#define RPC_E_ATTEMPTED_MULTITHREAD ((HRESULT)0x80010102L)
#define RPC_E_NOT_REGISTERED ((HRESULT)0x80010103L)
#define RPC_E_FAULT ((HRESULT)0x80010104L)
#define RPC_E_SERVERFAULT ((HRESULT)0x80010105L)
#define RPC_E_CHANGED_MODE ((HRESULT)0x80010106L)
#define RPC_E_INVALIDMETHOD ((HRESULT)0x80010107L)
#define RPC_E_DISCONNECTED ((HRESULT)0x80010108L)
#define RPC_E_RETRY ((HRESULT)0x80010109L)
#define RPC_E_SERVERCALL_RETRYLATER ((HRESULT)0x8001010AL)
#define RPC_E_SERVERCALL_REJECTED ((HRESULT)0x8001010BL)
#define RPC_E_INVALID_CALLDATA ((HRESULT)0x8001010CL)
#define RPC_E_CANTCALLOUT_ININPUTSYNCCALL ((HRESULT)0x8001010DL)
#define RPC_E_WRONG_THREAD ((HRESULT)0x8001010EL)
#define RPC_E_THREAD_NOT_INIT ((HRESULT)0x8001010FL)
#define RPC_E_VERSION_MISMATCH ((HRESULT)0x80010110L)
#define RPC_E_INVALID_HEADER ((HRESULT)0x80010111L)
#define RPC_E_INVALID_EXTENSION ((HRESULT)0x80010112L)
#define RPC_E_INVALID_IPID ((HRESULT)0x80010113L)
#define RPC_E_INVALID_OBJECT ((HRESULT)0x80010114L)
#define RPC_E_CALL_COMPLETE ((HRESULT)0x80010117L)
#define RPC_E_UNSECURE_CALL ((HRESULT)0x80010118L)
#define RPC_E_TOO_LATE ((HRESULT)0x80010119L)
#define RPC_E_NO_GOOD_SECURITY_PACKAGES ((HRESULT)0x8001011AL)
#define RPC_E_ACCESS_DENIED ((HRESULT)0x8001011BL)
#define RPC_E_REMOTE_DISABLED ((HRESULT)0x8001011CL)
#define RPC_E_INVALID_OBJREF ((HRESULT)0x8001011DL)
#define RPC_E_NO_CONTEXT ((HRESULT)0x8001011EL)
#define RPC_E_TIMEOUT ((HRESULT)0x8001011FL)
#define RPC_E_NO_SYNC ((HRESULT)0x80010120L)
#define RPC_E_FULLSIC_REQUIRED ((HRESULT)0x80010121L)
#define RPC_E_INVALID_STD_NAME ((HRESULT)0x80010122L)
#define RPC_E_UNEXPECTED ((HRESULT)0x8001FFFFL)

#define NTE_BAD_UID ((HRESULT)0x80090001L)
#define NTE_BAD_HASH ((HRESULT)0x80090002L)
#define NTE_BAD_KEY ((HRESULT)0x80090003L)
#define NTE_BAD_LEN ((HRESULT)0x80090004L)
#define NTE_BAD_DATA ((HRESULT)0x80090005L)
#define NTE_BAD_SIGNATURE ((HRESULT)0x80090006L)
#define NTE_BAD_VER ((HRESULT)0x80090007L)
#define NTE_BAD_ALGID ((HRESULT)0x80090008L)
#define NTE_BAD_FLAGS ((HRESULT)0x80090009L)
#define NTE_BAD_TYPE ((HRESULT)0x8009000AL)
#define NTE_BAD_KEY_STATE ((HRESULT)0x8009000BL)
#define NTE_BAD_HASH_STATE ((HRESULT)0x8009000CL)
#define NTE_NO_KEY ((HRESULT)0x8009000DL)
#define NTE_NO_MEMORY ((HRESULT)0x8009000EL)
#define NTE_EXISTS ((HRESULT)0x8009000FL)
#define NTE_PERM ((HRESULT)0x80090010L)
#define NTE_NOT_FOUND ((HRESULT)0x80090011L)
#define NTE_DOUBLE_ENCRYPT ((HRESULT)0x80090012L)
#define NTE_BAD_PROVIDER ((HRESULT)0x80090013L)
#define NTE_BAD_PROV_TYPE ((HRESULT)0x80090014L)
#define NTE_BAD_PUBLIC_KEY ((HRESULT)0x80090015L)
#define NTE_BAD_KEYSET ((HRESULT)0x80090016L)
#define NTE_PROV_TYPE_NOT_DEF ((HRESULT)0x80090017L)
#define NTE_PROV_TYPE_ENTRY_BAD ((HRESULT)0x80090018L)
#define NTE_KEYSET_NOT_DEF ((HRESULT)0x80090019L)
#define NTE_KEYSET_ENTRY_BAD ((HRESULT)0x8009001AL)
#define NTE_PROV_TYPE_NO_MATCH ((HRESULT)0x8009001BL)
#define NTE_SIGNATURE_FILE_BAD ((HRESULT)0x8009001CL)
#define NTE_PROVIDER_DLL_FAIL ((HRESULT)0x8009001DL)
#define NTE_PROV_DLL_NOT_FOUND ((HRESULT)0x8009001EL)
#define NTE_BAD_KEYSET_PARAM ((HRESULT)0x8009001FL)
#define NTE_FAIL ((HRESULT)0x80090020L)
#define NTE_SYS_ERR ((HRESULT)0x80090021L)
#define NTE_SILENT_CONTEXT ((HRESULT)0x80090022L)
#define NTE_TOKEN_KEYSET_STORAGE_FULL ((HRESULT)0x80090023L)
#define NTE_TEMPORARY_PROFILE ((HRESULT)0x80090024L)
#define NTE_FIXEDPARAMETER ((HRESULT)0x80090025L)

#endif
